#region ļ
/******************************************************************************
* : Daoting
* ժҪ: 
* ־: 2015-10-06 
******************************************************************************/
#endregion

#region 
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Threading.Tasks;
#endregion

namespace Dt.Base
{
    /// <summary>
    /// ɳ첽ȴ¼
    /// <para>using (e.Wait())</para>
    /// <para>{</para>
    /// <para>    await Fun();</para>
    /// <para>}</para>
    /// </summary>
    public class AsyncCancelEventArgs : CancelEventArgs
    {
        List<Task> _tasks;

        /// <summary>
        /// 첽ȴ
        /// using (e.Wait())
        /// {
        ///     await Fun();
        /// }
        /// </summary>
        /// <returns></returns>
        public IDisposable Wait()
        {
            return new Deferral(this);
        }

        /// <summary>
        /// ȴⲿ񶼽¼ʱڲ
        /// </summary>
        public Task EnsureAllCompleted()
        {
            if (_tasks == null || _tasks.Count == 0)
                return Task.CompletedTask;
            if (_tasks.Count == 1)
                return _tasks[0];
            return Task.WhenAll(_tasks);
        }

        /// <summary>
        /// Ӷʱж첽ȴ
        /// </summary>
        /// <param name="p_task"></param>
        void AddTask(Task p_task)
        {
            if (_tasks == null)
                _tasks = new List<Task>();
            _tasks.Add(p_task);
        }

        class Deferral : IDisposable
        {
            AsyncCancelEventArgs _owner;
            TaskCompletionSource<bool> _taskSrc;

            public Deferral(AsyncCancelEventArgs p_owner)
            {
                _owner = p_owner;
                _taskSrc = new TaskCompletionSource<bool>();
                _owner.AddTask(_taskSrc.Task);
            }

            public void Dispose()
            {
                if (_taskSrc != null && !_taskSrc.Task.IsCompleted)
                {
                    _taskSrc.SetResult(true);
                    _taskSrc = null;
                }
            }
        }
    }
}