#region 文件描述
/******************************************************************************
* 创建: Daoting
* 摘要: 
* 日志: 2013-10-07 创建
******************************************************************************/
#endregion

#region 引用命名
using Dt.CalcEngine;
using System;
#endregion

namespace Dt.CalcEngine.Functions
{
    /// <summary>
    /// Returns the largest value in a list of arguments.
    /// </summary>
    /// <remarks>
    /// MAXA is similar to MINA. For more information, see the examples for MINA.
    /// </remarks>
    public class CalcMaxAFunction : CalcBuiltinFunction
    {
        /// <summary>
        /// Determines whether the function accepts array values
        /// for the specified argument.
        /// </summary>
        /// <param name="i">Index of the argument</param>
        /// <returns>
        /// <see langword="true" /> if the function accepts array values
        /// for the specified argument; <see langword="false" /> otherwise.
        /// </returns>
        public override bool AcceptsArray(int i)
        {
            return true;
        }

        /// <summary>
        /// Determines whether the function accepts CalcReference values
        /// for the specified argument.
        /// </summary>
        /// <param name="i">Index of the argument</param>
        /// <returns>
        /// <see langword="true" /> if the function accepts CalcReference values
        /// for the specified argument; <see langword="false" /> otherwise.
        /// </returns>
        public override bool AcceptsReference(int i)
        {
            return true;
        }

        /// <summary>
        /// Returns the largest value in a list of arguments.
        /// </summary>
        /// <param name="args"><para>
        /// The args contains 1 - 255 items: value1, [value2], [value3], ..
        /// </para>
        /// <para>
        /// Value1, value2, ... are 1 to 255 values for which you want to
        /// find the largest value.
        /// </para></param>
        /// <returns>
        /// A <see cref="T:System.Object" /> value that indicates the evaluate result.
        /// </returns>
        public override object Evaluate(object[] args)
        {
            base.CheckArgumentsLength(args);
            bool flag = false;
            double num = 0.0;
            for (int i = 0; i < args.Length; i++)
            {
                if (args[i] is CalcError)
                {
                    return args[i];
                }
                if (ArrayHelper.IsArrayOrRange(args[i]))
                {
                    for (int j = 0; j < ArrayHelper.GetLength(args[i], 0); j++)
                    {
                        object obj2 = ArrayHelper.GetValue(args[i], j, 0);
                        if (CalcConvert.IsNumber(obj2) || (obj2 is bool))
                        {
                            double num4 = CalcConvert.ToDouble(obj2);
                            if (!flag || (num4 > num))
                            {
                                num = num4;
                            }
                            flag = true;
                        }
                        else if (obj2 is string)
                        {
                            double num5 = 0.0;
                            if (!flag || (num5 > num))
                            {
                                num = num5;
                            }
                            flag = true;
                        }
                        else if (obj2 is CalcError)
                        {
                            return obj2;
                        }
                    }
                }
                else
                {
                    double num6;
                    if (!CalcConvert.TryToDouble(args[i], out num6, true))
                    {
                        return CalcErrors.Value;
                    }
                    if (!flag || (num6 > num))
                    {
                        num = num6;
                    }
                    flag = true;
                }
            }
            return (double) num;
        }

        /// <summary>
        /// Gets the maximum number of arguments for the function.
        /// </summary>
        /// <value>
        /// The maximum number of arguments for the function.
        /// </value>
        public override int MaxArgs
        {
            get
            {
                return 0xff;
            }
        }

        /// <summary>
        /// Gets the minimum number of arguments for the function.
        /// </summary>
        /// <value>
        /// The minimum number of arguments for the function.
        /// </value>
        public override int MinArgs
        {
            get
            {
                return 1;
            }
        }

        /// <summary>
        /// Gets The name of the function.
        /// </summary>
        /// <value>
        /// The name of the function.
        /// </value>
        public override string Name
        {
            get
            {
                return "MAXA";
            }
        }
    }
}

