#region 文件描述
/******************************************************************************
* 创建: Daoting
* 摘要: 
* 日志: 2014-07-03 创建
******************************************************************************/
#endregion

#region 引用命名
using System;
using System.ComponentModel;
#endregion

namespace Dt.Cells.UI
{
    /// <summary>
    /// Represents the event data for the Error event for the control; 
    /// occurs when errors are generated by user interaction.
    /// </summary>
    public class UserErrorEventArgs : CancelEventArgs
    {
        int column;
        string errorMessage;
        System.Exception exception;
        object owner;
        int row;

        /// <summary>
        /// Creates a new object with the Error event arguments.
        /// </summary>
        /// <param name="owner">The owner.</param>
        /// <param name="row">The row index of the cell with the editor that raised the event.</param>
        /// <param name="column">The column index of the cell with the editor that raised the event.</param>
        /// <param name="errorMessage">The text describing the error.</param>
        /// <param name="exception">The exception being thrown.</param>
        public UserErrorEventArgs(object owner, int row, int column, string errorMessage, System.Exception exception)
        {
            this.owner = owner;
            this.row = row;
            this.column = column;
            this.errorMessage = errorMessage;
            this.exception = exception;
        }

        /// <summary>
        /// Gets the column index of the cell with the editor that raised the event.
        /// </summary>
        /// <value>The column index of the cell with the editor that raised the event.</value>
        public int Column
        {
            get { return  column; }
        }

        /// <summary>
        /// Gets the text description of the error.
        /// </summary>
        /// <value>The text description of the error.</value>
        public string ErrorMessage
        {
            get { return  errorMessage; }
        }

        /// <summary>
        /// Gets the exception thrown by the error.
        /// </summary>
        /// <value>The exception thrown by the error.</value>
        public System.Exception Exception
        {
            get { return  exception; }
        }

        /// <summary>
        /// Gets the view that contains the cell with the editor that raised the event.
        /// </summary>
        /// <value>The view that contains the cell with the editor that raised the event.</value>
        public object Owner
        {
            get { return  owner; }
        }

        /// <summary>
        /// Gets the row index of the cell with the editor that raised the event.
        /// </summary>
        /// <value>The row index of the cell with the editor that raised the event.</value>
        public int Row
        {
            get { return  row; }
        }
    }
}

