#region ļ
/******************************************************************************
* : Daoting
* ժҪ: 
* ־: 2019-06-10 
******************************************************************************/
#endregion

#region 
using Dt.Core.RabbitMQ;
using Microsoft.Extensions.DependencyInjection;
using System.Text;
using System.Text.Json;
#endregion

namespace Dt.Core.EventBus
{
    /// <summary>
    /// RabbitMQ¼
    /// </summary>
    [Svc(ServiceLifetime.Singleton)]
    public sealed class RemoteEventBus
    {
        #region Ա
        readonly RabbitMQCenter _mq;
        #endregion

        #region 췽
        public RemoteEventBus(RabbitMQCenter p_mq)
        {
            _mq = p_mq;
        }
        #endregion

        /// <summary>
        /// Ϊ¼ƣֵΪIRemoteHandler
        /// </summary>
        internal static readonly Dictionary<string, Type> Events = new Dictionary<string, Type>();

        /// <summary>
        /// Ӧڵзй㲥
        /// </summary>
        /// <param name="p_event">¼</param>
        /// <param name="p_isAllSvcInst">trueʾзиfalseʾжʱֻͶݸһ</param>
        public void Broadcast(IEvent p_event, bool p_isAllSvcInst = true)
        {
            if (p_event == null)
                return;

            List<string> svcs = Kit.GetAllSvcs(false);
            foreach (var svc in svcs)
            {
                if (p_isAllSvcInst)
                {
                    // зиڶ
                    Publish(p_event, $"{svc}.All", true);
                }
                else
                {
                    // ÿֻͶݸһһ
                    Publish(p_event, svc, false);
                }
            }
        }

        /// <summary>
        /// ӦڵĶй㲥
        /// </summary>
        /// <param name="p_event">¼</param>
        /// <param name="p_svcs">б</param>
        /// <param name="p_isAllSvcInst">trueʾзиfalseʾжʱֻͶݸһ</param>
        public void Broadcast(IEvent p_event, List<string> p_svcs, bool p_isAllSvcInst = true)
        {
            if (p_event == null || p_svcs == null || p_svcs.Count == 0)
                return;

            if (p_isAllSvcInst)
            {
                // зиڶ
                foreach (var svc in p_svcs)
                {
                    if (!string.IsNullOrEmpty(svc))
                        Publish(p_event, $"{Kit.AppName}.{svc.ToLower()}.All", true);
                }
            }
            else
            {
                // ÿֻͶݸһһ
                foreach (var svc in p_svcs)
                {
                    if (!string.IsNullOrEmpty(svc))
                        Publish(p_event, $"{Kit.AppName}.{svc.ToLower()}", false);
                }
            }
        }

        /// <summary>
        /// ĳз񸱱鲥
        /// </summary>
        /// <param name="p_event">¼</param>
        /// <param name="p_svcName">ƣnullʾǰ</param>
        public void Multicast(IEvent p_event, string p_svcName = null)
        {
            // ڶ
            if (p_event != null)
            {
                if (string.IsNullOrEmpty(p_svcName))
                    p_svcName = Kit.Stubs[0].SvcName;
                Publish(p_event, $"{Kit.AppName}.{p_svcName.ToLower()}.All", true);
            }
        }

        /// <summary>
        /// ĳ񷢲¼ж񸱱ʱþ㷨ϢͶݸһ
        /// </summary>
        /// <param name="p_event">¼</param>
        /// <param name="p_svcName"></param>
        public void Push(IEvent p_event, string p_svcName)
        {
            // һ
            if (p_event != null && !string.IsNullOrEmpty(p_svcName))
                Publish(p_event, $"{Kit.AppName}.{p_svcName.ToLower()}", false);
        }

        /// <summary>
        /// ĳĹ̶¼ʹó٣Ϣͻӵĸͬ
        /// </summary>
        /// <param name="p_event">¼</param>
        /// <param name="p_svcID">񸱱ID</param>
        public void PushFixed(IEvent p_event, string p_svcID)
        {
            // ڶУʹʱƥи
            if (p_event != null && !string.IsNullOrEmpty(p_svcID))
                Publish(p_event, $".{p_svcID}", true);
        }

        /// <summary>
        /// Զ¼
        /// </summary>
        /// <param name="p_event"></param>
        /// <param name="p_routingKey"></param>
        /// <param name="p_bindExchange"></param>
        void Publish(IEvent p_event, string p_routingKey, bool p_bindExchange)
        {
            // δRabbitMQշϢ磺Boot
            if (!Kit.EnableRabbitMQ)
                return;

            // л
            EventWrapper body = new EventWrapper
            {
                EventName = p_event.GetType().Name,
                Data = JsonSerializer.Serialize(p_event, p_event.GetType(), JsonOptions.UnsafeSerializer)
            };
            var data = Encoding.UTF8.GetBytes(JsonSerializer.Serialize(body, JsonOptions.UnsafeSerializer));
            _mq.Publish(data, p_routingKey, p_bindExchange);
        }
    }
}