#region ļ
/******************************************************************************
* : Daoting
* ժҪ: 
* ־: 2021-01-17 
******************************************************************************/
#endregion

#region 
using Dt.Core.Rpc;
using Microsoft.Extensions.DependencyInjection;
using Nito.AsyncEx;
using RabbitMQ.Client;
using RabbitMQ.Client.Events;
using Serilog;
#endregion

namespace Dt.Core.RabbitMQ
{
    /// <summary>
    /// RabbitMQ ŵСϢ
    /// </summary>
    [Svc(ServiceLifetime.Singleton)]
    public sealed class RabbitMQCenter
    {
        #region Ա
        // 
        readonly string _exchangeName = Kit.AppName;
        readonly RabbitMQConnection _conn;
        readonly AsyncLock _mutex;
        IModel _chPublish;
        #endregion

        #region 췽
        public RabbitMQCenter()
        {
            // δRabbitMQ磺Boot
            if (!Kit.EnableRabbitMQ)
                return;

            _conn = new RabbitMQConnection();
            _mutex = new AsyncLock();
            Init();
        }
        #endregion

        #region 
        /// <summary>
        ///  RabbitMQ Ϣ
        /// </summary>
        /// <param name="p_data"></param>
        /// <param name="p_routingKey"></param>
        /// <param name="p_bindExchange"></param>
        /// <param name="p_correlationId"></param>
        /// <param name="p_replyTo"></param>
        public async void Publish(
            byte[] p_data,
            string p_routingKey,
            bool p_bindExchange,
            string p_correlationId = null,
            string p_replyTo = null)
        {
            // IModelʵֶ֧߳ͬʱʹ
            using (await _mutex.LockAsync())
            {
                await Task.Run(() =>
                {
                    if (!_conn.IsConnected)
                        _conn.TryConnect();

                    if (_chPublish == null)
                    {
                        _chPublish = _conn.CreateModel();
                        _chPublish.ModelShutdown += (s, e) =>
                        {
                            _chPublish.Dispose();
                            _chPublish = null;
                        };
                    }

                    var props = _chPublish.CreateBasicProperties();
                    if (!string.IsNullOrEmpty(p_correlationId))
                        props.CorrelationId = p_correlationId;
                    if (!string.IsNullOrEmpty(p_replyTo))
                        props.ReplyTo = p_replyTo;

                    _chPublish.BasicPublish(
                        p_bindExchange ? _exchangeName : "",
                        p_routingKey,
                        props,
                        p_data);
                });
            }
        }
        #endregion

        #region 
        /// <summary>
        /// ʼ RabbitMQ ŵ
        /// </summary>
        /// <param name="p_provider"></param>
        internal static void Subscribe(IServiceProvider p_provider)
        {
            // ʵʱж
            p_provider.GetRequiredService<RabbitMQCenter>();
        }

        void Init()
        {
            if (!_conn.IsConnected)
                _conn.TryConnect();

            // Ϣͨ
            _chPublish = _conn.CreateModel();
            _chPublish.ModelShutdown += (s, e) =>
            {
                _chPublish.Dispose();
                _chPublish = null;
            };

            // ·ɹ
            // direct͸ͬһµӵӦRoutingKeyĶ
            // fanout͸ͬһµж
            // topic͸ͬһµİʽRoutingKeyƥĶ
            // headers͸ͬһµӵӦRoutingKeyheadersĶ
            _chPublish.ExchangeDeclare(
                _exchangeName,      // Ӧֽ
                "topic",            // ʽƥ
                durable: true,      // ־û
                autoDelete: false); // ǷԶɾ

            var name = Kit.Stubs[0].SvcName;
            // ÿ΢߶
            // 1. dt.cmյʱֱͶ  񸱱ʱþ㷨Ͷݸһ
            CreateWorkConsumer(name);
            // 2. dt.cm.xxxնи㲥򰴷鲥ÿidͬвԶɾģʽ
            CreateTopicConsumer(name);
            // 3. Ķб仯¼(queue.*)׼ȷȡ΢ĸ
            // ҪRabbitMQ¼֪ͨrabbitmq-plugins enable rabbitmq_event_exchange
            CreateQueueChangeConsumer(name);
        }

        /// <summary>
        /// ߶ AppName.SvcNameworkģʽδ󶨽ֺֻ֧ͶȫƥʱͶ
        /// ڽյʱֱͶ  񸱱ʱþ㷨Ͷݸһ
        /// </summary>
        /// <param name="p_svcName"></param>
        void CreateWorkConsumer(string p_svcName)
        {
            string queueName = $"{Kit.AppName}.{p_svcName}";
            IModel channel = _conn.CreateModel();

            // 
            channel.QueueDeclare(
                queueName,         // 
                durable: false,    // Ƿ־û
                exclusive: false,  // ǷΪУֻ״ӿɼӶϿʱɾ
                autoDelete: true); // trueʱûκζߵĻöлᱻԶɾֶʱ

            // 
            var consumer = new EventingBasicConsumer(channel);
            consumer.Received += (s, e) =>
            {
                OnConsumeMessage(e);
                channel.BasicAck(e.DeliveryTag, false);
            };

            // 
            // һ 0ϢĴСκ
            //  1ϢһһѣûȷѣϢ
            //  falseΪconsumer 
            channel.BasicQos(0, 1, false);

            // Ҫ뽫autoAckΪfalse
            channel.BasicConsume(queue: queueName, autoAck: false, consumer: consumer);

            // 쳣
            channel.CallbackException += (s, e) =>
            {
                try
                {
                    channel.Dispose();
                    channel = null;

                    if (!_conn.IsConnected)
                        _conn.TryConnect();
                    if (_conn.IsConnected)
                        CreateWorkConsumer(p_svcName);
                }
                catch (Exception ex)
                {
                    Log.Error(ex, $"ؽRabbitMQ{queueName}ʱ쳣");
                }
            };
        }

        /// <summary>
        /// ߶ AppName.SvcName.SvcID󶨽topicģʽְ֧ʽƥ
        /// AppName.SvcName.*  նԷиͶ
        /// #.SvcID  նԵǰͶ
        /// </summary>
        /// <param name="p_svcName"></param>
        void CreateTopicConsumer(string p_svcName)
        {
            string queueName = $"{Kit.AppName}.{p_svcName}.{Kit.SvcID}";
            IModel channel = _conn.CreateModel();

            // 
            channel.QueueDeclare(
                queueName,         // 
                durable: false,    // Ƿ־û
                exclusive: false,  // ǷΪУֻ״ӿɼӶϿʱɾ
                autoDelete: true); // trueʱûκζߵĻöлᱻԶɾֶʱ

            // 󶨶
            channel.QueueBind(
                queue: queueName,          // 
                exchange: _exchangeName,   // 󶨵Ľ
                routingKey: $"{Kit.AppName}.{p_svcName}.*"); // ·
            channel.QueueBind(
                queue: queueName,           // 
                exchange: _exchangeName,    // 󶨵Ľ
                routingKey: $"#.{Kit.SvcID}"); // ·

            // 
            var consumer = new EventingBasicConsumer(channel);
            consumer.Received += (s, e) =>
            {
                OnConsumeMessage(e);
                channel.BasicAck(e.DeliveryTag, false);
            };

            // 
            // һ 0ϢĴСκ
            //  1ϢһһѣûȷѣϢ
            //  falseΪconsumer 
            channel.BasicQos(0, 1, false);

            // Ҫ뽫autoAckΪfalse
            channel.BasicConsume(queue: queueName, autoAck: false, consumer: consumer);

            // 쳣
            channel.CallbackException += (s, e) =>
            {
                try
                {
                    channel.Dispose();
                    channel = null;

                    if (!_conn.IsConnected)
                        _conn.TryConnect();
                    if (_conn.IsConnected)
                        CreateTopicConsumer(p_svcName);
                }
                catch (Exception ex)
                {
                    Log.Error(ex, $"ؽRabbitMQ{queueName}ʱ쳣");
                }
            };
        }

        /// <summary>
        /// ϵͳб仯¼(queue.*)׼ȷȡ΢ĸ
        /// </summary>
        void CreateQueueChangeConsumer(string p_svcName)
        {
            // '-'Ϊ˺֣ȡķб
            string queueName = $"{Kit.AppName}-{p_svcName}-{Kit.SvcID}-queue";
            IModel channel = _conn.CreateModel();

            // һġԶɾġǳ־ûĶ
            channel.QueueDeclare(
                queueName,         // 
                durable: false,    // Ƿ־û
                exclusive: true,   // ǷΪУֻ״ӿɼӶϿʱɾ
                autoDelete: true); // trueʱûκζߵĻöлᱻԶɾֶʱ

            // queue.*
            channel.QueueBind(
               queue: queueName,
               exchange: "amq.rabbitmq.event",
               routingKey: "queue.*");

            // б仯ʱ΢б
            var consumer = new EventingBasicConsumer(channel);
            consumer.Received += (s, e) => Kit.UpdateSvcList();

            channel.BasicConsume(queue: queueName, true, consumer: consumer);

            // ֤״θб
            Kit.UpdateSvcList();
        }

        /// <summary>
        /// յϢ
        /// </summary>
        /// <param name="p_args"></param>
        void OnConsumeMessage(BasicDeliverEventArgs p_args)
        {
            if (!string.IsNullOrEmpty(p_args.BasicProperties.CorrelationId))
            {
                // Rpc
                if (!string.IsNullOrEmpty(p_args.BasicProperties.ReplyTo))
                {
                    // Rpc
                    _ = new RabbitMQApiInvoker().Process(p_args);
                }
                else
                {
                    // RpcصĽ
                    new RabbitMQRpcResponse().Process(p_args);
                }
            }
            else
            {
                _ = new RemoteEventHandler().Process(p_args);
            }
        }
        #endregion
    }
}