#region 文件描述
/******************************************************************************
* 创建: Daoting
* 摘要: 
* 日志: 2014-07-01 创建
******************************************************************************/
#endregion

#region 引用命名
using Dt.Base;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using Windows.Foundation;
using Microsoft.UI.Xaml;
using Microsoft.UI.Xaml.Data;
#endregion

namespace Dt.Charts
{
    internal class DataBindingHelper
    {
        static Type[] _supportedTypes = new Type[] { typeof(double), typeof(float), typeof(decimal), typeof(byte), typeof(short), typeof(int), typeof(long), typeof(ushort), typeof(uint), typeof(ulong), typeof(DateTime), typeof(Point) };

        public static void AutoCreateSeries(Chart chart, IEnumerable items)
        {
            if (chart.AutoGenerateSeries)
            {
                chart.Data.notify = false;
                List<DataSeries> list = new List<DataSeries>();
                foreach (DataSeries series in chart.Data.Children)
                {
                    if (series.AutoGenerated)
                    {
                        list.Add(series);
                    }
                }
                if (list.Count > 0)
                {
                    foreach (DataSeries series2 in list)
                    {
                        chart.Data.Children.Remove(series2);
                    }
                }
                bool autoGenerateSeries = chart.AutoGenerateSeries;
                ChartBindings bindings = chart.Bindings;
                List<Binding> seriesBindings = null;
                Binding xBinding = null;
                if (bindings != null)
                {
                    seriesBindings = bindings.SeriesBindings;
                    xBinding = bindings.XBinding;
                }
                Type itemType = GetItemType(items);
                if (IsSupported(itemType))
                {
                    DataSeries series3 = null;
                    if (itemType == typeof(Point))
                    {
                        XYDataSeries series4 = new XYDataSeries {
                            AutoGenerated = true
                        };
                        Binding binding2 = new Binding();
                        binding2.Path = new PropertyPath("X");
                        series4.XValueBinding = binding2;
                        Binding binding3 = new Binding();
                        binding3.Path = new PropertyPath("Y");
                        series4.ValueBinding = binding3;
                        series4.FireNotifications = false;
                        series3 = series4;
                    }
                    else
                    {
                        series3 = new DataSeries {
                            AutoGenerated = true,
                            FireNotifications = false
                        };
                        series3.ValuesSource = items;
                    }
                    chart.Data.Children.Add(series3);
                }
                else if ((seriesBindings != null) && (seriesBindings.Count > 0))
                {
                    foreach (Binding binding4 in seriesBindings)
                    {
                        DataSeries series6 = null;
                        if (xBinding != null)
                        {
                            series6 = new XYDataSeries();
                        }
                        else
                        {
                            series6 = new DataSeries();
                        }
                        series6.AutoGenerated = true;
                        if ((binding4.Path != null) && !string.IsNullOrEmpty(binding4.Path.Path))
                        {
                            series6.Label = binding4.Path.Path;
                        }
                        series6.ValueBinding = binding4;
                        chart.Data.Children.Add(series6);
                    }
                }
                else if (itemType != null)
                {
                    PropertyInfo[] props = Enumerable.ToArray<PropertyInfo>(IntrospectionExtensions.GetTypeInfo(itemType).DeclaredProperties);
                    if (props != null)
                    {
                        if (xBinding != null)
                        {
                            int length = props.Length;
                            for (int i = 0; i < length; i++)
                            {
                                PropertyInfo info = props[i];
                                if ((info.Name != xBinding.Path.ToString()) && IsSupported(info.PropertyType))
                                {
                                    XYDataSeries series7 = new XYDataSeries {
                                        AutoGenerated = true
                                    };
                                    series7.Label = info.Name;
                                    Binding binding5 = new Binding();
                                    binding5.Path = new PropertyPath(info.Name);
                                    series7.ValueBinding = binding5;
                                    chart.Data.Children.Add(series7);
                                }
                            }
                        }
                        else if (chart.ChartType == ChartType.XYPlot)
                        {
                            XYPlotProcess(chart, props);
                        }
                        else
                        {
                            DefaultProcess(chart, props);
                        }
                    }
                }
                chart.Data.notify = true;
            }
        }

        static void DefaultProcess(Chart chart, PropertyInfo[] props)
        {
            int length = props.Length;
            for (int i = 0; i < length; i++)
            {
                PropertyInfo info = props[i];
                if (IsSupported(info.PropertyType))
                {
                    DataSeries series = new DataSeries {
                        AutoGenerated = true
                    };
                    series.Label = info.Name;
                    Binding binding = new Binding();
                    binding.Path = new PropertyPath(info.Name);
                    series.ValueBinding = binding;
                    chart.Data.Children.Add(series);
                }
            }
        }

        static Type GetItemType(IEnumerable items)
        {
            IEnumerator enumerator = items.GetEnumerator();
            DataUtils.TryReset(enumerator);
            if (enumerator.MoveNext())
            {
                return enumerator.Current.GetType();
            }
            return null;
        }

        static bool IsSupported(Type type)
        {
            int length = _supportedTypes.Length;
            for (int i = 0; i < length; i++)
            {
                if (_supportedTypes[i] == type)
                {
                    return true;
                }
            }
            return false;
        }

        static void XYPlotProcess(Chart chart, PropertyInfo[] props)
        {
            int length = props.Length;
            XYDataSeries series = null;
            for (int i = 0; i < length; i++)
            {
                PropertyInfo info = props[i];
                if (IsSupported(info.PropertyType))
                {
                    if (series == null)
                    {
                        series = new XYDataSeries {
                            AutoGenerated = true
                        };
                        series.Label = info.Name;
                        Binding binding = new Binding();
                        binding.Path = new PropertyPath(info.Name);
                        series.XValueBinding = binding;
                    }
                    else
                    {
                        Binding binding2 = new Binding();
                        binding2.Path = new PropertyPath(info.Name);
                        series.ValueBinding = binding2;
                        chart.Data.Children.Add(series);
                        series = null;
                    }
                }
            }
            if ((series != null) && (series.ValueBinding == null))
            {
                series.ValueBinding = series.XValueBinding;
                series.XValueBinding = null;
                chart.Data.Children.Add(series);
            }
        }
    }
}

