﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

internal static partial class Interop
{
    internal static partial class ComCtl32
    {
        /// <summary>
        ///  Messages that the ListView control will respond to.
        ///  Copied form commctrl.h
        /// </summary>
        public enum LVM : uint
        {
            FIRST = 0x1000,
            GETBKCOLOR = FIRST + 0,
            SETBKCOLOR = FIRST + 1,
            GETIMAGELIST = FIRST + 2,
            SETIMAGELIST = FIRST + 3,
            GETITEMCOUNT = FIRST + 4,
            DELETEITEM = FIRST + 8,
            DELETEALLITEMS = FIRST + 9,
            GETCALLBACKMASK = FIRST + 10,
            SETCALLBACKMASK = FIRST + 11,
            GETNEXTITEM = FIRST + 12,
            GETITEMRECT = FIRST + 14,
            SETITEMPOSITION = FIRST + 15,
            GETITEMPOSITION = FIRST + 16,
            HITTEST = FIRST + 18,
            ENSUREVISIBLE = FIRST + 19,
            SCROLL = FIRST + 20,
            REDRAWITEMS = FIRST + 21,
            ARRANGE = FIRST + 22,
            GETEDITCONTROL = FIRST + 24,
            DELETECOLUMN = FIRST + 28,
            GETCOLUMNWIDTH = FIRST + 29,
            SETCOLUMNWIDTH = FIRST + 30,
            GETHEADER = FIRST + 31,
            CREATEDRAGIMAGE = FIRST + 33,
            GETVIEWRECT = FIRST + 34,
            GETTEXTCOLOR = FIRST + 35,
            SETTEXTCOLOR = FIRST + 36,
            GETTEXTBKCOLOR = FIRST + 37,
            SETTEXTBKCOLOR = FIRST + 38,
            GETTOPINDEX = FIRST + 39,
            GETCOUNTPERPAGE = FIRST + 40,
            GETORIGIN = FIRST + 41,
            UPDATE = FIRST + 42,
            SETITEMSTATE = FIRST + 43,
            GETITEMSTATE = FIRST + 44,
            SETITEMCOUNT = FIRST + 47,
            SORTITEMS = FIRST + 48,
            SETITEMPOSITION32 = FIRST + 49,
            GETSELECTEDCOUNT = FIRST + 50,
            GETITEMSPACING = FIRST + 51,
            SETICONSPACING = FIRST + 53,
            SETEXTENDEDLISTVIEWSTYLE = FIRST + 54,
            GETEXTENDEDLISTVIEWSTYLE = FIRST + 55,
            GETSUBITEMRECT = FIRST + 56,
            SUBITEMHITTEST = FIRST + 57,
            SETCOLUMNORDERARRAY = FIRST + 58,
            GETCOLUMNORDERARRAY = FIRST + 59,
            SETHOTITEM = FIRST + 60,
            GETHOTITEM = FIRST + 61,
            SETHOTCURSOR = FIRST + 62,
            GETHOTCURSOR = FIRST + 63,
            APPROXIMATEVIEWRECT = FIRST + 64,
            SETWORKAREAS = FIRST + 65,
            GETSELECTIONMARK = FIRST + 66,
            SETSELECTIONMARK = FIRST + 67,
            GETWORKAREAS = FIRST + 70,
            SETHOVERTIME = FIRST + 71,
            GETHOVERTIME = FIRST + 72,
            GETNUMBEROFWORKAREAS = FIRST + 73,
            SETTOOLTIPS = FIRST + 74,
            GETITEMW = FIRST + 75,
            SETITEMW = FIRST + 76,
            INSERTITEMW = FIRST + 77,
            GETTOOLTIPS = FIRST + 78,
            SORTITEMSEX = FIRST + 81,
            FINDITEMW = FIRST + 83,
            GETSTRINGWIDTHW = FIRST + 87,
            GETGROUPSTATE = FIRST + 92,
            GETFOCUSEDGROUP = FIRST + 93,
            GETCOLUMNW = FIRST + 95,
            SETCOLUMNW = FIRST + 96,
            INSERTCOLUMNW = FIRST + 97,
            GETGROUPRECT = FIRST + 98,
            GETITEMTEXTW = FIRST + 115,
            SETITEMTEXTW = FIRST + 116,
            GETISEARCHSTRINGW = FIRST + 117,
            EDITLABELW = FIRST + 118,
            SETBKIMAGEW = FIRST + 138,
            GETBKIMAGEW = FIRST + 139,
            SETSELECTEDCOLUMN = FIRST + 140,
            SETVIEW = FIRST + 142,
            GETVIEW = FIRST + 143,
            INSERTGROUP = FIRST + 145,
            SETGROUPINFO = FIRST + 147,
            GETGROUPINFO = FIRST + 149,
            REMOVEGROUP = FIRST + 150,
            MOVEGROUP = FIRST + 151,
            GETGROUPCOUNT = FIRST + 152,
            GETGROUPINFOBYINDEX = FIRST + 153,
            MOVEITEMTOGROUP = FIRST + 154,
            SETGROUPMETRICS = FIRST + 155,
            GETGROUPMETRICS = FIRST + 156,
            ENABLEGROUPVIEW = FIRST + 157,
            SORTGROUPS = FIRST + 158,
            INSERTGROUPSORTED = FIRST + 159,
            REMOVEALLGROUPS = FIRST + 160,
            HASGROUP = FIRST + 161,
            SETTILEVIEWINFO = FIRST + 162,
            GETTILEVIEWINFO = FIRST + 163,
            SETTILEINFO = FIRST + 164,
            GETTILEINFO = FIRST + 165,
            SETINSERTMARK = FIRST + 166,
            GETINSERTMARK = FIRST + 167,
            INSERTMARKHITTEST = FIRST + 168,
            GETINSERTMARKRECT = FIRST + 169,
            SETINSERTMARKCOLOR = FIRST + 170,
            GETINSERTMARKCOLOR = FIRST + 171,
            SETINFOTIP = FIRST + 173,
            GETSELECTEDCOLUMN = FIRST + 174,
            ISGROUPVIEWENABLED = FIRST + 175,
            GETOUTLINECOLOR = FIRST + 176,
            SETOUTLINECOLOR = FIRST + 177,
            CANCELEDITLABEL = FIRST + 179,
            MAPINDEXTOID = FIRST + 180,
            MAPIDTOINDEX = FIRST + 181,
            ISITEMVISIBLE = FIRST + 182,
            GETEMPTYTEXT = FIRST + 204,
            GETFOOTERRECT = FIRST + 205,
            GETFOOTERINFO = FIRST + 206,
            GETFOOTERITEMRECT = FIRST + 207,
            GETFOOTERITEM = FIRST + 208,
            GETITEMINDEXRECT = FIRST + 209,
            SETITEMINDEXSTATE = FIRST + 210,
            GETNEXTITEMINDEX = FIRST + 211,
            SETUNICODEFORMAT = CCM.SETUNICODEFORMAT,
        }
    }
}
