# -*- coding: utf-8 -*-

# PLEASE DO NOT EDIT THIS FILE, IT IS GENERATED AND WILL BE OVERWRITTEN:
# https://github.com/ccxt/ccxt/blob/master/CONTRIBUTING.md#how-to-contribute-code

from ccxt.async.huobipro import huobipro

# -----------------------------------------------------------------------------

try:
    basestring  # Python 3
except NameError:
    basestring = str  # Python 2
import hashlib
import json
from ccxt.base.errors import ExchangeError
from ccxt.base.errors import AuthenticationError
from ccxt.base.errors import InsufficientFunds
from ccxt.base.errors import InvalidOrder
from ccxt.base.errors import OrderNotFound
from ccxt.base.errors import ExchangeNotAvailable
from ccxt.base.decimal_to_precision import ROUND
from ccxt.base.decimal_to_precision import TRUNCATE


class cointiger (huobipro):

    def describe(self):
        return self.deep_extend(super(cointiger, self).describe(), {
            'id': 'cointiger',
            'name': 'CoinTiger',
            'countries': ['CN'],
            'hostname': 'api.cointiger.pro',
            'has': {
                'fetchCurrencies': False,
                'fetchTickers': True,
                'fetchTradingLimits': False,
                'fetchOrder': False,
            },
            'headers': {
                'Language': 'en_US',
            },
            'urls': {
                'logo': 'https://user-images.githubusercontent.com/1294454/39797261-d58df196-5363-11e8-9880-2ec78ec5bd25.jpg',
                'api': {
                    'public': 'https://api.cointiger.pro/exchange/trading/api/market',
                    'private': 'https://api.cointiger.pro/exchange/trading/api',
                    'exchange': 'https://www.cointiger.pro/exchange',
                },
                'www': 'https://www.cointiger.pro',
                'referral': 'https://www.cointiger.pro/exchange/register.html?refCode=FfvDtt',
                'doc': 'https://github.com/cointiger/api-docs-en/wiki',
            },
            'api': {
                'public': {
                    'get': [
                        'history/kline',  # 获取K线数据
                        'detail/merged',  # 获取聚合行情(Ticker)
                        'depth',  # 获取 Market Depth 数据
                        'trade',  # 获取 Trade Detail 数据
                        'history/trade',  # 批量获取最近的交易记录
                        'detail',  # 获取 Market Detail 24小时成交量数据
                    ],
                },
                'exchange': {
                    'get': [
                        'footer/tradingrule.html',
                        'api/public/market/detail',
                    ],
                },
                'private': {
                    'get': [
                        'user/balance',
                        'order/new',
                        'order/history',
                        'order/trade',
                    ],
                    'post': [
                        'order',
                    ],
                    'delete': [
                        'order',
                    ],
                },
            },
            'exceptions': {
                '1': InsufficientFunds,
                '2': ExchangeError,
                '5': InvalidOrder,
                '6': InvalidOrder,
                '8': OrderNotFound,
                '16': AuthenticationError,  # funding password not set
                '100001': ExchangeError,
                '100002': ExchangeNotAvailable,
                '100003': ExchangeError,
                '100005': AuthenticationError,
            },
        })

    async def fetch_markets(self):
        result = [
            {'precision': {'amount': 1, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'aacbtc', 'uppercaseId': 'AACBTC', 'symbol': 'AAC/BTC', 'base': 'AAC', 'quote': 'BTC', 'baseId': 'aac', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.1, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'afcbtc', 'uppercaseId': 'AFCBTC', 'symbol': 'AFC/BTC', 'base': 'AFC', 'quote': 'BTC', 'baseId': 'afc', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 1, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'avhbtc', 'uppercaseId': 'AVHBTC', 'symbol': 'AVH/BTC', 'base': 'AVH', 'quote': 'BTC', 'baseId': 'avh', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 1, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'baieth', 'uppercaseId': 'BAIETH', 'symbol': 'BAI/ETH', 'base': 'BAI', 'quote': 'ETH', 'baseId': 'bai', 'quoteId': 'eth', 'active': True, 'info': None, 'limits': {'amount': {'min': 1, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 3, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'bchbtc', 'uppercaseId': 'BCHBTC', 'symbol': 'BCH/BTC', 'base': 'BCH', 'quote': 'BTC', 'baseId': 'bch', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.001, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'bkbtbtc', 'uppercaseId': 'BKBTBTC', 'symbol': 'BKBT/BTC', 'base': 'BKBT', 'quote': 'BTC', 'baseId': 'bkbt', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 1, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'bkbteth', 'uppercaseId': 'BKBTETH', 'symbol': 'BKBT/ETH', 'base': 'BKBT', 'quote': 'ETH', 'baseId': 'bkbt', 'quoteId': 'eth', 'active': True, 'info': None, 'limits': {'amount': {'min': 1, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'bptnbtc', 'uppercaseId': 'BPTNBTC', 'symbol': 'BPTN/BTC', 'base': 'BPTN', 'quote': 'BTC', 'baseId': 'bptn', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 100, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 4, 'price': 2}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'btcbitcny', 'uppercaseId': 'BTCBITCNY', 'symbol': 'BTC/BitCNY', 'base': 'BTC', 'quote': 'BitCNY', 'baseId': 'btc', 'quoteId': 'bitcny', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.0001, 'max': None}, 'price': {'min': 0.01, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 2, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'btmbtc', 'uppercaseId': 'BTMBTC', 'symbol': 'BTM/BTC', 'base': 'BTM', 'quote': 'BTC', 'baseId': 'btm', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.01, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 2, 'price': 6}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'btmeth', 'uppercaseId': 'BTMETH', 'symbol': 'BTM/ETH', 'base': 'BTM', 'quote': 'ETH', 'baseId': 'btm', 'quoteId': 'eth', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.01, 'max': None}, 'price': {'min': 0.000001, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 2, 'price': 3}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'btsbitcny', 'uppercaseId': 'BTSBITCNY', 'symbol': 'BTS/BitCNY', 'base': 'BTS', 'quote': 'BitCNY', 'baseId': 'bts', 'quoteId': 'bitcny', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.01, 'max': None}, 'price': {'min': 0.001, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 2, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'btsbtc', 'uppercaseId': 'BTSBTC', 'symbol': 'BTS/BTC', 'base': 'BTS', 'quote': 'BTC', 'baseId': 'bts', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.01, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 2, 'price': 6}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'btseth', 'uppercaseId': 'BTSETH', 'symbol': 'BTS/ETH', 'base': 'BTS', 'quote': 'ETH', 'baseId': 'bts', 'quoteId': 'eth', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.01, 'max': None}, 'price': {'min': 0.000001, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 2, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'ctxcbtc', 'uppercaseId': 'CTXCBTC', 'symbol': 'CTXC/BTC', 'base': 'CTXC', 'quote': 'BTC', 'baseId': 'ctxc', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.01, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 2, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'ctxceth', 'uppercaseId': 'CTXCETH', 'symbol': 'CTXC/ETH', 'base': 'CTXC', 'quote': 'ETH', 'baseId': 'ctxc', 'quoteId': 'eth', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.01, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 2, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'elfbtc', 'uppercaseId': 'ELFBTC', 'symbol': 'ELF/BTC', 'base': 'ELF', 'quote': 'BTC', 'baseId': 'elf', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.01, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 2, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'eosbtc', 'uppercaseId': 'EOSBTC', 'symbol': 'EOS/BTC', 'base': 'EOS', 'quote': 'BTC', 'baseId': 'eos', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.01, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 2, 'price': 6}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'eoseth', 'uppercaseId': 'EOSETH', 'symbol': 'EOS/ETH', 'base': 'EOS', 'quote': 'ETH', 'baseId': 'eos', 'quoteId': 'eth', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.01, 'max': None}, 'price': {'min': 0.000001, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 2, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'etcbtc', 'uppercaseId': 'ETCBTC', 'symbol': 'ETC/BTC', 'base': 'ETC', 'quote': 'BTC', 'baseId': 'etc', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.01, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 3, 'price': 2}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'ethbitcny', 'uppercaseId': 'ETHBITCNY', 'symbol': 'ETH/BitCNY', 'base': 'ETH', 'quote': 'BitCNY', 'baseId': 'eth', 'quoteId': 'bitcny', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.001, 'max': None}, 'price': {'min': 0.01, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 3, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'ethbtc', 'uppercaseId': 'ETHBTC', 'symbol': 'ETH/BTC', 'base': 'ETH', 'quote': 'BTC', 'baseId': 'eth', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.001, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 2}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'gtobitcny', 'uppercaseId': 'GTOBITCNY', 'symbol': 'GTO/BitCNY', 'base': 'GTO', 'quote': 'BitCNY', 'baseId': 'gto', 'quoteId': 'bitcny', 'active': True, 'info': None, 'limits': {'amount': {'min': 1, 'max': None}, 'price': {'min': 0.01, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'gusbtc', 'uppercaseId': 'GUSBTC', 'symbol': 'GUS/BTC', 'base': 'GUS', 'quote': 'BTC', 'baseId': 'gus', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 1, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 4, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'icxbtc', 'uppercaseId': 'ICXBTC', 'symbol': 'ICX/BTC', 'base': 'ICX', 'quote': 'BTC', 'baseId': 'icx', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.0001, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'incbtc', 'uppercaseId': 'INCBTC', 'symbol': 'INC/BTC', 'base': 'INC', 'quote': 'BTC', 'baseId': 'inc', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 5, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 6}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'inceth', 'uppercaseId': 'INCETH', 'symbol': 'INC/ETH', 'base': 'INC', 'quote': 'ETH', 'baseId': 'inc', 'quoteId': 'eth', 'active': True, 'info': None, 'limits': {'amount': {'min': 5, 'max': None}, 'price': {'min': 0.000001, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'kkgbtc', 'uppercaseId': 'KKGBTC', 'symbol': 'KKG/BTC', 'base': 'KKG', 'quote': 'BTC', 'baseId': 'kkg', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 1, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 6}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'kkgeth', 'uppercaseId': 'KKGETH', 'symbol': 'KKG/ETH', 'base': 'KKG', 'quote': 'ETH', 'baseId': 'kkg', 'quoteId': 'eth', 'active': True, 'info': None, 'limits': {'amount': {'min': 1, 'max': None}, 'price': {'min': 0.000001, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 2, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'ltcbtc', 'uppercaseId': 'LTCBTC', 'symbol': 'LTC/BTC', 'base': 'LTC', 'quote': 'BTC', 'baseId': 'ltc', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.01, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'mexbtc', 'uppercaseId': 'MEXBTC', 'symbol': 'MEX/BTC', 'base': 'MEX', 'quote': 'BTC', 'baseId': 'mex', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 100, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'mtbtc', 'uppercaseId': 'MTBTC', 'symbol': 'MT/BTC', 'base': 'MT', 'quote': 'BTC', 'baseId': 'mt', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 1, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'mteth', 'uppercaseId': 'MTETH', 'symbol': 'MT/ETH', 'base': 'MT', 'quote': 'ETH', 'baseId': 'mt', 'quoteId': 'eth', 'active': True, 'info': None, 'limits': {'amount': {'min': 1, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 3}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'ocnbitcny', 'uppercaseId': 'OCNBITCNY', 'symbol': 'OCN/BitCNY', 'base': 'OCN', 'quote': 'BitCNY', 'baseId': 'ocn', 'quoteId': 'bitcny', 'active': True, 'info': None, 'limits': {'amount': {'min': 1, 'max': None}, 'price': {'min': 0.001, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'ocnbtc', 'uppercaseId': 'OCNBTC', 'symbol': 'OCN/BTC', 'base': 'OCN', 'quote': 'BTC', 'baseId': 'ocn', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 1, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'olebtc', 'uppercaseId': 'OLEBTC', 'symbol': 'OLE/BTC', 'base': 'OLE', 'quote': 'BTC', 'baseId': 'ole', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 1, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'oleeth', 'uppercaseId': 'OLEETH', 'symbol': 'OLE/ETH', 'base': 'OLE', 'quote': 'ETH', 'baseId': 'ole', 'quoteId': 'eth', 'active': True, 'info': None, 'limits': {'amount': {'min': 1, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 2, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'omgbtc', 'uppercaseId': 'OMGBTC', 'symbol': 'OMG/BTC', 'base': 'OMG', 'quote': 'BTC', 'baseId': 'omg', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.01, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 2, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'repbtc', 'uppercaseId': 'REPBTC', 'symbol': 'REP/BTC', 'base': 'REP', 'quote': 'BTC', 'baseId': 'rep', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.01, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'sdabtc', 'uppercaseId': 'SDABTC', 'symbol': 'SDA/BTC', 'base': 'SDA', 'quote': 'BTC', 'baseId': 'sda', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 1, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'sdaeth', 'uppercaseId': 'SDAETH', 'symbol': 'SDA/ETH', 'base': 'SDA', 'quote': 'ETH', 'baseId': 'sda', 'quoteId': 'eth', 'active': True, 'info': None, 'limits': {'amount': {'min': 1, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'sntbtc', 'uppercaseId': 'SNTBTC', 'symbol': 'SNT/BTC', 'base': 'SNT', 'quote': 'BTC', 'baseId': 'snt', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 1, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 1, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'socbtc', 'uppercaseId': 'SOCBTC', 'symbol': 'SOC/BTC', 'base': 'SOC', 'quote': 'BTC', 'baseId': 'soc', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.1, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'sphbtc', 'uppercaseId': 'SPHBTC', 'symbol': 'SPH/BTC', 'base': 'SPH', 'quote': 'BTC', 'baseId': 'sph', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 100, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 2, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'storjbtc', 'uppercaseId': 'STORJBTC', 'symbol': 'STORJ/BTC', 'base': 'STORJ', 'quote': 'BTC', 'baseId': 'storj', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.01, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 1, 'price': 3}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'tchbitcny', 'uppercaseId': 'TCHBITCNY', 'symbol': 'TCH/BitCNY', 'base': 'TCH', 'quote': 'BitCNY', 'baseId': 'tch', 'quoteId': 'bitcny', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.1, 'max': None}, 'price': {'min': 0.001, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 1, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'tchbtc', 'uppercaseId': 'TCHBTC', 'symbol': 'TCH/BTC', 'base': 'TCH', 'quote': 'BTC', 'baseId': 'tch', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.1, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 3}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'trxbitcny', 'uppercaseId': 'TRXBITCNY', 'symbol': 'TRX/BitCNY', 'base': 'TRX', 'quote': 'BitCNY', 'baseId': 'trx', 'quoteId': 'bitcny', 'active': True, 'info': None, 'limits': {'amount': {'min': 1, 'max': None}, 'price': {'min': 0.001, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'trxbtc', 'uppercaseId': 'TRXBTC', 'symbol': 'TRX/BTC', 'base': 'TRX', 'quote': 'BTC', 'baseId': 'trx', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 1, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'trxeth', 'uppercaseId': 'TRXETH', 'symbol': 'TRX/ETH', 'base': 'TRX', 'quote': 'ETH', 'baseId': 'trx', 'quoteId': 'eth', 'active': True, 'info': None, 'limits': {'amount': {'min': 1, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 2, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'tusdbtc', 'uppercaseId': 'TUSDBTC', 'symbol': 'TUSD/BTC', 'base': 'TUSD', 'quote': 'BTC', 'baseId': 'tusd', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.01, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 2, 'price': 6}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'tusdeth', 'uppercaseId': 'TUSDETH', 'symbol': 'TUSD/ETH', 'base': 'TUSD', 'quote': 'ETH', 'baseId': 'tusd', 'quoteId': 'eth', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.01, 'max': None}, 'price': {'min': 0.000001, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 1, 'price': 2}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'xembitcny', 'uppercaseId': 'XEMBITCNY', 'symbol': 'XEM/BitCNY', 'base': 'XEM', 'quote': 'BitCNY', 'baseId': 'xem', 'quoteId': 'bitcny', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.1, 'max': None}, 'price': {'min': 0.01, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'yeebtc', 'uppercaseId': 'YEEBTC', 'symbol': 'YEE/BTC', 'base': 'YEE', 'quote': 'BTC', 'baseId': 'yee', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 1, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 0, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'yeeeth', 'uppercaseId': 'YEEETH', 'symbol': 'YEE/ETH', 'base': 'YEE', 'quote': 'ETH', 'baseId': 'yee', 'quoteId': 'eth', 'active': True, 'info': None, 'limits': {'amount': {'min': 1, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 4, 'price': 8}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'zrxbtc', 'uppercaseId': 'ZRXBTC', 'symbol': 'ZRX/BTC', 'base': 'ZRX', 'quote': 'BTC', 'baseId': 'zrx', 'quoteId': 'btc', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.0001, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 4, 'price': 2}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'btcusdt', 'uppercaseId': 'BTCUSDT', 'symbol': 'BTC/USDT', 'base': 'BTC', 'quote': 'USDT', 'baseId': 'btc', 'quoteId': 'usdt', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.0001, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 3, 'price': 2}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'ethusdt', 'uppercaseId': 'ETHUSDT', 'symbol': 'ETH/USDT', 'base': 'ETH', 'quote': 'USDT', 'baseId': 'eth', 'quoteId': 'usdt', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.001, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
            {'precision': {'amount': 2, 'price': 2}, 'tierBased': False, 'percentage': True, 'taker': 0.001, 'maker': 0.001, 'id': 'ltcusdt', 'uppercaseId': 'LTCUSDT', 'symbol': 'LTC/USDT', 'base': 'LTC', 'quote': 'USDT', 'baseId': 'ltc', 'quoteId': 'usdt', 'active': True, 'info': None, 'limits': {'amount': {'min': 0.01, 'max': None}, 'price': {'min': 1e-8, 'max': None}, 'cost': {'min': 0, 'max': None}}},
        ]
        self.options['marketsByUppercaseId'] = self.index_by(result, 'uppercaseId')
        return result

    def parse_ticker(self, ticker, market=None):
        symbol = None
        if market:
            symbol = market['symbol']
        timestamp = self.safe_integer(ticker, 'id')
        close = self.safe_float(ticker, 'last')
        percentage = self.safe_float(ticker, 'percentChange')
        return {
            'symbol': symbol,
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
            'high': self.safe_float(ticker, 'high24hr'),
            'low': self.safe_float(ticker, 'low24hr'),
            'bid': self.safe_float(ticker, 'highestBid'),
            'bidVolume': None,
            'ask': self.safe_float(ticker, 'lowestAsk'),
            'askVolume': None,
            'vwap': None,
            'open': None,
            'close': close,
            'last': close,
            'previousClose': None,
            'change': None,
            'percentage': percentage,
            'average': None,
            'baseVolume': self.safe_float(ticker, 'baseVolume'),
            'quoteVolume': self.safe_float(ticker, 'quoteVolume'),
            'info': ticker,
        }

    async def fetch_order_book(self, symbol, limit=None, params={}):
        await self.load_markets()
        market = self.market(symbol)
        response = await self.publicGetDepth(self.extend({
            'symbol': market['id'],  # self endpoint requires a lowercase market id
            'type': 'step0',
        }, params))
        data = response['data']['depth_data']
        if 'tick' in data:
            if not data['tick']:
                raise ExchangeError(self.id + ' fetchOrderBook() returned empty response: ' + self.json(response))
            orderbook = data['tick']
            timestamp = data['ts']
            return self.parse_order_book(orderbook, timestamp, 'buys')
        raise ExchangeError(self.id + ' fetchOrderBook() returned unrecognized response: ' + self.json(response))

    async def fetch_ticker(self, symbol, params={}):
        await self.load_markets()
        market = self.market(symbol)
        marketId = market['uppercaseId']
        response = await self.exchangeGetApiPublicMarketDetail(params)
        if not(marketId in list(response.keys())):
            raise ExchangeError(self.id + ' fetchTicker symbol ' + symbol + '(' + marketId + ') not found')
        return self.parse_ticker(response[marketId], market)

    async def fetch_tickers(self, symbols=None, params={}):
        await self.load_markets()
        response = await self.exchangeGetApiPublicMarketDetail(params)
        result = {}
        ids = list(response.keys())
        for i in range(0, len(ids)):
            id = ids[i]
            market = None
            symbol = id
            if id in self.options['marketsByUppercaseId']:
                # self endpoint returns uppercase ids
                symbol = self.options['marketsByUppercaseId'][id]['symbol']
                market = self.options['marketsByUppercaseId'][id]
            result[symbol] = self.parse_ticker(response[id], market)
        return result

    def parse_trade(self, trade, market=None):
        #
        #     {
        #         "volume": {
        #             "amount": "1.000",
        #             "icon": "",
        #             "title": "成交量"
        #                   },
        #         "price": {
        #             "amount": "0.04978883",
        #             "icon": "",
        #             "title": "委托价格"
        #                  },
        #         "created_at": 1513245134000,
        #         "deal_price": {
        #             "amount": 0.04978883000000000000000000000000,
        #             "icon": "",
        #             "title": "成交价格"
        #                       },
        #         "id": 138
        #     }
        #
        side = self.safe_string(trade, 'side')
        amount = None
        price = None
        cost = None
        if side is not None:
            side = side.lower()
            price = self.safe_float(trade, 'price')
            amount = self.safe_float(trade, 'amount')
        else:
            price = self.safe_float(trade['price'], 'amount')
            amount = self.safe_float(trade['volume'], 'amount')
            cost = self.safe_float(trade['deal_price'], 'amount')
        if amount is not None:
            if price is not None:
                if cost is None:
                    cost = amount * price
        timestamp = self.safe_value(trade, 'created_at')
        if timestamp is None:
            timestamp = self.safe_value(trade, 'ts')
        iso8601 = self.iso8601(timestamp) if (timestamp is not None) else None
        symbol = None
        if market is not None:
            symbol = market['symbol']
        return {
            'info': trade,
            'id': str(trade['id']),
            'order': None,
            'timestamp': timestamp,
            'datetime': iso8601,
            'symbol': symbol,
            'type': None,
            'side': side,
            'price': price,
            'amount': amount,
            'cost': cost,
            'fee': None,
        }

    async def fetch_trades(self, symbol, since=None, limit=1000, params={}):
        await self.load_markets()
        market = self.market(symbol)
        request = {
            'symbol': market['id'],
        }
        if limit is not None:
            request['size'] = limit
        response = await self.publicGetHistoryTrade(self.extend(request, params))
        return self.parse_trades(response['data']['trade_data'], market, since, limit)

    async def fetch_my_trades(self, symbol=None, since=None, limit=None, params={}):
        if symbol is None:
            raise ExchangeError(self.id + ' fetchOrders requires a symbol argument')
        await self.load_markets()
        market = self.market(symbol)
        if limit is None:
            limit = 100
        response = await self.privateGetOrderTrade(self.extend({
            'symbol': market['id'],
            'offset': 1,
            'limit': limit,
        }, params))
        return self.parse_trades(response['data']['list'], market, since, limit)

    async def fetch_ohlcv(self, symbol, timeframe='1m', since=None, limit=1000, params={}):
        await self.load_markets()
        market = self.market(symbol)
        request = {
            'symbol': market['id'],
            'period': self.timeframes[timeframe],
        }
        if limit is not None:
            request['size'] = limit
        response = await self.publicGetHistoryKline(self.extend(request, params))
        return self.parse_ohlcvs(response['data']['kline_data'], market, timeframe, since, limit)

    async def fetch_balance(self, params={}):
        await self.load_markets()
        response = await self.privateGetUserBalance(params)
        #
        #     {
        #         "code": "0",
        #         "msg": "suc",
        #         "data": [{
        #             "normal": "1813.01144179",
        #             "lock": "1325.42036785",
        #             "coin": "btc"
        #         }, {
        #             "normal": "9551.96692244",
        #             "lock": "547.06506717",
        #             "coin": "eth"
        #         }]
        #     }
        #
        balances = response['data']
        result = {'info': response}
        for i in range(0, len(balances)):
            balance = balances[i]
            id = balance['coin']
            code = id.upper()
            code = self.common_currency_code(code)
            if id in self.currencies_by_id:
                code = self.currencies_by_id[id]['code']
            account = self.account()
            account['used'] = float(balance['lock'])
            account['free'] = float(balance['normal'])
            account['total'] = self.sum(account['used'], account['free'])
            result[code] = account
        return self.parse_balance(result)

    async def fetch_orders_by_status(self, status=None, symbol=None, since=None, limit=None, params={}):
        if symbol is None:
            raise ExchangeError(self.id + ' fetchOrders requires a symbol argument')
        await self.load_markets()
        market = self.market(symbol)
        if limit is None:
            limit = 100
        method = 'privateGetOrderNew' if (status == 'open') else 'privateGetOrderHistory'
        response = await getattr(self, method)(self.extend({
            'symbol': market['id'],
            'offset': 1,
            'limit': limit,
        }, params))
        return self.parse_orders(response['data']['list'], market, since, limit)

    async def fetch_open_orders(self, symbol=None, since=None, limit=None, params={}):
        return self.fetch_orders_by_status('open', symbol, since, limit, params)

    async def fetch_closed_orders(self, symbol=None, since=None, limit=None, params={}):
        return self.fetch_orders_by_status('closed', symbol, since, limit, params)

    def parse_order(self, order, market=None):
        side = self.safe_string(order, 'side')
        side = side.lower()
        #
        #      {
        #            volume: {"amount": "0.054", "icon": "", "title": "volume"},
        #         age_price: {"amount": "0.08377697", "icon": "", "title": "Avg price"},
        #              side: "BUY",
        #             price: {"amount": "0.00000000", "icon": "", "title": "price"},
        #        created_at: 1525569480000,
        #       deal_volume: {"amount": "0.64593598", "icon": "", "title": "Deal volume"},
        #   "remain_volume": {"amount": "1.00000000", "icon": "", "title": "尚未成交"
        #                id: 26834207,
        #             label: {go: "trade", title: "Traded", click: 1},
        #          side_msg: "Buy"
        #      },
        #
        type = None
        status = None
        symbol = None
        if market is not None:
            symbol = market['symbol']
        timestamp = order['created_at']
        amount = self.safe_float(order['volume'], 'amount')
        remaining = self.safe_float(order['remain_volume'], 'amount') if ('remain_volume' in list(order.keys())) else None
        filled = self.safe_float(order['deal_volume'], 'amount') if ('deal_volume' in list(order.keys())) else None
        price = self.safe_float(order['age_price'], 'amount') if ('age_price' in list(order.keys())) else None
        if price is None:
            price = self.safe_float(order['price'], 'amount') if ('price' in list(order.keys())) else None
        cost = None
        average = None
        if amount is not None:
            if remaining is not None:
                if filled is None:
                    filled = amount - remaining
            elif filled is not None:
                cost = filled * price
                average = float(cost / filled)
                if remaining is None:
                    remaining = amount - filled
        if (remaining is not None) and(remaining > 0):
            status = 'open'
        result = {
            'info': order,
            'id': str(order['id']),
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
            'lastTradeTimestamp': None,
            'symbol': symbol,
            'type': type,
            'side': side,
            'price': price,
            'average': average,
            'cost': cost,
            'amount': amount,
            'filled': filled,
            'remaining': remaining,
            'status': status,
            'fee': None,
        }
        return result

    def cost_to_precision(self, symbol, cost):
        return self.decimal_to_precision(cost, ROUND, self.markets[symbol]['precision']['price'])

    def price_to_precision(self, symbol, price):
        return self.decimal_to_precision(price, ROUND, self.markets[symbol]['precision']['price'])

    def amount_to_precision(self, symbol, amount):
        return self.decimal_to_precision(amount, TRUNCATE, self.markets[symbol]['precision']['amount'])

    def fee_to_precision(self, currency, fee):
        return self.decimal_to_precision(fee, ROUND, self.currencies[currency]['precision'])

    async def create_order(self, symbol, type, side, amount, price=None, params={}):
        await self.load_markets()
        if not self.password:
            raise AuthenticationError(self.id + ' createOrder requires exchange.password to be set to user trading password(not login passwordnot )')
        self.check_required_credentials()
        market = self.market(symbol)
        orderType = 1 if (type == 'limit') else 2
        order = {
            'symbol': market['id'],
            'side': side.upper(),
            'type': orderType,
            'volume': self.amount_to_precision(symbol, amount),
            'capital_password': self.password,
        }
        if (type == 'market') and(side == 'buy'):
            if price is None:
                raise InvalidOrder(self.id + ' createOrder requires price argument for market buy orders to calculate total cost according to exchange rules')
            order['volume'] = self.amount_to_precision(symbol, amount * price)
        if type == 'limit':
            order['price'] = self.price_to_precision(symbol, price)
        else:
            if price is None:
                order['price'] = self.price_to_precision(symbol, 0)
            else:
                order['price'] = self.price_to_precision(symbol, price)
        response = await self.privatePostOrder(self.extend(order, params))
        #
        #     {"order_id":34343}
        #
        timestamp = self.milliseconds()
        return {
            'info': response,
            'id': str(response['data']['order_id']),
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
            'lastTradeTimestamp': None,
            'status': None,
            'symbol': symbol,
            'type': type,
            'side': side,
            'price': price,
            'amount': amount,
            'filled': None,
            'remaining': None,
            'cost': None,
            'trades': None,
            'fee': None,
        }

    async def cancel_order(self, id, symbol=None, params={}):
        await self.load_markets()
        if symbol is None:
            raise ExchangeError(self.id + ' cancelOrder requires a symbol argument')
        market = self.market(symbol)
        response = await self.privateDeleteOrder(self.extend({
            'symbol': market['id'],
            'order_id': id,
        }, params))
        return {
            'id': id,
            'symbol': symbol,
            'info': response,
        }

    def sign(self, path, api='public', method='GET', params={}, headers=None, body=None):
        self.check_required_credentials()
        url = self.urls['api'][api] + '/' + self.implode_params(path, params)
        if api == 'private':
            timestamp = str(self.milliseconds())
            query = self.keysort(self.extend({
                'time': timestamp,
            }, params))
            keys = list(query.keys())
            auth = ''
            for i in range(0, len(keys)):
                auth += keys[i] + str(query[keys[i]])
            auth += self.secret
            signature = self.hmac(self.encode(auth), self.encode(self.secret), hashlib.sha512)
            isCreateOrderMethod = (path == 'order') and(method == 'POST')
            urlParams = {} if isCreateOrderMethod else query
            url += '?' + self.urlencode(self.keysort(self.extend({
                'api_key': self.apiKey,
                'time': timestamp,
            }, urlParams)))
            url += '&sign=' + signature
            if method == 'POST':
                body = self.urlencode(query)
                headers = {
                    'Content-Type': 'application/x-www-form-urlencoded',
                }
        elif api == 'public':
            url += '?' + self.urlencode(self.extend({
                'api_key': self.apiKey,
            }, params))
        else:
            if params:
                url += '?' + self.urlencode(params)
        return {'url': url, 'method': method, 'body': body, 'headers': headers}

    def handle_errors(self, httpCode, reason, url, method, headers, body):
        if not isinstance(body, basestring):
            return  # fallback to default error handler
        if len(body) < 2:
            return  # fallback to default error handler
        if (body[0] == '{') or (body[0] == '['):
            response = json.loads(body)
            if 'code' in response:
                #
                #     {"code": "100005", "msg": "request sign illegal", "data": null}
                #
                code = self.safe_string(response, 'code')
                if (code is not None) and(code != '0'):
                    message = self.safe_string(response, 'msg')
                    feedback = self.id + ' ' + self.json(response)
                    exceptions = self.exceptions
                    if code in exceptions:
                        if code == 2:
                            if message == 'offsetNot Null':
                                raise ExchangeError(feedback)
                            elif message == 'Parameter error':
                                raise ExchangeError(feedback)
                        raise exceptions[code](feedback)
                    else:
                        raise ExchangeError(self.id + ' unknown "error" value: ' + self.json(response))
