# -*- coding: utf-8 -*-

# PLEASE DO NOT EDIT THIS FILE, IT IS GENERATED AND WILL BE OVERWRITTEN:
# https://github.com/ccxt/ccxt/blob/master/CONTRIBUTING.md#how-to-contribute-code

from ccxt.base.exchange import Exchange
import base64
import hashlib
import math
import json
from ccxt.base.errors import ExchangeError
from ccxt.base.errors import AuthenticationError
from ccxt.base.errors import InsufficientFunds
from ccxt.base.errors import InvalidOrder
from ccxt.base.errors import OrderNotFound
from ccxt.base.errors import InvalidNonce


class kucoin (Exchange):

    def describe(self):
        return self.deep_extend(super(kucoin, self).describe(), {
            'id': 'kucoin',
            'name': 'Kucoin',
            'countries': ['HK'],  # Hong Kong
            'version': 'v1',
            'rateLimit': 2000,
            'userAgent': self.userAgents['chrome'],
            'has': {
                'CORS': False,
                'cancelOrders': True,
                'createMarketOrder': False,
                'fetchDepositAddress': True,
                'fetchTickers': True,
                'fetchOHLCV': True,  # see the method implementation below
                'fetchOrder': True,
                'fetchOrders': False,
                'fetchClosedOrders': True,
                'fetchOpenOrders': True,
                'fetchMyTrades': 'emulated',  # self method is to be deleted, see implementation and comments below
                'fetchCurrencies': True,
                'withdraw': True,
            },
            'timeframes': {
                '1m': 1,
                '5m': 5,
                '15m': 15,
                '30m': 30,
                '1h': 60,
                '8h': 480,
                '1d': 'D',
                '1w': 'W',
            },
            'urls': {
                'logo': 'https://user-images.githubusercontent.com/1294454/33795655-b3c46e48-dcf6-11e7-8abe-dc4588ba7901.jpg',
                'api': {
                    'public': 'https://api.kucoin.com',
                    'private': 'https://api.kucoin.com',
                    'kitchen': 'https://kitchen.kucoin.com',
                    'kitchen-2': 'https://kitchen-2.kucoin.com',
                },
                'www': 'https://www.kucoin.com',
                'referral': 'https://www.kucoin.com/?r=E5wkqe',
                'doc': 'https://kucoinapidocs.docs.apiary.io',
                'fees': 'https://news.kucoin.com/en/fee',
            },
            'api': {
                'kitchen': {
                    'get': [
                        'open/chart/history',
                    ],
                },
                'public': {
                    'get': [
                        'open/chart/config',
                        'open/chart/history',
                        'open/chart/symbol',
                        'open/currencies',
                        'open/deal-orders',
                        'open/kline',
                        'open/lang-list',
                        'open/orders',
                        'open/orders-buy',
                        'open/orders-sell',
                        'open/tick',
                        'market/open/coin-info',
                        'market/open/coins',
                        'market/open/coins-trending',
                        'market/open/symbols',
                    ],
                },
                'private': {
                    'get': [
                        'account/balance',
                        'account/{coin}/wallet/address',
                        'account/{coin}/wallet/records',
                        'account/{coin}/balance',
                        'account/promotion/info',
                        'account/promotion/sum',
                        'deal-orders',
                        'order/active',
                        'order/active-map',
                        'order/dealt',
                        'order/detail',
                        'referrer/descendant/count',
                        'user/info',
                    ],
                    'post': [
                        'account/{coin}/withdraw/apply',
                        'account/{coin}/withdraw/cancel',
                        'account/promotion/draw',
                        'cancel-order',
                        'order',
                        'order/cancel-all',
                        'user/change-lang',
                    ],
                },
            },
            'fees': {
                'trading': {
                    'maker': 0.001,
                    'taker': 0.001,
                },
                'funding': {
                    'tierBased': False,
                    'percentage': False,
                    'withdraw': {
                        'KCS': 2.0,
                        'BTC': 0.0005,
                        'USDT': 10.0,
                        'ETH': 0.01,
                        'LTC': 0.001,
                        'NEO': 0.0,
                        'GAS': 0.0,
                        'KNC': 0.5,
                        'BTM': 5.0,
                        'QTUM': 0.1,
                        'EOS': 0.5,
                        'CVC': 3.0,
                        'OMG': 0.1,
                        'PAY': 0.5,
                        'SNT': 20.0,
                        'BHC': 1.0,
                        'HSR': 0.01,
                        'WTC': 0.1,
                        'VEN': 2.0,
                        'MTH': 10.0,
                        'RPX': 1.0,
                        'REQ': 20.0,
                        'EVX': 0.5,
                        'MOD': 0.5,
                        'NEBL': 0.1,
                        'DGB': 0.5,
                        'CAG': 2.0,
                        'CFD': 0.5,
                        'RDN': 0.5,
                        'UKG': 5.0,
                        'BCPT': 5.0,
                        'PPT': 0.1,
                        'BCH': 0.0005,
                        'STX': 2.0,
                        'NULS': 1.0,
                        'GVT': 0.1,
                        'HST': 2.0,
                        'PURA': 0.5,
                        'SUB': 2.0,
                        'QSP': 5.0,
                        'POWR': 1.0,
                        'FLIXX': 10.0,
                        'LEND': 20.0,
                        'AMB': 3.0,
                        'RHOC': 2.0,
                        'R': 2.0,
                        'DENT': 50.0,
                        'DRGN': 1.0,
                        'ACT': 0.1,
                    },
                    'deposit': {},
                },
            },
            # exchange-specific options
            'options': {
                'fetchOrderBookWarning': True,  # raises a warning on null response in fetchOrderBook
                'timeDifference': 0,  # the difference between system clock and Kucoin clock
                'adjustForTimeDifference': False,  # controls the adjustment logic upon instantiation
                'limits': {
                    'amount': {
                        'min': {
                            'BTC': 0.00001,
                            'ETH': 0.00001,
                            'BCH': 0.00001,
                            'GAS': 0.1,
                            'NEO': 0.01,
                            'KCS': 1,
                            'TMT': 1,
                            'TFD': 1,
                            'LALA': 1,
                            'CS': 1,
                            'DOCK': 1,
                            'ETN': 1,
                            'IHT': 1,
                            'KICK': 1,
                            'WAN': 1,
                            'ACT': 1,
                            'APH': 1,
                            'BAX': 1,
                            'DATX': 1,
                            'DEB': 1,
                            'ELEC': 1,
                            'GO': 1,
                            'HSR': 1,
                            'IOTX': 1,
                            'LOOM': 1,
                            'LYM': 1,
                            'MOBI': 1,
                            'OMX': 1,
                            'ONT': 1,
                            'OPEN': 1,
                            'QKC': 1,
                            'SHL': 1,
                            'SOUL': 1,
                            'SPHTX': 1,
                            'SRN': 1,
                            'TKY': 1,
                            'TOMO': 1,
                            'TRAC': 1,
                            'COV': 1,
                            'DADI': 1,
                            'ELF': 1,
                            'LTC': 1,
                            'MAN': 1,
                            'PRL': 1,
                            'STK': 1,
                            'ZIL': 1,
                            'ZPT': 1,
                            'BPT': 1,
                            'CAPP': 1,
                            'POLY': 1,
                            'TNC': 1,
                            'XRB': 0.1,
                            'AXP': 1,
                            'COFI': 1,
                            'CXO': 1,
                            'DRGN': 1,
                            'DTA': 1,
                            'ING': 1,
                            'MTN': 1,
                            'OCN': 10,
                            'PARETO': 1,
                            'SNC': 1,
                            'TEL': 10,
                            'WAX': 1,
                            'ADB': 1,
                            'BOS': 1,
                            'HAT': 1,
                            'HKN': 1,
                            'HPB': 1,
                            'IOST': 1,
                            'ARY': 1,
                            'DBC': 1,
                            'KEY': 1,
                            'GAT': 1,
                            'RPX': 1,
                            'ACAT': 1,
                            'CV': 10,
                            'QLC': 1,
                            'R': 1,
                            'TIO': 1,
                            'ITC': 1,
                            'AGI': 10,
                            'EXY': 1,
                            'MWAT': 1,
                            'DENT': 1,
                            'J8T': 1,
                            'LOCI': 1,
                            'CAT': 1,
                            'ARN': 1,
                            'CAN': 1,
                            'EOS': 0.1,
                            'ETC': 0.1,
                            'JNT': 1,
                            'PLAY': 1,
                            'CHP': 1,
                            'DASH': 0.01,
                            'DNA': 1,
                            'EBTC': 1,
                            'FOTA': 1,
                            'PURA': 0.1,
                            'UTK': 1,
                            'CAG': 1,
                            'GLA': 1,
                            'HAV': 1,
                            'SPF': 1,
                            'TIME': 1,
                            'ABT': 1,
                            'BNTY': 1,
                            'ELIX': 1,
                            'ENJ': 1,
                            'AIX': 1,
                            'VEN': 1,
                            'AION': 1,
                            'DAT': 1,
                            'QTUM': 0.1,
                            'WTC': 0.1,
                            'DGB': 1,
                            'SNOV': 1,
                            'BRD': 1,
                            'AMB': 1,
                            'BTM': 1,
                            'MANA': 1,
                            'RHOC': 1,
                            'XLR': 1,
                            'XAS': 0.1,
                            'CHSB': 1,
                            'UKG': 1,
                            'POLL': 1,
                            'FLIXX': 0.1,
                            'INS': 1,
                            'OMG': 0.1,
                            'TFL': 1,
                            'WPR': 1,
                            'LEND': 1,
                            'KNC': 0.001,
                            'BCD': 0.001,
                            'LA': 1,
                            'ONION': 1,
                            'POWR': 0.1,
                            'SNM': 1,
                            'BTG': 0.001,
                            'PBL': 1,
                            'MOD': 0.1,
                            'PPT': 0.1,
                            'BCPT': 1,
                            'GVT': 0.1,
                            'HST': 0.1,
                            'SNT': 0.1,
                            'SUB': 0.1,
                            'NEBL': 0.1,
                            'CVC': 0.1,
                            'MTH': 1,
                            'NULS': 0.1,
                            'PAY': 0.1,
                            'RDN': 1,
                            'REQ': 1,
                            'QSP': 0.1,
                        },
                    },
                },
            },
            'commonCurrencies': {
                'CAN': 'CanYa',
                'XRB': 'NANO',
            },
        })

    def nonce(self):
        return self.milliseconds() - self.options['timeDifference']

    def load_time_difference(self):
        response = self.publicGetOpenTick()
        after = self.milliseconds()
        self.options['timeDifference'] = int(after - response['timestamp'])
        return self.options['timeDifference']

    def calculate_fee(self, symbol, type, side, amount, price, takerOrMaker='taker', params={}):
        market = self.markets[symbol]
        key = 'quote'
        rate = market[takerOrMaker]
        cost = float(self.cost_to_precision(symbol, amount * rate))
        if side == 'sell':
            cost *= price
        else:
            key = 'base'
        return {
            'type': takerOrMaker,
            'currency': market[key],
            'rate': rate,
            'cost': float(self.fee_to_precision(symbol, cost)),
        }

    def fetch_markets(self):
        response = self.publicGetMarketOpenSymbols()
        if self.options['adjustForTimeDifference']:
            self.load_time_difference()
        markets = response['data']
        result = []
        for i in range(0, len(markets)):
            market = markets[i]
            id = market['symbol']
            baseId = market['coinType']
            quoteId = market['coinTypePair']
            base = self.common_currency_code(baseId)
            quote = self.common_currency_code(quoteId)
            symbol = base + '/' + quote
            precision = {
                'amount': 8,
                'price': 8,
            }
            defaultMinAmount = math.pow(10, -precision['amount'])
            minAmount = self.safe_float(self.options['limits']['amount']['min'], base, defaultMinAmount)
            active = market['trading']
            result.append({
                'id': id,
                'symbol': symbol,
                'base': base,
                'quote': quote,
                'baseId': baseId,
                'quoteId': quoteId,
                'active': active,
                'taker': self.safe_float(market, 'feeRate'),
                'maker': self.safe_float(market, 'feeRate'),
                'info': market,
                'lot': math.pow(10, -precision['amount']),
                'precision': precision,
                'limits': {
                    'amount': {
                        'min': minAmount,
                        'max': None,
                    },
                    'price': {
                        'min': None,
                        'max': None,
                    },
                },
            })
        return result

    def fetch_deposit_address(self, code, params={}):
        self.load_markets()
        currency = self.currency(code)
        response = self.privateGetAccountCoinWalletAddress(self.extend({
            'coin': currency['id'],
        }, params))
        data = response['data']
        address = self.safe_string(data, 'address')
        self.check_address(address)
        tag = self.safe_string(data, 'userOid')
        return {
            'currency': code,
            'address': address,
            'tag': tag,
            'info': response,
        }

    def fetch_currencies(self, params={}):
        response = self.publicGetMarketOpenCoins(params)
        currencies = response['data']
        result = {}
        for i in range(0, len(currencies)):
            currency = currencies[i]
            id = currency['coin']
            # todo: will need to rethink the fees
            # to add support for multiple withdrawal/deposit methods and
            # differentiated fees for each particular method
            code = self.common_currency_code(id)
            precision = currency['tradePrecision']
            deposit = currency['enableDeposit']
            withdraw = currency['enableWithdraw']
            active = (deposit and withdraw)
            defaultMinAmount = math.pow(10, -precision)
            minAmount = self.safe_float(self.options['limits']['amount']['min'], code, defaultMinAmount)
            result[code] = {
                'id': id,
                'code': code,
                'info': currency,
                'name': currency['name'],
                'active': active,
                'fee': currency['withdrawMinFee'],  # todo: redesign
                'precision': precision,
                'limits': {
                    'amount': {
                        'min': minAmount,
                        'max': math.pow(10, precision),
                    },
                    'price': {
                        'min': math.pow(10, -precision),
                        'max': math.pow(10, precision),
                    },
                    'cost': {
                        'min': None,
                        'max': None,
                    },
                    'withdraw': {
                        'min': currency['withdrawMinAmount'],
                        'max': math.pow(10, precision),
                    },
                },
            }
        return result

    def fetch_balance(self, params={}):
        self.load_markets()
        response = self.privateGetAccountBalance(self.extend({
        }, params))
        balances = response['data']
        result = {'info': balances}
        indexed = self.index_by(balances, 'coinType')
        keys = list(indexed.keys())
        for i in range(0, len(keys)):
            id = keys[i]
            currency = self.common_currency_code(id)
            account = self.account()
            balance = indexed[id]
            used = float(balance['freezeBalance'])
            free = float(balance['balance'])
            total = self.sum(free, used)
            account['free'] = free
            account['used'] = used
            account['total'] = total
            result[currency] = account
        return self.parse_balance(result)

    def fetch_order_book(self, symbol, limit=None, params={}):
        self.load_markets()
        market = self.market(symbol)
        request = {
            'symbol': market['id'],
        }
        if limit is not None:
            request['limit'] = limit
        response = self.publicGetOpenOrders(self.extend(request, params))
        orderbook = None
        timestamp = None
        # sometimes kucoin returns self:
        # {"success":true,"code":"OK","msg":"Operation succeeded.","timestamp":xxxxxxxxxxxxx,"data":null}
        if not('data' in list(response.keys())) or not response['data']:
            if self.options['fetchOrderBookWarning']:
                raise ExchangeError(self.id + " fetchOrderBook returned an null reply. Set exchange.options['fetchOrderBookWarning'] = False to silence self warning")
            orderbook = {
                'BUY': [],
                'SELL': [],
            }
        else:
            orderbook = response['data']
            timestamp = self.safe_integer(response, 'timestamp')
            timestamp = self.safe_integer(response['data'], 'timestamp', timestamp)
        return self.parse_order_book(orderbook, timestamp, 'BUY', 'SELL')

    def parse_order(self, order, market=None):
        side = self.safe_value(order, 'direction')
        if side is None:
            side = order['type']
        if side is not None:
            side = side.lower()
        orderId = self.safe_string(order, 'orderOid')
        if orderId is None:
            orderId = self.safe_string(order, 'oid')
        # do not confuse trades with orders
        trades = None
        if 'dealOrders' in order:
            trades = self.safe_value(order['dealOrders'], 'datas')
        if trades is not None:
            trades = self.parse_trades(trades, market)
            for i in range(0, len(trades)):
                trades[i]['side'] = side
                trades[i]['order'] = orderId
        symbol = None
        if market is not None:
            symbol = market['symbol']
        else:
            symbol = order['coinType'] + '/' + order['coinTypePair']
        timestamp = self.safe_value(order, 'createdAt')
        remaining = self.safe_float(order, 'pendingAmount')
        status = self.safe_value(order, 'status')
        filled = self.safe_float(order, 'dealAmount')
        amount = self.safe_float(order, 'amount')
        cost = self.safe_float(order, 'dealValue')
        if cost is None:
            cost = self.safe_float(order, 'dealValueTotal')
        if status is None:
            if remaining is not None:
                if remaining > 0:
                    status = 'open'
                else:
                    status = 'closed'
        if filled is None:
            if status is not None:
                if status == 'closed':
                    filled = self.safe_float(order, 'amount')
        elif filled == 0.0:
            if trades is not None:
                cost = 0
                for i in range(0, len(trades)):
                    filled += trades[i]['amount']
                    cost += trades[i]['cost']
        # kucoin price and amount fields have varying names
        # thus the convoluted spaghetti code below
        price = None
        if filled is not None:
            # if the order was filled at least for some part
            if filled > 0.0:
                price = self.safe_float(order, 'price')
                if price is None:
                    price = self.safe_float(order, 'dealPrice')
                if price is None:
                    price = self.safe_float(order, 'dealPriceAverage')
            else:
                # it's an open order, not filled yet, use the initial price
                price = self.safe_float(order, 'orderPrice')
                if price is None:
                    price = self.safe_float(order, 'price')
            if price is not None:
                if cost is None:
                    cost = price * filled
            if amount is None:
                if remaining is not None:
                    amount = self.sum(filled, remaining)
            elif remaining is None:
                remaining = amount - filled
        if status == 'open':
            if (cost is None) or (cost == 0.0):
                if price is not None:
                    if amount is not None:
                        cost = amount * price
        feeCurrency = None
        if market is not None:
            feeCurrency = market['quote'] if (side == 'sell') else market['base']
        else:
            feeCurrencyField = 'coinTypePair' if (side == 'sell') else 'coinType'
            feeCurrency = self.safe_string(order, feeCurrencyField)
            if feeCurrency is not None:
                if feeCurrency in self.currencies_by_id:
                    feeCurrency = self.currencies_by_id[feeCurrency]['code']
        feeCost = self.safe_float(order, 'fee')
        fee = {
            'cost': self.safe_float(order, 'feeTotal', feeCost),
            'rate': self.safe_float(order, 'feeRate'),
            'currency': feeCurrency,
        }
        result = {
            'info': order,
            'id': orderId,
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
            'lastTradeTimestamp': None,
            'symbol': symbol,
            'type': 'limit',
            'side': side,
            'price': price,
            'amount': amount,
            'cost': cost,
            'filled': filled,
            'remaining': remaining,
            'status': status,
            'fee': fee,
            'trades': trades,
        }
        return result

    def fetch_order(self, id, symbol=None, params={}):
        if symbol is None:
            raise ExchangeError(self.id + ' fetchOrder requires a symbol argument')
        orderType = self.safe_value(params, 'type')
        if orderType is None:
            raise ExchangeError(self.id + ' fetchOrder requires a type parameter("BUY" or "SELL")')
        self.load_markets()
        market = self.market(symbol)
        request = {
            'symbol': market['id'],
            'type': orderType,
            'orderOid': id,
        }
        response = self.privateGetOrderDetail(self.extend(request, params))
        if not response['data']:
            raise OrderNotFound(self.id + ' ' + self.json(response))
        #
        # the caching part to be removed
        #
        #     order = self.parse_order(response['data'], market)
        #     orderId = order['id']
        #     if orderId in self.orders:
        #         order['status'] = self.orders[orderId]['status']
        #     self.orders[orderId] = order
        #
        return self.parse_order(response['data'], market)

    def parse_orders_by_status(self, orders, market, since, limit, status):
        result = []
        for i in range(0, len(orders)):
            order = self.parse_order(self.extend(orders[i], {
                'status': status,
            }), market)
            result.append(order)
        symbol = market['symbol'] if (market is not None) else None
        return self.filter_by_symbol_since_limit(result, symbol, since, limit)

    def fetch_open_orders(self, symbol=None, since=None, limit=None, params={}):
        self.load_markets()
        marketId = None
        market = None
        if symbol is not None:
            market = self.market(symbol)
            marketId = market['id']
        else:
            marketId = ''
        request = {
            'symbol': marketId,
        }
        response = self.privateGetOrderActiveMap(self.extend(request, params))
        sell = self.safe_value(response['data'], 'SELL')
        if sell is None:
            sell = []
        buy = self.safe_value(response['data'], 'BUY')
        if buy is None:
            buy = []
        orders = self.array_concat(sell, buy)
        #
        # the caching part to be removed
        #
        #     for i in range(0, len(orders)):
        #         order = self.parse_order(self.extend(orders[i], {
        #             'status': 'open',
        #         }), market)
        #         orderId = order['id']
        #         if orderId in self.orders:
        #             if self.orders[orderId]['status'] != 'open':
        #                 order['status'] = self.orders[orderId]['status']
        #         self.orders[order['id']] = order
        #     }
        #     openOrders = self.filter_by(self.orders, 'status', 'open')
        #     return self.filter_by_symbol_since_limit(openOrders, symbol, since, limit)
        #
        return self.parse_orders_by_status(orders, market, since, limit, 'open')

    def fetch_closed_orders(self, symbol=None, since=None, limit=20, params={}):
        request = {}
        self.load_markets()
        market = None
        if symbol is not None:
            market = self.market(symbol)
            request['symbol'] = market['id']
        if since is not None:
            request['since'] = since
        if limit is not None:
            request['limit'] = limit
        response = self.privateGetOrderDealt(self.extend(request, params))
        orders = response['data']['datas']
        #
        # the caching part to be removed
        #
        #     for i in range(0, len(orders)):
        #         order = self.parse_order(self.extend(orders[i], {
        #             'status': 'closed',
        #         }), market)
        #         orderId = order['id']
        #         if orderId in self.orders:
        #             if self.orders[orderId]['status'] == 'canceled':
        #                 order['status'] = self.orders[orderId]['status']
        #         self.orders[order['id']] = order
        #     }
        #     closedOrders = self.filter_by(self.orders, 'status', 'closed')
        #     return self.filter_by_symbol_since_limit(closedOrders, symbol, since, limit)
        #
        return self.parse_orders_by_status(orders, market, since, limit, 'closed')

    def create_order(self, symbol, type, side, amount, price=None, params={}):
        if type != 'limit':
            raise ExchangeError(self.id + ' allows limit orders only')
        self.load_markets()
        market = self.market(symbol)
        quote = market['quote']
        base = market['base']
        request = {
            'symbol': market['id'],
            'type': side.upper(),
            'price': self.truncate(price, self.currencies[quote]['precision']),
            'amount': self.truncate(amount, self.currencies[base]['precision']),
        }
        price = float(price)
        amount = float(amount)
        cost = price * amount
        response = self.privatePostOrder(self.extend(request, params))
        orderId = self.safe_string(response['data'], 'orderOid')
        timestamp = self.safe_integer(response, 'timestamp')
        iso8601 = None
        if timestamp is not None:
            iso8601 = self.iso8601(timestamp)
        order = {
            'info': response,
            'id': orderId,
            'timestamp': timestamp,
            'datetime': iso8601,
            'lastTradeTimestamp': None,
            'symbol': market['symbol'],
            'type': type,
            'side': side,
            'amount': amount,
            'filled': None,
            'remaining': None,
            'price': price,
            'cost': cost,
            'status': 'open',
            'fee': None,
            'trades': None,
        }
        self.orders[orderId] = order
        return order

    def cancel_orders(self, symbol=None, params={}):
        # https://kucoinapidocs.docs.apiary.io/#reference/0/trading/cancel-all-orders
        # docs say symbol is required, but it seems to be optional
        # you can cancel all orders, or filter by symbol or type or both
        request = {}
        if symbol is not None:
            self.load_markets()
            market = self.market(symbol)
            request['symbol'] = market['id']
        if 'type' in params:
            request['type'] = params['type'].upper()
            params = self.omit(params, 'type')
        #
        # the caching part to be removed
        #
        #     response = self.privatePostOrderCancelAll(self.extend(request, params))
        #     openOrders = self.filter_by(self.orders, 'status', 'open')
        #     for i in range(0, len(openOrders)):
        #         order = openOrders[i]
        #         orderId = order['id']
        #         self.orders[orderId]['status'] = 'canceled'
        #     }
        #     return response
        #
        return self.privatePostOrderCancelAll(self.extend(request, params))

    def cancel_order(self, id, symbol=None, params={}):
        if symbol is None:
            raise ExchangeError(self.id + ' cancelOrder requires a symbol')
        self.load_markets()
        market = self.market(symbol)
        request = {
            'symbol': market['id'],
            'orderOid': id,
        }
        if 'type' in params:
            request['type'] = params['type'].upper()
            params = self.omit(params, 'type')
        else:
            raise ExchangeError(self.id + ' cancelOrder requires parameter type=["BUY"|"SELL"]')
        #
        # the caching part to be removed
        #
        #     response = self.privatePostCancelOrder(self.extend(request, params))
        #     if id in self.orders:
        #         self.orders[id]['status'] = 'canceled'
        #     else:
        #         # store it in cache for further references
        #         timestamp = self.milliseconds()
        #         side = request['type'].lower()
        #         self.orders[id] = {
        #             'id': id,
        #             'timestamp': timestamp,
        #             'datetime': self.iso8601(timestamp),
        #             'type': None,
        #             'side': side,
        #             'symbol': symbol,
        #             'status': 'canceled',
        #         }
        #     }
        #     return response
        #
        return self.privatePostCancelOrder(self.extend(request, params))

    def parse_ticker(self, ticker, market=None):
        timestamp = ticker['datetime']
        symbol = None
        if market is None:
            marketId = ticker['coinType'] + '-' + ticker['coinTypePair']
            if marketId in self.markets_by_id:
                market = self.markets_by_id[marketId]
        # TNC coin doesn't have changerate for some reason
        change = self.safe_float(ticker, 'change')
        last = self.safe_float(ticker, 'lastDealPrice')
        open = None
        if last is not None:
            if change is not None:
                open = last - change
        changePercentage = self.safe_float(ticker, 'changeRate')
        if market is not None:
            symbol = market['symbol']
        return {
            'symbol': symbol,
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
            'high': self.safe_float(ticker, 'high'),
            'low': self.safe_float(ticker, 'low'),
            'bid': self.safe_float(ticker, 'buy'),
            'bidVolume': None,
            'ask': self.safe_float(ticker, 'sell'),
            'askVolume': None,
            'vwap': None,
            'open': open,
            'close': last,
            'last': last,
            'previousClose': None,
            'change': change,
            'percentage': changePercentage,
            'average': None,
            'baseVolume': self.safe_float(ticker, 'vol'),
            'quoteVolume': self.safe_float(ticker, 'volValue'),
            'info': ticker,
        }

    def fetch_tickers(self, symbols=None, params={}):
        self.load_markets()
        response = self.publicGetMarketOpenSymbols(params)
        tickers = response['data']
        result = {}
        for t in range(0, len(tickers)):
            ticker = self.parse_ticker(tickers[t])
            symbol = ticker['symbol']
            result[symbol] = ticker
        return result

    def fetch_ticker(self, symbol, params={}):
        self.load_markets()
        market = self.market(symbol)
        response = self.publicGetOpenTick(self.extend({
            'symbol': market['id'],
        }, params))
        ticker = response['data']
        return self.parse_ticker(ticker, market)

    def parse_trade(self, trade, market=None):
        id = None
        order = None
        info = trade
        timestamp = None
        type = None
        side = None
        price = None
        cost = None
        amount = None
        fee = None
        if isinstance(trade, list):
            timestamp = trade[0]
            type = 'limit'
            if trade[1] == 'BUY':
                side = 'buy'
            elif trade[1] == 'SELL':
                side = 'sell'
            price = trade[2]
            amount = trade[3]
        else:
            timestamp = self.safe_value(trade, 'createdAt')
            order = self.safe_string(trade, 'orderOid')
            id = self.safe_string(trade, 'oid')
            side = self.safe_string(trade, 'direction')
            if side is not None:
                side = side.lower()
            price = self.safe_float(trade, 'dealPrice')
            amount = self.safe_float(trade, 'amount')
            cost = self.safe_float(trade, 'dealValue')
            feeCurrency = None
            if market is not None:
                feeCurrency = market['quote'] if (side == 'sell') else market['base']
            else:
                feeCurrencyField = 'coinTypePair' if (side == 'sell') else 'coinType'
                feeCurrency = self.safe_string(order, feeCurrencyField)
                if feeCurrency is not None:
                    if feeCurrency in self.currencies_by_id:
                        feeCurrency = self.currencies_by_id[feeCurrency]['code']
            fee = {
                'cost': self.safe_float(trade, 'fee'),
                'currency': feeCurrency,
            }
        symbol = None
        if market is not None:
            symbol = market['symbol']
        return {
            'id': id,
            'order': order,
            'info': info,
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
            'symbol': symbol,
            'type': type,
            'side': side,
            'price': price,
            'cost': cost,
            'amount': amount,
            'fee': fee,
        }

    def fetch_trades(self, symbol, since=None, limit=None, params={}):
        self.load_markets()
        market = self.market(symbol)
        response = self.publicGetOpenDealOrders(self.extend({
            'symbol': market['id'],
            'limit': limit,
        }, params))
        return self.parse_trades(response['data'], market, since, limit)

    def fetch_my_trades(self, symbol=None, since=None, limit=None, params={}):
        # todo: self method is deprecated and to be deleted shortly
        # it improperly mimics fetchMyTrades with closed orders
        # kucoin does not have any means of fetching personal trades at all
        # self will effectively simplify current convoluted implementations of parseOrder and parseTrade
        if symbol is None:
            raise ExchangeError(self.id + ' fetchMyTrades is deprecated and requires a symbol argument')
        self.load_markets()
        market = self.market(symbol)
        request = {
            'symbol': market['id'],
        }
        if limit is not None:
            request['limit'] = limit
        response = self.privateGetDealOrders(self.extend(request, params))
        return self.parse_trades(response['data']['datas'], market, since, limit)

    def parse_trading_view_ohlcv(self, ohlcvs, market=None, timeframe='1m', since=None, limit=None):
        result = self.convert_trading_view_to_ohlcv(ohlcvs)
        return self.parse_ohlcvs(result, market, timeframe, since, limit)

    def fetch_ohlcv(self, symbol, timeframe='1m', since=None, limit=None, params={}):
        self.load_markets()
        market = self.market(symbol)
        end = self.seconds()
        resolution = self.timeframes[timeframe]
        # convert 'resolution' to minutes in order to calculate 'from' later
        minutes = resolution
        if minutes == 'D':
            if limit is None:
                limit = 30  # 30 days, 1 month
            minutes = 1440
        elif minutes == 'W':
            if limit is None:
                limit = 52  # 52 weeks, 1 year
            minutes = 10080
        elif limit is None:
            # last 1440 periods, whatever the duration of the period is
            # for 1m it equals 1 day(24 hours)
            # for 5m it equals 5 days
            # ...
            limit = 1440
        start = end - limit * minutes * 60
        # if 'since' has been supplied by user
        if since is not None:
            start = int(since / 1000)  # convert milliseconds to seconds
            end = min(end, self.sum(start, limit * minutes * 60))
        request = {
            'symbol': market['id'],
            'resolution': resolution,
            'from': start,
            'to': end,
        }
        response = self.publicGetOpenChartHistory(self.extend(request, params))
        return self.parse_trading_view_ohlcv(response, market, timeframe, since, limit)

    def withdraw(self, code, amount, address, tag=None, params={}):
        self.check_address(address)
        self.load_markets()
        currency = self.currency(code)
        self.check_address(address)
        response = self.privatePostAccountCoinWithdrawApply(self.extend({
            'coin': currency['id'],
            'amount': amount,
            'address': address,
        }, params))
        return {
            'info': response,
            'id': None,
        }

    def sign(self, path, api='public', method='GET', params={}, headers=None, body=None):
        endpoint = '/' + self.version + '/' + self.implode_params(path, params)
        url = self.urls['api'][api] + endpoint
        query = self.omit(params, self.extract_params(path))
        if api == 'private':
            self.check_required_credentials()
            # their nonce is always a calibrated synched milliseconds-timestamp
            nonce = self.nonce()
            queryString = ''
            nonce = str(nonce)
            if query:
                queryString = self.rawencode(self.keysort(query))
                url += '?' + queryString
                if method != 'GET':
                    body = queryString
            auth = endpoint + '/' + nonce + '/' + queryString
            payload = base64.b64encode(self.encode(auth))
            # payload should be "encoded" as returned from stringToBase64
            signature = self.hmac(payload, self.encode(self.secret), hashlib.sha256)
            headers = {
                'KC-API-KEY': self.apiKey,
                'KC-API-NONCE': nonce,
                'KC-API-SIGNATURE': signature,
            }
        else:
            if query:
                url += '?' + self.urlencode(query)
        return {'url': url, 'method': method, 'body': body, 'headers': headers}

    def throw_exception_on_error(self, response):
        #
        # API endpoints return the following formats
        #     {success: False, code: "ERROR", msg: "Min price:100.0"}
        #     {success: True,  code: "OK",    msg: "Operation succeeded."}
        #
        # Web OHLCV endpoint returns self:
        #     {s: "ok", o: [], h: [], l: [], c: [], v: []}
        #
        # This particular method handles API responses only
        #
        if not('success' in list(response.keys())):
            return
        if response['success'] is True:
            return  # not an error
        if not('code' in list(response.keys())) or not('msg' in list(response.keys())):
            raise ExchangeError(self.id + ': malformed response: ' + self.json(response))
        code = self.safe_string(response, 'code')
        message = self.safe_string(response, 'msg')
        feedback = self.id + ' ' + self.json(response)
        if code == 'UNAUTH':
            if message == 'Invalid nonce':
                raise InvalidNonce(feedback)
            raise AuthenticationError(feedback)
        elif code == 'ERROR':
            if message.find('The precision of amount') >= 0:
                raise InvalidOrder(feedback)  # amount violates precision.amount
            if message.find('Min amount each order') >= 0:
                raise InvalidOrder(feedback)  # amount < limits.amount.min
            if message.find('Min price:') >= 0:
                raise InvalidOrder(feedback)  # price < limits.price.min
            if message.find('Max price:') >= 0:
                raise InvalidOrder(feedback)  # price > limits.price.max
            if message.find('The precision of price') >= 0:
                raise InvalidOrder(feedback)  # price violates precision.price
        elif code == 'NO_BALANCE':
            if message.find('Insufficient balance') >= 0:
                raise InsufficientFunds(feedback)
        raise ExchangeError(self.id + ': unknown response: ' + self.json(response))

    def handle_errors(self, code, reason, url, method, headers, body, response=None):
        if response is not None:
            # JS callchain parses body beforehand
            self.throw_exception_on_error(response)
        elif body and(body[0] == '{'):
            # Python/PHP callchains don't have json available at self step
            self.throw_exception_on_error(json.loads(body))
