# Frequently Asked Questions

## I'm trying to run the code, but it's not working, how do I fix it?

If your question is formulated in a short manner like the above, we won't help. We don't teach programming. If you're unable to read and understand the [Manual](https://github.com/ccxt/ccxt/wiki) or you can't follow the guides from the [CONTRIBUTING](https://github.com/ccxt/ccxt/blob/master/CONTRIBUTING.md) doc on how to report an issue, we won't help either. Read the Manual. You should not risk money and time without reading the entire Manual very carefully. Namely, when asking a question:
- Use the search button for duplicates first!
- **Post your request and response in `verbose` mode!** It's written and mentioned everywhere, in the [Troubleshooting](https://github.com/ccxt/ccxt/wiki/Manual#troubleshooting) section, in the [README](https://github.com/ccxt/ccxt/blob/master/README.md) and in many answers to similar questions among [previous issues](https://github.com/ccxt/ccxt/issues) and [pull requests](https://github.com/ccxt/ccxt/pulls).
- **Post your code** to reproduce the problem. Make it a complete short runnable program, don't swallow the lines and make it as compact as you can (5-10 lines of code), including the instantation code.
    - **Surround code and output with triple backticks: &#096;&#096;&#096;GOOD&#096;&#096;&#096;**.
    - Don't confuse the backtick symbol (&#096;) with the quote symbol (\'): '''BAD'''
    - Don't confuse a single backtick with triple backticks: &#096;BAD&#096;
- Post your version number of ccxt
- Post your language version number, how do you think we can guess it otherwise?


## I am calling a method and I get an error, what am I doing wrong?

You're not reporting the issue properly ) Please, help the community to help you ) Read this and follow the steps: https://github.com/ccxt/ccxt/blob/master/CONTRIBUTING.md#how-to-submit-an-issue. Once again, your code to reproduce the issue and your verbose request and response **ARE REQUIRED**. *The error traceback is not enough.*

## Can you implement feature `foo` in exchange `bar`?

Yes, we can. And we will, if nobody else does that before us. There's very little point in asking this type of questions, because the answer is always positive. When someone asks if we can do this or that, the question is not about our abilities, it all boils down to time and management needed for implementing all accumulated feature requests. Moreover, this is an open-source library which is a work in progress. This means, that this project is intended to be developed by the community of users, who are using it. All contributions are welcome! What you're asking is not whether we can or cannot implement it, in fact you're actually telling us to go do that particular task and this is not how we see a voluntary collaboration.

## When will you add feature `foo` for exchange `bar` ? What's the estimated time? When should we expect this?

We don't give promises or estimates on the open-source work. The reasoning behind this is explained in the previous paragraph.

## What's your progress on adding the feature `foo` that was requested earlier? How do you do implementing exchange `bar`?

This type of questions is usually a waste of time, because answering it usually requires too much time for context-switching, and it often takes more time to answer this question, than to actually satisfy the request with code for a new feature or a new exchange. The progress of this open-source project is also open, so, whenever you're wondering how it is doing, take a look into commit history.

## Hey! The fix you've uploaded is in JS, would you fix Python / PHP as well, please?

Our build system generates exchange-specific Python and PHP code for us automatically, so it is transpiled from JS, and there's no need to fix all languages separately one by one. Thus, if it is fixed in JS, it is fixed in Python pip and PHP Composer as well. Just upgrade your version with `pip` or `composer` and you'll be fine. More about it here: https://github.com/ccxt/ccxt/blob/master/CONTRIBUTING.md#multilanguage-support