export const styles = {
  body: {
    fontFamily: "'Source Sans Pro', Helvetica, sans-serif",
    lineHeight: 1.6,
  },
  container: {
    width: ['100%', '100%', 920],
    padding: ['20px', '0 40px 40px'],
  },
  h1: {
    margin: ['30px 0 20px', '60px 0 20px', '40px 0 30px'],
    fontFamily: '"Playfair Display", serif',
    fontSize: [50, 50, 70],
    fontWeight: 700,
    letterSpacing: '-0.02em',
  },
  h2: {
    margin: ['40px 0 20px', '40px 0 30px'],
    lineHeight: ['1.2em', '1.5em'],
    fontFamily: '"Poppins", serif',
    fontWeight: 400,
    fontSize: 32,
    letterSpacing: '-0.02em',
  },
  h3: {
    margin: '25px 0 10px',
    fontSize: 22,
    fontWeight: 400,
  },
  h4: {
    margin: '25px 0 10px',
    fontSize: 18,
    fontWeight: 400,
  },
  h5: {
    margin: '20px 0 10px',
    fontSize: 16,
    fontWeight: 400,
  },
  h6: {
    margin: '20px 0 10px',
    fontSize: 16,
    fontWeight: 400,
    textTransform: 'uppercase',
  },
  ol: {
    padding: 0,
    margin: '10px 0 10px',
  },
  ul: {
    padding: 0,
    margin: '10px 0 10px',
  },
  playground: {
    padding: ['1.5em', '2em'],
  },
  code: {
    margin: '0 3px',
    borderRadius: '3px',
    fontFamily: '"Source Code Pro", monospace',
    padding: `2px 5px`,
    fontSize: '0.8em',
    border: '1px solid rgba(0, 0, 0, 0.02)',
  },
  pre: {
    fontFamily: '"Source Code Pro", monospace',
    fontSize: 14,
    lineHeight: 1.8,
  },
  paragraph: {
    margin: '10px 0 20px 0',
  },
  table: {
    overflowY: 'hidden',
    overflowX: ['initial', 'initial', 'initial', 'hidden'],
    display: ['block', 'block', 'block', 'table'],
    width: '100%',
    fontFamily: '"Source Code Pro", monospace',
    fontSize: 14,
  },
  blockquote: {
    margin: '25px 0',
    padding: '20px',
    fontStyle: 'italic',
    fontSize: 18,
  },
}
