---
order: 8
title: 国际化
---

`antd` 目前的默认文案是英文，如果需要使用其他语言，可以参考下面的方案。

## LocaleProvider

antd 提供了一个 React 组件 [LocaleProvider](/components/locale-provider) 用于全局配置国际化文案。

```jsx
import zhCN from 'antd/lib/locale-provider/zh_CN';

return (
  <LocaleProvider locale={zhCN}>
    <App />
  </LocaleProvider>
);
```

注意：`zh_CN` 是文件名，以下表格也遵循同样的规则。

目前支持以下语言：

|语言|文件名|
|---|---|
|阿拉伯|ar_EG|
|保加利亚语|bg_BG|
|加泰罗尼亚语|ca_ES|
|捷克语|cs_CZ|
|德语|de_DE|
|希腊语|el_GR|
|英语|en_GB|
|英语（美式）|en_US|
|西班牙语|es_ES|
|爱沙尼亚语|et_EE|
|波斯语|fa_IR|
|芬兰语|fi_FI|
|法语（比利时）|fr_BE|
|法语|fr_FR|
|冰岛语|is_IS|
|意大利语|it_IT|
|日语|ja_JP|
|韩语/朝鲜语|ko_KR|
|挪威|nb_NO|
|荷兰语（比利时）|nl_BE|
|荷兰语|nl_NL|
|波兰语|pl_PL|
|葡萄牙语(巴西)|pt_BR|
|葡萄牙语|pt_PT|
|斯洛伐克语|sk_SK|
|塞尔维亚|sr_RS|
|瑞典语|sv_SE|
|泰语|th_TH|
|土耳其语|tr_TR|
|俄罗斯语|ru_RU|
|乌克兰语|uk_UA|
|越南语|vi_VN|
|简体中文|zh_CN|
|繁体中文|zh_TW|

具体的使用方法和新语言包贡献方式请参考 [LocaleProvider 文档](/components/locale-provider)。

## i18n 项目示例

我们还提供了一个使用了 [react-intl](https://github.com/yahoo/react-intl) 和 LocaleProvider 的完整的国际化项目示例：[ant-design/intl-example](https://github.com/ant-design/intl-example)，欢迎参考使用。
