---
order: 7
title: Third-Party Libraries
---

`antd` is designed to provide high-quality React UI components which follow the Ant Design Specification. So, we are not going to implement other functions which are not relative to `antd`'s target, and recommend using the excellent third-party library which have come from the React community:

Category | Recommended Components
---------|-----------------------
Router | [react-router](https://github.com/ReactTraining/react-router)
Layout | [react-blocks](http://whoisandy.github.io/react-blocks/)
Drag and drop | [react-dnd](https://github.com/gaearon/react-dnd)  [react-draggable](https://github.com/mzabriskie/react-draggable)
Code Editor | [react-codemirror2](https://github.com/scniro/react-codemirror2)
Rich Text Editor | [react-quill](https://github.com/zenoamaro/react-quill)  [react-draft-wysiwyg](https://github.com/jpuri/react-draft-wysiwyg) [react-lz-editor](https://github.com/leejaen/react-lz-editor)(Ant Design style)
Color Picker | [rc-color-picker](https://github.com/react-component/color-picker) [react-color](http://casesandberg.github.io/react-color/)
Media Query | [react-responsive](https://github.com/contra/react-responsive) [react-media](https://github.com/ReactTraining/react-media)
Copy to clipboard | [react-copy-to-clipboard](https://github.com/nkbt/react-copy-to-clipboard)
Document head manager | [react-helmet](https://github.com/nfl/react-helmet) [react-document-title](https://github.com/gaearon/react-document-title)
Icons | [react-fa](https://github.com/andreypopp/react-fa) [react-icons](https://github.com/gorangajic/react-icons)
QR Code | [qrcode.react](https://github.com/zpao/qrcode.react)
Charts | [BizCharts](https://github.com/alibaba/BizCharts) [recharts](https://github.com/recharts/recharts/) [victory](https://github.com/FormidableLabs/victory)
Top Progress Bar | [nprogress](https://github.com/rstacruz/nprogress)
i18n | [react-intl](https://github.com/yahoo/react-intl)
Code highlight | [react-syntax-highlighter](https://github.com/conorhastings/react-syntax-highlighter)
Markdown renderer | [react-markdown](http://rexxars.github.io/react-markdown/)
Infinite Scroll | [react-virtualized](https://github.com/bvaughn/react-virtualized)
Map | [react-google-maps](https://github.com/tomchentw/react-google-maps) [google-map-react](https://github.com/istarkov/google-map-react) [react-amap](https://github.com/ElemeFE/react-amap)
Emoji | [emoji-mart](https://github.com/missive/emoji-mart)

<style>
.markdown table td:first-child {
  font-weight: 500;
  width: 25%;
  background: #fcfcfc;
}
.markdown table td > a:not(:last-child) {
  margin-right: 18px;
}
.markdown table td > a:not(:last-child):after {
  content: '|';
  color: #bbb;
  margin: 0 6px 0 8px;
  pointer-events: none;
  position: absolute;
}
</style>
