---
category: 视觉
order: 4
title: 图标
---

图标是具有指代意义的图形，也是一种标识。通过使用图标表达命令，强调状态，表示产品或类别。为了系统及跨平台之间图形认知保持一致，Ant Design 的图标在设计和使用时有以下两个原则点需要注意：

- 简单的图形语言以及高辨识度。清晰、直观的图标更能明确指代含义便于识别记忆；
- 保持图标之间一致的风格和表现方式。界面中的所有图标都应该在细节设计、透视和笔画权重上保持一致。

---

## 系统图标

<img class="preview-img no-padding" align="right" src="https://gw.alipayobjects.com/zos/rmsportal/XzOPonWCsPjvgkrklCzo.png">

系统图标通常用来表示常用的操作，比如：删除、保存、编辑。也可以用来表示一个文件或者状态。

- [查看图标库](/components/icon/)

### 关键轮廓线

<img class="preview-img no-padding" align="right" src="https://gw.alipayobjects.com/zos/rmsportal/beTZeZjJBVuhMyTOhebs.png" alt="网格和关键轮廓线">

根据不同的图标形状类型使用不同的轮廓线，可以使图标之间保持一致的视觉效果。

请将所有图标在 1024×1024（16×16 的 64 倍）的画板中制作。

- [制作小技巧](https://zos.alipayobjects.com/rmsportal/hmNuLjCkBssupcZgYAde.png)

<img class="preview-img no-padding inline" align="right" src="https://gw.alipayobjects.com/zos/rmsportal/rxuHAKGEGLuqBJAAhnSm.png" alt="正方形外轮廓">
<img class="preview-img no-padding inline" align="right" src="https://gw.alipayobjects.com/zos/rmsportal/fhkmysGZiTkPVszWHgUy.png" alt="横向矩形外轮廓">

<img class="preview-img no-padding inline" align="right" src="https://gw.alipayobjects.com/zos/rmsportal/BiraoJgbXokyzmUFqVuf.png" alt="圆形外轮廓">
<img class="preview-img no-padding inline" align="right" src="https://gw.alipayobjects.com/zos/rmsportal/wgQLwFnPaeEalmmSuBMO.png" alt="纵向矩形外轮廓">

### 笔画

<img class="preview-img no-padding good" align="right" src="https://gw.alipayobjects.com/zos/rmsportal/uoNmxXiqKpfoFDdEVjUB.png" alt="正确示范" description="icon 的线条粗细统一保持为 72px">
<img class="preview-img no-padding bad" align="right" src="https://gw.alipayobjects.com/zos/rmsportal/cnFYbWzcKaPFSiHcptCF.png" alt="错误示范" description="icon 的线条粗细不统一">

一致的笔画权重是保持整个图标系统视觉统一的关键，Ant Design 系统图标的线条统一为 72px 宽度。

### 边角

<img class="preview-img no-padding good" align="right" src="https://gw.alipayobjects.com/zos/rmsportal/tGbuhPmvEJXmOFoYAkPK.png" alt="正确示范" description="图标的边角设计都遵循了 Ant Design 的规范">
<img class="preview-img no-padding bad" align="right" src="https://gw.alipayobjects.com/zos/rmsportal/JekevTlqdDJQLIQwrppm.png" alt="错误示范" description="线条的终端并不是圆角">

一致的角度半径也是保持整个图标系统视觉统一的重要元素。

Ant Design 的图标设计中，外轮廓线统一半径为 72px 的圆角，icon 内部空间的边角保持直角，笔画的终端为圆角。

### 视觉修正

<img class="preview-img no-padding good" align="right" src="https://gw.alipayobjects.com/zos/rmsportal/VghPLyDUdFmjhGJlNxjV.png" alt="正确示范" description="对于图标内较复杂的『JPG』字母在笔画权重上进行了微调，让图标看上去更和谐">
<img class="preview-img no-padding bad" align="right" src="https://gw.alipayobjects.com/zos/rmsportal/qnzloxRQmvHzHAhWWwCS.png" alt="错误示范" description="icon 图形太复杂，空间显得拥挤">

在一些特殊情况下（比如，icon 的形状比较复杂紧凑），可以通过调整线条的粗细或圆角的大小等微妙的变化来增加图标的易读性。

### 透视角度

<img class="preview-img no-padding good" align="right" src="https://gw.alipayobjects.com/zos/rmsportal/tIePnIOTXtgzVKbqwucm.png" alt="正确示范" description="保持平面、简洁的风格">
<img class="preview-img no-padding bad" align="right" src="https://gw.alipayobjects.com/zos/rmsportal/ALNOEelXeFhxUobLqyCq.png" alt="错误示范" description="图标具有俯视角度，并不是在一个维度空间内">

始终保持简洁、平面的风格,不要让图标具有多维度空间感，或者充满了细节。

### 命名规则

<img class="preview-img no-padding" align="right" src="https://gw.alipayobjects.com/zos/rmsportal/NFOvbdbVWeeEqOkdUfVB.png">

统一的命名方式有助于管理图标，也能更快速的找到需要的图标。例如，环绕型的图标统一以「-o」后缀。

### 图标尺寸

<img class="preview-img no-padding" align="right" src="https://gw.alipayobjects.com/zos/rmsportal/jAuedlyhNIDyOIZTqbqN.png">

应用于页面时请使用 Ant Design 的规范尺寸，与字体搭配时和字体的尺寸保持一致。

例如：和 12pt 字体搭配时，图标使用 12px，图标与文字的间距为 8px。

### 颜色

<img class="preview-img no-padding" align="right" src="https://gw.alipayobjects.com/zos/rmsportal/LxGLhtnwvCqZWYqGDAAr.png" description="表格中 @Black = #000000、@White = #FFFFFF、@Blue-6 = #1890FF">

图标的颜色需要与搭配文案的色值保持一致（表示状态的除外）。

---

## 业务图标

<img class="preview-img no-padding" align="right" src="https://gw.alipayobjects.com/zos/rmsportal/EADAnRecKSTxvpxPzKoq.png">

业务图标不同于系统图标，本身不带有功能性的操作，而是辅助配合文案的一个抽象化图形。相较于系统图标，业务图标在设计的细节上更为丰富，使用的尺寸也比较大。

> 注：业务图标的设计原则与系统图标基本一致，在细节处理上（如笔画权重、圆角大小等）可视具体场景而定。

### 图标尺寸

<img class="preview-img no-padding" align="right" src="https://gw.alipayobjects.com/zos/rmsportal/uwAgfciGszhdiVlMSBXK.png">

在常规使用中，有 32px（最小尺寸）、48px 和 64px（最大尺寸）三种选择。

### 颜色

<img class="preview-img no-padding" align="right" src="https://gw.alipayobjects.com/zos/rmsportal/wUxhTxZlHoTxDvneWBWO.png">

业务图标有单色（中性色）和双色（中性色+主色）两种，主色的面积不超过整个 icon 的 40%。
