---
category: Ant Design
order: 1
title: 设计价值观
---

设计价值观为 Ant Design 的设计者以及基于 Ant Design 进行产品设计的设计者，提供评价设计好坏的内在标准，并提供有效的设计实践所遵循的规则。同时，它启示并激发了设计原则和设计模式，为具体的设计问题提供向导和一般解决方案。

<div>
  <img src="https://gw.alipayobjects.com/zos/rmsportal/bIJZFjriQqeMPYyUkSev.png" alt="总概" />
</div>

在『设计价值观』的坚持上，Ant Design 有两点与众不同：

## 自然

<div>
  <img src="https://gw.alipayobjects.com/zos/rmsportal/cdaxgaTMQCGTqjdlwwgt.png" alt="自然" />
</div>

作为一份子，自然界的方方面面都会对用户行为产生深远影响，设计者应该从其中汲取灵感，并运用到当下的设计工作中。我们已做了部分探索，并将追求『自然』作为我们未来持之以恒的方向。

- 在感知和认知中，视觉系统扮演着最重要的角色，通过提炼自然界中的客观规律并运用到界面设计中，从而创建更有层次产品体验；同时，适时加入听觉系统、触觉系统等，创建更多维、更真实的产品体验。详见视觉语言
- 在行为的执行中，利用行为分析、人工智能、传感器等一系列方式，辅助用户有效决策、减少用户额外操作，从而节省用户脑力和体力，让人机交互行为更自然。

## 确定

<div>
  <img src="https://gw.alipayobjects.com/zos/rmsportal/ZxgRAMzXNrxHTcvMLchq.png" alt="确定" />
</div>

『设计者』需要做出更好的设计决策，给予研发团队一种高确定性、低熵值的研发状态。同时，不同设计者在充分理解业务述求后，基于 Ant Design 体系都会有相同且符合当前业务特性的设计产出。

- **保持克制：** 能做，但想清楚了不做。设计者应当聚焦在最有价值产品功能打磨，并用尽可能少的设计元素将其表达。正如 Antoine de St.Exupery 所说：完美不在于无以复加，而在于无可删减，万事莫不如此。
- **面向对象的方法：** 探索设计规律，并将其抽象成『对象』，增强界面设计的灵活性和可维护性，同时也减少『设计者』的主观干扰，从而降低系统的不确定性。例如：色值换算、间距排版。
- **模块化设计：** 将复杂或者重复出现的局部封装成模块，提供有限接口与其他模块互动，最终全面减少系统的复杂度，进而增进可靠性以及可维护性。设计者可运用现有的组件/模板或者自行抽象可复用的组件/模板，节约无谓的设计且保持系统一致性，让『设计者』把创造力专注在最需要的地方。
