﻿// Copyright (c) Microsoft.  All Rights Reserved.  Licensed under the Apache License, Version 2.0.  See License.txt in the project root for license information.

namespace Microsoft.CodeAnalysis.CSharp
{
    internal enum ErrorCode
    {
        Void = InternalErrorCode.Void,
        Unknown = InternalErrorCode.Unknown,
        //FTL_InternalError = 1,
        //FTL_FailedToLoadResource = 2,
        //FTL_NoMemory = 3,
        //ERR_WarningAsError = 4,
        //ERR_MissingOptionArg = 5,
        ERR_NoMetadataFile = 6,
        //FTL_ComPlusInit = 7,
        //FTL_MetadataImportFailure = 8,    no longer used in Roslyn. 
        FTL_MetadataCantOpenFile = 9,
        //ERR_FatalError = 10,
        //ERR_CantImportBase = 11,
        ERR_NoTypeDef = 12,
        //FTL_MetadataEmitFailure = 13,     Roslyn does not catch stream writing exceptions. Those are propagated to the caller.
        //FTL_RequiredFileNotFound = 14,
        //ERR_ClassNameTooLong = 15,    Deprecated in favor of ERR_MetadataNameTooLong.
        ERR_OutputWriteFailed = 16,
        ERR_MultipleEntryPoints = 17,
        //ERR_UnimplementedOp = 18,
        ERR_BadBinaryOps = 19,
        ERR_IntDivByZero = 20,
        ERR_BadIndexLHS = 21,
        ERR_BadIndexCount = 22,
        ERR_BadUnaryOp = 23,
        //ERR_NoStdLib = 25,        not used in Roslyn
        ERR_ThisInStaticMeth = 26,
        ERR_ThisInBadContext = 27,
        WRN_InvalidMainSig = 28,
        ERR_NoImplicitConv = 29, // Requires SymbolDistinguisher.
        ERR_NoExplicitConv = 30, // Requires SymbolDistinguisher.
        ERR_ConstOutOfRange = 31,
        ERR_AmbigBinaryOps = 34,
        ERR_AmbigUnaryOp = 35,
        ERR_InAttrOnOutParam = 36,
        ERR_ValueCantBeNull = 37,
        //ERR_WrongNestedThis = 38,     No longer given in Roslyn. Less specific ERR_ObjectRequired "An object reference is required for the non-static..."
        ERR_NoExplicitBuiltinConv = 39, // Requires SymbolDistinguisher.
        //FTL_DebugInit = 40,           Not used in Roslyn. Roslyn gives FTL_DebugEmitFailure with specific error code info.
        FTL_DebugEmitFailure = 41,
        //FTL_DebugInitFile = 42,       Not used in Roslyn. Roslyn gives ERR_CantOpenFileWrite with specific error info.
        //FTL_BadPDBFormat = 43,        Not used in Roslyn. Roslyn gives FTL_DebugEmitFailure with specific error code info.
        ERR_BadVisReturnType = 50,
        ERR_BadVisParamType = 51,
        ERR_BadVisFieldType = 52,
        ERR_BadVisPropertyType = 53,
        ERR_BadVisIndexerReturn = 54,
        ERR_BadVisIndexerParam = 55,
        ERR_BadVisOpReturn = 56,
        ERR_BadVisOpParam = 57,
        ERR_BadVisDelegateReturn = 58,
        ERR_BadVisDelegateParam = 59,
        ERR_BadVisBaseClass = 60,
        ERR_BadVisBaseInterface = 61,
        ERR_EventNeedsBothAccessors = 65,
        ERR_EventNotDelegate = 66,
        WRN_UnreferencedEvent = 67,
        ERR_InterfaceEventInitializer = 68,
        ERR_EventPropertyInInterface = 69,
        ERR_BadEventUsage = 70,
        ERR_ExplicitEventFieldImpl = 71,
        ERR_CantOverrideNonEvent = 72,
        ERR_AddRemoveMustHaveBody = 73,
        ERR_AbstractEventInitializer = 74,
        //ERR_PossibleBadNegCast = 75,      Not used in Roslyn. Occurs so infrequently, not worth reimplementing.
        ERR_ReservedEnumerator = 76,
        ERR_AsMustHaveReferenceType = 77,
        WRN_LowercaseEllSuffix = 78,
        ERR_BadEventUsageNoField = 79,
        ERR_ConstraintOnlyAllowedOnGenericDecl = 80,
        ERR_TypeParamMustBeIdentifier = 81,
        ERR_MemberReserved = 82,
        ERR_DuplicateParamName = 100,
        ERR_DuplicateNameInNS = 101,
        ERR_DuplicateNameInClass = 102,
        ERR_NameNotInContext = 103,
        ERR_AmbigContext = 104,
        WRN_DuplicateUsing = 105,
        ERR_BadMemberFlag = 106,
        ERR_BadMemberProtection = 107,
        WRN_NewRequired = 108,
        WRN_NewNotRequired = 109,
        ERR_CircConstValue = 110,
        ERR_MemberAlreadyExists = 111,
        ERR_StaticNotVirtual = 112,
        ERR_OverrideNotNew = 113,
        WRN_NewOrOverrideExpected = 114,
        ERR_OverrideNotExpected = 115,
        ERR_NamespaceUnexpected = 116,
        ERR_NoSuchMember = 117,
        ERR_BadSKknown = 118,
        ERR_BadSKunknown = 119,
        ERR_ObjectRequired = 120,
        ERR_AmbigCall = 121,
        ERR_BadAccess = 122,
        ERR_MethDelegateMismatch = 123,
        ERR_RetObjectRequired = 126,
        ERR_RetNoObjectRequired = 127,
        ERR_LocalDuplicate = 128,
        ERR_AssgLvalueExpected = 131,
        ERR_StaticConstParam = 132,
        ERR_NotConstantExpression = 133,
        ERR_NotNullConstRefField = 134,
        // ERR_NameIllegallyOverrides = 135, // Not used in Roslyn anymore due to 'Single Meaning' relaxation changes
        ERR_LocalIllegallyOverrides = 136,
        ERR_BadUsingNamespace = 138,
        ERR_NoBreakOrCont = 139,
        ERR_DuplicateLabel = 140,
        ERR_NoConstructors = 143,
        ERR_NoNewAbstract = 144,
        ERR_ConstValueRequired = 145,
        ERR_CircularBase = 146,
        ERR_BadDelegateConstructor = 148,
        ERR_MethodNameExpected = 149,
        ERR_ConstantExpected = 150,
        // ERR_SwitchGoverningTypeValueExpected shares the same error code (CS0151) with ERR_IntegralTypeValueExpected in Dev10 compiler.
        // However ERR_IntegralTypeValueExpected is currently unused and hence being removed. If we need to generate this error in future
        // we can use error code CS0166. CS0166 was originally reserved for ERR_SwitchFallInto in Dev10, but was never used. 
        ERR_SwitchGoverningTypeValueExpected = 151,
        ERR_DuplicateCaseLabel = 152,
        ERR_InvalidGotoCase = 153,
        ERR_PropertyLacksGet = 154,
        ERR_BadExceptionType = 155,
        ERR_BadEmptyThrow = 156,
        ERR_BadFinallyLeave = 157,
        ERR_LabelShadow = 158,
        ERR_LabelNotFound = 159,
        ERR_UnreachableCatch = 160,
        ERR_ReturnExpected = 161,
        WRN_UnreachableCode = 162,
        ERR_SwitchFallThrough = 163,
        WRN_UnreferencedLabel = 164,
        ERR_UseDefViolation = 165,
        //ERR_NoInvoke = 167,
        WRN_UnreferencedVar = 168,
        WRN_UnreferencedField = 169,
        ERR_UseDefViolationField = 170,
        ERR_UnassignedThis = 171,
        ERR_AmbigQM = 172,
        ERR_InvalidQM = 173, // Requires SymbolDistinguisher.
        ERR_NoBaseClass = 174,
        ERR_BaseIllegal = 175,
        ERR_ObjectProhibited = 176,
        ERR_ParamUnassigned = 177,
        ERR_InvalidArray = 178,
        ERR_ExternHasBody = 179,
        ERR_AbstractAndExtern = 180,
        ERR_BadAttributeParamType = 181,
        ERR_BadAttributeArgument = 182,
        WRN_IsAlwaysTrue = 183,
        WRN_IsAlwaysFalse = 184,
        ERR_LockNeedsReference = 185,
        ERR_NullNotValid = 186,
        ERR_UseDefViolationThis = 188,
        ERR_ArgsInvalid = 190,
        ERR_AssgReadonly = 191,
        ERR_RefReadonly = 192,
        ERR_PtrExpected = 193,
        ERR_PtrIndexSingle = 196,
        WRN_ByRefNonAgileField = 197,
        ERR_AssgReadonlyStatic = 198,
        ERR_RefReadonlyStatic = 199,
        ERR_AssgReadonlyProp = 200,
        ERR_IllegalStatement = 201,
        ERR_BadGetEnumerator = 202,
        ERR_TooManyLocals = 204,
        ERR_AbstractBaseCall = 205,
        ERR_RefProperty = 206,
        // WRN_OldWarning_UnsafeProp = 207,    // This error code is unused.
        ERR_ManagedAddr = 208,
        ERR_BadFixedInitType = 209,
        ERR_FixedMustInit = 210,
        ERR_InvalidAddrOp = 211,
        ERR_FixedNeeded = 212,
        ERR_FixedNotNeeded = 213,
        ERR_UnsafeNeeded = 214,
        ERR_OpTFRetType = 215,
        ERR_OperatorNeedsMatch = 216,
        ERR_BadBoolOp = 217,
        ERR_MustHaveOpTF = 218,
        WRN_UnreferencedVarAssg = 219,
        ERR_CheckedOverflow = 220,
        ERR_ConstOutOfRangeChecked = 221,
        ERR_BadVarargs = 224,
        ERR_ParamsMustBeArray = 225,
        ERR_IllegalArglist = 226,
        ERR_IllegalUnsafe = 227,
        //ERR_NoAccessibleMember = 228,
        ERR_AmbigMember = 229,
        ERR_BadForeachDecl = 230,
        ERR_ParamsLast = 231,
        ERR_SizeofUnsafe = 233,
        ERR_DottedTypeNameNotFoundInNS = 234,
        ERR_FieldInitRefNonstatic = 236,
        ERR_SealedNonOverride = 238,
        ERR_CantOverrideSealed = 239,
        //ERR_NoDefaultArgs = 241,
        ERR_VoidError = 242,
        ERR_ConditionalOnOverride = 243,
        ERR_PointerInAsOrIs = 244,
        ERR_CallingFinalizeDeprecated = 245, //Dev10: ERR_CallingFinalizeDepracated
        ERR_SingleTypeNameNotFound = 246,
        ERR_NegativeStackAllocSize = 247,
        ERR_NegativeArraySize = 248,
        ERR_OverrideFinalizeDeprecated = 249,
        ERR_CallingBaseFinalizeDeprecated = 250,
        WRN_NegativeArrayIndex = 251,
        WRN_BadRefCompareLeft = 252,
        WRN_BadRefCompareRight = 253,
        ERR_BadCastInFixed = 254,
        ERR_StackallocInCatchFinally = 255,
        ERR_VarargsLast = 257,
        ERR_MissingPartial = 260,
        ERR_PartialTypeKindConflict = 261,
        ERR_PartialModifierConflict = 262,
        ERR_PartialMultipleBases = 263,
        ERR_PartialWrongTypeParams = 264,
        ERR_PartialWrongConstraints = 265,
        ERR_NoImplicitConvCast = 266, // Requires SymbolDistinguisher.
        ERR_PartialMisplaced = 267,
        ERR_ImportedCircularBase = 268,
        ERR_UseDefViolationOut = 269,
        ERR_ArraySizeInDeclaration = 270,
        ERR_InaccessibleGetter = 271,
        ERR_InaccessibleSetter = 272,
        ERR_InvalidPropertyAccessMod = 273,
        ERR_DuplicatePropertyAccessMods = 274,
        ERR_PropertyAccessModInInterface = 275,
        ERR_AccessModMissingAccessor = 276,
        ERR_UnimplementedInterfaceAccessor = 277,
        WRN_PatternIsAmbiguous = 278,
        WRN_PatternStaticOrInaccessible = 279,
        WRN_PatternBadSignature = 280,
        ERR_FriendRefNotEqualToThis = 281,
        WRN_SequentialOnPartialClass = 282,
        ERR_BadConstType = 283,
        ERR_NoNewTyvar = 304,
        ERR_BadArity = 305,
        ERR_BadTypeArgument = 306,
        ERR_TypeArgsNotAllowed = 307,
        ERR_HasNoTypeVars = 308,
        ERR_NewConstraintNotSatisfied = 310,
        ERR_GenericConstraintNotSatisfiedRefType = 311, // Requires SymbolDistinguisher.
        ERR_GenericConstraintNotSatisfiedNullableEnum = 312, // Uses (but doesn't require) SymbolDistinguisher.
        ERR_GenericConstraintNotSatisfiedNullableInterface = 313, // Uses (but doesn't require) SymbolDistinguisher.
        ERR_GenericConstraintNotSatisfiedTyVar = 314, // Requires SymbolDistinguisher.
        ERR_GenericConstraintNotSatisfiedValType = 315, // Requires SymbolDistinguisher.
        ERR_DuplicateGeneratedName = 316,
        // unused 317-399
        ERR_GlobalSingleTypeNameNotFound = 400,
        ERR_NewBoundMustBeLast = 401,
        WRN_MainCantBeGeneric = 402,
        ERR_TypeVarCantBeNull = 403,
        ERR_AttributeCantBeGeneric = 404,
        ERR_DuplicateBound = 405,
        ERR_ClassBoundNotFirst = 406,
        ERR_BadRetType = 407,
        ERR_DuplicateConstraintClause = 409,
        //ERR_WrongSignature = 410,     unused in Roslyn
        ERR_CantInferMethTypeArgs = 411,
        ERR_LocalSameNameAsTypeParam = 412,
        ERR_AsWithTypeVar = 413,
        WRN_UnreferencedFieldAssg = 414,
        ERR_BadIndexerNameAttr = 415,
        ERR_AttrArgWithTypeVars = 416,
        ERR_NewTyvarWithArgs = 417,
        ERR_AbstractSealedStatic = 418,
        WRN_AmbiguousXMLReference = 419,
        WRN_VolatileByRef = 420,
        // WRN_IncrSwitchObsolete = 422,    // This error code is unused.
        ERR_ComImportWithImpl = 423,
        ERR_ComImportWithBase = 424,
        ERR_ImplBadConstraints = 425,
        ERR_DottedTypeNameNotFoundInAgg = 426,
        ERR_MethGrpToNonDel = 428,
        // WRN_UnreachableExpr = 429,       // This error code is unused.
        ERR_BadExternAlias = 430,
        ERR_ColColWithTypeAlias = 431,
        ERR_AliasNotFound = 432,
        ERR_SameFullNameAggAgg = 433,
        ERR_SameFullNameNsAgg = 434,
        WRN_SameFullNameThisNsAgg = 435,
        WRN_SameFullNameThisAggAgg = 436,
        WRN_SameFullNameThisAggNs = 437,
        ERR_SameFullNameThisAggThisNs = 438,
        ERR_ExternAfterElements = 439,
        WRN_GlobalAliasDefn = 440,
        ERR_SealedStaticClass = 441,
        ERR_PrivateAbstractAccessor = 442,
        ERR_ValueExpected = 443,
        // WRN_UnexpectedPredefTypeLoc = 444,  // This error code is unused.
        ERR_UnboxNotLValue = 445,
        ERR_AnonMethGrpInForEach = 446,
        //ERR_AttrOnTypeArg = 447,      unused in Roslyn. The scenario for which this error exists should, and does generate a parse error.
        ERR_BadIncDecRetType = 448,
        ERR_RefValBoundMustBeFirst = 449,
        ERR_RefValBoundWithClass = 450,
        ERR_NewBoundWithVal = 451,
        ERR_RefConstraintNotSatisfied = 452,
        ERR_ValConstraintNotSatisfied = 453,
        ERR_CircularConstraint = 454,
        ERR_BaseConstraintConflict = 455,
        ERR_ConWithValCon = 456,
        ERR_AmbigUDConv = 457,
        WRN_AlwaysNull = 458,
        ERR_AddrOnReadOnlyLocal = 459,
        ERR_OverrideWithConstraints = 460,
        ERR_AmbigOverride = 462,
        ERR_DecConstError = 463,
        WRN_CmpAlwaysFalse = 464,
        WRN_FinalizeMethod = 465,
        ERR_ExplicitImplParams = 466,
        // WRN_AmbigLookupMeth = 467,      //no longer issued in Roslyn
        //ERR_SameFullNameThisAggThisAgg = 468, no longer used in Roslyn
        WRN_GotoCaseShouldConvert = 469,
        ERR_MethodImplementingAccessor = 470,
        //ERR_TypeArgsNotAllowedAmbig = 471,    no longer issued in Roslyn
        WRN_NubExprIsConstBool = 472,
        WRN_ExplicitImplCollision = 473,
        // unused 474-499
        ERR_AbstractHasBody = 500,
        ERR_ConcreteMissingBody = 501,
        ERR_AbstractAndSealed = 502,
        ERR_AbstractNotVirtual = 503,
        ERR_StaticConstant = 504,
        ERR_CantOverrideNonFunction = 505,
        ERR_CantOverrideNonVirtual = 506,
        ERR_CantChangeAccessOnOverride = 507,
        ERR_CantChangeReturnTypeOnOverride = 508,
        ERR_CantDeriveFromSealedType = 509,
        ERR_AbstractInConcreteClass = 513,
        ERR_StaticConstructorWithExplicitConstructorCall = 514,
        ERR_StaticConstructorWithAccessModifiers = 515,
        ERR_RecursiveConstructorCall = 516,
        ERR_ObjectCallingBaseConstructor = 517,
        ERR_PredefinedTypeNotFound = 518,
        //ERR_PredefinedTypeBadType = 520,
        ERR_StructWithBaseConstructorCall = 522,
        ERR_StructLayoutCycle = 523,
        ERR_InterfacesCannotContainTypes = 524,
        ERR_InterfacesCantContainFields = 525,
        ERR_InterfacesCantContainConstructors = 526,
        ERR_NonInterfaceInInterfaceList = 527,
        ERR_DuplicateInterfaceInBaseList = 528,
        ERR_CycleInInterfaceInheritance = 529,
        ERR_InterfaceMemberHasBody = 531,
        ERR_HidingAbstractMethod = 533,
        ERR_UnimplementedAbstractMethod = 534,
        ERR_UnimplementedInterfaceMember = 535,
        ERR_ObjectCantHaveBases = 537,
        ERR_ExplicitInterfaceImplementationNotInterface = 538,
        ERR_InterfaceMemberNotFound = 539,
        ERR_ClassDoesntImplementInterface = 540,
        ERR_ExplicitInterfaceImplementationInNonClassOrStruct = 541,
        ERR_MemberNameSameAsType = 542,
        ERR_EnumeratorOverflow = 543,
        ERR_CantOverrideNonProperty = 544,
        ERR_NoGetToOverride = 545,
        ERR_NoSetToOverride = 546,
        ERR_PropertyCantHaveVoidType = 547,
        ERR_PropertyWithNoAccessors = 548,
        ERR_NewVirtualInSealed = 549,
        ERR_ExplicitPropertyAddingAccessor = 550,
        ERR_ExplicitPropertyMissingAccessor = 551,
        ERR_ConversionWithInterface = 552,
        ERR_ConversionWithBase = 553,
        ERR_ConversionWithDerived = 554,
        ERR_IdentityConversion = 555,
        ERR_ConversionNotInvolvingContainedType = 556,
        ERR_DuplicateConversionInClass = 557,
        ERR_OperatorsMustBeStatic = 558,
        ERR_BadIncDecSignature = 559,
        ERR_BadUnaryOperatorSignature = 562,
        ERR_BadBinaryOperatorSignature = 563,
        ERR_BadShiftOperatorSignature = 564,
        ERR_InterfacesCantContainOperators = 567,
        ERR_StructsCantContainDefaultConstructor = 568,
        ERR_CantOverrideBogusMethod = 569,
        ERR_BindToBogus = 570,
        ERR_CantCallSpecialMethod = 571,
        ERR_BadTypeReference = 572,
        ERR_FieldInitializerInStruct = 573,
        ERR_BadDestructorName = 574,
        ERR_OnlyClassesCanContainDestructors = 575,
        ERR_ConflictAliasAndMember = 576,
        ERR_ConditionalOnSpecialMethod = 577,
        ERR_ConditionalMustReturnVoid = 578,
        ERR_DuplicateAttribute = 579,
        ERR_ConditionalOnInterfaceMethod = 582,
        //ERR_ICE_Culprit = 583,            No ICE in Roslyn. All of these are unused
        //ERR_ICE_Symbol = 584,
        //ERR_ICE_Node = 585,
        //ERR_ICE_File = 586,
        //ERR_ICE_Stage = 587,
        //ERR_ICE_Lexer = 588,
        //ERR_ICE_Parser = 589,
        ERR_OperatorCantReturnVoid = 590,
        ERR_InvalidAttributeArgument = 591,
        ERR_AttributeOnBadSymbolType = 592,
        ERR_FloatOverflow = 594,
        ERR_InvalidReal = 595,
        ERR_ComImportWithoutUuidAttribute = 596,
        ERR_InvalidNamedArgument = 599,
        ERR_DllImportOnInvalidMethod = 601,
        // WRN_FeatureDeprecated = 602,    // This error code is unused.
        // ERR_NameAttributeOnOverride = 609, // removed in Roslyn
        ERR_FieldCantBeRefAny = 610,
        ERR_ArrayElementCantBeRefAny = 611,
        WRN_DeprecatedSymbol = 612,
        ERR_NotAnAttributeClass = 616,
        ERR_BadNamedAttributeArgument = 617,
        WRN_DeprecatedSymbolStr = 618,
        ERR_DeprecatedSymbolStr = 619,
        ERR_IndexerCantHaveVoidType = 620,
        ERR_VirtualPrivate = 621,
        ERR_ArrayInitToNonArrayType = 622,
        ERR_ArrayInitInBadPlace = 623,
        ERR_MissingStructOffset = 625,
        WRN_ExternMethodNoImplementation = 626,
        WRN_ProtectedInSealed = 628,
        ERR_InterfaceImplementedByConditional = 629,
        ERR_IllegalRefParam = 631,
        ERR_BadArgumentToAttribute = 633,
        //ERR_MissingComTypeOrMarshaller = 635,
        ERR_StructOffsetOnBadStruct = 636,
        ERR_StructOffsetOnBadField = 637,
        ERR_AttributeUsageOnNonAttributeClass = 641,
        WRN_PossibleMistakenNullStatement = 642,
        ERR_DuplicateNamedAttributeArgument = 643,
        ERR_DeriveFromEnumOrValueType = 644,
        //ERR_IdentifierTooLong = 645,    //not used in Roslyn. See ERR_MetadataNameTooLong
        ERR_DefaultMemberOnIndexedType = 646,
        //ERR_CustomAttributeError = 647,
        ERR_BogusType = 648,
        WRN_UnassignedInternalField = 649,
        ERR_CStyleArray = 650,
        WRN_VacuousIntegralComp = 652,
        ERR_AbstractAttributeClass = 653,
        ERR_BadNamedAttributeArgumentType = 655,
        ERR_MissingPredefinedMember = 656,
        WRN_AttributeLocationOnBadDeclaration = 657,
        WRN_InvalidAttributeLocation = 658,
        WRN_EqualsWithoutGetHashCode = 659,
        WRN_EqualityOpWithoutEquals = 660,
        WRN_EqualityOpWithoutGetHashCode = 661,
        ERR_OutAttrOnRefParam = 662,
        ERR_OverloadRefOut = 663,
        ERR_LiteralDoubleCast = 664,
        WRN_IncorrectBooleanAssg = 665,
        ERR_ProtectedInStruct = 666,
        //ERR_FeatureDeprecated = 667,
        ERR_InconsistentIndexerNames = 668, // Named 'ERR_InconsistantIndexerNames' in native compiler
        ERR_ComImportWithUserCtor = 669,
        ERR_FieldCantHaveVoidType = 670,
        WRN_NonObsoleteOverridingObsolete = 672,
        ERR_SystemVoid = 673,
        ERR_ExplicitParamArray = 674,
        WRN_BitwiseOrSignExtend = 675,
        ERR_VolatileStruct = 677,
        ERR_VolatileAndReadonly = 678,
        // WRN_OldWarning_ProtectedInternal = 679,    // This error code is unused.
        // WRN_OldWarning_AccessibleReadonly = 680,    // This error code is unused.
        ERR_AbstractField = 681,
        ERR_BogusExplicitImpl = 682,
        ERR_ExplicitMethodImplAccessor = 683,
        WRN_CoClassWithoutComImport = 684,
        ERR_ConditionalWithOutParam = 685,
        ERR_AccessorImplementingMethod = 686,
        ERR_AliasQualAsExpression = 687,
        ERR_DerivingFromATyVar = 689,
        //FTL_MalformedMetadata = 690,
        ERR_DuplicateTypeParameter = 692,
        WRN_TypeParameterSameAsOuterTypeParameter = 693,
        ERR_TypeVariableSameAsParent = 694,
        ERR_UnifyingInterfaceInstantiations = 695,
        ERR_GenericDerivingFromAttribute = 698,
        ERR_TyVarNotFoundInConstraint = 699,
        ERR_BadBoundType = 701,
        ERR_SpecialTypeAsBound = 702,
        ERR_BadVisBound = 703,
        ERR_LookupInTypeVariable = 704,
        ERR_BadConstraintType = 706,
        ERR_InstanceMemberInStaticClass = 708,
        ERR_StaticBaseClass = 709,
        ERR_ConstructorInStaticClass = 710,
        ERR_DestructorInStaticClass = 711,
        ERR_InstantiatingStaticClass = 712,
        ERR_StaticDerivedFromNonObject = 713,
        ERR_StaticClassInterfaceImpl = 714,
        ERR_OperatorInStaticClass = 715,
        ERR_ConvertToStaticClass = 716,
        ERR_ConstraintIsStaticClass = 717,
        ERR_GenericArgIsStaticClass = 718,
        ERR_ArrayOfStaticClass = 719,
        ERR_IndexerInStaticClass = 720,
        ERR_ParameterIsStaticClass = 721,
        ERR_ReturnTypeIsStaticClass = 722,
        ERR_VarDeclIsStaticClass = 723,
        ERR_BadEmptyThrowInFinally = 724,
        //ERR_InvalidDecl = 725,
        ERR_InvalidSpecifier = 726,
        //ERR_InvalidSpecifierUnk = 727,
        WRN_AssignmentToLockOrDispose = 728,
        ERR_ForwardedTypeInThisAssembly = 729,
        ERR_ForwardedTypeIsNested = 730,
        ERR_CycleInTypeForwarder = 731,
        //ERR_FwdedGeneric = 733,
        ERR_AssemblyNameOnNonModule = 734,
        ERR_InvalidFwdType = 735,
        ERR_CloseUnimplementedInterfaceMemberStatic = 736,
        ERR_CloseUnimplementedInterfaceMemberNotPublic = 737,
        ERR_CloseUnimplementedInterfaceMemberWrongReturnType = 738,
        ERR_DuplicateTypeForwarder = 739,
        ERR_ExpectedSelectOrGroup = 742,
        ERR_ExpectedContextualKeywordOn = 743,
        ERR_ExpectedContextualKeywordEquals = 744,
        ERR_ExpectedContextualKeywordBy = 745,
        ERR_InvalidAnonymousTypeMemberDeclarator = 746,
        ERR_InvalidInitializerElementInitializer = 747,
        ERR_InconsistentLambdaParameterUsage = 748,
        ERR_PartialMethodInvalidModifier = 750,
        ERR_PartialMethodOnlyInPartialClass = 751,
        ERR_PartialMethodCannotHaveOutParameters = 752,
        ERR_PartialMethodOnlyMethods = 753,
        ERR_PartialMethodNotExplicit = 754,
        ERR_PartialMethodExtensionDifference = 755,
        ERR_PartialMethodOnlyOneLatent = 756,
        ERR_PartialMethodOnlyOneActual = 757,
        ERR_PartialMethodParamsDifference = 758,
        ERR_PartialMethodMustHaveLatent = 759,
        ERR_PartialMethodInconsistentConstraints = 761,
        ERR_PartialMethodToDelegate = 762,
        ERR_PartialMethodStaticDifference = 763,
        ERR_PartialMethodUnsafeDifference = 764,
        ERR_PartialMethodInExpressionTree = 765,
        ERR_PartialMethodMustReturnVoid = 766,
        ERR_ExplicitImplCollisionOnRefOut = 767,
        ERR_IndirectRecursiveConstructorCall = 768,

        // unused 769-799
        //ERR_NoEmptyArrayRanges = 800,
        //ERR_IntegerSpecifierOnOneDimArrays = 801,
        //ERR_IntegerSpecifierMustBePositive = 802,
        //ERR_ArrayRangeDimensionsMustMatch = 803,
        //ERR_ArrayRangeDimensionsWrong = 804,
        //ERR_IntegerSpecifierValidOnlyOnArrays = 805,
        //ERR_ArrayRangeSpecifierValidOnlyOnArrays = 806,
        //ERR_UseAdditionalSquareBrackets = 807,
        //ERR_DotDotNotAssociative = 808,
        WRN_ObsoleteOverridingNonObsolete = 809,
        WRN_DebugFullNameTooLong = 811,                                 // Dev11 name: ERR_DebugFullNameTooLong
        ERR_ImplicitlyTypedVariableAssignedBadValue = 815,              // Dev10 name: ERR_ImplicitlyTypedLocalAssignedBadValue
        ERR_ImplicitlyTypedVariableWithNoInitializer = 818,             // Dev10 name: ERR_ImplicitlyTypedLocalWithNoInitializer
        ERR_ImplicitlyTypedVariableMultipleDeclarator = 819,            // Dev10 name: ERR_ImplicitlyTypedLocalMultipleDeclarator
        ERR_ImplicitlyTypedVariableAssignedArrayInitializer = 820,      // Dev10 name: ERR_ImplicitlyTypedLocalAssignedArrayInitializer
        ERR_ImplicitlyTypedLocalCannotBeFixed = 821,
        ERR_ImplicitlyTypedVariableCannotBeConst = 822,                 // Dev10 name: ERR_ImplicitlyTypedLocalCannotBeConst
        WRN_ExternCtorNoImplementation = 824,
        ERR_TypeVarNotFound = 825,
        ERR_ImplicitlyTypedArrayNoBestType = 826,
        ERR_AnonymousTypePropertyAssignedBadValue = 828,
        ERR_ExpressionTreeContainsBaseAccess = 831,
        ERR_ExpressionTreeContainsAssignment = 832,
        ERR_AnonymousTypeDuplicatePropertyName = 833,
        ERR_StatementLambdaToExpressionTree = 834,
        ERR_ExpressionTreeMustHaveDelegate = 835,
        ERR_AnonymousTypeNotAvailable = 836,
        ERR_LambdaInIsAs = 837,
        ERR_ExpressionTreeContainsMultiDimensionalArrayInitializer = 838,
        ERR_MissingArgument = 839,
        //ERR_AutoPropertiesMustHaveBothAccessors = 840,
        ERR_VariableUsedBeforeDeclaration = 841,
        ERR_ExplicitLayoutAndAutoImplementedProperty = 842,
        ERR_UnassignedThisAutoProperty = 843,
        ERR_VariableUsedBeforeDeclarationAndHidesField = 844,
        ERR_ExpressionTreeContainsBadCoalesce = 845,
        ERR_ArrayInitializerExpected = 846,
        ERR_ArrayInitializerIncorrectLength = 847,
        ERR_OverloadRefOutCtor = 851,
        ERR_ExpressionTreeContainsNamedArgument = 853,
        ERR_ExpressionTreeContainsOptionalArgument = 854,
        ERR_ExpressionTreeContainsIndexedProperty = 855,
        ERR_IndexedPropertyRequiresParams = 856,
        ERR_IndexedPropertyMustHaveAllOptionalParams = 857,
        //ERR_FusionConfigFileNameTooLong = 858,    unused in Roslyn. We give ERR_CantReadConfigFile now.
        // unused 859-1000
        ERR_IdentifierExpected = 1001,
        ERR_SemicolonExpected = 1002,
        ERR_SyntaxError = 1003,
        ERR_DuplicateModifier = 1004,
        ERR_DuplicateAccessor = 1007,
        ERR_IntegralTypeExpected = 1008,
        ERR_IllegalEscape = 1009,
        ERR_NewlineInConst = 1010,
        ERR_EmptyCharConst = 1011,
        ERR_TooManyCharsInConst = 1012,
        ERR_InvalidNumber = 1013,
        ERR_GetOrSetExpected = 1014,
        ERR_ClassTypeExpected = 1015,
        ERR_NamedArgumentExpected = 1016,
        ERR_TooManyCatches = 1017,
        ERR_ThisOrBaseExpected = 1018,
        ERR_OvlUnaryOperatorExpected = 1019,
        ERR_OvlBinaryOperatorExpected = 1020,
        ERR_IntOverflow = 1021,
        ERR_EOFExpected = 1022,
        ERR_BadEmbeddedStmt = 1023,
        ERR_PPDirectiveExpected = 1024,
        ERR_EndOfPPLineExpected = 1025,
        ERR_CloseParenExpected = 1026,
        ERR_EndifDirectiveExpected = 1027,
        ERR_UnexpectedDirective = 1028,
        ERR_ErrorDirective = 1029,
        WRN_WarningDirective = 1030,
        ERR_TypeExpected = 1031,
        ERR_PPDefFollowsToken = 1032,
        //ERR_TooManyLines = 1033,      unused in Roslyn.
        //ERR_LineTooLong = 1034,       unused in Roslyn.
        ERR_OpenEndedComment = 1035,
        ERR_OvlOperatorExpected = 1037,
        ERR_EndRegionDirectiveExpected = 1038,
        ERR_UnterminatedStringLit = 1039,
        ERR_BadDirectivePlacement = 1040,
        ERR_IdentifierExpectedKW = 1041,
        ERR_SemiOrLBraceExpected = 1043,
        ERR_MultiTypeInDeclaration = 1044,
        ERR_AddOrRemoveExpected = 1055,
        ERR_UnexpectedCharacter = 1056,
        ERR_ProtectedInStatic = 1057,
        WRN_UnreachableGeneralCatch = 1058,
        ERR_IncrementLvalueExpected = 1059,
        // WRN_UninitializedField = 1060,  // unused in Roslyn.
        ERR_NoSuchMemberOrExtension = 1061,
        WRN_DeprecatedCollectionInitAddStr = 1062,
        ERR_DeprecatedCollectionInitAddStr = 1063,
        WRN_DeprecatedCollectionInitAdd = 1064,
        ERR_DefaultValueNotAllowed = 1065,
        WRN_DefaultValueForUnconsumedLocation = 1066,
        ERR_PartialWrongTypeParamsVariance = 1067,
        ERR_GlobalSingleTypeNameNotFoundFwd = 1068,
        ERR_DottedTypeNameNotFoundInNSFwd = 1069,
        ERR_SingleTypeNameNotFoundFwd = 1070,
        //ERR_NoSuchMemberOnNoPIAType = 1071,   //EE
        WRN_IdentifierOrNumericLiteralExpected = 1072,
        ERR_UnexpectedToken = 1073,
        // unused 1074-1098
        // ERR_EOLExpected = 1099, // EE
        // ERR_NotSupportedinEE = 1100, // EE
        ERR_BadThisParam = 1100,
        ERR_BadRefWithThis = 1101,
        ERR_BadOutWithThis = 1102,
        ERR_BadTypeforThis = 1103,
        ERR_BadParamModThis = 1104,
        ERR_BadExtensionMeth = 1105,
        ERR_BadExtensionAgg = 1106,
        ERR_DupParamMod = 1107,
        ERR_MultiParamMod = 1108,
        ERR_ExtensionMethodsDecl = 1109,
        ERR_ExtensionAttrNotFound = 1110,
        //ERR_ExtensionTypeParam = 1111,
        ERR_ExplicitExtension = 1112,
        ERR_ValueTypeExtDelegate = 1113,
        // unused 1114-1199
        // Below five error codes are unused.
        // WRN_FeatureDeprecated2 = 1200,
        // WRN_FeatureDeprecated3 = 1201,
        // WRN_FeatureDeprecated4 = 1202,
        // WRN_FeatureDeprecated5 = 1203,
        // WRN_OldWarning_FeatureDefaultDeprecated = 1204,
        // unused 1205-1500
        ERR_BadArgCount = 1501,
        //ERR_BadArgTypes = 1502,
        ERR_BadArgType = 1503,
        ERR_NoSourceFile = 1504,
        ERR_CantRefResource = 1507,
        ERR_ResourceNotUnique = 1508,
        ERR_ImportNonAssembly = 1509,
        ERR_RefLvalueExpected = 1510,
        ERR_BaseInStaticMeth = 1511,
        ERR_BaseInBadContext = 1512,
        ERR_RbraceExpected = 1513,
        ERR_LbraceExpected = 1514,
        ERR_InExpected = 1515,
        ERR_InvalidPreprocExpr = 1517,
        //ERR_BadTokenInType = 1518,    unused in Roslyn
        ERR_InvalidMemberDecl = 1519,
        ERR_MemberNeedsType = 1520,
        ERR_BadBaseType = 1521,
        WRN_EmptySwitch = 1522,
        ERR_ExpectedEndTry = 1524,
        ERR_InvalidExprTerm = 1525,
        ERR_BadNewExpr = 1526,
        ERR_NoNamespacePrivate = 1527,
        ERR_BadVarDecl = 1528,
        ERR_UsingAfterElements = 1529,
        //ERR_NoNewOnNamespaceElement = 1530, EDMAURER we now give BadMemberFlag which is only a little less specific than this.
        //ERR_DontUseInvoke = 1533,
        ERR_BadBinOpArgs = 1534,
        ERR_BadUnOpArgs = 1535,
        ERR_NoVoidParameter = 1536,
        ERR_DuplicateAlias = 1537,
        ERR_BadProtectedAccess = 1540,
        //ERR_CantIncludeDirectory = 1541,
        ERR_AddModuleAssembly = 1542,
        ERR_BindToBogusProp2 = 1545,
        ERR_BindToBogusProp1 = 1546,
        ERR_NoVoidHere = 1547,
        //ERR_CryptoFailed = 1548,
        //ERR_CryptoNotFound = 1549,
        ERR_IndexerNeedsParam = 1551,
        ERR_BadArraySyntax = 1552,
        ERR_BadOperatorSyntax = 1553,
        //ERR_BadOperatorSyntax2 = 1554,    Not used in Roslyn.
        ERR_MainClassNotFound = 1555,
        ERR_MainClassNotClass = 1556,
        //ERR_MainClassWrongFile = 1557,    Not used in Roslyn. This was used only when compiling and producing two outputs.
        ERR_NoMainInClass = 1558,
        //ERR_MainClassIsImport = 1559,     Not used in Roslyn. Scenario occurs so infrequently that it is not worth re-implementing.
        //ERR_FileNameTooLong = 1560,
        //ERR_OutputFileNameTooLong = 1561, Not used in Roslyn. We report a more generic error that doesn't mention "output file" but is fine.
        ERR_OutputNeedsName = 1562,
        //ERR_OutputNeedsInput = 1563,
        ERR_CantHaveWin32ResAndManifest = 1564,
        ERR_CantHaveWin32ResAndIcon = 1565,
        ERR_CantReadResource = 1566,
        //ERR_AutoResGen = 1567,
        //ERR_DocFileGen = 1569,
        WRN_XMLParseError = 1570,
        WRN_DuplicateParamTag = 1571,
        WRN_UnmatchedParamTag = 1572,
        WRN_MissingParamTag = 1573,
        WRN_BadXMLRef = 1574,
        ERR_BadStackAllocExpr = 1575,
        ERR_InvalidLineNumber = 1576,
        //ERR_ALinkFailed = 1577,               No alink usage in Roslyn
        ERR_MissingPPFile = 1578,
        ERR_ForEachMissingMember = 1579,
        WRN_BadXMLRefParamType = 1580,
        WRN_BadXMLRefReturnType = 1581,
        ERR_BadWin32Res = 1583,
        WRN_BadXMLRefSyntax = 1584,
        ERR_BadModifierLocation = 1585,
        ERR_MissingArraySize = 1586,
        WRN_UnprocessedXMLComment = 1587,
        //ERR_CantGetCORSystemDir = 1588,
        WRN_FailedInclude = 1589,
        WRN_InvalidInclude = 1590,
        WRN_MissingXMLComment = 1591,
        WRN_XMLParseIncludeError = 1592,
        ERR_BadDelArgCount = 1593,
        //ERR_BadDelArgTypes = 1594,
        // WRN_OldWarning_MultipleTypeDefs = 1595,    // This error code is unused.
        // WRN_OldWarning_DocFileGenAndIncr = 1596,    // This error code is unused.
        ERR_UnexpectedSemicolon = 1597,
        // WRN_XMLParserNotFound = 1598, // No longer used (though, conceivably, we could report it if Linq to Xml is missing at compile time).
        ERR_MethodReturnCantBeRefAny = 1599,
        ERR_CompileCancelled = 1600,
        ERR_MethodArgCantBeRefAny = 1601,
        ERR_AssgReadonlyLocal = 1604,
        ERR_RefReadonlyLocal = 1605,
        //ERR_ALinkCloseFailed = 1606,
        WRN_ALinkWarn = 1607,
        ERR_CantUseRequiredAttribute = 1608,
        ERR_NoModifiersOnAccessor = 1609,
        // WRN_DeleteAutoResFailed = 1610, // Unused.
        ERR_ParamsCantBeRefOut = 1611,
        ERR_ReturnNotLValue = 1612,
        ERR_MissingCoClass = 1613,
        ERR_AmbiguousAttribute = 1614,
        ERR_BadArgExtraRef = 1615,
        WRN_CmdOptionConflictsSource = 1616,
        ERR_BadCompatMode = 1617,
        ERR_DelegateOnConditional = 1618,
        ERR_CantMakeTempFile = 1619,    //changed to now accept only one argument
        ERR_BadArgRef = 1620,
        ERR_YieldInAnonMeth = 1621,
        ERR_ReturnInIterator = 1622,
        ERR_BadIteratorArgType = 1623,
        ERR_BadIteratorReturn = 1624,
        ERR_BadYieldInFinally = 1625,
        ERR_BadYieldInTryOfCatch = 1626,
        ERR_EmptyYield = 1627,
        ERR_AnonDelegateCantUse = 1628,
        ERR_IllegalInnerUnsafe = 1629,
        //ERR_BadWatsonMode = 1630,
        ERR_BadYieldInCatch = 1631,
        ERR_BadDelegateLeave = 1632,
        WRN_IllegalPragma = 1633,
        WRN_IllegalPPWarning = 1634,
        WRN_BadRestoreNumber = 1635,
        ERR_VarargsIterator = 1636,
        ERR_UnsafeIteratorArgType = 1637,
        //ERR_ReservedIdentifier = 1638,
        ERR_BadCoClassSig = 1639,
        ERR_MultipleIEnumOfT = 1640,
        ERR_FixedDimsRequired = 1641,
        ERR_FixedNotInStruct = 1642,
        ERR_AnonymousReturnExpected = 1643,
        //ERR_NonECMAFeature = 1644,
        WRN_NonECMAFeature = 1645,
        ERR_ExpectedVerbatimLiteral = 1646,
        //FTL_StackOverflow = 1647,
        ERR_AssgReadonly2 = 1648,
        ERR_RefReadonly2 = 1649,
        ERR_AssgReadonlyStatic2 = 1650,
        ERR_RefReadonlyStatic2 = 1651,
        ERR_AssgReadonlyLocal2Cause = 1654,
        ERR_RefReadonlyLocal2Cause = 1655,
        ERR_AssgReadonlyLocalCause = 1656,
        ERR_RefReadonlyLocalCause = 1657,
        WRN_ErrorOverride = 1658,
        // WRN_OldWarning_ReservedIdentifier = 1659,    // This error code is unused.
        ERR_AnonMethToNonDel = 1660,
        ERR_CantConvAnonMethParams = 1661,
        ERR_CantConvAnonMethReturns = 1662,
        ERR_IllegalFixedType = 1663,
        ERR_FixedOverflow = 1664,
        ERR_InvalidFixedArraySize = 1665,
        ERR_FixedBufferNotFixed = 1666,
        ERR_AttributeNotOnAccessor = 1667,
        WRN_InvalidSearchPathDir = 1668,
        ERR_IllegalVarArgs = 1669,
        ERR_IllegalParams = 1670,
        ERR_BadModifiersOnNamespace = 1671,
        ERR_BadPlatformType = 1672,
        ERR_ThisStructNotInAnonMeth = 1673,
        ERR_NoConvToIDisp = 1674,
        // ERR_InvalidGenericEnum = 1675,    replaced with 7002
        ERR_BadParamRef = 1676,
        ERR_BadParamExtraRef = 1677,
        ERR_BadParamType = 1678, // Requires SymbolDistinguisher.
        ERR_BadExternIdentifier = 1679,
        ERR_AliasMissingFile = 1680,
        ERR_GlobalExternAlias = 1681,
        // WRN_MissingTypeNested = 1682,   // unused in Roslyn.
        // In Roslyn, we generate errors ERR_MissingTypeInSource and ERR_MissingTypeInAssembly instead of warnings WRN_MissingTypeInSource and WRN_MissingTypeInAssembly respectively.
        // WRN_MissingTypeInSource = 1683,
        // WRN_MissingTypeInAssembly = 1684,
        WRN_MultiplePredefTypes = 1685,
        ERR_LocalCantBeFixedAndHoisted = 1686,
        WRN_TooManyLinesForDebugger = 1687,
        ERR_CantConvAnonMethNoParams = 1688,
        ERR_ConditionalOnNonAttributeClass = 1689,
        WRN_CallOnNonAgileField = 1690,
        // WRN_BadWarningNumber = 1691,    // we no longer generate this warning for an unrecognized warning ID specified as an argument to /nowarn or /warnaserror.
        WRN_InvalidNumber = 1692,
        // WRN_FileNameTooLong = 1694, //unused.
        WRN_IllegalPPChecksum = 1695,
        WRN_EndOfPPLineExpected = 1696,
        WRN_ConflictingChecksum = 1697,
        // WRN_AssumedMatchThis = 1698,     // This error code is unused.
        // WRN_UseSwitchInsteadOfAttribute = 1699,     // This error code is unused.
        WRN_InvalidAssemblyName = 1700,
        WRN_UnifyReferenceMajMin = 1701,
        WRN_UnifyReferenceBldRev = 1702,
        ERR_DuplicateImport = 1703,
        ERR_DuplicateImportSimple = 1704,
        ERR_AssemblyMatchBadVersion = 1705,
        //ERR_AnonMethNotAllowed = 1706,            Unused in Roslyn. Previously given when a lambda was supplied as an attribute argument.
        // WRN_DelegateNewMethBind = 1707,             // This error code is unused.
        ERR_FixedNeedsLvalue = 1708,
        // WRN_EmptyFileName = 1709,        // This error code is unused.
        WRN_DuplicateTypeParamTag = 1710,
        WRN_UnmatchedTypeParamTag = 1711,
        WRN_MissingTypeParamTag = 1712,
        //FTL_TypeNameBuilderError = 1713,
        //ERR_ImportBadBase = 1714,                 // This error code is unused and replaced with ERR_NoTypeDef
        ERR_CantChangeTypeOnOverride = 1715,
        ERR_DoNotUseFixedBufferAttr = 1716,
        WRN_AssignmentToSelf = 1717,
        WRN_ComparisonToSelf = 1718,
        ERR_CantOpenWin32Res = 1719,
        WRN_DotOnDefault = 1720,
        ERR_NoMultipleInheritance = 1721,
        ERR_BaseClassMustBeFirst = 1722,
        WRN_BadXMLRefTypeVar = 1723,
        //ERR_InvalidDefaultCharSetValue = 1724,    Not used in Roslyn.
        ERR_FriendAssemblyBadArgs = 1725,
        ERR_FriendAssemblySNReq = 1726,
        //ERR_WatsonSendNotOptedIn = 1727,            We're not doing any custom Watson processing in Roslyn. In modern OSs, Watson behavior is configured with machine policy settings.
        ERR_DelegateOnNullable = 1728,
        ERR_BadCtorArgCount = 1729,
        ERR_GlobalAttributesNotFirst = 1730,
        //ERR_CantConvAnonMethReturnsNoDelegate = 1731,     Not used in Roslyn. When there is no delegate, we reuse the message that contains a substitution string for the delegate type.
        //ERR_ParameterExpected = 1732,             Not used in Roslyn.
        ERR_ExpressionExpected = 1733,
        WRN_UnmatchedParamRefTag = 1734,
        WRN_UnmatchedTypeParamRefTag = 1735,
        ERR_DefaultValueMustBeConstant = 1736,
        ERR_DefaultValueBeforeRequiredValue = 1737,
        ERR_NamedArgumentSpecificationBeforeFixedArgument = 1738,
        ERR_BadNamedArgument = 1739,
        ERR_DuplicateNamedArgument = 1740,
        ERR_RefOutDefaultValue = 1741,
        ERR_NamedArgumentForArray = 1742,
        ERR_DefaultValueForExtensionParameter = 1743,
        ERR_NamedArgumentUsedInPositional = 1744,
        ERR_DefaultValueUsedWithAttributes = 1745,
        ERR_BadNamedArgumentForDelegateInvoke = 1746,
        ERR_NoPIAAssemblyMissingAttribute = 1747,
        ERR_NoCanonicalView = 1748,
        //ERR_TypeNotFoundForNoPIA = 1749,
        ERR_NoConversionForDefaultParam = 1750,
        ERR_DefaultValueForParamsParameter = 1751,
        ERR_NewCoClassOnLink = 1752,
        ERR_NoPIANestedType = 1754,
        //ERR_InvalidTypeIdentifierConstructor = 1755,
        ERR_InteropTypeMissingAttribute = 1756,
        ERR_InteropStructContainsMethods = 1757,
        ERR_InteropTypesWithSameNameAndGuid = 1758,
        ERR_NoPIAAssemblyMissingAttributes = 1759,
        ERR_AssemblySpecifiedForLinkAndRef = 1760,
        ERR_LocalTypeNameClash = 1761,
        WRN_ReferencedAssemblyReferencesLinkedPIA = 1762,
        ERR_NotNullRefDefaultParameter = 1763,
        ERR_FixedLocalInLambda = 1764,
        // WRN_TypeNotFoundForNoPIAWarning = 1765,  // This error code is unused.
        ERR_MissingMethodOnSourceInterface = 1766,
        ERR_MissingSourceInterface = 1767,
        ERR_GenericsUsedInNoPIAType = 1768,
        ERR_GenericsUsedAcrossAssemblies = 1769,
        ERR_NoConversionForNubDefaultParam = 1770,
        //ERR_MemberWithGenericsUsedAcrossAssemblies = 1771,
        //ERR_GenericsUsedInBaseTypeAcrossAssemblies = 1772,
        ERR_InvalidSubsystemVersion = 1773,
        ERR_InteropMethodWithBody = 1774,
        // unused 1775-1899
        ERR_BadWarningLevel = 1900,
        ERR_BadDebugType = 1902,
        //ERR_UnknownTestSwitch = 1903,
        ERR_BadResourceVis = 1906,
        ERR_DefaultValueTypeMustMatch = 1908,
        //ERR_DefaultValueBadParamType = 1909, // Replaced by ERR_DefaultValueBadValueType in Roslyn.
        ERR_DefaultValueBadValueType = 1910,
        ERR_MemberAlreadyInitialized = 1912,
        ERR_MemberCannotBeInitialized = 1913,
        ERR_StaticMemberInObjectInitializer = 1914,
        ERR_ReadonlyValueTypeInObjectInitializer = 1917,
        ERR_ValueTypePropertyInObjectInitializer = 1918,
        ERR_UnsafeTypeInObjectCreation = 1919,
        ERR_EmptyElementInitializer = 1920,
        ERR_InitializerAddHasWrongSignature = 1921,
        ERR_CollectionInitRequiresIEnumerable = 1922,
        //ERR_InvalidCollectionInitializerType = 1925,  unused in Roslyn. Occurs so infrequently in real usage that it is not worth reimplementing.
        ERR_CantOpenWin32Manifest = 1926,
        WRN_CantHaveManifestForModule = 1927,
        ERR_BadExtensionArgTypes = 1928,
        ERR_BadInstanceArgType = 1929,
        ERR_QueryDuplicateRangeVariable = 1930,
        ERR_QueryRangeVariableOverrides = 1931,
        ERR_QueryRangeVariableAssignedBadValue = 1932,
        //ERR_QueryNotAllowed = 1933,       unused in Roslyn. This specific message is not necessary for correctness and adds little.
        ERR_QueryNoProviderCastable = 1934,
        ERR_QueryNoProviderStandard = 1935,
        ERR_QueryNoProvider = 1936,
        ERR_QueryOuterKey = 1937,
        ERR_QueryInnerKey = 1938,
        ERR_QueryOutRefRangeVariable = 1939,
        ERR_QueryMultipleProviders = 1940,
        ERR_QueryTypeInferenceFailedMulti = 1941,
        ERR_QueryTypeInferenceFailed = 1942,
        ERR_QueryTypeInferenceFailedSelectMany = 1943,
        ERR_ExpressionTreeContainsPointerOp = 1944,
        ERR_ExpressionTreeContainsAnonymousMethod = 1945,
        ERR_AnonymousMethodToExpressionTree = 1946,
        ERR_QueryRangeVariableReadOnly = 1947,
        ERR_QueryRangeVariableSameAsTypeParam = 1948,
        ERR_TypeVarNotFoundRangeVariable = 1949,
        ERR_BadArgTypesForCollectionAdd = 1950,
        ERR_ByRefParameterInExpressionTree = 1951,
        ERR_VarArgsInExpressionTree = 1952,
        // ERR_MemGroupInExpressionTree = 1953, unused in roslyn (replaced by ERR_LambdaInIsAs)
        ERR_InitializerAddHasParamModifiers = 1954,
        ERR_NonInvocableMemberCalled = 1955,
        WRN_MultipleRuntimeImplementationMatches = 1956,
        WRN_MultipleRuntimeOverrideMatches = 1957,
        ERR_ObjectOrCollectionInitializerWithDelegateCreation = 1958,
        ERR_InvalidConstantDeclarationType = 1959,
        ERR_IllegalVarianceSyntax = 1960,
        ERR_UnexpectedVariance = 1961,
        ERR_BadDynamicTypeof = 1962,
        ERR_ExpressionTreeContainsDynamicOperation = 1963,
        ERR_BadDynamicConversion = 1964,
        ERR_DeriveFromDynamic = 1965,
        ERR_DeriveFromConstructedDynamic = 1966,
        ERR_DynamicTypeAsBound = 1967,
        ERR_ConstructedDynamicTypeAsBound = 1968,
        ERR_DynamicRequiredTypesMissing = 1969,
        ERR_ExplicitDynamicAttr = 1970,
        ERR_NoDynamicPhantomOnBase = 1971,
        ERR_NoDynamicPhantomOnBaseIndexer = 1972,
        ERR_BadArgTypeDynamicExtension = 1973,
        WRN_DynamicDispatchToConditionalMethod = 1974,
        ERR_NoDynamicPhantomOnBaseCtor = 1975,
        ERR_BadDynamicMethodArgMemgrp = 1976,
        ERR_BadDynamicMethodArgLambda = 1977,
        ERR_BadDynamicMethodArg = 1978,
        ERR_BadDynamicQuery = 1979,
        ERR_DynamicAttributeMissing = 1980,
        WRN_IsDynamicIsConfusing = 1981,
        ERR_DynamicNotAllowedInAttribute = 1982,                    // Replaced by ERR_BadAttributeParamType in Roslyn.
        ERR_BadAsyncReturn = 1983,
        ERR_BadAwaitInFinally = 1984,
        ERR_BadAwaitInCatch = 1985,
        ERR_BadAwaitArg = 1986,
        ERR_BadAsyncArgType = 1988,
        ERR_BadAsyncExpressionTree = 1989,
        ERR_WindowsRuntimeTypesMissing = 1990,
        ERR_MixingWinRTEventWithRegular = 1991,
        ERR_BadAwaitWithoutAsync = 1992,
        ERR_MissingAsyncTypes = 1993,
        ERR_BadAsyncLacksBody = 1994,
        ERR_BadAwaitInQuery = 1995,
        ERR_BadAwaitInLock = 1996,
        ERR_TaskRetNoObjectRequired = 1997,
        WRN_AsyncLacksAwaits = 1998,
        ERR_FileNotFound = 2001,
        WRN_FileAlreadyIncluded = 2002,
        //ERR_DuplicateResponseFile = 2003,
        ERR_NoFileSpec = 2005,
        ERR_SwitchNeedsString = 2006,
        ERR_BadSwitch = 2007,
        WRN_NoSources = 2008,
        ERR_OpenResponseFile = 2011,
        ERR_CantOpenFileWrite = 2012,
        ERR_BadBaseNumber = 2013,
        // WRN_UseNewSwitch = 2014,    //unused.
        ERR_BinaryFile = 2015,
        FTL_BadCodepage = 2016,
        ERR_NoMainOnDLL = 2017,
        //FTL_NoMessagesDLL = 2018,
        FTL_InvalidTarget = 2019,
        //ERR_BadTargetForSecondInputSet = 2020,    Roslyn doesn't support building two binaries at once!
        FTL_InputFileNameTooLong = 2021,
        //ERR_NoSourcesInLastInputSet = 2022,       Roslyn doesn't support building two binaries at once!
        WRN_NoConfigNotOnCommandLine = 2023,
        ERR_InvalidFileAlignment = 2024,
        //ERR_NoDebugSwitchSourceMap = 2026,    no sourcemap support in Roslyn.
        //ERR_SourceMapFileBinary = 2027,
        WRN_DefineIdentifierRequired = 2029,
        //ERR_InvalidSourceMap = 2030,
        //ERR_NoSourceMapFile = 2031,
        //ERR_IllegalOptionChar = 2032,
        FTL_OutputFileExists = 2033,
        ERR_OneAliasPerReference = 2034,
        ERR_SwitchNeedsNumber = 2035,
        ERR_MissingDebugSwitch = 2036,
        ERR_ComRefCallInExpressionTree = 2037,
        WRN_BadUILang = 2038,
        ERR_InvalidFormatForGuidForOption = 2039,
        ERR_MissingGuidForOption = 2040,
        ERR_InvalidOutputName = 2041,
        ERR_InvalidDebugInformationFormat = 2042,
        ERR_LegacyObjectIdSyntax = 2043,
        // unused 2044-2999
        WRN_CLS_NoVarArgs = 3000,
        WRN_CLS_BadArgType = 3001, // Requires SymbolDistinguisher.
        WRN_CLS_BadReturnType = 3002,
        WRN_CLS_BadFieldPropType = 3003,
        // WRN_CLS_BadUnicode = 3004, //unused
        WRN_CLS_BadIdentifierCase = 3005,
        WRN_CLS_OverloadRefOut = 3006,
        WRN_CLS_OverloadUnnamed = 3007,
        WRN_CLS_BadIdentifier = 3008,
        WRN_CLS_BadBase = 3009,
        WRN_CLS_BadInterfaceMember = 3010,
        WRN_CLS_NoAbstractMembers = 3011,
        WRN_CLS_NotOnModules = 3012,
        WRN_CLS_ModuleMissingCLS = 3013,
        WRN_CLS_AssemblyNotCLS = 3014,
        WRN_CLS_BadAttributeType = 3015,
        WRN_CLS_ArrayArgumentToAttribute = 3016,
        WRN_CLS_NotOnModules2 = 3017,
        WRN_CLS_IllegalTrueInFalse = 3018,
        WRN_CLS_MeaninglessOnPrivateType = 3019,
        WRN_CLS_AssemblyNotCLS2 = 3021,
        WRN_CLS_MeaninglessOnParam = 3022,
        WRN_CLS_MeaninglessOnReturn = 3023,
        WRN_CLS_BadTypeVar = 3024,
        WRN_CLS_VolatileField = 3026,
        WRN_CLS_BadInterface = 3027,
        FTL_BadChecksumAlgorithm = 3028,

        // unused 3029-3999

        // Errors introduced in C# 5 are in the range 4000-4999
        // 4000 unused
        ERR_BadAwaitArgIntrinsic = 4001,
        // 4002 unused
        ERR_BadAwaitAsIdentifier = 4003,
        ERR_AwaitInUnsafeContext = 4004,
        ERR_UnsafeAsyncArgType = 4005,
        ERR_VarargsAsync = 4006,
        ERR_ByRefTypeAndAwait = 4007,
        ERR_BadAwaitArgVoidCall = 4008,
        ERR_MainCantBeAsync = 4009,
        ERR_CantConvAsyncAnonFuncReturns = 4010,
        ERR_BadAwaiterPattern = 4011,
        ERR_BadSpecialByRefLocal = 4012,
        ERR_SpecialByRefInLambda = 4013,
        WRN_UnobservedAwaitableExpression = 4014,
        ERR_SynchronizedAsyncMethod = 4015,
        ERR_BadAsyncReturnExpression = 4016,
        ERR_NoConversionForCallerLineNumberParam = 4017,
        ERR_NoConversionForCallerFilePathParam = 4018,
        ERR_NoConversionForCallerMemberNameParam = 4019,
        ERR_BadCallerLineNumberParamWithoutDefaultValue = 4020,
        ERR_BadCallerFilePathParamWithoutDefaultValue = 4021,
        ERR_BadCallerMemberNameParamWithoutDefaultValue = 4022,
        ERR_BadPrefer32OnLib = 4023,
        WRN_CallerLineNumberParamForUnconsumedLocation = 4024,
        WRN_CallerFilePathParamForUnconsumedLocation = 4025,
        WRN_CallerMemberNameParamForUnconsumedLocation = 4026,
        ERR_DoesntImplementAwaitInterface = 4027,
        ERR_BadAwaitArg_NeedSystem = 4028,
        ERR_CantReturnVoid = 4029,
        ERR_SecurityCriticalOrSecuritySafeCriticalOnAsync = 4030,
        ERR_SecurityCriticalOrSecuritySafeCriticalOnAsyncInClassOrStruct = 4031,
        ERR_BadAwaitWithoutAsyncMethod = 4032,
        ERR_BadAwaitWithoutVoidAsyncMethod = 4033,
        ERR_BadAwaitWithoutAsyncLambda = 4034,
        // ERR_BadAwaitWithoutAsyncAnonMeth = 4035,         Merged with ERR_BadAwaitWithoutAsyncLambda in Roslyn
        ERR_NoSuchMemberOrExtensionNeedUsing = 4036,

        // available 4037-4999

        // WRN_UnknownOption = 5000,   //unused in Roslyn
        ERR_NoEntryPoint = 5001,

        // available 5002-6999

        ERR_UnexpectedAliasedName = 7000,
        ERR_UnexpectedGenericName = 7002,
        ERR_UnexpectedUnboundGenericName = 7003,
        ERR_GlobalStatement = 7006,
        ERR_BadUsingType = 7007,
        ERR_ReservedAssemblyName = 7008,
        ERR_PPReferenceFollowsToken = 7009,
        ERR_ExpectedPPFile = 7010,
        ERR_ReferenceDirectiveOnlyAllowedInScripts = 7011,
        ERR_NameNotInContextPossibleMissingReference = 7012,
        ERR_MetadataNameTooLong = 7013,
        ERR_AttributesNotAllowed = 7014,
        ERR_ExternAliasNotAllowed = 7015,
        ERR_ConflictingAliasAndDefinition = 7016,
        ERR_GlobalDefinitionOrStatementExpected = 7017,
        ERR_ExpectedSingleScript = 7018,
        ERR_RecursivelyTypedVariable = 7019,
        ERR_YieldNotAllowedInScript = 7020,
        ERR_NamespaceNotAllowedInScript = 7021,
        WRN_MainIgnored = 7022,
        ERR_StaticInAsOrIs = 7023,
        ERR_InvalidDelegateType = 7024,
        ERR_BadVisEventType = 7025,
        ERR_GlobalAttributesNotAllowed = 7026,
        ERR_PublicKeyFileFailure = 7027,
        ERR_PublicKeyContainerFailure = 7028,
        ERR_FriendRefSigningMismatch = 7029,
        ERR_CannotPassNullForFriendAssembly = 7030,
        ERR_SignButNoPrivateKey = 7032,
        WRN_DelaySignButNoKey = 7033,
        ERR_InvalidVersionFormat = 7034,
        WRN_InvalidVersionFormat = 7035,
        ERR_NoCorrespondingArgument = 7036,
        // Moot: WRN_DestructorIsNotFinalizer = 7037,
        ERR_ModuleEmitFailure = 7038,
        // ERR_NameIllegallyOverrides2 = 7039, // Not used anymore due to 'Single Meaning' relaxation changes
        // ERR_NameIllegallyOverrides3 = 7040, // Not used anymore due to 'Single Meaning' relaxation changes
        ERR_ResourceFileNameNotUnique = 7041,
        ERR_DllImportOnGenericMethod = 7042,

        ERR_ParameterNotValidForType = 7045,
        ERR_AttributeParameterRequired1 = 7046,
        ERR_AttributeParameterRequired2 = 7047,
        ERR_SecurityAttributeMissingAction = 7048,
        ERR_SecurityAttributeInvalidAction = 7049,
        ERR_SecurityAttributeInvalidActionAssembly = 7050,
        ERR_SecurityAttributeInvalidActionTypeOrMethod = 7051,
        ERR_PrincipalPermissionInvalidAction = 7052,
        ERR_FeatureNotValidInExpressionTree = 7053,
        ERR_MarshalUnmanagedTypeNotValidForFields = 7054,
        ERR_MarshalUnmanagedTypeOnlyValidForFields = 7055,
        ERR_PermissionSetAttributeInvalidFile = 7056,
        ERR_PermissionSetAttributeFileReadError = 7057,
        ERR_InvalidVersionFormat2 = 7058,
        ERR_InvalidAssemblyCultureForExe = 7059,
        //ERR_AsyncBeforeVersionFive = 7060,
        ERR_DuplicateAttributeInNetModule = 7061,
        //WRN_PDBConstantStringValueTooLong = 7063,     gave up on this warning
        ERR_CantOpenIcon = 7064,
        ERR_ErrorBuildingWin32Resources = 7065,
        ERR_IteratorInInteractive = 7066,
        ERR_BadAttributeParamDefaultArgument = 7067,
        ERR_MissingTypeInSource = 7068,
        ERR_MissingTypeInAssembly = 7069,
        ERR_SecurityAttributeInvalidTarget = 7070,
        ERR_InvalidAssemblyName = 7071,
        //ERR_PartialTypesBeforeVersionTwo = 7072,
        //ERR_PartialMethodsBeforeVersionThree = 7073,
        //ERR_QueryBeforeVersionThree = 7074,
        //ERR_AnonymousTypeBeforeVersionThree = 7075,
        //ERR_ImplicitArrayBeforeVersionThree = 7076,
        //ERR_ObjectInitializerBeforeVersionThree = 7077,
        //ERR_LambdaBeforeVersionThree = 7078,
        ERR_NoTypeDefFromModule = 7079,
        WRN_CallerFilePathPreferredOverCallerMemberName = 7080,
        WRN_CallerLineNumberPreferredOverCallerMemberName = 7081,
        WRN_CallerLineNumberPreferredOverCallerFilePath = 7082,
        ERR_InvalidDynamicCondition = 7083,
        ERR_WinRtEventPassedByRef = 7084,
        ERR_ByRefReturnUnsupported = 7085,
        ERR_NetModuleNameMismatch = 7086,
        ERR_BadCompilationOption = 7087,
        ERR_BadCompilationOptionValue = 7088,
        ERR_BadAppConfigPath = 7089,
        WRN_AssemblyAttributeFromModuleIsOverridden = 7090,
        ERR_CmdOptionConflictsSource = 7091,
        ERR_FixedBufferTooManyDimensions = 7092,
        ERR_CantReadConfigFile = 7093,
        ERR_BadAwaitInCatchFilter = 7094,
        WRN_FilterIsConstant = 7095,
        ERR_EncNoPIAReference = 7096,
        //ERR_EncNoDynamicOperation = 7097,   // dynamic operations are now allowed
        ERR_LinkedNetmoduleMetadataMustProvideFullPEImage = 7098,
        ERR_MetadataReferencesNotSupported = 7099,
        ERR_InvalidAssemblyCulture = 7100,
        ERR_EncReferenceToAddedMember = 7101,
        ERR_MutuallyExclusiveOptions = 7102,

        // available 7102-8000

        WRN_UnimplementedCommandLineSwitch = 8001,
        WRN_ReferencedAssemblyDoesNotHaveStrongName = 8002,
        ERR_InvalidSignaturePublicKey = 8003,
        ERR_ExportedTypeConflictsWithDeclaration = 8004,
        ERR_ExportedTypesConflict = 8005,
        ERR_ForwardedTypeConflictsWithDeclaration = 8006,
        ERR_ForwardedTypesConflict = 8007,
        ERR_ForwardedTypeConflictsWithExportedType = 8008,
        WRN_RefCultureMismatch = 8009,
        ERR_AgnosticToMachineModule = 8010,
        ERR_ConflictingMachineModule = 8011,
        WRN_ConflictingMachineAssembly = 8012,
        ERR_CryptoHashFailed = 8013,
        ERR_MissingNetModuleReference = 8014,
        ERR_NetModuleNameMustBeUnique = 8015,
        ERR_UnsupportedTransparentIdentifierAccess = 8016,
        ERR_ParamDefaultValueDiffersFromAttribute = 8017,
        WRN_UnqualifiedNestedTypeInCref = 8018,
        HDN_UnusedUsingDirective = 8019,
        HDN_UnusedExternAlias = 8020,
        WRN_NoRuntimeMetadataVersion = 8021,
        ERR_FeatureNotAvailableInVersion1 = 8022,        // Note: one per version to make telemetry easier
        ERR_FeatureNotAvailableInVersion2 = 8023,
        ERR_FeatureNotAvailableInVersion3 = 8024,
        ERR_FeatureNotAvailableInVersion4 = 8025,
        ERR_FeatureNotAvailableInVersion5 = 8026,
        // ERR_FeatureNotAvailableInVersion6 is below
        ERR_FieldHasMultipleDistinctConstantValues = 8027,
        ERR_ComImportWithInitializers = 8028,
        WRN_PdbLocalNameTooLong = 8029,
        ERR_RetNoObjectRequiredLambda = 8030,
        ERR_TaskRetNoObjectRequiredLambda = 8031,
        WRN_AnalyzerCannotBeCreated = 8032,
        WRN_NoAnalyzerInAssembly = 8033,
        WRN_UnableToLoadAnalyzer = 8034,
        ERR_CantReadRulesetFile = 8035,
        ERR_BadPdbData = 8036,
        // available 8037-8039
        INF_UnableToLoadSomeTypesInAnalyzer = 8040,
        // available 8041-8049
        ERR_InitializerOnNonAutoProperty = 8050,
        ERR_AutoPropertyMustHaveGetAccessor = 8051,
        ERR_AutoPropertyInitializerInInterface = 8052,

        ERR_EnumsCantContainDefaultConstructor = 8054,
        ERR_EncodinglessSyntaxTree = 8055,
        ERR_AccessorListAndExpressionBody = 8056,
        ERR_BlockBodyAndExpressionBody = 8057,
        ERR_FeatureIsExperimental = 8058,
        ERR_FeatureNotAvailableInVersion6 = 8059,
        // available 8060-8069
        ERR_SwitchFallOut = 8070,
        // ERR_UnexpectedBoundGenericName = 8071, // for nameof - used in an early prototype
        ERR_NullPropagatingOpInExpressionTree = 8072,
        WRN_NubExprIsConstBool2 = 8073,
        ERR_DictionaryInitializerInExpressionTree = 8074,
        ERR_ExtensionCollectionElementInitializerInExpressionTree = 8075,
        ERR_UnclosedExpressionHole = 8076,
        ERR_SingleLineCommentInExpressionHole = 8077,
        ERR_InsufficientStack = 8078,
        ERR_UseDefViolationProperty = 8079,
        ERR_AutoPropertyMustOverrideSet = 8080,
        ERR_ExpressionHasNoName = 8081,
        ERR_SubexpressionNotInNameof = 8082,
        ERR_AliasQualifiedNameNotAnExpression = 8083,
        ERR_NameofMethodGroupWithTypeParameters = 8084,
        ERR_NoAliasHere = 8085,
        ERR_UnescapedCurly = 8086,
        ERR_EscapedCurly = 8087,
        ERR_TrailingWhitespaceInFormatSpecifier = 8088,
        ERR_EmptyFormatSpecifier = 8089,
        ERR_ErrorInReferencedAssembly = 8090,
        ERR_ExternHasConstructorInitializer = 8091,
        ERR_ExpressionOrDeclarationExpected = 8092,
        ERR_NameofExtensionMethod = 8093,
        WRN_AlignmentMagnitude = 8094,
        ERR_ConstantStringTooLong = 8095,
        ERR_DebugEntryPointNotSourceMethodDefinition = 8096,
        ERR_LoadDirectiveOnlyAllowedInScripts = 8097,
        ERR_PPLoadFollowsToken = 8098,
        ERR_SourceFileReferencesNotSupported = 8099,
        ERR_BadAwaitInStaticVariableInitializer = 8100,
        ERR_InvalidPathMap = 8101,
        ERR_PublicSignButNoKey = 8102,
    }
}
