---
title: React.js Conf Round-up 2015
layout: post
author: steveluscher
---

It was a privilege to welcome the React community to Facebook HQ on January 28–29 for the first-ever React.js Conf, and a pleasure to be able to unveil three new technologies that we've been using internally at Facebook for some time: GraphQL, Relay, and React Native.

## The talks

<div class="skinny-row">
  <div class="skinny-col">
    <h3 style="margin-top:0"><a class="anchor" name="talk-keynote"></a>Keynote <a class="hash-link" href="#talk-keynote">#</a></h3>
    <p>
      <strong>Tom Occhino</strong> opened with a history of how React came to be, before announcing Facebook’s answer to a long-looming what-if question: what if we could use React to target something other than the DOM?
    </p>
  </div>
  <div class="skinny-col">
    <iframe width="305" height="171" src="https://www.youtube-nocookie.com/embed/KVZ-P-ZI6W4" frameborder="0" allowfullscreen></iframe>
  </div>
</div>

<div class="skinny-row">
  <div class="skinny-col">
    <h3 style="margin-top:0"><a class="anchor" name="talk-tweak"></a>Tweaking in real time <a class="hash-link" href="#talk-tweak">#</a></h3>
    <p>
      <strong>Brenton Simpson</strong> showed us how eBay brings Bret Victor’s feedback loop to your favorite editor using Webpack, react-hot-loader, and <a href="https://github.com/appsforartists/ambidex">Ambidex</a>.
    </p>
  </div>
  <div class="skinny-col">
    <iframe width="305" height="171" src="https://www.youtube-nocookie.com/embed/yaymfLj5tjA" frameborder="0" allowfullscreen></iframe>
  </div>
</div>

<div class="skinny-row">
  <div class="skinny-col">
    <h3 style="margin-top:0"><a class="anchor" name="talk-ast"></a>Abstract Syntax Trees <a class="hash-link" href="#talk-ast">#</a></h3>
    <p>
      <strong>Gurdas Nijor</strong> showed us how we can leverage some conventions of React to perform source code transformations that unlock an inspirational set of use cases.
    </p>
  </div>
  <div class="skinny-col">
    <iframe width="305" height="171" src="https://www.youtube-nocookie.com/embed/OZGgVxFxSIs" frameborder="0" allowfullscreen></iframe>
  </div>
</div>

<div class="skinny-row">
  <div class="skinny-col">
    <h3 style="margin-top:0"><a class="anchor" name="talk-relay-graphql"></a>Relay and GraphQL <a class="hash-link" href="#talk-relay-graphql">#</a></h3>
    <p>
      <strong>Daniel Schafer</strong> and <strong>Jing Chen</strong> showed us how Facebook approaches data fetching with React, giving us an early peek at the forthcoming duo of Relay and GraphQL.
    </p>
  </div>
  <div class="skinny-col">
    <iframe width="305" height="171" src="https://www.youtube-nocookie.com/embed/9sc8Pyc51uU" frameborder="0" allowfullscreen></iframe>
  </div>
</div>

<div class="skinny-row">
  <div class="skinny-col">
    <h3 style="margin-top:0"><a class="anchor" name="talk-channels"></a>Channels <a class="hash-link" href="#talk-channels">#</a></h3>
    <p>
      <strong>James Long</strong> explores what might happen if we introduce channels, a new style of coordinating actions, to React.
    </p>
  </div>
  <div class="skinny-col">
    <iframe width="305" height="171" src="https://www.youtube-nocookie.com/embed/W2DgDNQZOwo" frameborder="0" allowfullscreen></iframe>
  </div>
</div>

<div class="skinny-row">
  <div class="skinny-col">
    <h3 style="margin-top:0"><a class="anchor" name="talk-router"></a>React Router <a class="hash-link" href="#talk-router">#</a></h3>
    <p>
      <strong>Michael Jackson</strong> reminded us that URLs should be part of our design process, and showed us how <a href="https://github.com/rackt/react-router">react-router</a> can help to manage the transitions between them.
    </p>
  </div>
  <div class="skinny-col">
    <iframe width="305" height="171" src="https://www.youtube-nocookie.com/embed/XZfvW1a8Xac" frameborder="0" allowfullscreen></iframe>
  </div>
</div>

<div class="skinny-row">
  <div class="skinny-col">
    <h3 style="margin-top:0"><a class="anchor" name="talk-full-stack-flux"></a>Full-stack Flux <a class="hash-link" href="#talk-full-stack-flux">#</a></h3>
    <p>
      <strong>Pete Hunt</strong> showed us how a Flux approach can help us scale actions and questions on the backend in addition to the frontend.
    </p>
  </div>
  <div class="skinny-col">
    <iframe width="305" height="171" src="https://www.youtube-nocookie.com/embed/KtmjkCuV-EU" frameborder="0" allowfullscreen></iframe>
  </div>
</div>

<div class="skinny-row">
  <div class="skinny-col">
    <h3 style="margin-top:0"><a class="anchor" name="talk-performance"></a>High-performance <a class="hash-link" href="#talk-performance">#</a></h3>
    <p>
      <strong>Jason Bonta</strong> showed us how complex user interfaces can get, and how his team keeps them performant as they scale. He also had the pleasure of open-sourcing his team’s work on <a href="https://facebook.github.io/fixed-data-table/">FixedDataTable</a>.
    </p>
  </div>
  <div class="skinny-col">
    <iframe width="305" height="171" src="https://www.youtube-nocookie.com/embed/KYzlpRvWZ6c" frameborder="0" allowfullscreen></iframe>
  </div>
</div>

<div class="skinny-row">
  <div class="skinny-col">
    <h3 style="margin-top:0"><a class="anchor" name="talk-intl"></a>FormatJS and react-intl <a class="hash-link" href="#talk-intl">#</a></h3>
    <p>
      <strong>Eric Ferraiuolo</strong> showed how you can bring your app to a worldwide audience using a series of polyfills and emerging ECMAScript APIs.
    </p>
  </div>
  <div class="skinny-col">
    <iframe width="305" height="171" src="https://www.youtube-nocookie.com/embed/Sla-DkvmIHY" frameborder="0" allowfullscreen></iframe>
  </div>
</div>

<div class="skinny-row">
  <div class="skinny-col">
    <h3 style="margin-top:0"><a class="anchor" name="talk-hype"></a>Hype! <a class="hash-link" href="#talk-hype">#</a></h3>
    <p>
      <strong>Ryan Florence</strong> showed us how easy it is to transition from a career selling life insurance, to a burgeoning one as a software developer. All you have to do is to learn how to say “yes.”
    </p>
  </div>
  <div class="skinny-col">
    <iframe width="305" height="171" src="https://www.youtube-nocookie.com/embed/z5e7kWSHWTg" frameborder="0" allowfullscreen></iframe>
  </div>
</div>

<div class="skinny-row">
  <div class="skinny-col">
    <h3 style="margin-top:0"><a class="anchor" name="talk-native"></a>React Native <a class="hash-link" href="#talk-native">#</a></h3>
    <p>
      <strong>Christopher Chedeau</strong> showed us how to bring the developer experience of working with React on the web to native app development, using React Native.
    </p>
  </div>
  <div class="skinny-col">
    <iframe width="305" height="171" src="https://www.youtube-nocookie.com/embed/7rDsRXj9-cU" frameborder="0" allowfullscreen></iframe>
  </div>
</div>

<div class="skinny-row">
  <div class="skinny-col">
    <h3 style="margin-top:0"><a class="anchor" name="talk-components"></a>Components <a class="hash-link" href="#talk-components">#</a></h3>
    <p>
      <strong>Andrew Rota</strong> explained how React and Web Components can work together, and how to avoid some common pitfalls.
    </p>
  </div>
  <div class="skinny-col">
    <iframe width="305" height="171" src="https://www.youtube-nocookie.com/embed/g0TD0efcwVg" frameborder="0" allowfullscreen></iframe>
  </div>
</div>

<div class="skinny-row">
  <div class="skinny-col">
    <h3 style="margin-top:0"><a class="anchor" name="talk-immutable"></a>Immutability <a class="hash-link" href="#talk-immutable">#</a></h3>
    <p>
      <strong>Lee Byron</strong> led a master-class on persistent immutable data structures, showing us the world of possibility that they can unlock for your software, and perhaps Javascript in general.
    </p>
  </div>
  <div class="skinny-col">
    <iframe width="305" height="171" src="https://www.youtube-nocookie.com/embed/I7IdS-PbEgI" frameborder="0" allowfullscreen></iframe>
  </div>
</div>

<div class="skinny-row">
  <div class="skinny-col">
    <h3 style="margin-top:0"><a class="anchor" name="talk-gibbon"></a>Beyond the DOM <a class="hash-link" href="#talk-gibbon">#</a></h3>
    <p>
      <strong>Jafar Husain</strong> told us a story about how Netflix was able to push React into places where the DOM could not go.
  </div>
  <div class="skinny-col">
    <iframe width="305" height="171" src="https://www.youtube-nocookie.com/embed/eNC0mRYGWgc" frameborder="0" allowfullscreen></iframe>
  </div>
</div>

<div class="skinny-row">
  <div class="skinny-col">
    <h3 style="margin-top:0"><a class="anchor" name="talk-visualization"></a>Data Visualization <a class="hash-link" href="#talk-visualization">#</a></h3>
    <p>
      <strong>Zach Nation</strong> showed us how we can produce visualizations from over 45 million data points without breaking a sweat.
  </div>
  <div class="skinny-col">
    <iframe width="305" height="171" src="https://www.youtube-nocookie.com/embed/2ii1lEkIv1s" frameborder="0" allowfullscreen></iframe>
  </div>
</div>

<div class="skinny-row">
  <div class="skinny-col">
    <h3 style="margin-top:0"><a class="anchor" name="talk-refracted"></a>React Refracted <a class="hash-link" href="#talk-refracted">#</a></h3>
    <p>
      <strong>David Nolen</strong> gave us a view of React from a non-JavaScript perspective, challenging some common intuition along the way.
  </div>
  <div class="skinny-col">
    <iframe width="305" height="171" src="https://www.youtube-nocookie.com/embed/5hGHdETNteE" frameborder="0" allowfullscreen></iframe>
  </div>
</div>

<div class="skinny-row">
  <div class="skinny-col">
    <h3 style="margin-top:0"><a class="anchor" name="talk-flux-panel"></a>Flux Panel <a class="hash-link" href="#talk-flux-panel">#</a></h3>
    <p>
      <strong>Bill Fisher</strong> coordinated a Flux panel together with <strong>Michael Ridgway</strong>, <strong>Spike Brehm</strong>, <strong>Andres Suarez</strong>, <strong>Jing Chen</strong>, <strong>Ian Obermiller</strong>, and <strong>Kyle Davis</strong>.
  </div>
  <div class="skinny-col">
    <iframe width="305" height="171" src="https://www.youtube-nocookie.com/embed/LTj4O7WJJ98" frameborder="0" allowfullscreen></iframe>
  </div>
</div>

<div class="skinny-row">
  <div class="skinny-col">
    <h3 style="margin-top:0"><a class="anchor" name="talk-communication"></a>Component communication <a class="hash-link" href="#talk-communication">#</a></h3>
    <p>
      <strong>Bonnie Eisenman</strong> led us through the ‘adapter’ approach to inter-component communication taken by her team at Codecademy.
  </div>
  <div class="skinny-col">
    <iframe width="305" height="171" src="https://www.youtube-nocookie.com/embed/ZM6wXoFTY3o" frameborder="0" allowfullscreen></iframe>
  </div>
</div>

<div class="skinny-row">
  <div class="skinny-col">
    <h3 style="margin-top:0"><a class="anchor" name="talk-typescript"></a>Flow and TypeScript <a class="hash-link" href="#talk-typescript">#</a></h3>
    <p>
      <strong>James Brantly</strong> demonstrated how we can reap the benefits of static typing using both Flow and TypeScript.
  </div>
  <div class="skinny-col">
    <iframe width="305" height="171" src="https://www.youtube-nocookie.com/embed/9PTa9-PPVAc" frameborder="0" allowfullscreen></iframe>
  </div>
</div>

<div class="skinny-row">
  <div class="skinny-col">
    <h3 style="margin-top:0"><a class="anchor" name="talk-qa"></a>Core Team Q&amp;A <a class="hash-link" href="#talk-qa">#</a></h3>
    <p>
      <strong>Tom Occhino</strong>, <strong>Ben Alpert</strong>, <strong>Lee Byron</strong>, <strong>Christopher Chedeau</strong>, <strong>Sebastian Markbåge</strong>, <strong>Jing Chen</strong>, and <strong>Dan Schafer</strong> closed the conference with a Q&amp;A session.
  </div>
  <div class="skinny-col">
    <iframe width="305" height="171" src="https://www.youtube-nocookie.com/embed/EPpkboSKvPI" frameborder="0" allowfullscreen></iframe>
  </div>
</div>

## Reactions

The conference is over, but the conversation has just begun.

**Mihai Parparita** detailed his efforts to [hack his way to a React.js Conf ticket](http://blog.persistent.info/2014/12/html-munging-my-way-to-reactjs-conf.html); **James Long** blogged about [his first encounter with React Native](http://jlongster.com/First-Impressions-using-React-Native); **Eric Florenzano** talked about how he perceives the [impact of Relay, GraphQL, and React Native](https://medium.com/@ericflo/facebook-just-taught-us-all-how-to-build-websites-51f1e7e996f2) on software development; **Margaret Staples** blogged about her experience of [being on-campus at Facebook HQ](http://deadlugosi.blogspot.com/2015/02/facebook-gave-me-ice-cream.html); **Jeff Barczewski** tied his experience of attending the conference up with a bow in this [blog post filled with photos, videos, and links](http://codewinds.com/blog/2015-02-04-reactjs-conf.html); **Kevin Old** left us with [his takeaways](http://kevinold.com/2015/01/31/takeaways-from-reactjs-conf-2015.html); **Paul Wittmann** found React Native [freshly on his radar](http://www.railslove.com/stories/fresh-on-our-radar-react-native); and finally, undeterred by not being able to attend the conference in person, **Justin Ball** [summarized it from afar](http://www.justinball.com/2015/02/03/i-didn't-attend-react.js-conf/).

And, in case you missed a session, you can borrow **Michael Chan’s** [drawings](http://chantastic.io/2015-reactjs-conf/), **Mihai Parparita’s** [summary](https://quip.com/uJQeABv7nkFN), or **Shaohua Zhou’s** [day 1](http://getshao.com/2015/01/29/react-js-conf-notes-day1/) / [day 2](http://getshao.com/2015/01/29/react-js-conf-notes-day-2/) notes.

<div class="skinny-row">
  <div class="skinny-col">
    <blockquote class="twitter-tweet" lang="en"><p>Notes from <a href="https://twitter.com/dlschafer">@dlschafer</a> and <a href="https://twitter.com/jingc">@jingc</a>&#39;s <a href="https://twitter.com/hashtag/reactjsconf?src=hash">#reactjsconf</a> talk &quot;Data fetching for React applications at Facebook&quot; <a href="http://t.co/IUZUbDCDMQ">pic.twitter.com/IUZUbDCDMQ</a></p>&mdash; Michael Chan (@chantastic) <a href="https://twitter.com/chantastic/status/560538533161472000">January 28, 2015</a></blockquote>
    <blockquote class="twitter-tweet" lang="en"><p>This is just magical (in the good way)… GraphQL + Relay is amazing. <a href="https://twitter.com/hashtag/reactjsconf?src=hash">#reactjsconf</a></p>&mdash; Chris Williams (@voodootikigod) <a href="https://twitter.com/voodootikigod/status/560533225395589120">January 28, 2015</a></blockquote>
    <blockquote class="twitter-tweet" lang="en"><p>These… these are my people. :) <a href="https://twitter.com/hashtag/reactjsconf?src=hash">#reactjsconf</a></p>&mdash; Thomas Beirne (@Beirnet) <a href="https://twitter.com/Beirnet/status/560317879501848576">January 28, 2015</a></blockquote>
  </div>
  <div class="skinny-col">
    <blockquote class="twitter-tweet" lang="en"><p>Humbled by the React team and community. Found <a href="https://twitter.com/hashtag/reactjsconf?src=hash">#reactjsconf</a> very mindful, practical and just real.</p>&mdash; xnoɹǝʃ uɐıɹq (@brianleroux) <a href="https://twitter.com/brianleroux/status/560972130112655360">January 30, 2015</a></blockquote>
    <blockquote class="twitter-tweet" lang="en"><p>I say with confidence as a former UIKit author: React&#39;s model for the UI layer is vastly better than UIKit&#39;s. React Native is a *huge* deal.</p>&mdash; Andy Matuschak (@andy_matuschak) <a href="https://twitter.com/andy_matuschak/status/560511204867575808">January 28, 2015</a></blockquote>
    <blockquote class="twitter-tweet" lang="en"><p><a href="https://twitter.com/hashtag/reactjsconf?src=hash">#reactjsconf</a> was incredible. Amazing project stewardship and community. Boring prediction, React Native sends adoption vertical in 2015.</p>&mdash; David Nolen (@swannodette) <a href="https://twitter.com/swannodette/status/561232290273980416">January 30, 2015</a></blockquote>
    <blockquote class="twitter-tweet" lang="en"><p>I really love the community shout outs by <a href="https://twitter.com/Vjeux">@vjeux</a> between talks at <a href="https://twitter.com/hashtag/reactjsconf?src=hash">#reactjsconf</a>!</p>&mdash; Andrew Rota (@AndrewRota) <a href="https://twitter.com/AndrewRota/status/560927339522297856">January 29, 2015</a></blockquote>
  </div>
</div>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

**All proceeds from React.js Conf 2015 were donated to the wonderful programs at [code.org](http://code.org)**. These programs aim to increase access to the field of computer science by underrepresented members of our community. Watch this video to learn more.

<iframe width="305" height="171" src="https://www.youtube-nocookie.com/embed/FC5FbmsH4fw" frameborder="0" allowfullscreen></iframe>
