---
id: why-react-ja-JP
title: なぜReactを使うのでしょうか？
permalink: docs/why-react-ja-JP.html
next: displaying-data-ja-JP.html

---
ReactはFacebookとInstagramによって作られたユーザーインターフェイスを構築するためのJavaScriptのライブラリです。
多くの人がReactを **[MVC](https://en.wikipedia.org/wiki/Model%E2%80%93view%E2%80%93controller)** の **V** だと考えています。
私たちはReactをある1つの問題を解決するために使います。それは、 **絶えず変化していくデータとともに大きなアプリケーションを構築する** ことです。それを行うために、Reactは2つの主要な考えを持っています。

## 単純さ

どのタイミングにおいても、アプリケーションがどのように見えるべきかを単純に表現し、Reactは根底にあるデータの変更があった場合に自動的に全てのUIを管理します。

## 叙述的

データが変わった時、Reactは概念的に「リフレッシュ」ボタンを押し、変わった箇所のみを検知します。

## コンポーザブルなコンポーネントの構築
Reactは再利用可能なコンポーネントを構築するものです。実際、Reactを用いてあなたがする *ただ1つの* ことは、コンポーネントを構築することです。Reactは無駄な部分を省いてあるので、コンポーネントはコードの再利用、テスト、関心の分離を可能にします。

## 5分ください

Reactは型にはまった知識にも挑戦し、ちらっと見ただけではおかしく見えるアイディアもあるでしょう。このガイドを読むのに[5分ください](https://signalvnoise.com/posts/3124-give-it-five-minutes) 。それらのおかしく見えるアイディアはFacebookやInstagramの中と外の両方で何千ものコンポーネントを構築するために動いています。

## 更なる学習

[このブログの投稿](/react/blog/2013/06/05/why-react.html)で、私たちがReactを構築するモチベーションについて更に学習することができます。
