---
id: jsx-in-depth-it-IT
title: JSX in Profondità
permalink: docs/jsx-in-depth-it-IT.html
prev: displaying-data-it-IT.html
next: jsx-spread-it-IT.html
---

[JSX](https://facebook.github.io/jsx/) è un'estensione della sintassi JavaScript che somiglia all'XML. Puoi usare una semplice trasformazione sintattica di JSX con React.

## Perché JSX?

Non devi per forza utilizzare JSX con React. Puoi anche usare semplice JS. Tuttavia, raccomandiamo di utilizzare JSX perché usa una sintassi concisa e familiare per definire strutture ad albero dotate di attributi.

È più familiare a sviluppatori occasionali come i designer.

L'XML ha i benefici di tag di apertura e chiusura bilanciati. Ciò rende la lettura di grandi strutture ad albero più semplice di chiamate a funzione o oggetti letterali.

Non altera la semantica di JavaScript.

## Tag HTML o Componenti React

React può sia rendere tag HTML (stringhe) che componenti React (classi).

Per rendere untag HTML, usa nomi di tag minuscoli in JSX:

```javascript
var myDivElement = <div className="foo" />;
ReactDOM.render(myDivElement, document.getElementById('example'));
```

Per rendere un componente React, definisci una variabile locale che comincia con una lettera maiuscola:

```javascript
var MyComponent = React.createClass({/*...*/});
var myElement = <MyComponent someProperty={true} />;
ReactDOM.render(myElement, document.getElementById('example'));
```

Il JSX di React utilizza la convenzione maiuscolo o minuscolo per distinguere tra classi di componenti locali e tag HTML.

> Nota:
>
> Poiché JSX è JavaScript, gli identificatori come `class` e `for` sono sconsigliati
> come nomi di attributi XML. Invece, i componenti DOM React si aspettano nomi di proprietà
> come `className` e `htmlFor` rispettivamente.

## La Trasformazione

Il JSX di React viene trasformato da una sintassi XML a JavaScript nativo. Gli elementi XML, gli attributi e i figli sono trasformati in argomenti passati a `React.createElement`.

```javascript
var Nav;
// Input (JSX):
var app = <Nav color="blue" />;
// Output (JS):
var app = React.createElement(Nav, {color:"blue"});
```

Osserva che per utilizzare `<Nav />`, la variabile `Nav` deve essere visibile.

JSX permette anche di specificare i figli usando una sintassi XML:

```javascript
var Nav, Profile;
// Input (JSX):
var app = <Nav color="blue"><Profile>click</Profile></Nav>;
// Output (JS):
var app = React.createElement(
  Nav,
  {color:"blue"},
  React.createElement(Profile, null, "click")
);
```

JSX inferirà il [displayName](/react/docs/component-specs-it-IT.html#displayname) della classe dall'assegnazione delle variabile, quando il valore di displayName è indefinito:

```javascript
// Input (JSX):
var Nav = React.createClass({ });
// Output (JS):
var Nav = React.createClass({displayName: "Nav", });
```

Usa la [REPL di Babel](https://babeljs.io/repl/) per provare il JSX e vedere come viene trasformato
in JavaScript nativo, e il
[convertitore da HTML a JSX](http://magic.reactjs.net/htmltojsx.htm) per convertire il tuo HTML esistente a
JSX.

Se desideri utilizzare JSX, la guida [Primi Passi](/react/docs/getting-started-it-IT.html) ti mostra come impostare la compilazione.

> Nota:
>
> L'espressione JSX viene sempre valutata come un ReactElement. Le implementazioni
> attuali potrebbero differire. Un modo ottimizzato potrebbe porre il
> ReactElement in linea come un oggetto letterale per evitare il codice di validazione in
> `React.createElement`.

## Namespace dei Componenti

Se stai costruendo un componente che ha parecchi figli, come ad esempio un modulo, potresti facilmente trovarti con una quantità di dichiarazioni di variabili:

```javascript
// Imbarazzante blocco di dichiarazioni di variabili
var Form = MyFormComponent;
var FormRow = Form.Row;
var FormLabel = Form.Label;
var FormInput = Form.Input;

var App = (
  <Form>
    <FormRow>
      <FormLabel />
      <FormInput />
    </FormRow>
  </Form>
);
```

Per rendere tutto ciò più semplice e leggibile, *i componenti con un namespace* ti permettono di usare un componente che dispone di altri componenti come proprietà:

```javascript
var Form = MyFormComponent;

var App = (
  <Form>
    <Form.Row>
      <Form.Label />
      <Form.Input />
    </Form.Row>
  </Form>
);
```

Per fare ciò, devi semplicemente creare i tuoi *"sub-componenti"* come proprietà del componente principale:

```javascript
var MyFormComponent = React.createClass({ ... });

MyFormComponent.Row = React.createClass({ ... });
MyFormComponent.Label = React.createClass({ ... });
MyFormComponent.Input = React.createClass({ ... });
```

JSX gestirà il tutto correttamente al momento di compilare il tuo codice.

```javascript
var App = (
  React.createElement(Form, null,
    React.createElement(Form.Row, null,
      React.createElement(Form.Label, null),
      React.createElement(Form.Input, null)
    )
  )
);
```

> Nota:
>
> Questa funzionalità è disponibile nella [v0.11](/react/blog/2014/07/17/react-v0.11.html#jsx) e successive.

## Espressioni JavaScript

### Expressioni come Attributi

Per usare un'espressione JavaScript come valore di un attributo, racchiudi l'espressione in un paio
di parentesi graffe (`{}`) anziché doppi apici (`""`).

```javascript
// Input (JSX):
var person = <Person name={window.isLoggedIn ? window.name : ''} />;
// Output (JS):
var person = React.createElement(
  Person,
  {name: window.isLoggedIn ? window.name : ''}
);
```

### Attributi Booleani

Omettere il valore di un attributo fa in modo che JSX lo tratti come `true`. Per passare `false` occorre utilizzare un'espressione come attributo. Ciò capita spesso quando si usano elementi di moduli HTML, con attributi come `disabled`, `required`, `checked` e `readOnly`.

```javascript
// Queste due forme sono equivalenti in JSX per disabilitare un bottone
<input type="button" disabled />;
<input type="button" disabled={true} />;

// E queste due forme sono equivalenti in JSX per non disabilitare un bottone
<input type="button" />;
<input type="button" disabled={false} />;
```

### Expressioni per Figli

Similmente, espressioni JavaScript possono essere utilizzate per rappresentare figli:

```javascript
// Input (JSX):
var content = <Container>{window.isLoggedIn ? <Nav /> : <Login />}</Container>;
// Output (JS):
var content = React.createElement(
  Container,
  null,
  window.isLoggedIn ? React.createElement(Nav) : React.createElement(Login)
);
```

### Commenti

È facile aggiungere commenti al tuo codice JSX; sono semplici espressioni JS. Devi soltanto prestare attenzione a porre `{}` attorno ai commenti quando ti trovi dentro la sezione figli di un tag.

```javascript
var content = (
  <Nav>
    {/* commento figlio, racchiuso in {} */}
    <Person
      /* commento
         su più
         righe */
      name={window.isLoggedIn ? window.name : ''} // fine del commento su una riga
    />
  </Nav>
);
```

> NOTA:
>
> JSX è simile all'HTML, ma non esattamente identico. Consulta la guida [JSX gotchas](/react/docs/jsx-gotchas-it-IT.html) per le differenze fondamentali.
