---
id: jsx-in-depth-ko-KR
title: JSX 깊이보기
permalink: docs/jsx-in-depth-ko-KR.html
prev: displaying-data-ko-KR.html
next: jsx-spread-ko-KR.html
---

[JSX](https://facebook.github.io/jsx/)는 XML과 비슷한 JavaScript문법 확장입니다. React에서 변환되는 간단한 JSX 구문을 사용하실 수 있습니다.

## 왜 JSX인가?

React를 위해 꼭 JSX를 사용할 필요는 없고, 그냥 일반 JS를 사용할 수도 있습니만 JSX를 사용하기를 추천합니다. 왜냐하면, 어트리뷰트를 가진 트리 구조로 정의할 수 있는 간결하고 익숙한 문법이기 때문입니다.

이것은 디자이너 같은 케쥬얼 개발자에게 더 익숙합니다.

XML에는 여닫는 태그의 장점이 있습니다. 태그는 큰 트리일 때 함수 호출이나 객체 리터럴보다 읽기 쉬워 집니다.

JSX는 JavaScript의 시맨틱을 변경하지 않습니다.

## HTML 태그 vs. React 컴포넌트

React는 렌더 HTML 태그(문자열)이나 React 컴포넌트(클래스)일 수 있습니다.

HTML 태그를 렌더하려면, 그냥 JSX에 소문자 태그를 사용하세요.

```javascript
var myDivElement = <div className="foo" />;
ReactDOM.render(myDivElement, document.getElementById('example'));
```

React 컴포넌트를 렌더하려면, 대문자로 시작하는 로컬 변수를 만드세요.

```javascript
var MyComponent = React.createClass({/*...*/});
var myElement = <MyComponent someProperty={true} />;
ReactDOM.render(myElement, document.getElementById('example'));
```

React JSX는 대소문자를 로컬 컴포넌트 클래스와 HTML 태그를 구별하는 컨벤션으로 사용합니다.

> 주의:
>
> JSX가 JavaScript기 때문에, `class`, `for`같은 식별자는 XML 어트리뷰트 이름으로
> 권장하지 않습니다. 대신, React DOM 컴포넌트는 각각 `className`, `htmlFor`같은
> DOM 프로퍼티 이름을 기대합니다.

<a name="the-transform"></a>
## 변환

React JSX는 XML같은 문법에서 네이티브 JavaScript로 변환됩니다. XML 엘리먼트, 어트리뷰트, 자식은 `React.createElement`에 넘겨지는 인자로 변환됩니다.

```javascript
var Nav;
// 입력 (JSX):
var app = <Nav color="blue" />;
// 출력 (JS):
var app = React.createElement(Nav, {color:"blue"});
```

`<Nav />`를 사용하려면, `Nav`변수는 스코프에 있어야 합니다.

JSX에서는 XML 구문으로 자식을 지정할 수도 있습니다.

```javascript
var Nav, Profile;
// 입력 (JSX):
var app = <Nav color="blue"><Profile>click</Profile></Nav>;
// 출력 (JS):
var app = React.createElement(
  Nav,
  {color:"blue"},
  React.createElement(Profile, null, "click")
);
```

클래스에 [displayName](/react/docs/component-specs-ko-KR.html#displayName)이 정의되어 있지 않으면 JSX는 변수명을 displayName으로 간주할 것입니다:

```javascript
// 입력 (JSX):
var Nav = React.createClass({ });
// 출력 (JS):
var Nav = React.createClass({displayName: "Nav", });
```

[바벨 REPL](https://babeljs.io/repl/)를 보면 JSX에서 어떻게 네이티브 JavaScript로 변환(desugars)하는지 볼 수 있고, [HTML-JSX 변환기](http://magic.reactjs.net/htmltojsx.htm)는 이미 있는 HTML을 JSX로 변환해 줍니다.

JSX를 사용 하시려면, [시작하기](/react/docs/getting-started-ko-KR.html) 가이드에서 어떻게 컴파일을 하기 위해 설정하는지 보실 수 있습니다.

> 주의:
>
> JSX 표현식은 언제나 ReactElement로 변환됩니다. 실제 구현의 세부사항은 많이
> 다를 수 있습니다. 최적화 모드는 ReactElement를 `React.createElement`에서 검증
> 코드를 우회하는 객체 리터럴로 ReactElement를 인라인으로 만들 수 있습니다.

## 네임스페이스를 사용한 컴포넌트

폼같은 자식을 많이 가지는 컴포넌트를 만든다면, 많은 변수 선언을 하게 될 것입니다.

```javascript
// 변수 선언의 어색한 블록
var Form = MyFormComponent;
var FormRow = Form.Row;
var FormLabel = Form.Label;
var FormInput = Form.Input;

var App = (
  <Form>
    <FormRow>
      <FormLabel />
      <FormInput />
    </FormRow>
  </Form>
);
```

더 간단하고 쉽게 *네임스페이스를 사용한 컴포넌트*를 사용해서, 다른 컴포넌트를 어트리뷰트로 가지는 하나의 컴포넌트만 쓸 수 있습니다.

```javascript
var Form = MyFormComponent;

var App = (
  <Form>
    <Form.Row>
      <Form.Label />
      <Form.Input />
    </Form.Row>
  </Form>
);
```

이렇게 하려면, *"sub-components"*를 메인 컴포넌트의 어트리뷰트로 만들 필요가 있습니다.

```javascript
var MyFormComponent = React.createClass({ ... });

MyFormComponent.Row = React.createClass({ ... });
MyFormComponent.Label = React.createClass({ ... });
MyFormComponent.Input = React.createClass({ ... });
```

코드를 컴파일할 때 JSX는 이것을 제대로 처리해 줍니다.

```javascript
var App = (
  React.createElement(Form, null,
    React.createElement(Form.Row, null,
      React.createElement(Form.Label, null),
      React.createElement(Form.Input, null)
    )
  )
);
```

> 주의:
>
> 이 기능은 [v0.11](/react/blog/2014/07/17/react-v0.11.html#jsx) 이상에만 있습니다.

## JavaScript 표현식

### 어트리뷰트 표현식

JavaScript 표현식을 어트리뷰트 값으로 사용하려면, 표현식을 쌍따옴표(`""`)대신 중괄호(`{}`)로 감싸야 합니다.

```javascript
// 입력 (JSX):
var person = <Person name={window.isLoggedIn ? window.name : ''} />;
// 출력 (JS):
var person = React.createElement(
  Person,
  {name: window.isLoggedIn ? window.name : ''}
);
```

### 불린 어트리뷰트

어트리뷰트의 값을 생략하면 JSX는 값을 `true`로 취급합니다. 어트리뷰트 표현식에 `false`를 넘기려면 사용해야만 합니다. HTML 폼 엘리먼트에 `disabled`, `required`, `checked`, `readOnly`같은 어트리뷰트를 사용할 일이 자주 있습니다.

```javascript
// JSX에서 이 두 줄은 똑같이 버튼을 비활성화합니다.
<input type="button" disabled />;
<input type="button" disabled={true} />;

// 그리고 JSX에서 이 두 줄은 똑같이 버튼을 비활성화하지 않습니다.
<input type="button" />;
<input type="button" disabled={false} />;
```

### 자식 표현식

비슷하게, JavaScript 표현식을 자식을 표현하는 데 사용할 수 있습니다.

```javascript
// 입력 (JSX):
var content = <Container>{window.isLoggedIn ? <Nav /> : <Login />}</Container>;
// 출력 (JS):
var content = React.createElement(
  Container,
  null,
  window.isLoggedIn ? React.createElement(Nav) : React.createElement(Login)
);
```

### 주석

JSX에 주석을 넣기는 쉽습니다. 그냥 JS 표현식과 같습니다. 그냥 태그의 자식 섹션에서만 조심하시면 됩니다. 이럴 땐 주석 주변에 `{}`를 감싸야 합니다.

```javascript
var content = (
  <Nav>
    {/* 자식 주석, {}로 감싼다 */}
    <Person
      /* 여러
         줄
         주석 */
      name={window.isLoggedIn ? window.name : ''} // 줄 끝부분 주석
    />
  </Nav>
);
```

> 주의:
>
> JSX 는 HTML과 비슷하지만 완전히 같지는 않습니다. 중요한 차이점을 보시려면 [JSX gotchas](/react/docs/jsx-gotchas-ko-KR.html)를 보세요.
