---
id: jsx-spread-it-IT
title: Attributi Spread JSX
permalink: docs/jsx-spread-it-IT.html
prev: jsx-in-depth-it-IT.html
next: jsx-gotchas-it-IT.html
---

Se sai in anticipo che tutte le proprietà che desideri assegnare ad un componente, usare JSX è facile:

```javascript
  var component = <Component foo={x} bar={y} />;
```

## Le Props Mutevoli sono il Male

Se non sai quali proprietà desideri impostare, potresti essere tentato di aggiungerle all'oggetto in seguito:

```javascript
  var component = <Component />;
  component.props.foo = x; // male
  component.props.bar = y; // altrettanto male
```

Questo è un anti-pattern perché significa che non possiamo aiutarti a verificare i propTypes per tempo. Ciò significa che i tuoi errori di propTypes finiscono per avere uno stack trace indecifrabile.

Le props dovrebbero essere considerate immutabili. Mutare l'oggetto props altrove potrebbe causare conseguenze inattese, quindi a questo punto dovrebbe essere idealmente considerato un oggetto congelato.

## Attributi Spread

Adesso puoi utilizzare una nuova caratteristica di JSX chiamata attributi spread:

```javascript
  var props = {};
  props.foo = x;
  props.bar = y;
  var component = <Component {...props} />;
```

Le proprietà dell'oggetto che passi al componente sono copiate nelle sue props.

Puoi usarlo più volte o combinarlo con altri attributi. L'ordine in cui sono specificati è rilevante. Attributi successivi ridefiniscono quelli precedentemente impostati.

```javascript
  var props = { foo: 'default' };
  var component = <Component {...props} foo={'override'} />;
  console.log(component.props.foo); // 'override'
```

## Cos'è la strana notazione `...`?

L'operatore `...` (o operatore spread) è già supportato per gli [array in ES6](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Spread_operator). Esiste anche una proposta per ES7 per le proprietà [Spread e Rest di Object](https://github.com/sebmarkbage/ecmascript-rest-spread). Stiamo prendendo spunto da questi standard supportati o in corso di sviluppo per fornire una sintassi più pulita a JSX.
