---
id: jsx-spread
title: JSXの拡張属性
permalink: docs/jsx-spread-ja-JP.html
prev: jsx-in-depth-ja-JP.html
next: jsx-gotchas-ja-JP.html
---

以下のように、コンポーネントにどのようなプロパティを配置したいか前もって全て分かっている場合は、JSXを使うことは簡単です。

```javascript
  var component = <Component foo={x} bar={y} />;
```

## Propsを変更してはいけない

セットしたいプロパティが分からない場合は、以下のように後からオブジェクトに追加したいと思うでしょう。

```javascript
  var component = <Component />;
  component.props.foo = x; // だめ
  component.props.bar = y; // 同様にだめ
```

これはアンチパターンです。なぜなら、後々まで正しいpropTypesであるかどうかチェックすることを助けることができないことを意味するからです。これは、propTypesのエラーが隠されたスタックトレースに出力されて終わってしまうことを意味します。

propsは変更不可と考えられるべきです。propsのオブジェクトをどこかで変更することは予期せぬ結果を発生させる可能性があるので、理想的には、この時点ではpropsは固定のオブジェクトであるべきです。

## 拡張属性

以下のように、拡張属性というJSXの新しい特徴を使うことができます。

```javascript
  var props = {};
  props.foo = x;
  props.bar = y;
  var component = <Component {...props} />;
```

あなたが渡したオブジェクトのプロパティはコンポーネントのpropsにコピーされます。

これを複数回使用したり、他の属性と組み合わせたりすることもできます。仕様書では、順序が重要となっています。後の属性は前の属性をオーバーライドします。

```javascript
  var props = { foo: 'default' };
  var component = <Component {...props} foo={'override'} />;
  console.log(component.props.foo); // 'override'
```

## 奇妙な `...` という表現は何でしょうか？

`...` 操作（拡張操作）は既に[ES6のarrays](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Spread_operator)でサポートされています。[Object Rest と Spread Properties](https://github.com/sebmarkbage/ecmascript-rest-spread)のES7のプロポーザルもあります。JSXのきれいなシンタックスを供給するために、それらのサポートや開発中の標準使用を利用しています。
