---
id: jsx-spread-ko-KR
title: JSX 스프레드 어트리뷰트
permalink: docs/jsx-spread-ko-KR.html
prev: jsx-in-depth-ko-KR.html
next: jsx-gotchas-ko-KR.html
---

미리 컴포넌트에 넣을 모든 프로퍼티를 알게 된다면, JSX를 사용하기 쉬워집니다.

```javascript
  var component = <Component foo={x} bar={y} />;
```

## Props의 변경은 나빠요

하지만 어떤 프로퍼티를 설정하고 싶은지 모른다면, 객체 레이어에 넣고 싶어질 수도 있습니다.

```javascript
  var component = <Component />;
  component.props.foo = x; // 나쁨
  component.props.bar = y; // 역시 나쁨
```

이것은 안티 패턴입니다. 왜냐하면 한참 뒤까지 정확한 propTypes을 체크할 수 없다는 뜻이기 때문입니다. 이것은 propTypes 에러는 알기 힘든 스택 트레이스로 끝난다는 의미입니다.

props는 변하지 않는 것으로 간주해야 합니다. props 객체를 변경하는 것은 다른 곳에서 예기치 못한 결과가 생길 수 있기 때문에 이상적으로는 이 시점에서 frozen 객체가 되어야 합니다.

## 스프레드 어트리뷰트

이제 JSX의 새로운 기능인 스프레드 어트리뷰트를 사용하실 수 있습니다.

```javascript
  var props = {};
  props.foo = x;
  props.bar = y;
  var component = <Component {...props} />;
```

전달한 객체의 프로퍼티가 컴포넌트의 props에 복사됩니다.

이렇게 여러 번 사용하거나 다른 어트리뷰트와 조합해서 사용할 수 있습니다. 명세의 순서는 중요합니다. 나중의 어트리뷰트가 이전 것보다 우선되기 때문입니다.

```javascript
  var props = { foo: 'default' };
  var component = <Component {...props} foo={'override'} />;
  console.log(component.props.foo); // 'override'
```

## 이상한 `...` 표기법은 무엇인가요?

`...` 연산자(스프레드 연산자)는 이미 [ES6의 배열](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Spread_operator)에서 지원합니다. [객체 rest와 스프레드 프로퍼티](https://github.com/sebmarkbage/ecmascript-rest-spread)에 대한 ES7의 제안도 있습니다. JSX의 구문을 더 깔끔하게 하기 위해 지원되고 개발중인 표준을 활용하고 있습니다.
