---
id: jsx-gotchas-it-IT
title: JSX Gotchas
permalink: docs/jsx-gotchas-it-IT.html
prev: jsx-spread-it-IT.html
next: interactivity-and-dynamic-uis-it-IT.html
---

JSX somiglia all'HTML ma ci sono delle differenze importanti da tenere in considerazione.

> Nota:
>
> Per le differenze del DOM, come l'attributo `style` in linea, consulta [here](/react/docs/dom-differences-it-IT.html).

## Entità HTML

Puoi inserire entità HTML nel testo letterale in JSX:

```javascript
<div>Primo &middot; Secondo</div>
```

Se desideri visualizzare un'entità HTML all'interno di un contenuto dinamico, avrai problemi con il doppio escape, poiché React effettua in maniera predefinita l'escape di tutte le stringhe visualizzate per prevenire un'ampia gamma di attacchi XSS.

```javascript
// Male: Mostra "Primo &middot; Secondo"
<div>{'Primo &middot; Secondo'}</div>
```

Esistono molte maniere di aggirare questo problema. La più facile è scrivere i caratteri Unicode direttamente in JavaScript. Dovrai assicurarti che il file sia salvato come UTF-8 e che le appropriate direttive UTF-8 siano impostate in modo che il browser li visualizzi correttamente.

```javascript
<div>{'Primo · Secondo'}</div>
```

Un'alternativa più sicura consiste nel trovare il [codice Unicode corrispondente all'entità](http://www.fileformat.info/info/unicode/char/b7/index.htm) e usarlo all'interno di una stringa JavaScript.

```javascript
<div>{'Primo \u00b7 Secondo'}</div>
<div>{'Primo ' + String.fromCharCode(183) + ' Secondo'}</div>
```

Puoi usare array misti con stringhe ed elementi JSX.

```javascript
<div>{['Primo ', <span>&middot;</span>, ' Secondo']}</div>
```

Come ultima risorsa, puoi sempre [inserire HTML nativo](/react/tips/dangerously-set-inner-html.html).

```javascript
<div dangerouslySetInnerHTML={{'{{'}}__html: 'Primo &middot; Secondo'}} />
```


## Attributi HTML Personalizzati

Se passi proprietà che non esistono nella specifica HTML ad elementi HTML nativi, React li ignorerà. Se vuoi usare un attributo personalizzato, devi prefiggerlo con `data-`.

```javascript
<div data-custom-attribute="foo" />
```

Gli attributi per [l'Accessibilità del Web](http://www.w3.org/WAI/intro/aria) che iniziano per `aria-` saranno gestiti correttamente.

```javascript
<div aria-hidden={true} />
```
