---
id: jsx-gotchas-ko-KR
title: JSX Gotchas
permalink: docs/jsx-gotchas-ko-KR.html
prev: jsx-spread-ko-KR.html
next: interactivity-and-dynamic-uis-ko-KR.html
---

JSX는 HTML처럼 보이지만, 작업하다 보면 마주치게 될 몇 가지 중요한 차이점이 있습니다.

> 주의:
>
> 인라인 `style` 어트리뷰트 같은 DOM과의 차이점은 [여기](/react/tips/dangerously-set-inner-html-ko-KR.html)를 보세요.

## HTML 엔티티

JSX의 리터럴 텍스트에 HTML 엔티티를 넣을 수 있습니다.

```javascript
<div>First &middot; Second</div>
```

동적 콘텐츠 안에 HTML 엔티티를 표시하려 할 때, React에서는 XSS 공격을 광범위하게 막기 위해서 기본적으로 모든 표시하는 문자열을 이스케이프 하기 때문에 더블 이스케이프 문제에 부딪히게 됩니다.

```javascript
// 나쁨: "First &middot; Second"를 표시
<div>{'First &middot; Second'}</div>
```

이 이슈를 피해 갈 방법은 여럿 있지만, 가장 쉬운 방법은 유니코드 문자를 JavaScript에 직접 쓰는 것입니다. 브라우저가 올바르게 표시하도록 파일이 UTF-8으로 저장되어 있고 올바른 UTF-8 지시자를 사용하고 있는지 확인해야 합니다.

```javascript
<div>{'First · Second'}</div>
```

더 안전한 대안으로 [엔티티에 대응하는 유니코드 숫자](http://www.fileformat.info/info/unicode/char/b7/index.htm)를 찾아 JavaScript 문자열 안에서 사용하는 방법도 있습니다.

```javascript
<div>{'First \u00b7 Second'}</div>
<div>{'First ' + String.fromCharCode(183) + ' Second'}</div>
```

문자열과 JSX 엘리먼트를 혼합한 배열을 사용할 수도 있습니다.

```javascript
<div>{['First ', <span>&middot;</span>, ' Second']}</div>
```

최후의 수단으로, 항상 [생 HTML을 삽입](/react/docs/dom-differences-ko-KR.html)할 수 있습니다.

```javascript
<div dangerouslySetInnerHTML={{'{{'}}__html: 'First &middot; Second'}} />
```


## 커스텀 HTML 어트리뷰트

프로퍼티를 HTML 사양에는 없는 네이티브 HTML 엘리먼트에 넘기면, React는 그 프로퍼티를 렌더하지 않습니다. 커스텀 어트리뷰트를 사용하고 싶다면, 접두사로 `data-`를 붙이셔야 합니다.

```javascript
<div data-custom-attribute="foo" />
```

`aria-`로 시작하는 [Web 접근성](http://www.w3.org/WAI/intro/aria) 어트리뷰트는 제대로 렌더될 것입니다.

```javascript
<div aria-hidden={true} />
```
