---
id: jsx-gotchas-zh-CN
title: JSX 陷阱
permalink: docs/jsx-gotchas-zh-CN.html
prev: jsx-spread-zh-CN.html
next: interactivity-and-dynamic-uis-zh-CN.html
---

JSX 与 HTML 非常相似，但是有些关键区别要注意。

> 注意:
>
> 关于 DOM 的区别，如行内样式属性 `style`，参考 [DOM 区别](/react/docs/dom-differences.html)

## HTML 实体

HTML 实体可以插入到 JSX 的文本中。

```javascript
<div>First &middot; Second</div>
```

如果想在 JSX 表达式中显示 HTML 实体，可以会遇到二次转义的问题，因为 React 默认会转义所有字符串，为了防止各种 XSS 攻击。

```javascript
// 错误: 会显示 “First &middot; Second”
<div>{'First &middot; Second'}</div>
```

有多种绕过的方法。最简单的是直接用 Unicode 字符。这时要确保文件是 UTF-8 编码且网页也指定为 UTF-8 编码。

```javascript
<div>{'First · Second'}</div>
```

安全的做法是先找到 [实体的 Unicode 编号](http://www.fileformat.info/info/unicode/char/b7/index.htm) ，然后在 JavaScript 字符串里使用。

```javascript
<div>{'First \u00b7 Second'}</div>
<div>{'First ' + String.fromCharCode(183) + ' Second'}</div>
```

可以在数组里混合使用字符串和 JSX 元素。

```javascript
<div>{['First ', <span>&middot;</span>, ' Second']}</div>
```

万不得已，可以直接[插入原始HTML](/react/tips/dangerously-set-inner-html.html)。

```javascript
<div dangerouslySetInnerHTML={{'{{'}}__html: 'First &middot; Second'}} />
```


## 自定义 HTML 属性

如果往原生 HTML 元素里传入 HTML 规范里不存在的属性，React 不会显示它们。如果需要使用自定义属性，要加 `data-` 前缀。

```javascript
<div data-custom-attribute="foo" />
```

然而，在自定义元素中任意的属性都是被支持的 （那些在tag名里带有连接符或者 `is="..."` 属性的）

```javascript
<x-my-component custom-attribute="foo" />
```

以 `aria-` 开头的 [网络无障碍](http://www.w3.org/WAI/intro/aria) 属性可以正常使用。

```javascript
<div aria-hidden={true} />
```
