---
id: shallow-compare-zh-CN
title: 浅比较
permalink: docs/shallow-compare-zh-CN.html
prev: perf-zh-CN.html
next: advanced-performance-zh-CN.html
---

`shallowCompare` 是一个辅助函数 在以ES6类使用React时，完成和 `PureRenderMixin` 相同的功能。

如果你的React组件的绘制函数是 “干净的” （换句话说，它在给定的 props 和 state 下绘制相同的结果）,你可以使用这个辅助函数以在某些情况下提升性能。

例如:

```js
var shallowCompare = require('react-addons-shallow-compare');
export class SampleComponent extends React.Component {
  shouldComponentUpdate(nextProps, nextState) {
    return shallowCompare(this, nextProps, nextState);
  }

  render() {
    return <div className={this.props.className}>foo</div>;
  }
}
```

`shallowCompare` 对当前的 `props` 和 `nextProps`对象 执行一个浅的相等检查，同样对于 `state` 和 `nextState`对象。
它 通过迭代比较对象的keys 并在 对象的key值不严格相等时返回false 实现此功能.

`shallowCompare` 返回 `true` 如果对 props 或 state的浅比较失败，因此组件应该更新。
`shallowCompare` 返回 `false` 如果对 props 或 state的浅比较都通过了，因此组件不应该更新。
