---
id: class-name-manipulation-it-IT
title: Manipolazione del Nome di Classe
permalink: docs/class-name-manipulation-it-IT.html
prev: two-way-binding-helpers-it-IT.html
next: test-utils-it-IT.html
---

> NOTA:
>
> Questo modulo esiste adesso in forma separata come [JedWatson/classnames](https://github.com/JedWatson/classnames) ed è indipendente da React. Questo add-on verrà quindi rimosso nell'immediato futuro.

`classSet()` è una elegante utility per manipolare facilmente la stringa dell'attributo `class` del DOM.

Ecco uno scenario comune e la sua soluzione senza `classSet()`:

```javascript
// all'interno di un componente React `<Message />`
render: function() {
  var classString = 'message';
  if (this.props.isImportant) {
    classString += ' message-important';
  }
  if (this.props.isRead) {
    classString += ' message-read';
  }
  // 'message message-important message-read'
  return <div className={classString}>Fantastico, vediamoci lì.</div>;
}
```

Questo può facilmente diventare noioso, in quanto assegnare stringhe per nomi di classi può essere difficile da leggere e soggetto ad errori. `classSet()` risolve questo problema:

```javascript
render: function() {
  var cx = React.addons.classSet;
  var classes = cx({
    'message': true,
    'message-important': this.props.isImportant,
    'message-read': this.props.isRead
  });
  // same final string, but much cleaner
  return <div className={classes}>Fantastico, vediamoci lì.</div>;
}
```

Quando usi `classSet()`, passa un oggetto le cui chiavi sono i nomi di classe CSS di cui potresti o meno avere bisogno. Valori di verità risulteranno nell'inclusione della chiave nella stringa risultante.

`classSet()` ti permette inoltre di passare nomi di classe che devono essere concatenati come argomenti:

```javascript
render: function() {
  var cx = React.addons.classSet;
  var importantModifier = 'message-important';
  var readModifier = 'message-read';
  var classes = cx('message', importantModifier, readModifier);
  // Final string is 'message message-important message-read'
  return <div className={classes}>Fantastico, vediamoci lì.</div>;
}
```

Niente più hack per concatenare le stringhe!
