---
id: class-name-manipulation
title: クラス名の操作
permalink: docs/class-name-manipulation-ja-JP.html
prev: two-way-binding-helpers-ja-JP.html
next: test-utils-ja-JP.html
---

> 注意:
> このモジュールは現在[JedWatson/classnames](https://github.com/JedWatson/classnames)に独立して存在しており、Reactは変更を検知していません。したがって、こちらは将来削除される予定です。

`classSet()` はDOMの `class` 文字列を簡単に操作するすっきりとしたユーティリティです。

以下は、 `classSet()` を使用しない共通なシナリオと解決策です。

```javascript
// `<Message />` などの中のReactコンポーネント
render: function() {
  var classString = 'message';
  if (this.props.isImportant) {
    classString += ' message-important';
  }
  if (this.props.isRead) {
    classString += ' message-read';
  }
  // 'message message-important message-read'
  return <div className={classString}>Great, I'll be there.</div>;
}
```

上記は、クラス名を文字列として渡しているので、面倒で、読みにくく、エラーが発生しやすくなります。以下のように、 `classSet()` を使用するとこの問題が解決します。

```javascript
render: function() {
  var cx = React.addons.classSet;
  var classes = cx({
    'message': true,
    'message-important': this.props.isImportant,
    'message-read': this.props.isRead
  });
  // 同様に最終的には文字列になりますが、クリアにはなります
  return <div className={classes}>Great, I'll be there.</div>;
}
```

 `classSet()` を使用する際には、キーと、必要であったり、必要でないCSSのクラス名をオブジェクトとして渡してください。値が真であるものはキーとなり、最終的には文字列の一部になります。

`classSet()` もまた、以下のように連結した文字列の引数としてクラス名を渡します。

```javascript
render: function() {
  var cx = React.addons.classSet;
  var importantModifier = 'message-important';
  var readModifier = 'message-read';
  var classes = cx('message', importantModifier, readModifier);
  // 最終的な文字列は 'message message-important message-read'
  return <div className={classes}>Great, I'll be there.</div>;
}
```

文字列の連結を手で書くのはやめましょう！
