---
id: class-name-manipulation-ko-KR
title: 클래스 이름 조작
permalink: docs/class-name-manipulation-ko-KR.html
prev: two-way-binding-helpers-ko-KR.html
next: test-utils-ko-KR.html
---

> 주의:
>
> 이 모듈은 폐기예정입니다. 대신 [JedWatson/classnames](https://github.com/JedWatson/classnames)를 사용하세요.

`classSet()`은 간단히 DOM `class` 문자열을 조작하는 편리한 도구입니다.

일반적으로 있을법한 경우와 `classSet()`을 사용하지 않았을 때의 처리법을 보시죠.

```javascript
// 어떤 `<Message />` React 컴포넌트의 안쪽
render: function() {
  var classString = 'message';
  if (this.props.isImportant) {
    classString += ' message-important';
  }
  if (this.props.isRead) {
    classString += ' message-read';
  }
  // 'message message-important message-read'
  return <div className={classString}>좋아요, 거기서 봅시다.</div>;
}
```

이것은 순식간에 장황해질 수 있습니다. 클래스 이름 문자열은 읽기 어렵고 에러가 발생하기도 쉽죠. `classSet()`가 이 문제를 해결할 수 있습니다.

```javascript
render: function() {
  var cx = React.addons.classSet;
  var classes = cx({
    'message': true,
    'message-important': this.props.isImportant,
    'message-read': this.props.isRead
  });
  // 최종 문자열은 동일하지만, 훨씬 깔끔함
  return <div className={classes}>좋아요, 거기서 봅시다.</div>;
}
```

`classSet()`을 사용할 때 사용할지 안할지 잘 모르는 CSS 클래스 이름 키와 함께 객체를 전달합니다. true로 간주되는(Truthy) 값은 키를 결과 문자열의 일부로 만듭니다.

`classSet()`은 클래스 이름을 인자로 넘겨 연결되게 할 수도 있습니다.

```javascript
render: function() {
  var cx = React.addons.classSet;
  var importantModifier = 'message-important';
  var readModifier = 'message-read';
  var classes = cx('message', importantModifier, readModifier);
  // 최종 문자열은 'message message-important message-read'
  return <div className={classes}>좋아요, 거기서 봅시다.</div>;
}
```

복잡한 문자열 연결은 이제 안하셔도 됩니다!
