---
id: test-utils-it-IT
title: Utilità di Test
permalink: docs/test-utils-it-IT.html
prev: two-way-binding-helpers-it-IT.html
next: clone-with-props-it-IT.html
---

`React.addons.TestUtils` semplifica la validazione dei componenti React nel framework di test di tua scelta (noi utilizziamo [Jest](https://facebook.github.io/jest/)).

### Simulate

```javascript
Simulate.{eventName}(
  DOMElement element,
  [object eventData]
)
```

Simula l'inoltro di un evento su un nodo DOM con dei dati dell'evento opzionali `eventData`. **Questa è probabilmente l'utilità più essenziale in `ReactTestUtils`.**

**Cliccare un elemento**

```javascript
var node = ReactDOM.findDOMNode(this.refs.button);
React.addons.TestUtils.Simulate.click(node);
```

**Cambiare il valore di un campo di input e in seguito premere INVIO**

```javascript
var node = ReactDOM.findDOMNode(this.refs.input);
node.value = 'giraffe';
React.addons.TestUtils.Simulate.change(node);
React.addons.TestUtils.Simulate.keyDown(node, {key: "Enter", keyCode: 13, which: 13});
```

*nota che dovrai fornire tu stesso ciascuna proprietà dell'evento utilizzata nel tuo componente (ad es. keyCode, which, etc...) in quanto React non crea alcuna di esse per te*

`Simulate` possiede un metodo per ciascun evento che React comprende.

### renderIntoDocument

```javascript
ReactComponent renderIntoDocument(
  ReactElement instance
)
```

Effettua il rendering di un componente in un nodo DOM staccato dal documento. **Questa funzione richiede la presenza del DOM.**

### mockComponent

```javascript
object mockComponent(
  function componentClass,
  [string mockTagName]
)
```

Passa il mock di un componente a questo metodo per aumentarlo con metodi utili che gli permettono di essere utilizzato come un componente React fantoccio. Anziché essere visualizzato come al solito, il componente diventerà un semplice `<div>` (o qualsiasi altro tag se fornito come valore di `mockTagName`) contenente ciascun figlio fornito.

### isElement

```javascript
boolean isElement(
  ReactElement element
)
```

Restituisce `true` se `element` è un qualunque ReactElement.

### isElementOfType

```javascript
boolean isElementOfType(
  ReactElement element,
  function componentClass
)
```

Restituisce `true` se `element` è un ReactElement il cui tipo è la classe React `componentClass`.

### isDOMComponent

```javascript
boolean isDOMComponent(
  ReactComponent instance
)
```

Restituisce `true` se `instance` è un componente DOM (come ad esempio `<div>` o `<span>`).

### isCompositeComponent

```javascript
boolean isCompositeComponent(
  ReactComponent instance
)
```

Restituisce `true` se `instance` è un componente composito (creato tramite `React.createClass()`).

### isCompositeComponentWithType

```javascript
boolean isCompositeComponentWithType(
  ReactComponent instance,
  function componentClass
)
```

Restituisce `true` se `instance` è un componente composito (creato tramite `React.createClass()`) il cui tipo è una classe React dal nome `componentClass`.

### findAllInRenderedTree

```javascript
array findAllInRenderedTree(
  ReactComponent tree,
  function test
)
```

Attraversa tutti i componenti in `tree` e accumula tutti i componenti per i quali `test(component)` è `true`. Non è molto utile usata da sola, ma diventa ptente se usata come primitiva per altre utilità di test.

### scryRenderedDOMComponentsWithClass

```javascript
array scryRenderedDOMComponentsWithClass(
  ReactComponent tree, string className
)
```

Trova tutte le istanze di componenti nell'albero visualizzato che sono componenti DOM il cui nome di classe corrisponde a `className`.

### findRenderedDOMComponentWithClass

```javascript
ReactComponent findRenderedDOMComponentWithClass(
  ReactComponent tree,
  string className
)
```

Simile a `scryRenderedDOMComponentsWithClass()` ma si aspetta di trovare un solo risultato, e restituisce quel solo risultato, oppure lancia un'eccezione se viene trovato qualunque altro numero di occorrenze diverso da uno.

### scryRenderedDOMComponentsWithTag

```javascript
array scryRenderedDOMComponentsWithTag(
  ReactComponent tree,
  string tagName
)
```

Trova tutte le istanze di componenti nell'albero visualizzato che sono componenti DOM il cui nome di tag corrisponde a `tagName`.

### findRenderedDOMComponentWithTag

```javascript
ReactComponent findRenderedDOMComponentWithTag(
  ReactComponent tree,
  string tagName
)
```

Simile a `scryRenderedDOMComponentsWithTag()` ma si aspetta di trovare un solo risultato, e restituisce quel solo risultato, oppure lancia un'eccezione se viene trovato qualunque altro numero di occorrenze diverso da uno.

### scryRenderedComponentsWithType

```javascript
array scryRenderedComponentsWithType(
  ReactComponent tree,
  function componentClass
)
```

Trova tutte le istanze di componenti il cui tipo corrisponde a `componentClass`.

### findRenderedComponentWithType

```javascript
ReactComponent findRenderedComponentWithType(
  ReactComponent tree, function componentClass
)
```

Simile a `scryRenderedComponentsWithType()` si aspetta di trovare un solo risultato, oppure lancia un'eccezione se viene trovato qualunque altro numero di occorrenze diverso da uno.


## Rendering superficiale

Il rendering superficiale è una caratteristica sperimentale che ti permette di effettuare il rendering di un componente "ad un livello di profondità" e asserire dei fatti su ciò che viene restituito dal suo metodo render, senza preoccuparti del comportamento dei componenti figli, i quali non sono né istanziati né viene effettuato il rendering. Questo non richiede la presenza di un DOM.

```javascript
ReactShallowRenderer createRenderer()
```

Chiama questo metodo nei tuoi test per creare un renderer superficiale. Puoi pensare ad esso come un "luogo" in cui effettuare il rendering del componente che stai validando, dove può rispondere ad eventi e aggiornarsi.

```javascript
shallowRenderer.render(
  ReactElement element
)
```

Simile a `ReactDOM.render`.

```javascript
ReactComponent shallowRenderer.getRenderOutput()
```

Dopo che `render` è stato chiamato, restituisce un output di cui è stato effettuato un rendering superficiale. Puoi quindi iniziare ad asserire fatti sull'output. Ad esempio, se il metodo render del tuo componente resituisce:

```javascript
<div>
  <span className="heading">Titolo</span>
  <Subcomponent foo="bar" />
</div>
```

Allora puoi asserire:

```javascript
result = renderer.getRenderOutput();
expect(result.type).toBe('div');
expect(result.props.children).toEqual([
  <span className="heading">Titolo</span>,
  <Subcomponent foo="bar" />
]);
```

La validazione superficiale ha al momento alcune limitazioni, in particolare non supporta i riferimenti. Stiamo rilasciando questa caratteristica in anticipo e gradiremmo ascoltare il parere della comunità React per la direzione in cui debba evolvere.
