---
id: test-utils
title: テストユーティリティ
permalink: docs/test-utils-ja-JP.html
prev: two-way-binding-helpers-ja-JP.html
next: clone-with-props-ja-JP.html
---

`React.addons.TestUtils` は選んだテストフレームワーク（私たちは[Jest](https://facebook.github.io/jest/)を使っています）において、Reactのコンポーネントをテストすることを簡単にします。

### Simulate

```javascript
Simulate.{eventName}(DOMElement element, object eventData)
```

オプションの `eventData` であるイベントデータと共に、DOMノードの上でイベントのディスパッチをシミュレートします。 **これは `ReactTestUtils` の中で最も有用なユーティリティでしょう。**

使用例:

```javascript
var node = ReactDOM.findDOMNode(this.refs.input);
React.addons.TestUtils.Simulate.click(node);
React.addons.TestUtils.Simulate.change(node, {target: {value: 'Hello, world'}});
React.addons.TestUtils.Simulate.keyDown(node, {key: "Enter"});
```

`Simulate` はReactが理解出来る全てのイベントのためのメソッドを持っています。

### renderIntoDocument

```javascript
ReactComponent renderIntoDocument(ReactElement instance)
```

コンポーネントをドキュメントの中で分離したDOMノードにレンダリングします。 **この関数はDOMを必要とします。**


### mockComponent

```javascript
object mockComponent(function componentClass, string? mockTagName)
```

有効なダミーのReactのコンポーネントとして使われることを許可するメソッドと共にこれを増強させるためにモックとなったコンポーネントモジュールをこのメソッドに渡してください。いつものようにレンダリングされる代わりに、コンポーネントは単純で、提供された子要素はどんなものでも含む `<div>` （`mockTagName` が提供されている場合はそのタグ）になるでしょう。

### isElement

```javascript
boolean isElement(ReactElement element)
```

`element` が何かしらのReactElementだった場合に `true` を返します。

### isElementOfType

```javascript
boolean isElementOfType(ReactElement element, function componentClass)
```

`element` がReactの `componentClass` 型であるReactElementだった場合に `true` を返します。

### isDOMComponent

```javascript
boolean isDOMComponent(ReactComponent instance)
```

`instance` がDOMのコンポーネントだった場合に `true` を返します( `<div>` や `<span>` のように)。

### isCompositeComponent

```javascript
boolean isCompositeComponent(ReactComponent instance)`
```

`instance` が複合的なコンポーネントだった場合に `true` を返します（`React.createClass()` で作成されるような）。

### isCompositeComponentWithType

```javascript
boolean isCompositeComponentWithType(ReactComponent instance, function componentClass)
```

`instance` が複合的なコンポーネントだった場合に `true` を返します（`React.createClass()` で作成され、型がReactの `componentClass` であるような）。

### findAllInRenderedTree

```javascript
array findAllInRenderedTree(ReactComponent tree, function test)
```

`tree` の中の全てのコンポーネントや `test(component)` が `true` となる蓄積された全てのコンポーネントを検討します。これはこれだけでは有用ではありませんが、他のテストユーティリティの根本として使われます。

### scryRenderedDOMComponentsWithClass

```javascript
array scryRenderedDOMComponentsWithClass(ReactComponent tree, string className)
```

レンダリングされたツリーの中で、DOMコンポーネントであり、クラス名が `className` にマッチする、コンポーネントの全てのインスタンスを見つけます。

### findRenderedDOMComponentWithClass

```javascript
ReactComponent findRenderedDOMComponentWithClass(ReactComponent tree, string className)
```

`scryRenderedDOMComponentsWithClass()` に似ていますが、結果が1つであること、それを返すこと、またはマッチする個数が1個以外だった場合に例外を投げることを予期します。

### scryRenderedDOMComponentsWithTag

```javascript
array scryRenderedDOMComponentsWithTag(ReactComponent tree, string tagName)
```

レンダリングされたツリーの中で、DOMコンポーネントであり、タグ名が `tagName` にマッチする、コンポーネントの全てのインスタンスを見つけます。

### findRenderedDOMComponentWithTag

```javascript
ReactComponent findRenderedDOMComponentWithTag(ReactComponent tree, string tagName)
```

`scryRenderedDOMComponentsWithTag()` に似ていますが、結果が1つであること、それを返すこと、またはマッチする個数が1個以外だった場合に例外を投げることを予期します。

### scryRenderedComponentsWithType

```javascript
array scryRenderedComponentsWithType(ReactComponent tree, function componentClass)
```

型名が `componentClass` と同様である、コンポーネントの全てのインスタンスを見つけます。

### findRenderedComponentWithType

```javascript
ReactComponent findRenderedComponentWithType(ReactComponent tree, function componentClass)
```

`scryRenderedComponentsWithType()` と同じですが、結果が1つであること、それを返すこと、またはマッチする個数が1個以外だった場合に例外を投げることを予期します。

## Shallow rendering

シャローレンダリングは"第一段階の深さ"であるコンポーネントをレンダリングすることを強制し、レンダリングメソッドが返すものについての事実をアサートし、インスタンスを生成したり、レンダリングされたりしない子のコンポーネントの振る舞いについては関心しない実験的な特徴です。これはDOMを必要としません。

```javascript
ReactShallowRenderer createRenderer()
```

シャローレンダラーを作成するにはこれをテストの中で呼んでください。これをあなたがテストするコンポーネントをレンダリングする場所であると考えることができます。この場所はイベントに返答したり、これ自身を更新したりできます。

```javascript
shallowRenderer.render(ReactElement element)
```

`ReactDOM.render` に同様。

```javascript
ReactComponent shallowRenderer.getRenderOutput()
```

`render` が呼ばれた後、浅くレンダリングされた出力を返します。その後、その出力に関しての事実をアサートすることができます。例えば、以下のように、コンポーネントのレンダリングメソッドが返してきた場合は、

```javascript
<div>
  <span className="heading">Title</span>
  <Subcomponent foo="bar" />
</div>
```

以下のように、アサートできます。

```javascript
result = renderer.getRenderOutput();
expect(result.type).toBe('div');
expect(result.props.children).toEqual([
  <span className="heading">Title</span>,
  <Subcomponent foo="bar" />
]);
```

シャローテスティングは現在、制限があります。はっきり言うと、参照をサポートしていません。私たちは、この特徴を早めにリリースし、これが、どのように進化していくか、Reactのコミュニティのフィードバックを評価するつもりです。
