---
id: test-utils-ko-KR
title: 테스트 유틸리티
permalink: docs/test-utils-ko-KR.html
prev: two-way-binding-helpers-ko-KR.html
next: clone-with-props-ko-KR.html
---

`ReactTestUtils`는 선택한 테스트 프레임워크(React는 [Jest](https://facebook.github.io/jest/)를 사용)에서 React 컴포넌트를 테스트하기 쉽게 합니다.

```
var ReactTestUtils = require('react-addons-test-utils');
```

### Simulate

```javascript
Simulate.{eventName}(
  DOMElement element,
  [object eventData]
)
```

DOM 노드에 이벤트 디스패치하는 것을 시뮬레이트합니다. 선택적으로 `eventData`를 통해 이벤트 데이터도 처리할 수 있습니다. **아마 `ReactTestUtils`에서 가장 유용한 유틸리티일 것 입니다.**

**엘리먼트 클릭**

```javascript
// <button ref="button">...</button>
var node = this.refs.button;
ReactTestUtils.Simulate.click(node);
```

**입력 필드의 값을 변경하고 엔터 누르기.**

```javascript
// <input ref="input" />
var node = this.refs.input;
node.value = 'giraffe';
ReactTestUtils.Simulate.change(node);
ReactTestUtils.Simulate.keyDown(node, {key: "Enter", keyCode: 13, which: 13});
```

*컴포넌트에서 사용할 이벤트 프로퍼티(예를 들어 keyCode, which, 등등...)는 React에서 만들어 주지 않으므로 직접 제공해야 합니다.*

`Simulate`에는 React가 이해하는 모든 이벤트에 대해 메소드가 있습니다.

### renderIntoDocument

```javascript
ReactComponent renderIntoDocument(
  ReactElement instance
)
```

문서의 detach된 DOM 노드에 컴포넌트를 렌더합니다. **이 기능은 DOM을 필요로 합니다.**

> 주의:
>
> React를 임포트하기 **전에** `window`, `window.document`, `window.document.createElement`을 전역적으로 사용가능하게 해두어야 합니다. 아니면 React는 DOM과 `setState`같은 메소드가 동작하지 않는다고 생각할 수 있습니다.

### mockComponent

```javascript
object mockComponent(
  function componentClass,
  [string mockTagName]
)
```

목 컴포넌트 모듈을 이 메소드에 넘겨 더미 React 컴포넌트로 사용할 수 있도록 합니다. 이 더미는 유용한 메소드와 함께 사용해 기능을 보강할 수 있습니다. 일반적인 렌더링과는 다르게, 컴포넌트는 제공된 자식을 포함하는 평범한  `<div>`가 됩니다. (`mockTagName`을 통해 div가 아닌 다른 태그를 지정해 줄 수도 있습니다.)

### isElement

```javascript
boolean isElement(
  ReactElement element
)
```

`element`가 ReactElement면 `true`를 리턴합니다.

### isElementOfType

```javascript
boolean isElementOfType(
  ReactElement element,
  function componentClass
)
```

`element`가 React `componentClass` 타입인 ReactElement면 `true`를 리턴합니다.

### isDOMComponent

```javascript
boolean isDOMComponent(
  ReactComponent instance
)
```

`instance`가 (`<div>`나 `<span>`같은) DOM 컴포넌트면 `true`를 리턴합니다.

### isCompositeComponent

```javascript
boolean isCompositeComponent(ReactComponent instance)`
```

`instance`가 (`React.createClass()`로 생성된) 복합 컴포넌트면 `true`를 리턴합니다.

### isCompositeComponentWithType

```javascript
boolean isCompositeComponentWithType(
  ReactComponent instance,
  function componentClass
)
```

`instance`가 (`React.createClass()`로 생성된) 복합 컴포넌트고 React `componentClass` 타입이면 `true`를 리턴합니다.

### findAllInRenderedTree

```javascript
array findAllInRenderedTree(
  ReactComponent tree,
  function test
)
```

`tree`안의 모든 컴포넌트에서 `test(component)`가 `true`인 모든 컴포넌트를 모읍니다. 이것만으로는 그렇게 유용하지 않습니다만, 다른 테스트 유틸와 같이 사용합니다.

### scryRenderedDOMComponentsWithClass

```javascript
array scryRenderedDOMComponentsWithClass(
  ReactComponent tree, string className
)
```
렌더된 트리의 모든 컴포넌트 인스턴스 중에서 클래스 이름이 `className`인 DOM 컴포넌트들을 찾습니다.

### findRenderedDOMComponentWithClass

```javascript
ReactComponent findRenderedDOMComponentWithClass(ReactComponent tree, string className)
```

`scryRenderedDOMComponentsWithClass()`와 비슷하지만 하나의 결과만 기대될 때 사용합니다. 하나의 결과를 리턴하거나 한개 이상의 결과가 나온 경우에는 예외를 던집니다.

### scryRenderedDOMComponentsWithTag

```javascript
array scryRenderedDOMComponentsWithTag(
  ReactComponent tree,
  string tagName
)
```

렌더된 트리의 모든 컴포넌트 인스턴스중에서 태그 이름이 `tagName`인 DOM 컴포넌트들을 찾습니다.

### findRenderedDOMComponentWithTag

```javascript
ReactComponent findRenderedDOMComponentWithTag(
  ReactComponent tree,
  string tagName
)
```

`scryRenderedDOMComponentsWithTag()`와 비슷하지만 하나의 결과만 기대될 때 사용합니다. 하나의 결과를 리턴하거나 한개 이상의 결과가 나온 경우에는 예외를 던집니다.

### scryRenderedComponentsWithType

```javascript
array scryRenderedComponentsWithType(
  ReactComponent tree,
  function componentClass
)
```

타입이 `componentClass`인 모든 컴포넌트 인스턴스를 찾습니다.

### findRenderedComponentWithType

```javascript
ReactComponent findRenderedComponentWithType(
  ReactComponent tree, function componentClass
)
```

`scryRenderedComponentsWithType()`와 비슷하지만 하나의 결과만 기대될 때 사용합니다. 하나의 결과를 리턴하거나 한개 이상의 결과가 나온 경우에는 예외를 던집니다.

## 얕은 렌더링

얕은 렌더링은 "한 단계 깊이의" 컴포넌트를 렌더할 수 있는 실험적인 기능입니다. 자식 컴포넌트가 인스턴스화 되거나 렌더되는 등의 동작에 대한 걱정 없이 렌더 메소드가 반환하는 것만 검증합니다. 이 기능은 DOM이 필요하지 않습니다.

```javascript
ReactShallowRenderer createRenderer()
```

테스트에서 얕은 렌더러를 생성하고자 할때 호출합니다. 이를 이벤트와 업데이트에 스스로 반응하는 컴포넌트를 렌더하기 위한 "장소"라고 생각할 수 있습니다.

```javascript
shallowRenderer.render(
  ReactElement element
)
```

`ReactDOM.render`와 유사합니다.

```javascript
ReactElement shallowRenderer.getRenderOutput()
```

`render`가 호출 된 후, 얕게 렌더된 결과물을 반환합니다. 그 후엔 결과물에 대한 검증을 시작할 수 있습니다. 예를 들어 컴포넌트의 렌더 메소드가 다음을 반환한다면:

```javascript
<div>
  <span className="heading">Title</span>
  <Subcomponent foo="bar" />
</div>
```

그 후에는 검증할 수 있습니다:

```javascript
result = renderer.getRenderOutput();
expect(result.type).toBe('div');
expect(result.props.children).toEqual([
  <span className="heading">Title</span>,
  <Subcomponent foo="bar" />
]);
```

현재 얕은 테스트는 refs를 지원하지 않는 등 몇가지 제약사항이 있습니다. 우리는 이 기능을 빠르게 먼저 배포하고 React 커뮤니티의 피드백을 받아 나아갈 방향을 찾고자 합니다.
