---
id: test-utils-zh-CN
title: 测试工具
permalink: docs/test-utils-zh-CN.html
prev: two-way-binding-helpers-zh-CN.html
next: clone-with-props-zh-CN.html
---

`ReactTestUtils` 使你在你选择的测试框架中 (我们使用 [Jest](https://facebook.github.io/jest/)) 测试 React 组件变得容易。

```
var ReactTestUtils = require('react-addons-test-utils');
```

### Simulate

```javascript
Simulate.{eventName}(
  DOMElement element,
  [object eventData]
)
```

模拟一个在 DOM 节点上带有可选 `eventData` 事件数据的事件派遣（event dispatch）。**这可能是 `ReactTestUtils` 里单独最有用的工具。**

**点击一个元素**

```javascript
// <button ref="button">...</button>
var node = this.refs.button;
ReactTestUtils.Simulate.click(node);
```

**改变 input 域的值然后点击 回车。**

```javascript
// <input ref="input" />
var node = this.refs.input;
node.value = 'giraffe';
ReactTestUtils.Simulate.change(node);
ReactTestUtils.Simulate.keyDown(node, {key: "Enter", keyCode: 13, which: 13});
```

*注意你将必须提供任何你在你的组件里使用的事件属性（例如 keyCode, which, 等等）因为React没有为你创建任何这类东西。*

`Simulate` has a method for [every event that React understands](/react/docs/events.html#supported-events).

### renderIntoDocument

```javascript
ReactComponent renderIntoDocument(
  ReactElement instance
)
```

渲染一个组件到 document 里的 detached DOM 节点。**这个函数需要一个 DOM。**

> 注意:
>
> 在你 import React **之前**，你需要让 `window`, `window.document` 和 `window.document.createElement` 全局可用。
不然 React 会认为它不能访问 DOM 然后类似 `setState` 的方法会不工作。

### mockComponent

```javascript
object mockComponent(
  function componentClass,
  [string mockTagName]
)
```

传入一个 mocked 组件模块到这个方法来给它增加有用的方法，使它可以被用作 dummy React 组件。代替像通常一样的渲染，组件会成为一个简单的包含了任意被提供的子级的 `<div>` （或者其他 tag 名，如果提供了 `mockTagName`）

### isElement

```javascript
boolean isElement(
  ReactElement element
)
```

返回 `true` 如果 `element` 是任意的 ReactElement。

### isElementOfType

```javascript
boolean isElementOfType(
  ReactElement element,
  function componentClass
)
```

返回 `true` 如果 `element` 是一个类型是 React `componentClass` 的 ReactElement。

### isDOMComponent

```javascript
boolean isDOMComponent(
  ReactComponent instance
)
```

返回 `true` 如果 `instance` 是一个 DOM 组件 （比如一个 `<div>` 或者 `<span>`）。

### isCompositeComponent

```javascript
boolean isCompositeComponent(
  ReactComponent instance
)
```

返回 `true` 如果 `instance` 是一个复合组件 （由 `React.createClass()` 创建）。

### isCompositeComponentWithType

```javascript
boolean isCompositeComponentWithType(
  ReactComponent instance,
  function componentClass
)
```

返回 `true` 如果 `instance` 是一个类型为 React `componentClass` 的复合组件 （由 `React.createClass()` 创建）。

### findAllInRenderedTree

```javascript
array findAllInRenderedTree(
  ReactComponent tree,
  function test
)
```

遍历 `tree` 里所有的组件，并累积所有 `test(component)` 为 `true` 的组件。它本身并没有什么用，但是它被用作其他测试工具的基本元素。

### scryRenderedDOMComponentsWithClass

```javascript
array scryRenderedDOMComponentsWithClass(
  ReactComponent tree, string className
)
```

在渲染的树中查找所有 DOM组件的类名匹配`className` 的组件实例。

### findRenderedDOMComponentWithClass

```javascript
ReactComponent findRenderedDOMComponentWithClass(
  ReactComponent tree,
  string className
)
```

类似 `scryRenderedDOMComponentsWithClass()` 除了只有一个返回结果，并且要么返回这个结果，要么如果还有其他的匹配项就抛出一个异常。

### scryRenderedDOMComponentsWithTag

```javascript
array scryRenderedDOMComponentsWithTag(
  ReactComponent tree,
  string tagName
)
```

在渲染的树中查找所有 DOM 组件的 tag 名匹配 `tagName` 的组件实例。

### findRenderedDOMComponentWithTag

```javascript
ReactComponent findRenderedDOMComponentWithTag(
  ReactComponent tree,
  string tagName
)
```

类似 `scryRenderedDOMComponentsWithTag()` 除了只有一个返回结果，并且要么返回这个结果，要么如果还有其他的匹配项就抛出一个异常。

### scryRenderedComponentsWithType

```javascript
array scryRenderedComponentsWithType(
  ReactComponent tree,
  function componentClass
)
```

查找所有类型等于 `componentClass` 的组件实例。

### findRenderedComponentWithType

```javascript
ReactComponent findRenderedComponentWithType(
  ReactComponent tree, function componentClass
)
```

类似 `scryRenderedComponentsWithType()` 除了只有一个返回结果，并且要么返回这个结果，要么如果还有其他的匹配项就抛出一个异常。

## Shallow rendering（浅渲染）

浅渲染是一个实验性特性，让你渲染一个组件为 "one level deep" 并且断言渲染方法返回的内容，不用担心子组件的行为，它们没有被实例化或者渲染。这个方式不需要一个 DOM。

```javascript
ReactShallowRenderer createRenderer()
```

在你的测试里调用它来创建一个浅渲染器。你可以把它想做是一个你渲染你要测试的组件的 "地方"，它可以自己响应事件并更新。

```javascript
shallowRenderer.render(
  ReactElement element
)
```

类似于 `ReactDOM.render`。

```javascript
ReactElement shallowRenderer.getRenderOutput()
```

在 `render` 被调用后，返回一个浅渲染的输出。你可以接着断言输出的内容。例如，如果你的组件的渲染方法返回：

```javascript
<div>
  <span className="heading">Title</span>
  <Subcomponent foo="bar" />
</div>
```

然后你可以断言：

```javascript
var renderer = ReactTestUtils.createRenderer();
result = renderer.getRenderOutput();
expect(result.type).toBe('div');
expect(result.props.children).toEqual([
  <span className="heading">Title</span>,
  <Subcomponent foo="bar" />
]);
```

浅测试现在有一些限制，即不支持 refs。我们在早期发布这个特性，并感激 React 社区关于它应该如何演化的反馈。
