---
id: clone-with-props-it-IT
title: Clonare ReactElements
permalink: docs/clone-with-props-it-IT.html
prev: test-utils-it-IT.html
next: create-fragment-it-IT.html
---

> Nota:
> `cloneWithProps` è deprecato. Usa [React.cloneElement](top-level-api.html#react.cloneelement) al suo posto.

In rare condizioni, potresti voler creare una copia di un elemento React con proprietà diverse da quelle dell'elemento originale. Un esempio è clonare gli elementi passati come `this.props.children` ed effettuarne il rendering con proprietà diverse:

```js
var _makeBlue = function(element) {
  return React.addons.cloneWithProps(element, {style: {color: 'blue'}});
};

var Blue = React.createClass({
  render: function() {
    var blueChildren = React.Children.map(this.props.children, _makeBlue);
    return <div>{blueChildren}</div>;
  }
});

ReactDOM.render(
  <Blue>
    <p>Questo testo è blu.</p>
  </Blue>,
  document.getElementById('container')
);
```

`cloneWithProps` non trasferisce gli attributi `key` o `ref` agli elementi clonati. Le proprietà `className` e `style` sono automaticamente riunite.
