---
id: clone-with-props
title: ReactElementsをクローンすること
permalink: docs/clone-with-props-ja-JP.html
prev: test-utils-ja-JP.html
next: create-fragment-ja-JP.html
---

> 注意:
> `cloneWithProps` は使用不可になりました。[React.cloneElement](top-level-api-ja-JP.html#react.cloneelement)を代わりに使用してください。

元のReact要素とは異なるプロパティを持った要素のコピーを作成したいと考える稀なケースがあるかと思います。1つの例としては、以下のように、 `this.props.children` に渡すように要素をクローンし、異なるプロパティを持つようそれらをレンダリングするものです。

```js
var _makeBlue = function(element) {
  return React.addons.cloneWithProps(element, {style: {color: 'blue'}});
};

var Blue = React.createClass({
  render: function() {
    var blueChildren = React.Children.map(this.props.children, _makeBlue);
    return <div>{blueChildren}</div>;
  }
});

ReactDOM.render(
  <Blue>
    <p>This text is blue.</p>
  </Blue>,
  document.getElementById('container')
);
```

`cloneWithProps` は `key` や `ref` をクローンされた要素に渡すことはありません。 `className` や `style` は自動的にマージされます。
