---
id: clone-with-props-ko-KR
title: ReactElement 클론하기
permalink: docs/clone-with-props-ko-KR.html
prev: test-utils-ko-KR.html
next: create-fragment-ko-KR.html
---

> 주의:
> `cloneWithProps`는 비추천입니다. 대신 [React.cloneElement](top-level-api.html#react.cloneelement)를 사용하세요.

드문 경우긴 하지만 원래 엘리먼트와 다른 prop을 가진 React 엘리먼트의 복사본을 만들고 싶을 때가 있습니다. 예를 들면 `this.props.children`에 클론한 엘리먼트를 넘기고 다른 prop으로 렌더링하는 경우 입니다.

```js
var cloneWithProps = require('react-addons-clone-with-props');

var _makeBlue = function(element) {
  return cloneWithProps(element, {style: {color: 'blue'}});
};

var Blue = React.createClass({
  render: function() {
    var blueChildren = React.Children.map(this.props.children, _makeBlue);
    return <div>{blueChildren}</div>;
  }
});

ReactDOM.render(
  <Blue>
    <p>This text is blue.</p>
  </Blue>,
  document.getElementById('container')
);
```

`cloneWithProps`는 `key`나 `ref`를 클론된 엘리먼트에 전달하지 않습니다. `className`, `style` prop은 자동으로 머지됩니다.
