---
id: create-fragment-it-IT
title: Frammenti con Chiave
permalink: docs/create-fragment-it-IT.html
prev: clone-with-props-it-IT.html
next: update-it-IT.html
---

In molti casi, puoi utilizzare la proprietà `key` per specificare chiavi sugli elementi che restituisci da `render`. Tuttavia, questo approccio fallisce in una situazione: se hai due insiemi di figli che devi riordinare, non esiste alcun modo di assegnare una chiave a ciascuno di essi senza aggiungere un elemento contenitore.

Ovvero, se hai un componente come il seguente:

```js
var Swapper = React.createClass({
  propTypes: {
    // `leftChildren` e `rightChildren` possono essere una stringa, un elemento, un array, etc.
    leftChildren: React.PropTypes.node,
    rightChildren: React.PropTypes.node,

    swapped: React.PropTypes.bool
  }
  render: function() {
    var children;
    if (this.props.swapped) {
      children = [this.props.rightChildren, this.props.leftChildren];
    } else {
      children = [this.props.leftChildren, this.props.rightChildren];
    }
    return <div>{children}</div>;
  }
});
```

I figli saranno smontati e rimontati nel momento in cui cambi la proprietà `swapped` poiché non ci sono chiavi che marcano i due insiemi di figli.

Per risolvere questo problema, puoi utilizzare `React.addons.createFragment` per dare una chiave a ciascun insieme di figli.

#### `ReactFragment React.addons.createFragment(object children)`

Anziché creare array, scriviamo:

```js
if (this.props.swapped) {
  children = React.addons.createFragment({
    right: this.props.rightChildren,
    left: this.props.leftChildren
  });
} else {
  children = React.addons.createFragment({
    left: this.props.leftChildren,
    right: this.props.rightChildren
  });
}
```

Le chiavi degli oggetti passati (ovvero, `left` e `right`) sono usate come chiavi per l'intero insieme di figli, e l'ordine delle chiavi dell'oggetto è utilizzato per determinare l'ordine dei figli visualizzati. Con questo cambiamento, i due insiemi di figli saranno correttamente riordinati nel DOM senza bisogno di smontaggio.

Il valore di ritorno di `createFragment` deve essere trattato come un oggetto opaco; puoi usare gli helper `React.Children` per iterare su un frammento ma non dovresti accedervi direttamente. Nota anche che ci stiamo affidando al motore JavaScript per preservare l'ordine dell'enumerazione degli oggetti, che non viene garantito dalla specifica ma è implementato dai principali browser e macchine virtuali per oggetti con chiavi non numeriche.

> **Nota:**
>
> In un futuro, `createFragment` potrebbe essere sostituito da una API quale
>
> ```js
> return (
>   <div>
>     <x:frag key="right">{this.props.rightChildren}</x:frag>,
>     <x:frag key="left">{this.props.leftChildren}</x:frag>
>   </div>
> );
> ```
>
> che ti permette di assegnare chiavi direttamente in JSX senza aggiungere elementi contenitore.
