---
id: create-fragment
title: キー付けされたフラグメント
permalink: docs/create-fragment-ja-JP.html
prev: clone-with-props-ja-JP.html
next: update-ja-JP.html
---

多くの場合、 `render` から返された要素のキーを特定するために、 `key` プロパティを使用します。しかし、以下のような特定の状況では、こういったことを行うことはできません。何度も並び替える必要のある2つの子要素を持っているときには、ラッパーの要素を加える以外にそれぞれのセットのキーを追加する方法はありません。

これは、以下のようなコンポーネントがある場合には、

```js
var Swapper = React.createClass({
  propTypes: {
    // `leftChildren` と `rightChildren` は文字列や、要素や、配列などになり得ます。
    leftChildren: React.PropTypes.node,
    rightChildren: React.PropTypes.node,

    swapped: React.PropTypes.bool
  }
  render: function() {
    var children;
    if (this.props.swapped) {
      children = [this.props.rightChildren, this.props.leftChildren];
    } else {
      children = [this.props.leftChildren, this.props.rightChildren];
    }
    return <div>{children}</div>;
  }
});
```

2つの子要素のセットを表すキーがないため、 `swapped` プロパティを変更するたびに子要素はアンマウントされ、再度マウントされます。

この問題を解決するために、子要素のセットのキーを与える `React.addons.createFragment` を使用することができます。

#### `ReactFragment React.addons.createFragment(object children)`

配列を作成する代わりに、以下のように記述することができます。

```js
if (this.props.swapped) {
  children = React.addons.createFragment({
    right: this.props.rightChildren,
    left: this.props.leftChildren
  });
} else {
  children = React.addons.createFragment({
    left: this.props.leftChildren,
    right: this.props.rightChildren
  });
}
```

渡されたオブジェクトのキー（`left` や `right` のことです）は子要素のセット全体のキーとして使用され、そのオブジェクトのキーの順序はレンダリングされた子要素の順序を決める際に使用されます。この変更により、2つの子要素のセットはアンマウントされることなく、DOMの中で適切に順序立てられます。

`createFragment` の戻り値は、不透明なオブジェクトとして扱われるべきです。つまり、 `React.Children` ヘルパーを、フラグメントのなかでループするために使用することはできますが、直接アクセスするべきではないということです。私たちはいまオブジェクトの一覧における順序を保存するのにJavaScriptのエンジンに頼っていることに注意してください。それは、仕様が保証されているわけではありませんが、数に関するものではないキーとオブジェクトは全てのメジャーなブラウザやVMで実行されます。

> **注意:**
> 将来、 `createFragment` は以下のようなAPIに変わるでしょう。
>
> ```js
> return (
>   <div>
>     <x:frag key="right">{this.props.rightChildren}</x:frag>,
>     <x:frag key="left">{this.props.leftChildren}</x:frag>
>   </div>
> );
> ```
>
> ラッパーの要素を加えることなく、JSXの中に直接キーをアサインすることができます。
