---
id: pure-render-mixin-it-IT
title: PureRenderMixin
permalink: docs/pure-render-mixin-it-IT.html
prev: update-it-IT.html
next: perf-it-IT.html
---

Se la funzione render del tuo componente React è "pura" (in altre parole, visualizza lo stesso risultato a partire dagli stessi proprietà e stato), puoi usare questo mixin per un incremento di prestazioni in alcuni casi.

Esempio:

```js
var PureRenderMixin = require('react/addons').addons.PureRenderMixin;
React.createClass({
  mixins: [PureRenderMixin],

  render: function() {
    return <div className={this.props.className}>foo</div>;
  }
});
```

Dietro le quinte, il mixin implementa [shouldComponentUpdate](/react/docs/component-specs.html#updating-shouldcomponentupdate), nel quale confronta i valori attuali di `this.props` e `this.state` con i successivi e restituisce  `false` se l'uguaglianza è verificata.

> Nota:
>
> Questo confronto tra gli oggetti è soltanto superficiale. Se questi contengono strutture dati complesse, può causare dei falsi negativi per differenze in profondità. Effettua il mix in componenti la cui struttura di `this.props` e  `this.state` sia semplice, oppure utilizza `forceUpdate()` quando si ha la certezza che le strutture dati siano cambiate in profondità. In alternativa, considera l'utilizzo di [oggetti immutabili](https://facebook.github.io/immutable-js/) per facilitare il confronto rapido di oggetti annidati.
>
> Inoltre, `shouldComponentUpdate` rimanda gli aggiornamenti per l'intero sotto albero di componenti. Assicurati che tutti i componenti figli siano anch'essi "puri".
