---
id: pure-render-mixin
title: PureRenderMixin
permalink: docs/pure-render-mixin-ja-JP.html
prev: update-ja-JP.html
next: perf-ja-JP.html
---

Reactコンポーネントのrender関数が「ピュア」である（言い換えると、同じpropsやstateが与えられた時に同じ結果をレンダリングする）場合は、いくつかのケースでパフォーマンスをあげるためにこのミックスインを使用することができます。

例:

```js
var PureRenderMixin = require('react/addons').addons.PureRenderMixin;
React.createClass({
  mixins: [PureRenderMixin],

  render: function() {
    return <div className={this.props.className}>foo</div>;
  }
});
```

内部で、このミックスインは[shouldComponentUpdate](/react/docs/component-specs-ja-JP.html#updating-shouldcomponentupdate)を実行します。現在のpropsとstateを次のものと比較し、同様のものであれば、 `false` を返します。

> 注意:
> このミックスインはオブジェクトの比較のみを行います。それらが複雑なデータ構造を持っていた場合、深い位置における違いは見逃されることがあります。単純なpropsやstateをコンポーネントが持っている場合にのみ、使用してください。深いデータ構造が変更されることが分かっている場合は、 `forceUpdate()` を使用してください。または、ネストされたデータの比較を速く行うために[不変オブジェクト](https://facebook.github.io/immutable-js/)の使用を考えてみてください。
> 更に、 `shouldComponentUpdate` は全てのコンポーネントのサブツリーのアップデートをスキップします。全ての子要素のコンポーネントもまた、「ピュア」であることを確認してください。
