---
id: pure-render-mixin-zh-CN
title: PureRenderMixin
permalink: docs/pure-render-mixin-zh-CN.html
prev: update-zh-CN.html
next: perf-zh-CN.html
---

如果你的 React 组件的 render 函数是 "纯净" 的（换句话说，它的渲染在给定相同的 props 和 state 时返回相同的结果），你可以使用这个 mixin 在某些情况下进行性能加速。

例子:

```js
var PureRenderMixin = require('react-addons-pure-render-mixin');
React.createClass({
  mixins: [PureRenderMixin],

  render: function() {
    return <div className={this.props.className}>foo</div>;
  }
});
```

使用 ES6 class 语法的例子:

```js
import PureRenderMixin from 'react-addons-pure-render-mixin';
class FooComponent extends React.Component {
  constructor(props) {
    super(props);
    this.shouldComponentUpdate = PureRenderMixin.shouldComponentUpdate.bind(this);
  }

  render() {
    return <div className={this.props.className}>foo</div>;
  }
}
```

在内部, mixin 实现了 [shouldComponentUpdate](/react/docs/component-specs.html#updating-shouldcomponentupdate), 它对当前及下一步的 props 和 state 进行比较，并当相等时返回 `false`。

> 注意:
>
> 它仅仅浅比较对象。如果包含了复杂的对象，可能会对于深层的不同产生 false-negatives。只 mix 到那些含有简单 props 和 state 的组件，或者在你知道深层对象改变时使用 `forceUpdate()` 。或者，考虑使用[immutable objects](https://facebook.github.io/immutable-js/) 来促进快速的嵌套数据比较。
>
> 此外， `shouldComponentUpdate` 跳过了整个子树的更新。确保所有的子组件都是 "纯净" 的。
