---
id: perf-it-IT
title: Strumenti per la Performance
permalink: docs/perf-it-IT.html
prev: pure-render-mixin-it-IT.html
next: advanced-performance-it-IT.html
---

React è solitamente assai veloce. Tuttavia, in situazioni nelle quali devi spremere fino all'ultima goccia di prestazioni dalla tua applicazione, fornisce un hook [shouldComponentUpdate](/react/docs/component-specs.html#updating-shouldcomponentupdate) nel quale puoi aggiungere controlli di ottimizzazione per l'algoritmo di confronto di React.

Oltre a darti una panoramica sulle prestazioni generali della tua applicazione, ReactPerf è uno strumento di profilazione che ti dice esattamente dove è necessario aggiungere questi hook.

> Nota:
>
> La build di sviluppo di React è più lenta della build di produzione, per via di tutta la logica aggiuntiva per fornire, ad esempio, gli avvisi amichevoli di React nella console (eliminati dalla build di produzione). Pertanto, il profilatore serve soltanto ad indicare le parti _relativamente_ costose della tua applicazione.

## API Generale

L'oggetto `Perf` documentato di seguito è esposto come `React.addons.Perf` quando si usa la build `react-with-addons.js` in modalità di sviluppo.

### `Perf.start()` and `Perf.stop()`
Avvia/interrompe la misurazione. Le operazioni React intermedie sono registrate per analisi in seguito. Le operazioni che hanno impiegato un tempo trascurabile vengono ignorate.

Dopo l'interruzione, dovrai chiamare `Perf.getLastMeasurements()` (descritta in seguito) per ottenere le misurazioni.

### `Perf.printInclusive(measurements)`
Stampa il tempo complessivo impiegato. Se non vengono passati argomenti, stampa tutte le misurazioni dall'ultima registrazione. Stampa una tabella gradevolmente formattata nella console, come segue:

![](/react/img/docs/perf-inclusive.png)

### `Perf.printExclusive(measurements)`
I tempi "esclusivi" non includono il tempo impiegato a montare i componenti: processare le proprietà, `getInitialState`, chiamare `componentWillMount` e `componentDidMount`, etc.

![](/react/img/docs/perf-exclusive.png)

### `Perf.printWasted(measurements)`

**La parte più utile in assoluto del profilatore**.

Il tempo "sprecato" è impiegato nei componenti che non hanno di fatto visualizzato nulla, ad es. il rendering è rimasto inalterato, quindi il DOM non è stato toccato.

![](/react/img/docs/perf-wasted.png)

### `Perf.printDOM(measurements)`
Stampa le manipolazioni sottostanti del DOM, ad es. "imposta innerHTML" e "rimuovi".

![](/react/img/docs/perf-dom.png)

## API Avanzata

I metodi di stampa precedenti utilizzano `Perf.getLastMeasurements()` per effettuare una gradevole stampa dei risultati.

### `Perf.getLastMeasurements()`
Ottieni l'array delle misurazioni dall'ultima sessione di avvio-interruzione. L'array contiene oggetti, ciascuno dei quali assomiglia a quanto segue:

```js
{
  // I termini "inclusive" ed "exclusive" sono spiegati in seguito
  "exclusive": {},
  // '.0.0' è l'identificativo React del nodo
  "inclusive": {".0.0": 0.0670000008540228, ".0": 0.3259999939473346},
  "render": {".0": 0.036999990697950125, ".0.0": 0.010000003385357559},
  // Numero di istanze
  "counts": {".0": 1, ".0.0": 1},
  // Scritture sul DOM
  "writes": {},
  // Informazioni aggiuntive per il debug
  "displayNames": {
    ".0": {"current": "App", "owner": "<root>"},
    ".0.0": {"current": "Box", "owner": "App"}
  },
  "totalTime": 0.48499999684281647
}
```
