---
id: perf
title: パフォーマンスツール
permalink: docs/perf-ja-JP.html
prev: pure-render-mixin-ja-JP.html
next: advanced-performance-ja-JP.html
---

Reactは普通、従来の枠を超えてとても速いです。しかし、アプリケーションにおいて、少しでもパフォーマンスを上げようという状況では、Reactの差分を取るアルゴリズムを最大限活用するヒントが得られる、[shouldComponentUpdate](/react/docs/component-specs-ja-JP.html#updating-shouldcomponentupdate)のフックを提供します。

アプリケーション全体のパフォーマンスについての要約を得ることに加えて、ReactPerfはそれらのフックを実際にはどこに配置する必要があるか教えてくれるプロファイリングツールでもあります。

> 注意:
> Reactの開発版のビルドは与えられた外部ロジックのためにプロダクション版のビルドよりも遅くなります。例えば、Reactのフレンドリーコンソールの警告（プロダクション版のビルドにおいては警告が出ません）のように。それゆえ、プロファイラは *比較的* コストがかかっている箇所のみを指し示します。

## 一般的なAPI

ここに記述されている `Perf` オブジェクトは `react-with-addons.js` を開発版でビルドしたものを使用する際に `React.addons.Perf` として表されます。

### `Perf.start()` と `Perf.stop()`
測定の開始/終了です。その間のReactの操作は以下のような分析のために記録されます。あまり時間を使わない操作は無視されます。

停止した後、あなたは、測定結果を得るために `Perf.getLastMeasurements()` （後述）が必要になります。

### `Perf.printInclusive(measurements)`
かかった全ての時間を出力します。引数が渡されなかった場合は、デフォルトで最後の測定から全ての測定が行われます。これは以下のように、コンソールに綺麗にフォーマットされたテーブルを出力します。

![](/react/img/docs/perf-inclusive.png)

### `Perf.printExclusive(measurements)`
「占有」時間はコンポーネントをマウントするのにかかった時間を含みません。プロパティの処理、 `getInitialState` , `componentWillMount` や `componentDidMount` の呼び出しなどは含みます。

![](/react/img/docs/perf-exclusive.png)

### `Perf.printWasted(measurements)`

**プロファイラの最も有用な箇所です**。

「無駄な」時間はコンポーネントが実際には何もレンダリングしていないのにかかっている時間です。例えば、同じものをレンダリングしたので、DOMが触られなかったような場合です。

![](/react/img/docs/perf-wasted.png)

### `Perf.printDOM(measurements)`
以下のような、DOMの操作を出力します。例えば、"set innerHTML"や"remove"といったものです。

![](/react/img/docs/perf-dom.png)

## 先進的なAPI

上記の出力メソッドは結果をプリティプリントするのに `Perf.getLastMeasurements()` を使用しています。

### `Perf.getLastMeasurements()`
最後の開始と終了のセッションから測定の配列を取得します。配列は以下のようなオブジェクトを含みます。

```js
{
  // "inclusive"と"exclusive"の期間は以下で説明されています
  "exclusive": {},
  // '.0.0' はノードのReact ID
  "inclusive": {".0.0": 0.0670000008540228, ".0": 0.3259999939473346},
  "render": {".0": 0.036999990697950125, ".0.0": 0.010000003385357559},
  // インスタンスの数
  "counts": {".0": 1, ".0.0": 1},
  // 触ったDOM
  "writes": {},
  // 追加のデバッグ情報
  "displayNames": {
    ".0": {"current": "App", "owner": "<root>"},
    ".0.0": {"current": "Box", "owner": "App"}
  },
  "totalTime": 0.48499999684281647
}
```
