---
id: perf-ko-KR
title: 성능 도구
permalink: docs/perf-ko-KR.html
prev: pure-render-mixin-ko-KR.html
next: advanced-performance-ko-KR.html
---

React는 보통 처음에는 꽤 빠릅니다. 하지만 모든 성능을 짜내야 하는 상황일 때를 위해, React는 [shouldComponentUpdate](/react/docs/component-specs.html#updating-shouldcomponentupdate) 훅을 제공해 React의 diff 알고리즘을 위한 최적화 힌트를 추가할 수 있습니다.

덧붙여 앱의 전반적인 성능의 개요도 제공합니다. ReactPerf는 프로파일링 도구로 정확히 어디에 훅이 필요한지 알려줍니다.

> 주의:
>
> React의 개발 빌드는 제공되는 추가 기능으로 인해 프로덕션 빌드보다 느립니다. 추가 기능에는 React의 친절한 콘솔 경고같은 것이 있습니다.(이는 프로덕션 빌드에서는 제거 됩니다) 따라서, 프로파일러는 앱의 _상대적으로_ 비싼 부분만 표시하도록 합니다.

## 일반 API

여기에서 설명하는 `Perf` 객체는 `require('react-addons-perf')`로 노출되고 React 개발 모드에서만 사용할 수 있습니다. 이 번들을 프로덕션에서 앱과 같이 빌드하시면 안됩니다.

### `Perf.start()`와 `Perf.stop()`
측정을 시작/정지합니다. 그 사이의 React 연산은 밑에 있는 분석을 하기위해 기록됩니다. 미미한 양의 연산은 무시됩니다.

종료 후, 측정을 하기위해서는 이후에 설명할 `Perf.getLastMeasurements()`가 필요합니다.

### `Perf.printInclusive(measurements)`
전 수행 시간을 출력합니다. 인자가 넘겨지지 않으면, 기본값은 지난 기록부터의 모든 측정이 됩니다. 이 출력은 밑에 있는 것처럼 콘솔에서 깔끔한 테이블로 그려집니다.

![](/react/img/docs/perf-inclusive.png)

### `Perf.printExclusive(measurements)`
컴포넌트를 마운트하는 시간을 포함하지 않은 "exclusive" 시간입니다. 여기에는 props 연산, `getInitialState`, `componentWillMount` 호출, `componentDidMount`등이 포함됩니다.

![](/react/img/docs/perf-exclusive.png)

### `Perf.printWasted(measurements)`

**프로파일러에서 가장 유용한 부분입니다**.

렌더가 같아서, DOM을 변경(touch)하지 않는 경우같은 실제로는 아무것도 렌더하지 않는 컴포넌트가 사용하는 "낭비되는" 시간을 출력합니다.

![](/react/img/docs/perf-wasted.png)

### `Perf.printDOM(measurements)`
"set innerHTML"이나 "remove"같은 기저의 DOM 조작을 출력합니다.

![](/react/img/docs/perf-dom.png)

## 고급 API

위의 출력 메소드에 `Perf.getLastMeasurements()`를 사용해 결과를 이쁘게 출력합니다.

### `Perf.getLastMeasurements()`
마지막 start-stop 세션에서 측정들의 배열을 가져옵니다. 이 배열은 이런 객체들을 가지고 있습니다.

```js
{
  // 용어 "inclusive"와 "exclusive"는 위에서 설명했음
  "exclusive": {},
  // '.0.0'는 노드의 React ID
  "inclusive": {".0.0": 0.0670000008540228, ".0": 0.3259999939473346},
  "render": {".0": 0.036999990697950125, ".0.0": 0.010000003385357559},
  // 인스턴스의 수
  "counts": {".0": 1, ".0.0": 1},
  // DOM 변경(touch)
  "writes": {},
  // 추가 디버깅 정보
  "displayNames": {
    ".0": {"current": "App", "owner": "<root>"},
    ".0.0": {"current": "Box", "owner": "App"}
  },
  "totalTime": 0.48499999684281647
}
```
