---
id: perf-zh-CN
title: 性能工具
permalink: docs/perf-zh-CN.html
prev: pure-render-mixin-zh-CN.html
next: shallow-compare-zh-CN.html
---

React 通常是相当快的。然而，在你需要压榨你的 app 的每一分性能的情况下，它提供了一个[shouldComponentUpdate](/react/docs/component-specs.html#updating-shouldcomponentupdate) 钩子，在此你可以添加优化提示到 React 的 diff 算法里。

除了给予你一个你的 app 的整体性能概览外，ReactPerf 还是一个准确告诉你，你需要在哪里放置这些钩子的分析工具。

## General API

这里陈述的 `Perf` 对象被用 `require('react-addons-perf')` 暴露，并且只能被使用在 React 的开发模式。你不应在生产环境下在你的 app 包含这个包。

> 注意:
>
> 开发版的 React 慢于生产版，因为所有额外提供的逻辑，例如，React 的友好的控制台警告 （在生产版中被除去）。因此，分析工具仅服务于指示你的 app _相对_ 昂贵的部分。

### `Perf.start()` and `Perf.stop()`
开始/停止测量。其间的React操作被记录用于之后的分析。产生无关紧要时间的操作被忽略。

在停止以后，你将需要 `Perf.getLastMeasurements()` （下面将介绍）来获取测量结果。

### `Perf.printInclusive(measurements)`
打印总体花费的时间。如果没有传入参数，默认是从上次记录的所有测量数据。它在控制台里打印良好格式化的结果，像这样：

![](/react/img/docs/perf-inclusive.png)

### `Perf.printExclusive(measurements)`
"独占的"时间不包括花费于加载组件的时间： 处理 props, `getInitialState`, 调用 `componentWillMount` 及 `componentDidMount`, 等等。

![](/react/img/docs/perf-exclusive.png)

### `Perf.printWasted(measurements)`

**分析工具里最有用的部分**.

"垃圾"时间是花费在组件上实际没有绘制任何东西的时间，例如渲染结果总是相同，所以 DOM 没有被触碰到。

![](/react/img/docs/perf-wasted.png)

### `Perf.printDOM(measurements)`
打印底层的 DOM 操纵，例如 "set innerHTML" 和 "remove".

![](/react/img/docs/perf-dom.png)

## Advanced API

以上的打印方法使用 `Perf.getLastMeasurements()` 来美观的打印结果。

### `Perf.getLastMeasurements()`
从最后的 start-stop 会话获取测量数据数据。这个数组包含对象，每个看起来像这样：

```js
{
  // The term "inclusive" and "exclusive" are explained below
  "exclusive": {},
  // '.0.0' is the React ID of the node
  "inclusive": {".0.0": 0.0670000008540228, ".0": 0.3259999939473346},
  "render": {".0": 0.036999990697950125, ".0.0": 0.010000003385357559},
  // Number of instances
  "counts": {".0": 1, ".0.0": 1},
  // DOM touches
  "writes": {},
  // Extra debugging info
  "displayNames": {
    ".0": {"current": "App", "owner": "<root>"},
    ".0.0": {"current": "Box", "owner": "App"}
  },
  "totalTime": 0.48499999684281647
}
```
