/**
 * jQuery Mobile React Example
 *
 * Main application script.
 * For variety, this example is written in 100% JSHint-compliant JavaScript, not in JSX.
 * To see the JSX version, open app.jsx.
 *
 * Component structure:
 *
 * - App
 *   |-- JQueryMobilePage (one)
 *   |   |-- JQueryMobileHeader
 *   |   |-- JQueryMobileContent
 *   |   |   |-- PageOneContent
 *   |   |       |-- JQueryMobileButton
 *   |   |-- JQueryMobileFooter
 *   |-- JQueryMobilePage (two)
 *   |   |-- JQueryMobileHeader
 *   |   |-- JQueryMobileContent
 *   |   |   |-- PageTwoContent
 *   |   |       |-- JQueryMobileButton
 *   |   |-- JQueryMobileFooter
 *   |-- JQueryMobilePage (popup)
 *       |-- JQueryMobileHeader
 *       |-- JQueryMobileContent
 *       |   |-- PagePopUpContent
 *       |       |-- JQueryMobileButton
 *       |-- JQueryMobileFooter
 */

 /* global document, React */

'use strict';

/** Main application component. */
var App = React.createClass({
  render: function() {
    return (
      <div className="app">
        <JQueryMobilePage id="one"><PageOneContent /></JQueryMobilePage>
        <JQueryMobilePage id="two"> <PageTwoContent /></JQueryMobilePage>
        <JQueryMobilePage id="popup" headerTheme="b"> <PagePopUpContent /></JQueryMobilePage>
      </div>
    );
  }
});

/** jQuery Mobile button component. */
var JQueryMobileButton = React.createClass({
  getDefaultProps: function() {
    return {className:'ui-btn ui-shadow ui-corner-all'};
  },

  render: function() {
    return (
      <p>
        <a {...this.props}>
          {this.props.children}
        </a>
      </p>
    );
  }
});

/** jQuery Mobile page content component. */
var JQueryMobileContent = React.createClass({
  render: function() {
    return (
      <div role="main" className="ui-content">
        {this.props.children}
      </div>
    );
  }
});

/** jQuery Mobile footer component. */
var JQueryMobileFooter = React.createClass({
  render: function() {
    return <div data-role="footer"><h4>Page Footer</h4></div>;
  }
});

/** jQuery Mobile header component. */
var JQueryMobileHeader = React.createClass({
  render: function() {
    return (
      <div data-role="header" data-theme={this.props.headerTheme}>
        <h1>{this.props.title}</h1>
      </div>
    );
  }
});

/** jQuery Mobile page component. */
var JQueryMobilePage = React.createClass({
  getDefaultProps: function() {
    return {'data-role':'page', 'data-theme':'a', headerTheme:'a'};
  },

  render: function() {
    var props = {...this.props};
    return (
      <div {...props}>
        <JQueryMobileHeader title={'Page ' + this.props.id} headerTheme={this.props.headerTheme} />
        <JQueryMobileContent>{this.props.children}</JQueryMobileContent>
        <JQueryMobileFooter />
      </div>
    );
  }
});

/** Application page one component. */
var PageOneContent = React.createClass({
  render: function() {
    return (
      <div>
        <h2>One</h2>
        <p>
          I have an <code>id</code> of "one" on my page container. I'm first in the source order so I'm shown when the page loads.
        </p>
        <p>
          This is a multi-page boilerplate template that you can copy to build your first jQuery Mobile page. This template contains multiple "page" containers inside, unlike a single page template that has just one page within it.
        </p>
        <p>
          Just view the source and copy the code to get started. All the CSS and JS is linked to the jQuery CDN versions so this is super easy to set up. Remember to include a meta viewport tag in the head to set the zoom level.
        </p>
        <p>
          You link to internal pages by referring to the <code>id</code> of the page you want to show. For example, to <a href="#two">link</a> to the page with an <code>id</code> of "two", my link would have a <code>href="#two"</code> in the code.
        </p>
        <h3>Show internal pages:</h3>
        <JQueryMobileButton href="#two">Show page "two"</JQueryMobileButton>
        <JQueryMobileButton href="#popup" data-rel="dialog" data-transition="pop">Show page "popup" (as a dialog)</JQueryMobileButton>
      </div>
    );
  }
});

/** Application page two component. */
var PageTwoContent = React.createClass({
  render: function() {
    return (
      <div>
        <h2>Two</h2>
        <p>
          I have an id of "two" on my page container. I'm the second page container in this multi-page template.
        </p>
        <p>
          Notice that the theme is different for this page because we've added a few <code>data-theme</code> swatch assigments here to show off how flexible it is. You can add any content or widget to these pages, but we're keeping these simple.
        </p>
        <JQueryMobileButton href="#one" data-direction="reverse" className="ui-btn ui-shadow ui-corner-all ui-btn-b">Back to page "one"</JQueryMobileButton>
      </div>
    );
  }
});

/** Application popup page component. */
var PagePopUpContent = React.createClass({
  render: function() {
    return (
      <div>
        <h2>Popup</h2>
        <p>
          I have an id of "popup" on my page container and only look like a dialog because the link to me had a <code>data-rel="dialog"</code> attribute which gives me this inset look and a <code>data-transition="pop"</code> attribute to change the transition to pop. Without this, I\'d be styled as a normal page.
        </p>
        <JQueryMobileButton href="#one" data-rel="back" className="ui-btn ui-shadow ui-corner-all ui-btn-inline ui-icon-back ui-btn-icon-left">Back to page "one"</JQueryMobileButton>
      </div>
    );
  }
});

// Render application.
React.render(<App/>, document.getElementById('content'));

