An non-ascii identifier was used in an invalid context.

Erroneous code example:

```compile_fail,E0754
# #![feature(non_ascii_idents)]

mod řųśť;
// ^ error!
fn main() {}
```

```compile_fail,E0754
# #![feature(non_ascii_idents)]

#[no_mangle]
fn řųśť() {}
// ^ error!
fn main() {}
```

Non-ascii can be used as module names if it is inline
or a #\[path\] attribute is specified. For example:

```
# #![feature(non_ascii_idents)]

mod řųśť {
    const IS_GREAT: bool = true;
}

fn main() {}
```
