# InstructLab UI

![Lint](https://github.com/instructlab/ui/actions/workflows/lint-ui.yml/badge.svg?branch=main)
![Image](https://github.com/instructlab/ui/actions/workflows/images.yml/badge.svg?branch=main)

Project aims to provide a UI based interface to the contributors and reviewers to submit and review contribution to [instructlab/taxonomy](https://github.com/instructlab/taxonomy).
The intention is to simplify the process of contribution by providing a user friendly interface, that doesn't require the user to have a deep understanding of tools required to contribute skill and knowledge to the taxonomy. This project also aims to provide a platform for the reviewers to efficiently review the contributions and provide feedback to the contributors.

> [!IMPORTANT]
> InstructLab Community UI instance is currently hosted [here](https://ui.instructlab.ai). Please feel free to user the UI for contributing skills and knowledge to the taxonomy. If you have any feedback or suggestions please feel free to open an issue. See more details in the [Contributing](#contributing) section.

## Overview

Current scope of the project is to work on following personas:

- Taxonomy **Contributor**: Person who wants to contribute a skill or a knowledge to the taxonomy.
- Taxonomy **Triager**: Person who has expertise to review the contributions and provide feedback to the contributors.

The technical overview and developer docs for getting started can be found [here](docs/development.md).

## Contributing

If you have suggestions for how InstructLab UI can be improved, please open an [issue](https://github.com/instructlab/ui/issues) and tag it with `user suggested` label. We'd love all and any contributions.

If you encounter an issue in the hosted instance of the [InstructLab UI](ui.instructlab.ai), please open an [issue](https://github.com/instructlab/ui/issues) and tag it with `production issue` label. This will help us prioritize the issues and provide a better support to the users.

For more, check out the [InstructLab UI Contribution Guide](CONTRIBUTING.md)
and [InstructLab Community Guide](https://github.com/instructlab/community/blob/main/CONTRIBUTING.md).

## Getting Started

Get started with the [development documentation](docs/development.md).

## Tutorials and relevant documentation

- [Skill and Knowledge Contribution Guide](https://docs.instructlab.ai/taxonomy/)
- [UI User Documentation](https://docs.instructlab.ai/user-interface/ui_overview/)
- [Contributing Skills and Knowledge using InstructLab UI](https://developer.ibm.com/tutorials/awb-contributing-llm-granite-instructlab-ui/)

## Community Meeting

We have a weekly community meeting to discuss the project and contributions. Meeting happens **every Wednesday 10AM PST**.

Please subscribe to the InstructLab Community Calendar following the instructions [here](https://github.com/instructlab/community/blob/main/Collaboration.md). UI project meeting details are present in the calendar event.

## Slack channel

Please subscribe to the InstructLab Slack workspace by following the instructions [here](https://github.com/instructlab/community/blob/main/Collaboration.md#chat). Once you are part of the workspace, you can join the `#ui` channel where most of the project related topics are discussed.

## Discord channel

You can also chat with us on Discord in the `#ui` channel! Join here: [InstructLab Discord](https://discord.gg/Fa6tRapUZ2)

## License

[Apache 2.0](LICENSE)
