# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `actioncable` gem.
# Please instead update this file by running `bin/tapioca gem actioncable`.


# :markup: markdown
# :include: ../README.md
#
# source://actioncable//lib/action_cable.rb#54
module ActionCable
  private

  # Singleton instance of the server
  #
  # source://actioncable//lib/action_cable.rb#77
  def server; end

  class << self
    # source://actioncable//lib/action_cable/deprecator.rb#6
    def deprecator; end

    # Returns the currently loaded version of Action Cable as a `Gem::Version`.
    #
    # source://actioncable//lib/action_cable/gem_version.rb#7
    def gem_version; end

    # Singleton instance of the server
    #
    # source://actioncable//lib/action_cable.rb#77
    def server; end

    # Returns the currently loaded version of Action Cable as a `Gem::Version`.
    #
    # source://actioncable//lib/action_cable/version.rb#9
    def version; end
  end
end

# source://actioncable//lib/action_cable/channel/base.rb#10
module ActionCable::Channel; end

# # Action Cable Channel Base
#
# The channel provides the basic structure of grouping behavior into logical
# units when communicating over the WebSocket connection. You can think of a
# channel like a form of controller, but one that's capable of pushing content
# to the subscriber in addition to simply responding to the subscriber's direct
# requests.
#
# Channel instances are long-lived. A channel object will be instantiated when
# the cable consumer becomes a subscriber, and then lives until the consumer
# disconnects. This may be seconds, minutes, hours, or even days. That means you
# have to take special care not to do anything silly in a channel that would
# balloon its memory footprint or whatever. The references are forever, so they
# won't be released as is normally the case with a controller instance that gets
# thrown away after every request.
#
# Long-lived channels (and connections) also mean you're responsible for
# ensuring that the data is fresh. If you hold a reference to a user record, but
# the name is changed while that reference is held, you may be sending stale
# data if you don't take precautions to avoid it.
#
# The upside of long-lived channel instances is that you can use instance
# variables to keep reference to objects that future subscriber requests can
# interact with. Here's a quick example:
#
#     class ChatChannel < ApplicationCable::Channel
#       def subscribed
#         @room = Chat::Room[params[:room_number]]
#       end
#
#       def speak(data)
#         @room.speak data, user: current_user
#       end
#     end
#
# The #speak action simply uses the Chat::Room object that was created when the
# channel was first subscribed to by the consumer when that subscriber wants to
# say something in the room.
#
# ## Action processing
#
# Unlike subclasses of ActionController::Base, channels do not follow a RESTful
# constraint form for their actions. Instead, Action Cable operates through a
# remote-procedure call model. You can declare any public method on the channel
# (optionally taking a `data` argument), and this method is automatically
# exposed as callable to the client.
#
# Example:
#
#     class AppearanceChannel < ApplicationCable::Channel
#       def subscribed
#         @connection_token = generate_connection_token
#       end
#
#       def unsubscribed
#         current_user.disappear @connection_token
#       end
#
#       def appear(data)
#         current_user.appear @connection_token, on: data['appearing_on']
#       end
#
#       def away
#         current_user.away @connection_token
#       end
#
#       private
#         def generate_connection_token
#           SecureRandom.hex(36)
#         end
#     end
#
# In this example, the subscribed and unsubscribed methods are not callable
# methods, as they were already declared in ActionCable::Channel::Base, but
# `#appear` and `#away` are. `#generate_connection_token` is also not callable,
# since it's a private method. You'll see that appear accepts a data parameter,
# which it then uses as part of its model call. `#away` does not, since it's
# simply a trigger action.
#
# Also note that in this example, `current_user` is available because it was
# marked as an identifying attribute on the connection. All such identifiers
# will automatically create a delegation method of the same name on the channel
# instance.
#
# ## Rejecting subscription requests
#
# A channel can reject a subscription request in the #subscribed callback by
# invoking the #reject method:
#
#     class ChatChannel < ApplicationCable::Channel
#       def subscribed
#         @room = Chat::Room[params[:room_number]]
#         reject unless current_user.can_access?(@room)
#       end
#     end
#
# In this example, the subscription will be rejected if the `current_user` does
# not have access to the chat room. On the client-side, the `Channel#rejected`
# callback will get invoked when the server rejects the subscription request.
#
# source://actioncable//lib/action_cable/channel/base.rb#110
class ActionCable::Channel::Base
  include ::ActiveSupport::Callbacks
  include ::ActionCable::Channel::Callbacks
  include ::ActionCable::Channel::PeriodicTimers
  include ::ActionCable::Channel::Streams
  include ::ActionCable::Channel::Naming
  include ::ActionCable::Channel::Broadcasting
  include ::ActiveSupport::Rescuable
  extend ::ActiveSupport::Callbacks::ClassMethods
  extend ::ActiveSupport::DescendantsTracker
  extend ::ActionCable::Channel::Callbacks::ClassMethods
  extend ::ActionCable::Channel::PeriodicTimers::ClassMethods
  extend ::ActionCable::Channel::Naming::ClassMethods
  extend ::ActionCable::Channel::Broadcasting::ClassMethods
  extend ::ActiveSupport::Rescuable::ClassMethods

  # @return [Base] a new instance of Base
  #
  # source://actioncable//lib/action_cable/channel/base.rb#156
  def initialize(connection, identifier, params = T.unsafe(nil)); end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
  def __callbacks; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
  def __callbacks?; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#912
  def _run_subscribe_callbacks(&block); end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#912
  def _run_unsubscribe_callbacks(&block); end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#924
  def _subscribe_callbacks; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#924
  def _unsubscribe_callbacks; end

  # Returns the value of attribute connection.
  #
  # source://actioncable//lib/action_cable/channel/base.rb#118
  def connection; end

  # Returns the value of attribute identifier.
  #
  # source://actioncable//lib/action_cable/channel/base.rb#118
  def identifier; end

  # source://actioncable//lib/action_cable/channel/base.rb#119
  def logger(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute params.
  #
  # source://actioncable//lib/action_cable/channel/base.rb#118
  def params; end

  # Extract the action name from the passed data and process it via the channel.
  # The process will ensure that the action requested is a public method on the
  # channel declared by the user (so not one of the callbacks like #subscribed).
  #
  # source://actioncable//lib/action_cable/channel/base.rb#176
  def perform_action(data); end

  # source://actioncable//lib/action_cable/channel/periodic_timers.rb#11
  def periodic_timers=(_arg0); end

  # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
  def rescue_handlers; end

  # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
  def rescue_handlers=(_arg0); end

  # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
  def rescue_handlers?; end

  # This method is called after subscription has been added to the connection and
  # confirms or rejects the subscription.
  #
  # source://actioncable//lib/action_cable/channel/base.rb#191
  def subscribe_to_channel; end

  # Called by the cable connection when it's cut, so the channel has a chance to
  # cleanup with callbacks. This method is not intended to be called directly by
  # the user. Instead, override the #unsubscribed callback.
  #
  # source://actioncable//lib/action_cable/channel/base.rb#203
  def unsubscribe_from_channel; end

  private

  # source://actioncable//lib/action_cable/channel/base.rb#293
  def action_signature(action, data); end

  # source://actioncable//lib/action_cable/channel/base.rb#245
  def defer_subscription_confirmation!; end

  # @return [Boolean]
  #
  # source://actioncable//lib/action_cable/channel/base.rb#249
  def defer_subscription_confirmation?; end

  # source://actioncable//lib/action_cable/channel/base.rb#265
  def delegate_connection_identifiers; end

  # source://actioncable//lib/action_cable/channel/base.rb#281
  def dispatch_action(action, data); end

  # source://actioncable//lib/action_cable/channel/base.rb#239
  def ensure_confirmation_sent; end

  # source://actioncable//lib/action_cable/channel/base.rb#273
  def extract_action(data); end

  # source://actioncable//lib/action_cable/channel/base.rb#304
  def parameter_filter; end

  # @return [Boolean]
  #
  # source://actioncable//lib/action_cable/channel/base.rb#277
  def processable_action?(action); end

  # source://actioncable//lib/action_cable/channel/base.rb#257
  def reject; end

  # source://actioncable//lib/action_cable/channel/base.rb#319
  def reject_subscription; end

  # Called once a consumer has become a subscriber of the channel. Usually the
  # place to set up any streams you want this channel to be sending to the
  # subscriber.
  #
  # source://actioncable//lib/action_cable/channel/base.rb#213
  def subscribed; end

  # @return [Boolean]
  #
  # source://actioncable//lib/action_cable/channel/base.rb#253
  def subscription_confirmation_sent?; end

  # @return [Boolean]
  #
  # source://actioncable//lib/action_cable/channel/base.rb#261
  def subscription_rejected?; end

  # Transmit a hash of data to the subscriber. The hash will automatically be
  # wrapped in a JSON envelope with the proper channel identifier marked as the
  # recipient.
  #
  # source://actioncable//lib/action_cable/channel/base.rb#226
  def transmit(data, via: T.unsafe(nil)); end

  # source://actioncable//lib/action_cable/channel/base.rb#308
  def transmit_subscription_confirmation; end

  # source://actioncable//lib/action_cable/channel/base.rb#324
  def transmit_subscription_rejection; end

  # Called once a consumer has cut its cable connection. Can be used for cleaning
  # up connections or marking users as offline or the like.
  #
  # source://actioncable//lib/action_cable/channel/base.rb#219
  def unsubscribed; end

  class << self
    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks=(value); end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks?; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#916
    def _subscribe_callbacks; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#920
    def _subscribe_callbacks=(value); end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#916
    def _unsubscribe_callbacks; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#920
    def _unsubscribe_callbacks=(value); end

    # A list of method names that should be considered actions. This includes all
    # public instance methods on a channel, less any internal methods (defined on
    # Base), adding back in any methods that are internal, but still exist on the
    # class itself.
    #
    # #### Returns
    # *   `Set` - A set of all methods that should be considered actions.
    #
    # source://actioncable//lib/action_cable/channel/base.rb#129
    def action_methods; end

    # source://actioncable//lib/action_cable/channel/periodic_timers.rb#11
    def periodic_timers; end

    # source://actioncable//lib/action_cable/channel/periodic_timers.rb#11
    def periodic_timers=(value); end

    # source://actioncable//lib/action_cable/channel/periodic_timers.rb#11
    def periodic_timers?; end

    # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
    def rescue_handlers; end

    # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
    def rescue_handlers=(value); end

    # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
    def rescue_handlers?; end

    private

    # action_methods are cached and there is sometimes need to refresh them.
    # ::clear_action_methods! allows you to do that, so next time you run
    # action_methods, they will be recalculated.
    #
    # source://actioncable//lib/action_cable/channel/base.rb#145
    def clear_action_methods!; end

    # Refresh the cached action_methods when a new action_method is added.
    #
    # source://actioncable//lib/action_cable/channel/base.rb#150
    def method_added(name); end
  end
end

# source://actioncable//lib/action_cable/channel/broadcasting.rb#9
module ActionCable::Channel::Broadcasting
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActionCable::Channel::Broadcasting::ClassMethods

  # source://actioncable//lib/action_cable/channel/broadcasting.rb#45
  def broadcast_to(model, message); end

  # source://actioncable//lib/action_cable/channel/broadcasting.rb#41
  def broadcasting_for(model); end
end

# source://actioncable//lib/action_cable/channel/broadcasting.rb#12
module ActionCable::Channel::Broadcasting::ClassMethods
  # Broadcast a hash to a unique broadcasting for this `model` in this channel.
  #
  # source://actioncable//lib/action_cable/channel/broadcasting.rb#14
  def broadcast_to(model, message); end

  # Returns a unique broadcasting identifier for this `model` in this channel:
  #
  #     CommentsChannel.broadcasting_for("all") # => "comments:all"
  #
  # You can pass any object as a target (e.g. Active Record model), and it would
  # be serialized into a string under the hood.
  #
  # source://actioncable//lib/action_cable/channel/broadcasting.rb#24
  def broadcasting_for(model); end

  private

  # source://actioncable//lib/action_cable/channel/broadcasting.rb#29
  def serialize_broadcasting(object); end
end

# # Action Cable Channel Callbacks
#
# Action Cable Channel provides callback hooks that are invoked during the life
# cycle of a channel:
#
# *   [before_subscribe](rdoc-ref:ClassMethods#before_subscribe)
# *   [after_subscribe](rdoc-ref:ClassMethods#after_subscribe) (aliased as
#     [on_subscribe](rdoc-ref:ClassMethods#on_subscribe))
# *   [before_unsubscribe](rdoc-ref:ClassMethods#before_unsubscribe)
# *   [after_unsubscribe](rdoc-ref:ClassMethods#after_unsubscribe) (aliased as
#     [on_unsubscribe](rdoc-ref:ClassMethods#on_unsubscribe))
#
#
# #### Example
#
#     class ChatChannel < ApplicationCable::Channel
#       after_subscribe :send_welcome_message, unless: :subscription_rejected?
#       after_subscribe :track_subscription
#
#       private
#         def send_welcome_message
#           broadcast_to(...)
#         end
#
#         def track_subscription
#           # ...
#         end
#     end
#
# source://actioncable//lib/action_cable/channel/callbacks.rb#38
module ActionCable::Channel::Callbacks
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActiveSupport::Callbacks

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveSupport::Callbacks::ClassMethods
  mixes_in_class_methods ::ActiveSupport::DescendantsTracker
  mixes_in_class_methods ::ActionCable::Channel::Callbacks::ClassMethods

  module GeneratedClassMethods
    def __callbacks; end
    def __callbacks=(value); end
    def __callbacks?; end
  end

  module GeneratedInstanceMethods
    def __callbacks; end
    def __callbacks?; end
  end
end

# source://actioncable//lib/action_cable/channel/callbacks.rb#47
module ActionCable::Channel::Callbacks::ClassMethods
  # This callback will be triggered after the Base#subscribed method is called,
  # even if the subscription was rejected with the Base#reject method.
  #
  # To trigger the callback only on successful subscriptions, use the
  # Base#subscription_rejected? method:
  #
  #     after_subscribe :my_method, unless: :subscription_rejected?
  #
  # source://actioncable//lib/action_cable/channel/callbacks.rb#60
  def after_subscribe(*methods, &block); end

  # source://actioncable//lib/action_cable/channel/callbacks.rb#69
  def after_unsubscribe(*methods, &block); end

  # source://actioncable//lib/action_cable/channel/callbacks.rb#48
  def before_subscribe(*methods, &block); end

  # source://actioncable//lib/action_cable/channel/callbacks.rb#65
  def before_unsubscribe(*methods, &block); end

  # This callback will be triggered after the Base#subscribed method is called,
  # even if the subscription was rejected with the Base#reject method.
  #
  # To trigger the callback only on successful subscriptions, use the
  # Base#subscription_rejected? method:
  #
  #     after_subscribe :my_method, unless: :subscription_rejected?
  #
  # source://actioncable//lib/action_cable/channel/callbacks.rb#60
  def on_subscribe(*methods, &block); end

  # source://actioncable//lib/action_cable/channel/callbacks.rb#69
  def on_unsubscribe(*methods, &block); end
end

# # Action Cable Channel Stub
#
# Stub `stream_from` to track streams for the channel. Add public aliases for
# `subscription_confirmation_sent?` and `subscription_rejected?`.
#
# source://actioncable//lib/action_cable/channel/test_case.rb#24
module ActionCable::Channel::ChannelStub
  # @return [Boolean]
  #
  # source://actioncable//lib/action_cable/channel/test_case.rb#25
  def confirmed?; end

  # @return [Boolean]
  #
  # source://actioncable//lib/action_cable/channel/test_case.rb#29
  def rejected?; end

  # Make periodic timers no-op
  #
  # source://actioncable//lib/action_cable/channel/test_case.rb#46
  def start_periodic_timers; end

  # source://actioncable//lib/action_cable/channel/test_case.rb#37
  def stop_all_streams; end

  # Make periodic timers no-op
  #
  # source://actioncable//lib/action_cable/channel/test_case.rb#46
  def stop_periodic_timers; end

  # source://actioncable//lib/action_cable/channel/test_case.rb#33
  def stream_from(broadcasting, *_arg1); end

  # source://actioncable//lib/action_cable/channel/test_case.rb#41
  def streams; end
end

# source://actioncable//lib/action_cable/channel/test_case.rb#50
class ActionCable::Channel::ConnectionStub
  # @return [ConnectionStub] a new instance of ConnectionStub
  #
  # source://actioncable//lib/action_cable/channel/test_case.rb#55
  def initialize(identifiers = T.unsafe(nil)); end

  # source://actioncable//lib/action_cable/channel/test_case.rb#53
  def config(*_arg0, **_arg1, &_arg2); end

  # source://actioncable//lib/action_cable/channel/test_case.rb#72
  def connection_identifier; end

  # Returns the value of attribute identifiers.
  #
  # source://actioncable//lib/action_cable/channel/test_case.rb#51
  def identifiers; end

  # Returns the value of attribute logger.
  #
  # source://actioncable//lib/action_cable/channel/test_case.rb#51
  def logger; end

  # source://actioncable//lib/action_cable/channel/test_case.rb#53
  def pubsub(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute server.
  #
  # source://actioncable//lib/action_cable/channel/test_case.rb#51
  def server; end

  # Returns the value of attribute subscriptions.
  #
  # source://actioncable//lib/action_cable/channel/test_case.rb#51
  def subscriptions; end

  # Returns the value of attribute transmissions.
  #
  # source://actioncable//lib/action_cable/channel/test_case.rb#51
  def transmissions; end

  # source://actioncable//lib/action_cable/channel/test_case.rb#68
  def transmit(cable_message); end

  private

  # source://actioncable//lib/action_cable/channel/test_case.rb#77
  def connection_gid(ids); end
end

# source://actioncable//lib/action_cable/channel/naming.rb#7
module ActionCable::Channel::Naming
  extend ::ActiveSupport::Concern

  mixes_in_class_methods ::ActionCable::Channel::Naming::ClassMethods

  # source://actioncable//lib/action_cable/channel/naming.rb#23
  def channel_name; end
end

# source://actioncable//lib/action_cable/channel/naming.rb#10
module ActionCable::Channel::Naming::ClassMethods
  # Returns the name of the channel, underscored, without the `Channel` ending. If
  # the channel is in a namespace, then the namespaces are represented by single
  # colon separators in the channel name.
  #
  #     ChatChannel.channel_name # => 'chat'
  #     Chats::AppearancesChannel.channel_name # => 'chats:appearances'
  #     FooChats::BarAppearancesChannel.channel_name # => 'foo_chats:bar_appearances'
  #
  # source://actioncable//lib/action_cable/channel/naming.rb#18
  def channel_name; end
end

# source://actioncable//lib/action_cable/channel/test_case.rb#12
class ActionCable::Channel::NonInferrableChannelError < ::StandardError
  # @return [NonInferrableChannelError] a new instance of NonInferrableChannelError
  #
  # source://actioncable//lib/action_cable/channel/test_case.rb#13
  def initialize(name); end
end

# source://actioncable//lib/action_cable/channel/periodic_timers.rb#7
module ActionCable::Channel::PeriodicTimers
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActionCable::Channel::PeriodicTimers::ClassMethods

  private

  # source://actioncable//lib/action_cable/channel/periodic_timers.rb#56
  def active_periodic_timers; end

  # source://actioncable//lib/action_cable/channel/periodic_timers.rb#66
  def start_periodic_timer(callback, every:); end

  # source://actioncable//lib/action_cable/channel/periodic_timers.rb#60
  def start_periodic_timers; end

  # source://actioncable//lib/action_cable/channel/periodic_timers.rb#72
  def stop_periodic_timers; end

  module GeneratedClassMethods
    def periodic_timers; end
    def periodic_timers=(value); end
    def periodic_timers?; end
  end

  module GeneratedInstanceMethods
    def periodic_timers=(value); end
  end
end

# source://actioncable//lib/action_cable/channel/periodic_timers.rb#17
module ActionCable::Channel::PeriodicTimers::ClassMethods
  # Periodically performs a task on the channel, like updating an online user
  # counter, polling a backend for new status messages, sending regular
  # "heartbeat" messages, or doing some internal work and giving progress updates.
  #
  # Pass a method name or lambda argument or provide a block to call. Specify the
  # calling period in seconds using the `every:` keyword argument.
  #
  #     periodically :transmit_progress, every: 5.seconds
  #
  #     periodically every: 3.minutes do
  #       transmit action: :update_count, count: current_count
  #     end
  #
  # source://actioncable//lib/action_cable/channel/periodic_timers.rb#31
  def periodically(callback_or_method_name = T.unsafe(nil), every:, &block); end
end

# # Action Cable Channel Streams
#
# Streams allow channels to route broadcastings to the subscriber. A
# broadcasting is, as discussed elsewhere, a pubsub queue where any data placed
# into it is automatically sent to the clients that are connected at that time.
# It's purely an online queue, though. If you're not streaming a broadcasting at
# the very moment it sends out an update, you will not get that update, even if
# you connect after it has been sent.
#
# Most commonly, the streamed broadcast is sent straight to the subscriber on
# the client-side. The channel just acts as a connector between the two parties
# (the broadcaster and the channel subscriber). Here's an example of a channel
# that allows subscribers to get all new comments on a given page:
#
#     class CommentsChannel < ApplicationCable::Channel
#       def follow(data)
#         stream_from "comments_for_#{data['recording_id']}"
#       end
#
#       def unfollow
#         stop_all_streams
#       end
#     end
#
# Based on the above example, the subscribers of this channel will get whatever
# data is put into the, let's say, `comments_for_45` broadcasting as soon as
# it's put there.
#
# An example broadcasting for this channel looks like so:
#
#     ActionCable.server.broadcast "comments_for_45", { author: 'DHH', content: 'Rails is just swell' }
#
# If you have a stream that is related to a model, then the broadcasting used
# can be generated from the model and channel. The following example would
# subscribe to a broadcasting like `comments:Z2lkOi8vVGVzdEFwcC9Qb3N0LzE`.
#
#     class CommentsChannel < ApplicationCable::Channel
#       def subscribed
#         post = Post.find(params[:id])
#         stream_for post
#       end
#     end
#
# You can then broadcast to this channel using:
#
#     CommentsChannel.broadcast_to(@post, @comment)
#
# If you don't just want to parlay the broadcast unfiltered to the subscriber,
# you can also supply a callback that lets you alter what is sent out. The below
# example shows how you can use this to provide performance introspection in the
# process:
#
#     class ChatChannel < ApplicationCable::Channel
#       def subscribed
#         @room = Chat::Room[params[:room_number]]
#
#         stream_for @room, coder: ActiveSupport::JSON do |message|
#           if message['originated_at'].present?
#             elapsed_time = (Time.now.to_f - message['originated_at']).round(2)
#
#             ActiveSupport::Notifications.instrument :performance, measurement: 'Chat.message_delay', value: elapsed_time, action: :timing
#             logger.info "Message took #{elapsed_time}s to arrive"
#           end
#
#           transmit message
#         end
#       end
#     end
#
# You can stop streaming from all broadcasts by calling #stop_all_streams.
#
# source://actioncable//lib/action_cable/channel/streams.rb#77
module ActionCable::Channel::Streams
  extend ::ActiveSupport::Concern

  # source://actioncable//lib/action_cable/channel/streams.rb#153
  def pubsub(*_arg0, **_arg1, &_arg2); end

  # Unsubscribes all streams associated with this channel from the pubsub queue.
  #
  # source://actioncable//lib/action_cable/channel/streams.rb#135
  def stop_all_streams; end

  # Unsubscribes streams for the `model`.
  #
  # source://actioncable//lib/action_cable/channel/streams.rb#130
  def stop_stream_for(model); end

  # Unsubscribes streams from the named `broadcasting`.
  #
  # source://actioncable//lib/action_cable/channel/streams.rb#121
  def stop_stream_from(broadcasting); end

  # Start streaming the pubsub queue for the `model` in this channel. Optionally,
  # you can pass a `callback` that'll be used instead of the default of just
  # transmitting the updates straight to the subscriber.
  #
  # Pass `coder: ActiveSupport::JSON` to decode messages as JSON before passing to
  # the callback. Defaults to `coder: nil` which does no decoding, passes raw
  # messages.
  #
  # source://actioncable//lib/action_cable/channel/streams.rb#116
  def stream_for(model, callback = T.unsafe(nil), coder: T.unsafe(nil), &block); end

  # Start streaming from the named `broadcasting` pubsub queue. Optionally, you
  # can pass a `callback` that'll be used instead of the default of just
  # transmitting the updates straight to the subscriber. Pass `coder:
  # ActiveSupport::JSON` to decode messages as JSON before passing to the
  # callback. Defaults to `coder: nil` which does no decoding, passes raw
  # messages.
  #
  # source://actioncable//lib/action_cable/channel/streams.rb#90
  def stream_from(broadcasting, callback = T.unsafe(nil), coder: T.unsafe(nil), &block); end

  # Calls stream_for with the given `model` if it's present to start streaming,
  # otherwise rejects the subscription.
  #
  # source://actioncable//lib/action_cable/channel/streams.rb#144
  def stream_or_reject_for(model); end

  private

  # May be overridden to change the default stream handling behavior which decodes
  # JSON and transmits to the client.
  #
  # TODO: Tests demonstrating this.
  #
  # TODO: Room for optimization. Update transmit API to be coder-aware so we can
  # no-op when pubsub and connection are both JSON-encoded. Then we can skip
  # decode+encode if we're just proxying messages.
  #
  # source://actioncable//lib/action_cable/channel/streams.rb#189
  def default_stream_handler(broadcasting, coder:); end

  # source://actioncable//lib/action_cable/channel/streams.rb#210
  def identity_handler; end

  # source://actioncable//lib/action_cable/channel/streams.rb#194
  def stream_decoder(handler = T.unsafe(nil), coder:); end

  # May be overridden to add instrumentation, logging, specialized error handling,
  # or other forms of handler decoration.
  #
  # TODO: Tests demonstrating this.
  #
  # source://actioncable//lib/action_cable/channel/streams.rb#173
  def stream_handler(broadcasting, user_handler, coder: T.unsafe(nil)); end

  # source://actioncable//lib/action_cable/channel/streams.rb#202
  def stream_transmitter(handler = T.unsafe(nil), broadcasting:); end

  # source://actioncable//lib/action_cable/channel/streams.rb#155
  def streams; end

  # Always wrap the outermost handler to invoke the user handler on the worker
  # pool rather than blocking the event loop.
  #
  # source://actioncable//lib/action_cable/channel/streams.rb#161
  def worker_pool_stream_handler(broadcasting, user_handler, coder: T.unsafe(nil)); end
end

# Superclass for Action Cable channel functional tests.
#
# ## Basic example
#
# Functional tests are written as follows:
# 1.  First, one uses the `subscribe` method to simulate subscription creation.
# 2.  Then, one asserts whether the current state is as expected. "State" can be
#     anything: transmitted messages, subscribed streams, etc.
#
#
# For example:
#
#     class ChatChannelTest < ActionCable::Channel::TestCase
#       def test_subscribed_with_room_number
#         # Simulate a subscription creation
#         subscribe room_number: 1
#
#         # Asserts that the subscription was successfully created
#         assert subscription.confirmed?
#
#         # Asserts that the channel subscribes connection to a stream
#         assert_has_stream "chat_1"
#
#         # Asserts that the channel subscribes connection to a specific
#         # stream created for a model
#         assert_has_stream_for Room.find(1)
#       end
#
#       def test_does_not_stream_with_incorrect_room_number
#         subscribe room_number: -1
#
#         # Asserts that not streams was started
#         assert_no_streams
#       end
#
#       def test_does_not_subscribe_without_room_number
#         subscribe
#
#         # Asserts that the subscription was rejected
#         assert subscription.rejected?
#       end
#     end
#
# You can also perform actions:
#     def test_perform_speak
#       subscribe room_number: 1
#
#       perform :speak, message: "Hello, Rails!"
#
#       assert_equal "Hello, Rails!", transmissions.last["text"]
#     end
#
# ## Special methods
#
# ActionCable::Channel::TestCase will also automatically provide the following
# instance methods for use in the tests:
#
# connection
# :   An ActionCable::Channel::ConnectionStub, representing the current HTTP
#     connection.
#
# subscription
# :   An instance of the current channel, created when you call `subscribe`.
#
# transmissions
# :   A list of all messages that have been transmitted into the channel.
#
#
# ## Channel is automatically inferred
#
# ActionCable::Channel::TestCase will automatically infer the channel under test
# from the test class name. If the channel cannot be inferred from the test
# class name, you can explicitly set it with `tests`.
#
#     class SpecialEdgeCaseChannelTest < ActionCable::Channel::TestCase
#       tests SpecialChannel
#     end
#
# ## Specifying connection identifiers
#
# You need to set up your connection manually to provide values for the
# identifiers. To do this just use:
#
#     stub_connection(user: users(:john))
#
# ## Testing broadcasting
#
# ActionCable::Channel::TestCase enhances ActionCable::TestHelper assertions
# (e.g. `assert_broadcasts`) to handle broadcasting to models:
#
#     # in your channel
#     def speak(data)
#       broadcast_to room, text: data["message"]
#     end
#
#     def test_speak
#       subscribe room_id: rooms(:chat).id
#
#       assert_broadcast_on(rooms(:chat), text: "Hello, Rails!") do
#         perform :speak, message: "Hello, Rails!"
#       end
#     end
#
# source://actioncable//lib/action_cable/channel/test_case.rb#190
class ActionCable::Channel::TestCase < ::ActiveSupport::TestCase
  include ::ActiveSupport::Testing::ConstantLookup
  include ::ActionCable::TestHelper
  include ::ActionCable::Channel::TestCase::Behavior
  extend ::ActiveSupport::Testing::ConstantLookup::ClassMethods
  extend ::ActionCable::Channel::TestCase::Behavior::ClassMethods

  # source://actioncable//lib/action_cable/channel/test_case.rb#200
  def _channel_class; end

  # source://actioncable//lib/action_cable/channel/test_case.rb#200
  def _channel_class=(_arg0); end

  # source://actioncable//lib/action_cable/channel/test_case.rb#200
  def _channel_class?; end

  # source://actioncable//lib/action_cable/channel/test_case.rb#202
  def connection; end

  # source://actioncable//lib/action_cable/channel/test_case.rb#202
  def subscription; end

  class << self
    # source://actioncable//lib/action_cable/channel/test_case.rb#200
    def _channel_class; end

    # source://actioncable//lib/action_cable/channel/test_case.rb#200
    def _channel_class=(value); end

    # source://actioncable//lib/action_cable/channel/test_case.rb#200
    def _channel_class?; end
  end
end

# source://actioncable//lib/action_cable/channel/test_case.rb#191
module ActionCable::Channel::TestCase::Behavior
  include ::ActionCable::TestHelper
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActiveSupport::Testing::ConstantLookup

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveSupport::Testing::ConstantLookup::ClassMethods
  mixes_in_class_methods ::ActionCable::Channel::TestCase::Behavior::ClassMethods

  # source://actioncable//lib/action_cable/channel/test_case.rb#282
  def assert_broadcast_on(stream_or_object, *args); end

  # Enhance TestHelper assertions to handle non-String broadcastings
  #
  # source://actioncable//lib/action_cable/channel/test_case.rb#278
  def assert_broadcasts(stream_or_object, *args); end

  # Asserts that the specified stream has not been started.
  #
  #     def test_assert_no_started_stream
  #       subscribe
  #       assert_has_no_stream 'messages'
  #     end
  #
  # source://actioncable//lib/action_cable/channel/test_case.rb#326
  def assert_has_no_stream(stream); end

  # Asserts that the specified stream for a model has not started.
  #
  #     def test_assert_no_started_stream_for
  #       subscribe id: 41
  #       assert_has_no_stream_for User.find(42)
  #     end
  #
  # source://actioncable//lib/action_cable/channel/test_case.rb#337
  def assert_has_no_stream_for(object); end

  # Asserts that the specified stream has been started.
  #
  #     def test_assert_started_stream
  #       subscribe
  #       assert_has_stream 'messages'
  #     end
  #
  # source://actioncable//lib/action_cable/channel/test_case.rb#304
  def assert_has_stream(stream); end

  # Asserts that the specified stream for a model has started.
  #
  #     def test_assert_started_stream_for
  #       subscribe id: 42
  #       assert_has_stream_for User.find(42)
  #     end
  #
  # source://actioncable//lib/action_cable/channel/test_case.rb#315
  def assert_has_stream_for(object); end

  # Asserts that no streams have been started.
  #
  #     def test_assert_no_started_stream
  #       subscribe
  #       assert_no_streams
  #     end
  #
  # source://actioncable//lib/action_cable/channel/test_case.rb#293
  def assert_no_streams; end

  # Perform action on a channel.
  #
  # NOTE: Must be subscribed.
  #
  # source://actioncable//lib/action_cable/channel/test_case.rb#266
  def perform(action, data = T.unsafe(nil)); end

  # Set up test connection with the specified identifiers:
  #
  #     class ApplicationCable < ActionCable::Connection::Base
  #       identified_by :user, :token
  #     end
  #
  #     stub_connection(user: users[:john], token: 'my-secret-token')
  #
  # source://actioncable//lib/action_cable/channel/test_case.rb#243
  def stub_connection(identifiers = T.unsafe(nil)); end

  # Subscribe to the channel under test. Optionally pass subscription parameters
  # as a Hash.
  #
  # source://actioncable//lib/action_cable/channel/test_case.rb#249
  def subscribe(params = T.unsafe(nil)); end

  # Returns messages transmitted into channel
  #
  # source://actioncable//lib/action_cable/channel/test_case.rb#272
  def transmissions; end

  # Unsubscribe the subscription under test.
  #
  # source://actioncable//lib/action_cable/channel/test_case.rb#258
  def unsubscribe; end

  private

  # source://actioncable//lib/action_cable/channel/test_case.rb#346
  def broadcasting_for(stream_or_object); end

  # source://actioncable//lib/action_cable/channel/test_case.rb#342
  def check_subscribed!; end

  module GeneratedClassMethods
    def _channel_class; end
    def _channel_class=(value); end
    def _channel_class?; end
  end

  module GeneratedInstanceMethods
    def _channel_class; end
    def _channel_class=(value); end
    def _channel_class?; end
  end
end

# source://actioncable//lib/action_cable/channel/test_case.rb#197
ActionCable::Channel::TestCase::Behavior::CHANNEL_IDENTIFIER = T.let(T.unsafe(nil), String)

# source://actioncable//lib/action_cable/channel/test_case.rb#207
module ActionCable::Channel::TestCase::Behavior::ClassMethods
  # source://actioncable//lib/action_cable/channel/test_case.rb#219
  def channel_class; end

  # @raise [NonInferrableChannelError]
  #
  # source://actioncable//lib/action_cable/channel/test_case.rb#227
  def determine_default_channel(name); end

  # source://actioncable//lib/action_cable/channel/test_case.rb#208
  def tests(channel); end
end

# source://actioncable//lib/action_cable/connection/identification.rb#8
module ActionCable::Connection; end

# source://actioncable//lib/action_cable/connection/test_case.rb#22
module ActionCable::Connection::Assertions
  # Asserts that the connection is rejected (via
  # `reject_unauthorized_connection`).
  #
  #     # Asserts that connection without user_id fails
  #     assert_reject_connection { connect params: { user_id: '' } }
  #
  # source://actioncable//lib/action_cable/connection/test_case.rb#28
  def assert_reject_connection(&block); end
end

# source://actioncable//lib/action_cable/connection/authorization.rb#7
module ActionCable::Connection::Authorization
  # Closes the WebSocket connection if it is open and returns an "unauthorized"
  # reason.
  #
  # @raise [UnauthorizedError]
  #
  # source://actioncable//lib/action_cable/connection/authorization.rb#12
  def reject_unauthorized_connection; end
end

# source://actioncable//lib/action_cable/connection/authorization.rb#8
class ActionCable::Connection::Authorization::UnauthorizedError < ::StandardError; end

# # Action Cable Connection Base
#
# For every WebSocket connection the Action Cable server accepts, a Connection
# object will be instantiated. This instance becomes the parent of all of the
# channel subscriptions that are created from there on. Incoming messages are
# then routed to these channel subscriptions based on an identifier sent by the
# Action Cable consumer. The Connection itself does not deal with any specific
# application logic beyond authentication and authorization.
#
# Here's a basic example:
#
#     module ApplicationCable
#       class Connection < ActionCable::Connection::Base
#         identified_by :current_user
#
#         def connect
#           self.current_user = find_verified_user
#           logger.add_tags current_user.name
#         end
#
#         def disconnect
#           # Any cleanup work needed when the cable connection is cut.
#         end
#
#         private
#           def find_verified_user
#             User.find_by_identity(cookies.encrypted[:identity_id]) ||
#               reject_unauthorized_connection
#           end
#       end
#     end
#
# First, we declare that this connection can be identified by its current_user.
# This allows us to later be able to find all connections established for that
# current_user (and potentially disconnect them). You can declare as many
# identification indexes as you like. Declaring an identification means that an
# attr_accessor is automatically set for that key.
#
# Second, we rely on the fact that the WebSocket connection is established with
# the cookies from the domain being sent along. This makes it easy to use signed
# cookies that were set when logging in via a web interface to authorize the
# WebSocket connection.
#
# Finally, we add a tag to the connection-specific logger with the name of the
# current user to easily distinguish their messages in the log.
#
# Pretty simple, eh?
#
# source://actioncable//lib/action_cable/connection/base.rb#57
class ActionCable::Connection::Base
  include ::ActionCable::Connection::Identification
  include ::ActionCable::Connection::InternalChannel
  include ::ActionCable::Connection::Authorization
  include ::ActiveSupport::Callbacks
  include ::ActionCable::Connection::Callbacks
  include ::ActiveSupport::Rescuable
  extend ::ActionCable::Connection::Identification::ClassMethods
  extend ::ActiveSupport::Callbacks::ClassMethods
  extend ::ActiveSupport::DescendantsTracker
  extend ::ActionCable::Connection::Callbacks::ClassMethods
  extend ::ActiveSupport::Rescuable::ClassMethods

  # @return [Base] a new instance of Base
  #
  # source://actioncable//lib/action_cable/connection/base.rb#67
  def initialize(server, env, coder: T.unsafe(nil)); end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
  def __callbacks; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
  def __callbacks?; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#924
  def _command_callbacks; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#912
  def _run_command_callbacks(&block); end

  # source://actioncable//lib/action_cable/connection/base.rb#147
  def beat; end

  # Close the WebSocket connection.
  #
  # source://actioncable//lib/action_cable/connection/base.rb#120
  def close(reason: T.unsafe(nil), reconnect: T.unsafe(nil)); end

  # source://actioncable//lib/action_cable/connection/base.rb#65
  def config(*_arg0, **_arg1, &_arg2); end

  # source://actioncable//lib/action_cable/connection/base.rb#101
  def dispatch_websocket_message(websocket_message); end

  # Returns the value of attribute env.
  #
  # source://actioncable//lib/action_cable/connection/base.rb#64
  def env; end

  # source://actioncable//lib/action_cable/connection/base.rb#65
  def event_loop(*_arg0, **_arg1, &_arg2); end

  # source://actioncable//lib/action_cable/connection/base.rb#109
  def handle_channel_command(payload); end

  # source://actioncable//lib/action_cable/connection/identification.rb#13
  def identifiers; end

  # source://actioncable//lib/action_cable/connection/identification.rb#13
  def identifiers=(_arg0); end

  # source://actioncable//lib/action_cable/connection/identification.rb#13
  def identifiers?; end

  # source://actioncable//lib/action_cable/connection/base.rb#168
  def inspect; end

  # Returns the value of attribute logger.
  #
  # source://actioncable//lib/action_cable/connection/base.rb#64
  def logger; end

  # source://actioncable//lib/action_cable/connection/base.rb#164
  def on_close(reason, code); end

  # source://actioncable//lib/action_cable/connection/base.rb#159
  def on_error(message); end

  # source://actioncable//lib/action_cable/connection/base.rb#155
  def on_message(message); end

  # source://actioncable//lib/action_cable/connection/base.rb#151
  def on_open; end

  # Called by the server when a new WebSocket connection is established. This
  # configures the callbacks intended for overwriting by the user. This method
  # should not be called directly -- instead rely upon on the #connect (and
  # #disconnect) callbacks.
  #
  # source://actioncable//lib/action_cable/connection/base.rb#85
  def process; end

  # Returns the value of attribute protocol.
  #
  # source://actioncable//lib/action_cable/connection/base.rb#64
  def protocol; end

  # source://actioncable//lib/action_cable/connection/base.rb#65
  def pubsub(*_arg0, **_arg1, &_arg2); end

  # Decodes WebSocket messages and dispatches them to subscribed channels.
  # WebSocket message transfer encoding is always JSON.
  #
  # source://actioncable//lib/action_cable/connection/base.rb#97
  def receive(websocket_message); end

  # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
  def rescue_handlers; end

  # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
  def rescue_handlers=(_arg0); end

  # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
  def rescue_handlers?; end

  # Invoke a method on the connection asynchronously through the pool of thread
  # workers.
  #
  # source://actioncable//lib/action_cable/connection/base.rb#131
  def send_async(method, *arguments); end

  # Returns the value of attribute server.
  #
  # source://actioncable//lib/action_cable/connection/base.rb#64
  def server; end

  # Return a basic hash of statistics for the connection keyed with `identifier`,
  # `started_at`, `subscriptions`, and `request_id`. This can be returned by a
  # health check against the connection.
  #
  # source://actioncable//lib/action_cable/connection/base.rb#138
  def statistics; end

  # Returns the value of attribute subscriptions.
  #
  # source://actioncable//lib/action_cable/connection/base.rb#64
  def subscriptions; end

  # source://actioncable//lib/action_cable/connection/base.rb#115
  def transmit(cable_message); end

  # Returns the value of attribute worker_pool.
  #
  # source://actioncable//lib/action_cable/connection/base.rb#64
  def worker_pool; end

  private

  # @return [Boolean]
  #
  # source://actioncable//lib/action_cable/connection/base.rb#228
  def allow_request_origin?; end

  # The cookies of the request that initiated the WebSocket connection. Useful for
  # performing authorization checks.
  #
  # source://actioncable//lib/action_cable/connection/base.rb#187
  def cookies; end

  # source://actioncable//lib/action_cable/connection/base.rb#195
  def decode(websocket_message); end

  # source://actioncable//lib/action_cable/connection/base.rb#191
  def encode(cable_message); end

  # source://actioncable//lib/action_cable/connection/base.rb#271
  def finished_request_message; end

  # source://actioncable//lib/action_cable/connection/base.rb#211
  def handle_close; end

  # source://actioncable//lib/action_cable/connection/base.rb#199
  def handle_open; end

  # source://actioncable//lib/action_cable/connection/base.rb#279
  def invalid_request_message; end

  # Returns the value of attribute message_buffer.
  #
  # source://actioncable//lib/action_cable/connection/base.rb#174
  def message_buffer; end

  # Tags are declared in the server but computed in the connection. This allows us
  # per-connection tailored tags.
  #
  # source://actioncable//lib/action_cable/connection/base.rb#257
  def new_tagged_logger; end

  # The request that initiated the WebSocket connection is available here. This
  # gives access to the environment, cookies, etc.
  #
  # source://actioncable//lib/action_cable/connection/base.rb#178
  def request; end

  # source://actioncable//lib/action_cable/connection/base.rb#247
  def respond_to_invalid_request; end

  # source://actioncable//lib/action_cable/connection/base.rb#242
  def respond_to_successful_request; end

  # source://actioncable//lib/action_cable/connection/base.rb#222
  def send_welcome_message; end

  # source://actioncable//lib/action_cable/connection/base.rb#262
  def started_request_message; end

  # source://actioncable//lib/action_cable/connection/base.rb#285
  def successful_request_message; end

  # Returns the value of attribute websocket.
  #
  # source://actioncable//lib/action_cable/connection/base.rb#173
  def websocket; end

  class << self
    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks=(value); end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks?; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#916
    def _command_callbacks; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#920
    def _command_callbacks=(value); end

    # source://actioncable//lib/action_cable/connection/identification.rb#13
    def identifiers; end

    # source://actioncable//lib/action_cable/connection/identification.rb#13
    def identifiers=(value); end

    # source://actioncable//lib/action_cable/connection/identification.rb#13
    def identifiers?; end

    # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
    def rescue_handlers; end

    # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
    def rescue_handlers=(value); end

    # source://activesupport/7.2.1/lib/active_support/rescuable.rb#15
    def rescue_handlers?; end
  end
end

# # Action Cable Connection Callbacks
#
# The [before_command](rdoc-ref:ClassMethods#before_command),
# [after_command](rdoc-ref:ClassMethods#after_command), and
# [around_command](rdoc-ref:ClassMethods#around_command) callbacks are invoked
# when sending commands to the client, such as when subscribing, unsubscribing,
# or performing an action.
#
# #### Example
#
#     module ApplicationCable
#       class Connection < ActionCable::Connection::Base
#         identified_by :user
#
#         around_command :set_current_account
#
#         private
#
#         def set_current_account
#           # Now all channels could use Current.account
#           Current.set(account: user.account) { yield }
#         end
#       end
#     end
#
# source://actioncable//lib/action_cable/connection/callbacks.rb#34
module ActionCable::Connection::Callbacks
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActiveSupport::Callbacks

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveSupport::Callbacks::ClassMethods
  mixes_in_class_methods ::ActiveSupport::DescendantsTracker
  mixes_in_class_methods ::ActionCable::Connection::Callbacks::ClassMethods

  module GeneratedClassMethods
    def __callbacks; end
    def __callbacks=(value); end
    def __callbacks?; end
  end

  module GeneratedInstanceMethods
    def __callbacks; end
    def __callbacks?; end
  end
end

# source://actioncable//lib/action_cable/connection/callbacks.rb#42
module ActionCable::Connection::Callbacks::ClassMethods
  # source://actioncable//lib/action_cable/connection/callbacks.rb#47
  def after_command(*methods, &block); end

  # source://actioncable//lib/action_cable/connection/callbacks.rb#51
  def around_command(*methods, &block); end

  # source://actioncable//lib/action_cable/connection/callbacks.rb#43
  def before_command(*methods, &block); end
end

# source://actioncable//lib/action_cable/connection/client_socket.rb#13
class ActionCable::Connection::ClientSocket
  # @return [ClientSocket] a new instance of ClientSocket
  #
  # source://actioncable//lib/action_cable/connection/client_socket.rb#36
  def initialize(env, event_target, event_loop, protocols); end

  # @return [Boolean]
  #
  # source://actioncable//lib/action_cable/connection/client_socket.rb#114
  def alive?; end

  # source://actioncable//lib/action_cable/connection/client_socket.rb#110
  def client_gone; end

  # source://actioncable//lib/action_cable/connection/client_socket.rb#92
  def close(code = T.unsafe(nil), reason = T.unsafe(nil)); end

  # Returns the value of attribute env.
  #
  # source://actioncable//lib/action_cable/connection/client_socket.rb#34
  def env; end

  # source://actioncable//lib/action_cable/connection/client_socket.rb#106
  def parse(data); end

  # source://actioncable//lib/action_cable/connection/client_socket.rb#118
  def protocol; end

  # source://actioncable//lib/action_cable/connection/client_socket.rb#71
  def rack_response; end

  # source://actioncable//lib/action_cable/connection/client_socket.rb#59
  def start_driver; end

  # source://actioncable//lib/action_cable/connection/client_socket.rb#82
  def transmit(message); end

  # Returns the value of attribute url.
  #
  # source://actioncable//lib/action_cable/connection/client_socket.rb#34
  def url; end

  # source://actioncable//lib/action_cable/connection/client_socket.rb#76
  def write(data); end

  private

  # source://actioncable//lib/action_cable/connection/client_socket.rb#142
  def begin_close(reason, code); end

  # source://actioncable//lib/action_cable/connection/client_socket.rb#136
  def emit_error(message); end

  # source://actioncable//lib/action_cable/connection/client_socket.rb#151
  def finalize_close; end

  # source://actioncable//lib/action_cable/connection/client_socket.rb#123
  def open; end

  # source://actioncable//lib/action_cable/connection/client_socket.rb#130
  def receive_message(data); end

  class << self
    # source://actioncable//lib/action_cable/connection/client_socket.rb#14
    def determine_url(env); end

    # @return [Boolean]
    #
    # source://actioncable//lib/action_cable/connection/client_socket.rb#19
    def secure_request?(env); end
  end
end

# source://actioncable//lib/action_cable/connection/client_socket.rb#32
ActionCable::Connection::ClientSocket::CLOSED = T.let(T.unsafe(nil), Integer)

# source://actioncable//lib/action_cable/connection/client_socket.rb#31
ActionCable::Connection::ClientSocket::CLOSING = T.let(T.unsafe(nil), Integer)

# source://actioncable//lib/action_cable/connection/client_socket.rb#29
ActionCable::Connection::ClientSocket::CONNECTING = T.let(T.unsafe(nil), Integer)

# source://actioncable//lib/action_cable/connection/client_socket.rb#30
ActionCable::Connection::ClientSocket::OPEN = T.let(T.unsafe(nil), Integer)

# source://actioncable//lib/action_cable/connection/identification.rb#9
module ActionCable::Connection::Identification
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActionCable::Connection::Identification::ClassMethods

  # Return a single connection identifier that combines the value of all the
  # registered identifiers into a single gid.
  #
  # source://actioncable//lib/action_cable/connection/identification.rb#31
  def connection_identifier; end

  private

  # source://actioncable//lib/action_cable/connection/identification.rb#40
  def connection_gid(ids); end

  module GeneratedClassMethods
    def identifiers; end
    def identifiers=(value); end
    def identifiers?; end
  end

  module GeneratedInstanceMethods
    def identifiers; end
    def identifiers=(value); end
    def identifiers?; end
  end
end

# source://actioncable//lib/action_cable/connection/identification.rb#16
module ActionCable::Connection::Identification::ClassMethods
  # Mark a key as being a connection identifier index that can then be used to
  # find the specific connection again later. Common identifiers are current_user
  # and current_account, but could be anything, really.
  #
  # Note that anything marked as an identifier will automatically create a
  # delegate by the same name on any channel instances created off the connection.
  #
  # source://actioncable//lib/action_cable/connection/identification.rb#23
  def identified_by(*identifiers); end
end

# # Action Cable InternalChannel
#
# Makes it possible for the RemoteConnection to disconnect a specific
# connection.
#
# source://actioncable//lib/action_cable/connection/internal_channel.rb#11
module ActionCable::Connection::InternalChannel
  extend ::ActiveSupport::Concern

  private

  # source://actioncable//lib/action_cable/connection/internal_channel.rb#15
  def internal_channel; end

  # source://actioncable//lib/action_cable/connection/internal_channel.rb#36
  def process_internal_message(message); end

  # source://actioncable//lib/action_cable/connection/internal_channel.rb#19
  def subscribe_to_internal_channel; end

  # source://actioncable//lib/action_cable/connection/internal_channel.rb#30
  def unsubscribe_from_internal_channel; end
end

# Allows us to buffer messages received from the WebSocket before the Connection
# has been fully initialized, and is ready to receive them.
#
# source://actioncable//lib/action_cable/connection/message_buffer.rb#9
class ActionCable::Connection::MessageBuffer
  # @return [MessageBuffer] a new instance of MessageBuffer
  #
  # source://actioncable//lib/action_cable/connection/message_buffer.rb#10
  def initialize(connection); end

  # source://actioncable//lib/action_cable/connection/message_buffer.rb#15
  def append(message); end

  # source://actioncable//lib/action_cable/connection/message_buffer.rb#31
  def process!; end

  # @return [Boolean]
  #
  # source://actioncable//lib/action_cable/connection/message_buffer.rb#27
  def processing?; end

  private

  # source://actioncable//lib/action_cable/connection/message_buffer.rb#48
  def buffer(message); end

  # Returns the value of attribute buffered_messages.
  #
  # source://actioncable//lib/action_cable/connection/message_buffer.rb#38
  def buffered_messages; end

  # Returns the value of attribute connection.
  #
  # source://actioncable//lib/action_cable/connection/message_buffer.rb#37
  def connection; end

  # source://actioncable//lib/action_cable/connection/message_buffer.rb#44
  def receive(message); end

  # source://actioncable//lib/action_cable/connection/message_buffer.rb#52
  def receive_buffered_messages; end

  # @return [Boolean]
  #
  # source://actioncable//lib/action_cable/connection/message_buffer.rb#40
  def valid?(message); end
end

# source://actioncable//lib/action_cable/connection/test_case.rb#14
class ActionCable::Connection::NonInferrableConnectionError < ::StandardError
  # @return [NonInferrableConnectionError] a new instance of NonInferrableConnectionError
  #
  # source://actioncable//lib/action_cable/connection/test_case.rb#15
  def initialize(name); end
end

# source://actioncable//lib/action_cable/connection/stream.rb#11
class ActionCable::Connection::Stream
  # @return [Stream] a new instance of Stream
  #
  # source://actioncable//lib/action_cable/connection/stream.rb#12
  def initialize(event_loop, socket); end

  # source://actioncable//lib/action_cable/connection/stream.rb#28
  def close; end

  # source://actioncable//lib/action_cable/connection/stream.rb#24
  def each(&callback); end

  # source://actioncable//lib/action_cable/connection/stream.rb#72
  def flush_write_buffer; end

  # source://actioncable//lib/action_cable/connection/stream.rb#98
  def hijack_rack_socket; end

  # source://actioncable//lib/action_cable/connection/stream.rb#94
  def receive(data); end

  # source://actioncable//lib/action_cable/connection/stream.rb#33
  def shutdown; end

  # source://actioncable//lib/action_cable/connection/stream.rb#37
  def write(data); end

  private

  # source://actioncable//lib/action_cable/connection/stream.rb#110
  def clean_rack_hijack; end
end

# source://actioncable//lib/action_cable/connection/stream_event_loop.rb#9
class ActionCable::Connection::StreamEventLoop
  # @return [StreamEventLoop] a new instance of StreamEventLoop
  #
  # source://actioncable//lib/action_cable/connection/stream_event_loop.rb#10
  def initialize; end

  # source://actioncable//lib/action_cable/connection/stream_event_loop.rb#30
  def attach(io, stream); end

  # source://actioncable//lib/action_cable/connection/stream_event_loop.rb#38
  def detach(io, stream); end

  # source://actioncable//lib/action_cable/connection/stream_event_loop.rb#23
  def post(task = T.unsafe(nil), &block); end

  # source://actioncable//lib/action_cable/connection/stream_event_loop.rb#56
  def stop; end

  # source://actioncable//lib/action_cable/connection/stream_event_loop.rb#19
  def timer(interval, &block); end

  # source://actioncable//lib/action_cable/connection/stream_event_loop.rb#47
  def writes_pending(io); end

  private

  # source://actioncable//lib/action_cable/connection/stream_event_loop.rb#86
  def run; end

  # source://actioncable//lib/action_cable/connection/stream_event_loop.rb#62
  def spawn; end

  # source://actioncable//lib/action_cable/connection/stream_event_loop.rb#82
  def wakeup; end
end

# # Action Cable Connection Subscriptions
#
# Collection class for all the channel subscriptions established on a given
# connection. Responsible for routing incoming commands that arrive on the
# connection to the proper channel.
#
# source://actioncable//lib/action_cable/connection/subscriptions.rb#14
class ActionCable::Connection::Subscriptions
  # @return [Subscriptions] a new instance of Subscriptions
  #
  # source://actioncable//lib/action_cable/connection/subscriptions.rb#15
  def initialize(connection); end

  # source://actioncable//lib/action_cable/connection/subscriptions.rb#33
  def add(data); end

  # source://actioncable//lib/action_cable/connection/subscriptions.rb#20
  def execute_command(data); end

  # source://actioncable//lib/action_cable/connection/subscriptions.rb#64
  def identifiers; end

  # source://actioncable//lib/action_cable/connection/subscriptions.rb#74
  def logger(*_arg0, **_arg1, &_arg2); end

  # source://actioncable//lib/action_cable/connection/subscriptions.rb#60
  def perform_action(data); end

  # source://actioncable//lib/action_cable/connection/subscriptions.rb#50
  def remove(data); end

  # source://actioncable//lib/action_cable/connection/subscriptions.rb#55
  def remove_subscription(subscription); end

  # source://actioncable//lib/action_cable/connection/subscriptions.rb#68
  def unsubscribe_from_all; end

  private

  # Returns the value of attribute connection.
  #
  # source://actioncable//lib/action_cable/connection/subscriptions.rb#73
  def connection; end

  # source://actioncable//lib/action_cable/connection/subscriptions.rb#76
  def find(data); end

  # Returns the value of attribute subscriptions.
  #
  # source://actioncable//lib/action_cable/connection/subscriptions.rb#73
  def subscriptions; end
end

# # Action Cable Connection TaggedLoggerProxy
#
# Allows the use of per-connection tags against the server logger. This wouldn't
# work using the traditional ActiveSupport::TaggedLogging enhanced Rails.logger,
# as that logger will reset the tags between requests. The connection is
# long-lived, so it needs its own set of tags for its independent duration.
#
# source://actioncable//lib/action_cable/connection/tagged_logger_proxy.rb#13
class ActionCable::Connection::TaggedLoggerProxy
  # @return [TaggedLoggerProxy] a new instance of TaggedLoggerProxy
  #
  # source://actioncable//lib/action_cable/connection/tagged_logger_proxy.rb#16
  def initialize(logger, tags:); end

  # source://actioncable//lib/action_cable/connection/tagged_logger_proxy.rb#21
  def add_tags(*tags); end

  # source://actioncable//lib/action_cable/connection/tagged_logger_proxy.rb#36
  def debug(message = T.unsafe(nil), &block); end

  # source://actioncable//lib/action_cable/connection/tagged_logger_proxy.rb#36
  def error(message = T.unsafe(nil), &block); end

  # source://actioncable//lib/action_cable/connection/tagged_logger_proxy.rb#36
  def fatal(message = T.unsafe(nil), &block); end

  # source://actioncable//lib/action_cable/connection/tagged_logger_proxy.rb#36
  def info(message = T.unsafe(nil), &block); end

  # source://actioncable//lib/action_cable/connection/tagged_logger_proxy.rb#26
  def tag(logger, &block); end

  # Returns the value of attribute tags.
  #
  # source://actioncable//lib/action_cable/connection/tagged_logger_proxy.rb#14
  def tags; end

  # source://actioncable//lib/action_cable/connection/tagged_logger_proxy.rb#36
  def unknown(message = T.unsafe(nil), &block); end

  # source://actioncable//lib/action_cable/connection/tagged_logger_proxy.rb#36
  def warn(message = T.unsafe(nil), &block); end

  private

  # source://actioncable//lib/action_cable/connection/tagged_logger_proxy.rb#42
  def log(type, message, &block); end
end

# # Action Cable Connection TestCase
#
# Unit test Action Cable connections.
#
# Useful to check whether a connection's `identified_by` gets assigned properly
# and that any improper connection requests are rejected.
#
# ## Basic example
#
# Unit tests are written as follows:
#
# 1.  Simulate a connection attempt by calling `connect`.
# 2.  Assert state, e.g. identifiers, has been assigned.
#
#
#     class ApplicationCable::ConnectionTest < ActionCable::Connection::TestCase
#       def test_connects_with_proper_cookie
#         # Simulate the connection request with a cookie.
#         cookies["user_id"] = users(:john).id
#
#         connect
#
#         # Assert the connection identifier matches the fixture.
#         assert_equal users(:john).id, connection.user.id
#       end
#
#       def test_rejects_connection_without_proper_cookie
#         assert_reject_connection { connect }
#       end
#     end
#
# `connect` accepts additional information about the HTTP request with the
# `params`, `headers`, `session`, and Rack `env` options.
#
#     def test_connect_with_headers_and_query_string
#       connect params: { user_id: 1 }, headers: { "X-API-TOKEN" => "secret-my" }
#
#       assert_equal "1", connection.user.id
#       assert_equal "secret-my", connection.token
#     end
#
#     def test_connect_with_params
#       connect params: { user_id: 1 }
#
#       assert_equal "1", connection.user.id
#     end
#
# You can also set up the correct cookies before the connection request:
#
#     def test_connect_with_cookies
#       # Plain cookies:
#       cookies["user_id"] = 1
#
#       # Or signed/encrypted:
#       # cookies.signed["user_id"] = 1
#       # cookies.encrypted["user_id"] = 1
#
#       connect
#
#       assert_equal "1", connection.user_id
#     end
#
# ## Connection is automatically inferred
#
# ActionCable::Connection::TestCase will automatically infer the connection
# under test from the test class name. If the channel cannot be inferred from
# the test class name, you can explicitly set it with `tests`.
#
#     class ConnectionTest < ActionCable::Connection::TestCase
#       tests ApplicationCable::Connection
#     end
#
# source://actioncable//lib/action_cable/connection/test_case.rb#141
class ActionCable::Connection::TestCase < ::ActiveSupport::TestCase
  include ::ActiveSupport::Testing::ConstantLookup
  include ::ActionCable::Connection::Assertions
  include ::ActionCable::Connection::TestCase::Behavior
  extend ::ActiveSupport::Testing::ConstantLookup::ClassMethods
  extend ::ActionCable::Connection::TestCase::Behavior::ClassMethods

  # source://actioncable//lib/action_cable/connection/test_case.rb#151
  def _connection_class; end

  # source://actioncable//lib/action_cable/connection/test_case.rb#151
  def _connection_class=(_arg0); end

  # source://actioncable//lib/action_cable/connection/test_case.rb#151
  def _connection_class?; end

  # source://actioncable//lib/action_cable/connection/test_case.rb#153
  def connection; end

  class << self
    # source://actioncable//lib/action_cable/connection/test_case.rb#151
    def _connection_class; end

    # source://actioncable//lib/action_cable/connection/test_case.rb#151
    def _connection_class=(value); end

    # source://actioncable//lib/action_cable/connection/test_case.rb#151
    def _connection_class?; end
  end
end

# source://actioncable//lib/action_cable/connection/test_case.rb#142
module ActionCable::Connection::TestCase::Behavior
  include ::ActionCable::Connection::Assertions
  extend ::ActiveSupport::Concern
  include GeneratedInstanceMethods
  include ::ActiveSupport::Testing::ConstantLookup

  mixes_in_class_methods GeneratedClassMethods
  mixes_in_class_methods ::ActiveSupport::Testing::ConstantLookup::ClassMethods
  mixes_in_class_methods ::ActionCable::Connection::TestCase::Behavior::ClassMethods

  # Performs connection attempt to exert #connect on the connection under test.
  #
  # Accepts request path as the first argument and the following request options:
  #
  # *   params – URL parameters (Hash)
  # *   headers – request headers (Hash)
  # *   session – session data (Hash)
  # *   env – additional Rack env configuration (Hash)
  #
  # source://actioncable//lib/action_cable/connection/test_case.rb#195
  def connect(path = T.unsafe(nil), **request_params); end

  # source://actioncable//lib/action_cable/connection/test_case.rb#215
  def cookies; end

  # Exert #disconnect on the connection under test.
  #
  # source://actioncable//lib/action_cable/connection/test_case.rb#208
  def disconnect; end

  private

  # source://actioncable//lib/action_cable/connection/test_case.rb#220
  def build_test_request(path, params: T.unsafe(nil), headers: T.unsafe(nil), session: T.unsafe(nil), env: T.unsafe(nil)); end

  module GeneratedClassMethods
    def _connection_class; end
    def _connection_class=(value); end
    def _connection_class?; end
  end

  module GeneratedInstanceMethods
    def _connection_class; end
    def _connection_class=(value); end
    def _connection_class?; end
  end
end

# source://actioncable//lib/action_cable/connection/test_case.rb#158
module ActionCable::Connection::TestCase::Behavior::ClassMethods
  # source://actioncable//lib/action_cable/connection/test_case.rb#170
  def connection_class; end

  # @raise [NonInferrableConnectionError]
  #
  # source://actioncable//lib/action_cable/connection/test_case.rb#178
  def determine_default_connection(name); end

  # source://actioncable//lib/action_cable/connection/test_case.rb#159
  def tests(connection); end
end

# source://actioncable//lib/action_cable/connection/test_case.rb#145
ActionCable::Connection::TestCase::Behavior::DEFAULT_PATH = T.let(T.unsafe(nil), String)

# source://actioncable//lib/action_cable/connection/test_case.rb#57
module ActionCable::Connection::TestConnection
  # source://actioncable//lib/action_cable/connection/test_case.rb#60
  def initialize(request); end

  # Returns the value of attribute logger.
  #
  # source://actioncable//lib/action_cable/connection/test_case.rb#58
  def logger; end

  # Returns the value of attribute request.
  #
  # source://actioncable//lib/action_cable/connection/test_case.rb#58
  def request; end
end

# We don't want to use the whole "encryption stack" for connection unit-tests,
# but we want to make sure that users test against the correct types of cookies
# (i.e. signed or encrypted or plain)
#
# source://actioncable//lib/action_cable/connection/test_case.rb#43
class ActionCable::Connection::TestCookieJar < ::ActionCable::Connection::TestCookies
  # source://actioncable//lib/action_cable/connection/test_case.rb#48
  def encrypted; end

  # source://actioncable//lib/action_cable/connection/test_case.rb#44
  def signed; end
end

# source://actioncable//lib/action_cable/connection/test_case.rb#33
class ActionCable::Connection::TestCookies < ::ActiveSupport::HashWithIndifferentAccess
  # source://actioncable//lib/action_cable/connection/test_case.rb#34
  def []=(name, options); end
end

# source://actioncable//lib/action_cable/connection/test_case.rb#53
class ActionCable::Connection::TestRequest < ::ActionDispatch::TestRequest
  # Returns the value of attribute cookie_jar.
  #
  # source://actioncable//lib/action_cable/connection/test_case.rb#54
  def cookie_jar; end

  # Sets the attribute cookie_jar
  #
  # @param value the value to set the attribute cookie_jar to.
  #
  # source://actioncable//lib/action_cable/connection/test_case.rb#54
  def cookie_jar=(_arg0); end

  # Returns the value of attribute session.
  #
  # source://actioncable//lib/action_cable/connection/test_case.rb#54
  def session; end

  # Sets the attribute session
  #
  # @param value the value to set the attribute session to.
  #
  # source://actioncable//lib/action_cable/connection/test_case.rb#54
  def session=(_arg0); end
end

# # Action Cable Connection WebSocket
#
# Wrap the real socket to minimize the externally-presented API
#
# source://actioncable//lib/action_cable/connection/web_socket.rb#12
class ActionCable::Connection::WebSocket
  # @return [WebSocket] a new instance of WebSocket
  #
  # source://actioncable//lib/action_cable/connection/web_socket.rb#13
  def initialize(env, event_target, event_loop, protocols: T.unsafe(nil)); end

  # @return [Boolean]
  #
  # source://actioncable//lib/action_cable/connection/web_socket.rb#21
  def alive?; end

  # source://actioncable//lib/action_cable/connection/web_socket.rb#29
  def close(*_arg0, **_arg1, &_arg2); end

  # @return [Boolean]
  #
  # source://actioncable//lib/action_cable/connection/web_socket.rb#17
  def possible?; end

  # source://actioncable//lib/action_cable/connection/web_socket.rb#33
  def protocol; end

  # source://actioncable//lib/action_cable/connection/web_socket.rb#37
  def rack_response; end

  # source://actioncable//lib/action_cable/connection/web_socket.rb#25
  def transmit(*_arg0, **_arg1, &_arg2); end

  private

  # Returns the value of attribute websocket.
  #
  # source://actioncable//lib/action_cable/connection/web_socket.rb#42
  def websocket; end
end

# source://actioncable//lib/action_cable/engine.rb#10
class ActionCable::Engine < ::Rails::Engine
  class << self
    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks; end
  end
end

# source://actioncable//lib/action_cable/helpers/action_cable_helper.rb#6
module ActionCable::Helpers; end

# source://actioncable//lib/action_cable/helpers/action_cable_helper.rb#7
module ActionCable::Helpers::ActionCableHelper
  # Returns an "action-cable-url" meta tag with the value of the URL specified in
  # your configuration. Ensure this is above your JavaScript tag:
  #
  #     <head>
  #       <%= action_cable_meta_tag %>
  #       <%= javascript_include_tag 'application', 'data-turbo-track' => 'reload' %>
  #     </head>
  #
  # This is then used by Action Cable to determine the URL of your WebSocket
  # server. Your JavaScript can then connect to the server without needing to
  # specify the URL directly:
  #
  #     import Cable from "@rails/actioncable"
  #     window.Cable = Cable
  #     window.App = {}
  #     App.cable = Cable.createConsumer()
  #
  # Make sure to specify the correct server location in each of your environment
  # config files:
  #
  #     config.action_cable.mount_path = "/cable123"
  #     <%= action_cable_meta_tag %> would render:
  #     => <meta name="action-cable-url" content="/cable123" />
  #
  #     config.action_cable.url = "ws://actioncable.com"
  #     <%= action_cable_meta_tag %> would render:
  #     => <meta name="action-cable-url" content="ws://actioncable.com" />
  #
  # source://actioncable//lib/action_cable/helpers/action_cable_helper.rb#36
  def action_cable_meta_tag; end
end

# source://actioncable//lib/action_cable.rb#58
ActionCable::INTERNAL = T.let(T.unsafe(nil), Hash)

# # Action Cable Remote Connections
#
# If you need to disconnect a given connection, you can go through the
# RemoteConnections. You can find the connections you're looking for by
# searching for the identifier declared on the connection. For example:
#
#     module ApplicationCable
#       class Connection < ActionCable::Connection::Base
#         identified_by :current_user
#         ....
#       end
#     end
#
#     ActionCable.server.remote_connections.where(current_user: User.find(1)).disconnect
#
# This will disconnect all the connections established for `User.find(1)`,
# across all servers running on all machines, because it uses the internal
# channel that all of these servers are subscribed to.
#
# By default, server sends a "disconnect" message with "reconnect" flag set to
# true. You can override it by specifying the `reconnect` option:
#
#     ActionCable.server.remote_connections.where(current_user: User.find(1)).disconnect(reconnect: false)
#
# source://actioncable//lib/action_cable/remote_connections.rb#31
class ActionCable::RemoteConnections
  # @return [RemoteConnections] a new instance of RemoteConnections
  #
  # source://actioncable//lib/action_cable/remote_connections.rb#34
  def initialize(server); end

  # Returns the value of attribute server.
  #
  # source://actioncable//lib/action_cable/remote_connections.rb#32
  def server; end

  # source://actioncable//lib/action_cable/remote_connections.rb#38
  def where(identifier); end
end

# # Action Cable Remote Connection
#
# Represents a single remote connection found via
# `ActionCable.server.remote_connections.where(*)`. Exists solely for the
# purpose of calling #disconnect on that connection.
#
# source://actioncable//lib/action_cable/remote_connections.rb#48
class ActionCable::RemoteConnections::RemoteConnection
  include ::ActionCable::Connection::InternalChannel
  include ::ActionCable::Connection::Identification
  extend ::ActionCable::Connection::Identification::ClassMethods

  # @return [RemoteConnection] a new instance of RemoteConnection
  #
  # source://actioncable//lib/action_cable/remote_connections.rb#53
  def initialize(server, ids); end

  # Uses the internal channel to disconnect the connection.
  #
  # source://actioncable//lib/action_cable/remote_connections.rb#59
  def disconnect(reconnect: T.unsafe(nil)); end

  # source://actioncable//lib/action_cable/remote_connections.rb#64
  def identifiers; end

  # source://actioncable//lib/action_cable/connection/identification.rb#13
  def identifiers=(_arg0); end

  # source://actioncable//lib/action_cable/connection/identification.rb#13
  def identifiers?; end

  protected

  # Returns the value of attribute server.
  #
  # source://actioncable//lib/action_cable/remote_connections.rb#69
  def server; end

  private

  # @raise [InvalidIdentifiersError]
  #
  # source://actioncable//lib/action_cable/remote_connections.rb#72
  def set_identifier_instance_vars(ids); end

  # @return [Boolean]
  #
  # source://actioncable//lib/action_cable/remote_connections.rb#77
  def valid_identifiers?(ids); end

  class << self
    # source://actioncable//lib/action_cable/connection/identification.rb#13
    def identifiers; end

    # source://actioncable//lib/action_cable/connection/identification.rb#13
    def identifiers=(value); end

    # source://actioncable//lib/action_cable/connection/identification.rb#13
    def identifiers?; end
  end
end

# source://actioncable//lib/action_cable/remote_connections.rb#49
class ActionCable::RemoteConnections::RemoteConnection::InvalidIdentifiersError < ::StandardError; end

# source://actioncable//lib/action_cable/server/base.rb#8
module ActionCable::Server; end

# # Action Cable Server Base
#
# A singleton ActionCable::Server instance is available via ActionCable.server.
# It's used by the Rack process that starts the Action Cable server, but is also
# used by the user to reach the RemoteConnections object, which is used for
# finding and disconnecting connections across all servers.
#
# Also, this is the server instance used for broadcasting. See Broadcasting for
# more information.
#
# source://actioncable//lib/action_cable/server/base.rb#18
class ActionCable::Server::Base
  include ::ActionCable::Server::Broadcasting
  include ::ActionCable::Server::Connections

  # @return [Base] a new instance of Base
  #
  # source://actioncable//lib/action_cable/server/base.rb#31
  def initialize(config: T.unsafe(nil)); end

  # Called by Rack to set up the server.
  #
  # source://actioncable//lib/action_cable/server/base.rb#38
  def call(env); end

  # Returns the value of attribute config.
  #
  # source://actioncable//lib/action_cable/server/base.rb#24
  def config; end

  # All of the identifiers applied to the connection class associated with this
  # server.
  #
  # source://actioncable//lib/action_cable/server/base.rb#102
  def connection_identifiers; end

  # Disconnect all the connections identified by `identifiers` on this server or
  # any others via RemoteConnections.
  #
  # source://actioncable//lib/action_cable/server/base.rb#46
  def disconnect(identifiers); end

  # source://actioncable//lib/action_cable/server/base.rb#71
  def event_loop; end

  # source://actioncable//lib/action_cable/server/base.rb#27
  def logger(*_arg0, **_arg1, &_arg2); end

  # Returns the value of attribute mutex.
  #
  # source://actioncable//lib/action_cable/server/base.rb#29
  def mutex; end

  # Adapter used for all streams/broadcasting.
  #
  # source://actioncable//lib/action_cable/server/base.rb#96
  def pubsub; end

  # Gateway to RemoteConnections. See that class for details.
  #
  # source://actioncable//lib/action_cable/server/base.rb#67
  def remote_connections; end

  # source://actioncable//lib/action_cable/server/base.rb#50
  def restart; end

  # The worker pool is where we run connection callbacks and channel actions. We
  # do as little as possible on the server's main thread. The worker pool is an
  # executor service that's backed by a pool of threads working from a task queue.
  # The thread pool size maxes out at 4 worker threads by default. Tune the size
  # yourself with `config.action_cable.worker_pool_size`.
  #
  # Using Active Record, Redis, etc within your channel actions means you'll get a
  # separate connection from each thread in the worker pool. Plan your deployment
  # accordingly: 5 servers each running 5 Puma workers each running an 8-thread
  # worker pool means at least 200 database connections.
  #
  # Also, ensure that your database connection pool size is as least as large as
  # your worker pool size. Otherwise, workers may oversubscribe the database
  # connection pool and block while they wait for other workers to release their
  # connections. Use a smaller worker pool or a larger database connection pool
  # instead.
  #
  # source://actioncable//lib/action_cable/server/base.rb#91
  def worker_pool; end

  class << self
    # source://actioncable//lib/action_cable/server/base.rb#22
    def config; end

    # source://actioncable//lib/action_cable/server/base.rb#22
    def config=(val); end

    # source://actioncable//lib/action_cable/server/base.rb#26
    def logger; end
  end
end

# # Action Cable Server Broadcasting
#
# Broadcasting is how other parts of your application can send messages to a
# channel's subscribers. As explained in Channel, most of the time, these
# broadcastings are streamed directly to the clients subscribed to the named
# broadcasting. Let's explain with a full-stack example:
#
#     class WebNotificationsChannel < ApplicationCable::Channel
#       def subscribed
#         stream_from "web_notifications_#{current_user.id}"
#       end
#     end
#
#     # Somewhere in your app this is called, perhaps from a NewCommentJob:
#     ActionCable.server.broadcast \
#       "web_notifications_1", { title: "New things!", body: "All that's fit for print" }
#
#     # Client-side CoffeeScript, which assumes you've already requested the right to send web notifications:
#     App.cable.subscriptions.create "WebNotificationsChannel",
#       received: (data) ->
#         new Notification data['title'], body: data['body']
#
# source://actioncable//lib/action_cable/server/broadcasting.rb#28
module ActionCable::Server::Broadcasting
  # Broadcast a hash directly to a named `broadcasting`. This will later be JSON
  # encoded.
  #
  # source://actioncable//lib/action_cable/server/broadcasting.rb#31
  def broadcast(broadcasting, message, coder: T.unsafe(nil)); end

  # Returns a broadcaster for a named `broadcasting` that can be reused. Useful
  # when you have an object that may need multiple spots to transmit to a specific
  # broadcasting over and over.
  #
  # source://actioncable//lib/action_cable/server/broadcasting.rb#38
  def broadcaster_for(broadcasting, coder: T.unsafe(nil)); end
end

# source://actioncable//lib/action_cable/server/broadcasting.rb#43
class ActionCable::Server::Broadcasting::Broadcaster
  # @return [Broadcaster] a new instance of Broadcaster
  #
  # source://actioncable//lib/action_cable/server/broadcasting.rb#46
  def initialize(server, broadcasting, coder:); end

  # source://actioncable//lib/action_cable/server/broadcasting.rb#50
  def broadcast(message); end

  # Returns the value of attribute broadcasting.
  #
  # source://actioncable//lib/action_cable/server/broadcasting.rb#44
  def broadcasting; end

  # Returns the value of attribute coder.
  #
  # source://actioncable//lib/action_cable/server/broadcasting.rb#44
  def coder; end

  # Returns the value of attribute server.
  #
  # source://actioncable//lib/action_cable/server/broadcasting.rb#44
  def server; end
end

# # Action Cable Server Configuration
#
# An instance of this configuration object is available via
# ActionCable.server.config, which allows you to tweak Action Cable
# configuration in a Rails config initializer.
#
# source://actioncable//lib/action_cable/server/configuration.rb#14
class ActionCable::Server::Configuration
  # @return [Configuration] a new instance of Configuration
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#22
  def initialize; end

  # Returns the value of attribute allow_same_origin_as_host.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#17
  def allow_same_origin_as_host; end

  # Sets the attribute allow_same_origin_as_host
  #
  # @param value the value to set the attribute allow_same_origin_as_host to.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#17
  def allow_same_origin_as_host=(_arg0); end

  # Returns the value of attribute allowed_request_origins.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#17
  def allowed_request_origins; end

  # Sets the attribute allowed_request_origins
  #
  # @param value the value to set the attribute allowed_request_origins to.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#17
  def allowed_request_origins=(_arg0); end

  # Returns the value of attribute cable.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#18
  def cable; end

  # Sets the attribute cable
  #
  # @param value the value to set the attribute cable to.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#18
  def cable=(_arg0); end

  # Returns the value of attribute connection_class.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#16
  def connection_class; end

  # Sets the attribute connection_class
  #
  # @param value the value to set the attribute connection_class to.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#16
  def connection_class=(_arg0); end

  # Returns the value of attribute disable_request_forgery_protection.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#17
  def disable_request_forgery_protection; end

  # Sets the attribute disable_request_forgery_protection
  #
  # @param value the value to set the attribute disable_request_forgery_protection to.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#17
  def disable_request_forgery_protection=(_arg0); end

  # Returns the value of attribute filter_parameters.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#17
  def filter_parameters; end

  # Sets the attribute filter_parameters
  #
  # @param value the value to set the attribute filter_parameters to.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#17
  def filter_parameters=(_arg0); end

  # Returns the value of attribute health_check_application.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#20
  def health_check_application; end

  # Sets the attribute health_check_application
  #
  # @param value the value to set the attribute health_check_application to.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#20
  def health_check_application=(_arg0); end

  # Returns the value of attribute health_check_path.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#20
  def health_check_path; end

  # Sets the attribute health_check_path
  #
  # @param value the value to set the attribute health_check_path to.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#20
  def health_check_path=(_arg0); end

  # Returns the value of attribute log_tags.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#15
  def log_tags; end

  # Sets the attribute log_tags
  #
  # @param value the value to set the attribute log_tags to.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#15
  def log_tags=(_arg0); end

  # Returns the value of attribute logger.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#15
  def logger; end

  # Sets the attribute logger
  #
  # @param value the value to set the attribute logger to.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#15
  def logger=(_arg0); end

  # Returns the value of attribute mount_path.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#18
  def mount_path; end

  # Sets the attribute mount_path
  #
  # @param value the value to set the attribute mount_path to.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#18
  def mount_path=(_arg0); end

  # Returns the value of attribute precompile_assets.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#19
  def precompile_assets; end

  # Sets the attribute precompile_assets
  #
  # @param value the value to set the attribute precompile_assets to.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#19
  def precompile_assets=(_arg0); end

  # Returns constant of subscription adapter specified in config/cable.yml. If the
  # adapter cannot be found, this will default to the Redis adapter. Also makes
  # sure proper dependencies are required.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#40
  def pubsub_adapter; end

  # Returns the value of attribute url.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#18
  def url; end

  # Sets the attribute url
  #
  # @param value the value to set the attribute url to.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#18
  def url=(_arg0); end

  # Returns the value of attribute worker_pool_size.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#16
  def worker_pool_size; end

  # Sets the attribute worker_pool_size
  #
  # @param value the value to set the attribute worker_pool_size to.
  #
  # source://actioncable//lib/action_cable/server/configuration.rb#16
  def worker_pool_size=(_arg0); end
end

# # Action Cable Server Connections
#
# Collection class for all the connections that have been established on this
# specific server. Remember, usually you'll run many Action Cable servers, so
# you can't use this collection as a full list of all of the connections
# established against your application. Instead, use RemoteConnections for that.
#
# source://actioncable//lib/action_cable/server/connections.rb#13
module ActionCable::Server::Connections
  # source://actioncable//lib/action_cable/server/connections.rb#20
  def add_connection(connection); end

  # source://actioncable//lib/action_cable/server/connections.rb#16
  def connections; end

  # source://actioncable//lib/action_cable/server/connections.rb#39
  def open_connections_statistics; end

  # source://actioncable//lib/action_cable/server/connections.rb#24
  def remove_connection(connection); end

  # WebSocket connection implementations differ on when they'll mark a connection
  # as stale. We basically never want a connection to go stale, as you then can't
  # rely on being able to communicate with the connection. To solve this, a 3
  # second heartbeat runs on all connections. If the beat fails, we automatically
  # disconnect.
  #
  # source://actioncable//lib/action_cable/server/connections.rb#33
  def setup_heartbeat_timer; end
end

# source://actioncable//lib/action_cable/server/connections.rb#14
ActionCable::Server::Connections::BEAT_INTERVAL = T.let(T.unsafe(nil), Integer)

# Worker used by Server.send_async to do connection work in threads.
#
# source://actioncable//lib/action_cable/server/worker.rb#12
class ActionCable::Server::Worker
  include ::ActiveSupport::Callbacks
  include ::ActionCable::Server::Worker::ActiveRecordConnectionManagement
  extend ::ActiveSupport::Callbacks::ClassMethods
  extend ::ActiveSupport::DescendantsTracker

  # @return [Worker] a new instance of Worker
  #
  # source://actioncable//lib/action_cable/server/worker.rb#21
  def initialize(max_size: T.unsafe(nil)); end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
  def __callbacks; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
  def __callbacks?; end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#912
  def _run_work_callbacks(&block); end

  # source://activesupport/7.2.1/lib/active_support/callbacks.rb#924
  def _work_callbacks; end

  # source://actioncable//lib/action_cable/server/worker.rb#48
  def async_exec(receiver, *args, connection:, &block); end

  # source://actioncable//lib/action_cable/server/worker.rb#52
  def async_invoke(receiver, method, *args, connection: T.unsafe(nil), &block); end

  # source://activesupport/7.2.1/lib/active_support/core_ext/module/attribute_accessors_per_thread.rb#74
  def connection; end

  # source://activesupport/7.2.1/lib/active_support/core_ext/module/attribute_accessors_per_thread.rb#116
  def connection=(obj); end

  # Returns the value of attribute executor.
  #
  # source://actioncable//lib/action_cable/server/worker.rb#19
  def executor; end

  # Stop processing work: any work that has not already started running will be
  # discarded from the queue
  #
  # source://actioncable//lib/action_cable/server/worker.rb#32
  def halt; end

  # source://actioncable//lib/action_cable/server/worker.rb#58
  def invoke(receiver, method, *args, connection:, &block); end

  # @return [Boolean]
  #
  # source://actioncable//lib/action_cable/server/worker.rb#36
  def stopping?; end

  # source://actioncable//lib/action_cable/server/worker.rb#40
  def work(connection, &block); end

  private

  # source://actioncable//lib/action_cable/server/worker.rb#70
  def logger; end

  class << self
    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks=(value); end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#70
    def __callbacks?; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#916
    def _work_callbacks; end

    # source://activesupport/7.2.1/lib/active_support/callbacks.rb#920
    def _work_callbacks=(value); end

    # source://activesupport/7.2.1/lib/active_support/core_ext/module/attribute_accessors_per_thread.rb#49
    def connection; end

    # source://activesupport/7.2.1/lib/active_support/core_ext/module/attribute_accessors_per_thread.rb#108
    def connection=(obj); end
  end
end

# source://actioncable//lib/action_cable/server/worker/active_record_connection_management.rb#8
module ActionCable::Server::Worker::ActiveRecordConnectionManagement
  extend ::ActiveSupport::Concern

  # source://actioncable//lib/action_cable/server/worker/active_record_connection_management.rb#17
  def with_database_connections(&block); end
end

# source://actioncable//lib/action_cable/subscription_adapter/async.rb#6
module ActionCable::SubscriptionAdapter; end

# source://actioncable//lib/action_cable/subscription_adapter/async.rb#7
class ActionCable::SubscriptionAdapter::Async < ::ActionCable::SubscriptionAdapter::Inline
  private

  # source://actioncable//lib/action_cable/subscription_adapter/async.rb#9
  def new_subscriber_map; end
end

# source://actioncable//lib/action_cable/subscription_adapter/async.rb#13
class ActionCable::SubscriptionAdapter::Async::AsyncSubscriberMap < ::ActionCable::SubscriptionAdapter::SubscriberMap
  # @return [AsyncSubscriberMap] a new instance of AsyncSubscriberMap
  #
  # source://actioncable//lib/action_cable/subscription_adapter/async.rb#14
  def initialize(event_loop); end

  # source://actioncable//lib/action_cable/subscription_adapter/async.rb#19
  def add_subscriber(*_arg0); end

  # source://actioncable//lib/action_cable/subscription_adapter/async.rb#23
  def invoke_callback(*_arg0); end
end

# source://actioncable//lib/action_cable/subscription_adapter/base.rb#7
class ActionCable::SubscriptionAdapter::Base
  # @return [Base] a new instance of Base
  #
  # source://actioncable//lib/action_cable/subscription_adapter/base.rb#10
  def initialize(server); end

  # @raise [NotImplementedError]
  #
  # source://actioncable//lib/action_cable/subscription_adapter/base.rb#15
  def broadcast(channel, payload); end

  # source://actioncable//lib/action_cable/subscription_adapter/base.rb#31
  def identifier; end

  # Returns the value of attribute logger.
  #
  # source://actioncable//lib/action_cable/subscription_adapter/base.rb#8
  def logger; end

  # Returns the value of attribute server.
  #
  # source://actioncable//lib/action_cable/subscription_adapter/base.rb#8
  def server; end

  # @raise [NotImplementedError]
  #
  # source://actioncable//lib/action_cable/subscription_adapter/base.rb#27
  def shutdown; end

  # @raise [NotImplementedError]
  #
  # source://actioncable//lib/action_cable/subscription_adapter/base.rb#19
  def subscribe(channel, message_callback, success_callback = T.unsafe(nil)); end

  # @raise [NotImplementedError]
  #
  # source://actioncable//lib/action_cable/subscription_adapter/base.rb#23
  def unsubscribe(channel, message_callback); end
end

# source://actioncable//lib/action_cable/subscription_adapter/channel_prefix.rb#7
module ActionCable::SubscriptionAdapter::ChannelPrefix
  # source://actioncable//lib/action_cable/subscription_adapter/channel_prefix.rb#8
  def broadcast(channel, payload); end

  # source://actioncable//lib/action_cable/subscription_adapter/channel_prefix.rb#13
  def subscribe(channel, callback, success_callback = T.unsafe(nil)); end

  # source://actioncable//lib/action_cable/subscription_adapter/channel_prefix.rb#18
  def unsubscribe(channel, callback); end

  private

  # Returns the channel name, including channel_prefix specified in cable.yml
  #
  # source://actioncable//lib/action_cable/subscription_adapter/channel_prefix.rb#25
  def channel_with_prefix(channel); end
end

# source://actioncable//lib/action_cable/subscription_adapter/inline.rb#7
class ActionCable::SubscriptionAdapter::Inline < ::ActionCable::SubscriptionAdapter::Base
  # @return [Inline] a new instance of Inline
  #
  # source://actioncable//lib/action_cable/subscription_adapter/inline.rb#8
  def initialize(*_arg0); end

  # source://actioncable//lib/action_cable/subscription_adapter/inline.rb#13
  def broadcast(channel, payload); end

  # source://actioncable//lib/action_cable/subscription_adapter/inline.rb#25
  def shutdown; end

  # source://actioncable//lib/action_cable/subscription_adapter/inline.rb#17
  def subscribe(channel, callback, success_callback = T.unsafe(nil)); end

  # source://actioncable//lib/action_cable/subscription_adapter/inline.rb#21
  def unsubscribe(channel, callback); end

  private

  # source://actioncable//lib/action_cable/subscription_adapter/inline.rb#34
  def new_subscriber_map; end

  # source://actioncable//lib/action_cable/subscription_adapter/inline.rb#30
  def subscriber_map; end
end

# source://actioncable//lib/action_cable/subscription_adapter/subscriber_map.rb#7
class ActionCable::SubscriptionAdapter::SubscriberMap
  # @return [SubscriberMap] a new instance of SubscriberMap
  #
  # source://actioncable//lib/action_cable/subscription_adapter/subscriber_map.rb#8
  def initialize; end

  # source://actioncable//lib/action_cable/subscription_adapter/subscriber_map.rb#49
  def add_channel(channel, on_success); end

  # source://actioncable//lib/action_cable/subscription_adapter/subscriber_map.rb#13
  def add_subscriber(channel, subscriber, on_success); end

  # source://actioncable//lib/action_cable/subscription_adapter/subscriber_map.rb#38
  def broadcast(channel, message); end

  # source://actioncable//lib/action_cable/subscription_adapter/subscriber_map.rb#56
  def invoke_callback(callback, message); end

  # source://actioncable//lib/action_cable/subscription_adapter/subscriber_map.rb#53
  def remove_channel(channel); end

  # source://actioncable//lib/action_cable/subscription_adapter/subscriber_map.rb#27
  def remove_subscriber(channel, subscriber); end
end

# ## Test adapter for Action Cable
#
# The test adapter should be used only in testing. Along with
# ActionCable::TestHelper it makes a great tool to test your Rails application.
#
# To use the test adapter set `adapter` value to `test` in your
# `config/cable.yml` file.
#
# NOTE: `Test` adapter extends the `ActionCable::SubscriptionAdapter::Async`
# adapter, so it could be used in system tests too.
#
# source://actioncable//lib/action_cable/subscription_adapter/test.rb#17
class ActionCable::SubscriptionAdapter::Test < ::ActionCable::SubscriptionAdapter::Async
  # source://actioncable//lib/action_cable/subscription_adapter/test.rb#18
  def broadcast(channel, payload); end

  # source://actioncable//lib/action_cable/subscription_adapter/test.rb#23
  def broadcasts(channel); end

  # source://actioncable//lib/action_cable/subscription_adapter/test.rb#31
  def clear; end

  # source://actioncable//lib/action_cable/subscription_adapter/test.rb#27
  def clear_messages(channel); end

  private

  # source://actioncable//lib/action_cable/subscription_adapter/test.rb#36
  def channels_data; end
end

# source://actioncable//lib/action_cable/test_case.rb#8
class ActionCable::TestCase < ::ActiveSupport::TestCase
  include ::ActionCable::TestHelper
end

# Provides helper methods for testing Action Cable broadcasting
#
# source://actioncable//lib/action_cable/test_helper.rb#7
module ActionCable::TestHelper
  # source://actioncable//lib/action_cable/test_helper.rb#18
  def after_teardown; end

  # Asserts that the specified message has been sent to the stream.
  #
  #     def test_assert_transmitted_message
  #       ActionCable.server.broadcast 'messages', text: 'hello'
  #       assert_broadcast_on('messages', text: 'hello')
  #     end
  #
  # If a block is passed, that block should cause a message with the specified
  # data to be sent.
  #
  #     def test_assert_broadcast_on_again
  #       assert_broadcast_on('messages', text: 'hello') do
  #         ActionCable.server.broadcast 'messages', text: 'hello'
  #       end
  #     end
  #
  # source://actioncable//lib/action_cable/test_helper.rb#116
  def assert_broadcast_on(stream, data, &block); end

  # Asserts that the number of broadcasted messages to the stream matches the
  # given number.
  #
  #     def test_broadcasts
  #       assert_broadcasts 'messages', 0
  #       ActionCable.server.broadcast 'messages', { text: 'hello' }
  #       assert_broadcasts 'messages', 1
  #       ActionCable.server.broadcast 'messages', { text: 'world' }
  #       assert_broadcasts 'messages', 2
  #     end
  #
  # If a block is passed, that block should cause the specified number of messages
  # to be broadcasted.
  #
  #     def test_broadcasts_again
  #       assert_broadcasts('messages', 1) do
  #         ActionCable.server.broadcast 'messages', { text: 'hello' }
  #       end
  #
  #       assert_broadcasts('messages', 2) do
  #         ActionCable.server.broadcast 'messages', { text: 'hi' }
  #         ActionCable.server.broadcast 'messages', { text: 'how are you?' }
  #       end
  #     end
  #
  # source://actioncable//lib/action_cable/test_helper.rb#48
  def assert_broadcasts(stream, number, &block); end

  # Asserts that no messages have been sent to the stream.
  #
  #     def test_no_broadcasts
  #       assert_no_broadcasts 'messages'
  #       ActionCable.server.broadcast 'messages', { text: 'hi' }
  #       assert_broadcasts 'messages', 1
  #     end
  #
  # If a block is passed, that block should not cause any message to be sent.
  #
  #     def test_broadcasts_again
  #       assert_no_broadcasts 'messages' do
  #         # No job messages should be sent from this block
  #       end
  #     end
  #
  # Note: This assertion is simply a shortcut for:
  #
  #     assert_broadcasts 'messages', 0, &block
  #
  # source://actioncable//lib/action_cable/test_helper.rb#80
  def assert_no_broadcasts(stream, &block); end

  # source://actioncable//lib/action_cable/test_helper.rb#8
  def before_setup; end

  # source://actioncable//lib/action_cable/test_helper.rb#146
  def broadcasts(*_arg0, **_arg1, &_arg2); end

  # Returns the messages that are broadcasted in the block.
  #
  #     def test_broadcasts
  #       messages = capture_broadcasts('messages') do
  #         ActionCable.server.broadcast 'messages', { text: 'hi' }
  #         ActionCable.server.broadcast 'messages', { text: 'how are you?' }
  #       end
  #       assert_equal 2, messages.length
  #       assert_equal({ text: 'hi' }, messages.first)
  #       assert_equal({ text: 'how are you?' }, messages.last)
  #     end
  #
  # source://actioncable//lib/action_cable/test_helper.rb#96
  def capture_broadcasts(stream, &block); end

  # source://actioncable//lib/action_cable/test_helper.rb#146
  def clear_messages(*_arg0, **_arg1, &_arg2); end

  # source://actioncable//lib/action_cable/test_helper.rb#142
  def pubsub_adapter; end

  private

  # source://actioncable//lib/action_cable/test_helper.rb#149
  def new_broadcasts_from(current_messages, stream, assertion, &block); end
end

# source://actioncable//lib/action_cable/gem_version.rb#11
module ActionCable::VERSION; end

# source://actioncable//lib/action_cable/gem_version.rb#12
ActionCable::VERSION::MAJOR = T.let(T.unsafe(nil), Integer)

# source://actioncable//lib/action_cable/gem_version.rb#13
ActionCable::VERSION::MINOR = T.let(T.unsafe(nil), Integer)

# source://actioncable//lib/action_cable/gem_version.rb#15
ActionCable::VERSION::PRE = T.let(T.unsafe(nil), T.untyped)

# source://actioncable//lib/action_cable/gem_version.rb#17
ActionCable::VERSION::STRING = T.let(T.unsafe(nil), String)

# source://actioncable//lib/action_cable/gem_version.rb#14
ActionCable::VERSION::TINY = T.let(T.unsafe(nil), Integer)
